/***************************************************************************
                            KOpenWithDlg.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 "Open with" dialog box.
 Used automatically by KRun, and used by libkonq.

 @author David Faure <faure@kde.org>
 
 @short 
 "Open with" dialog box.
*/
public class KOpenWithDlg extends QDialog  {
	protected KOpenWithDlg(Class dummy){super((Class) null);}


/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
	private native void newKOpenWithDlg( ArrayList urls, QWidget parent);
	public KOpenWithDlg( ArrayList urls, QWidget parent) {
		super((Class) null);
		newKOpenWithDlg( urls, parent);
	}
	private native void newKOpenWithDlg( ArrayList urls);
	public KOpenWithDlg( ArrayList urls) {
		super((Class) null);
		newKOpenWithDlg( urls);
	}

/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
	private native void newKOpenWithDlg( ArrayList urls, String text, String value, QWidget parent);
	public KOpenWithDlg( ArrayList urls, String text, String value, QWidget parent) {
		super((Class) null);
		newKOpenWithDlg( urls, text, value, parent);
	}
	private native void newKOpenWithDlg( ArrayList urls, String text, String value);
	public KOpenWithDlg( ArrayList urls, String text, String value) {
		super((Class) null);
		newKOpenWithDlg( urls, text, value);
	}

/** 
 Create a dialog to select a service for a given service type.
 Note that this dialog doesn't apply to URLs.

*/
	private native void newKOpenWithDlg( String serviceType, String value, QWidget parent);
	public KOpenWithDlg( String serviceType, String value, QWidget parent) {
		super((Class) null);
		newKOpenWithDlg( serviceType, value, parent);
	}
	private native void newKOpenWithDlg( String serviceType, String value);
	public KOpenWithDlg( String serviceType, String value) {
		super((Class) null);
		newKOpenWithDlg( serviceType, value);
	}

/** 
 Destructor
     
*/
	protected native void finalize() throws InternalError;

/** 

*/
	public native String text();

/** 

*/
//	public native KService_Ptr service();

/** 
 The slot for clearing the edit widget
    
*/
	public native void slotClear();
	public native void slotSelected( String _name, String _exec);
	public native void slotHighlighted( String _name, String _exec);
	public native void slotTextChanged();
	public native void slotTerminalToggled( boolean arg1);
	public native void slotDbClick();
	public native void slotOK();

/** 
 Determine service type from URLs
     
*/
	protected native void setServiceType( ArrayList _urls);

/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
	protected native void init( String text, String value);

/** 
 Reimplemented from QDialog.accept() to save history of the combobox
     
*/
	protected native void accept();
}

/** Override these methods in subclasses of KOpenWithDlg to customise event handling behaviour */
interface KOpenWithDlgEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

