/***************************************************************************
                            KOpenWithHandler.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class handles the displayOpenWithDialog call, made by KRun
 when it has no idea what to do with a URL.
 The default implementation is to print a huge fat warning
 This behaviour is overriden by KFileOpenWithHandler, in libkfile,
 which displays the real open-with dialog box.

 If you use KRun you <code>need</code> to create an instance of KFileOpenWithHandler
 (except if you can make sure you only use it for executables or
  Type=Application desktop files)

 @short Handler for KRun's displayOpenWithDialog() call.
*/
public class  KOpenWithHandler implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KOpenWithHandler(Class dummy){}

	private native void newKOpenWithHandler();
	public KOpenWithHandler() {
		newKOpenWithHandler();
	}
	protected native void finalize() throws InternalError;

/** 
 Opens an open-with dialog box for <code>urls</code>

*/
	public native boolean displayOpenWithDialog( ArrayList urls);

/** 
 Call this to get the (only) instance of KOpenWithHandler
   
*/
	public static native KOpenWithHandler getOpenWithHandler();
	public static native boolean exists();
}
