/***************************************************************************
                            KPopupMenu.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KPopupMenu is a class for menus with standard title items. It acts
 identically to QPopupMenu, with the addition of insertTitle() and
 changeTitle() methods.

 The titles support a text string, an icon, plus user defined gradients,
 colors, and background pixmaps.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short A menu with title items.

*/
public class KPopupMenu extends QPopupMenu  {
	protected KPopupMenu(Class dummy){super((Class) null);}


/** 
 Creates a new KPopupMenu.
     
*/
	private native void newKPopupMenu( QWidget parent, String name);
	public KPopupMenu( QWidget parent, String name) {
		super((Class) null);
		newKPopupMenu( parent, name);
	}
	private native void newKPopupMenu();
	public KPopupMenu() {
		super((Class) null);
		newKPopupMenu();
	}

/** 
 Inserts a title item with no icon.
     
*/
	public native int insertTitle( String text, int identifier, int index);
	public native int insertTitle( String text);

/** 
 Inserts a title item with the given icon and title.
     
*/
	public native int insertTitle( QPixmap icon, String text, int identifier, int index);
	public native int insertTitle( QPixmap icon, String text);

/** 
 Changes the title of the item at the specified id. If a icon was
 previously set it is cleared.
     
*/
	public native void changeTitle( int identifier, String text);

/** 
 Changes the title and icon of the title item at the specified id.
     
*/
	public native void changeTitle( int identifier, QPixmap icon, String text);

/** 
 Returns the title of the title item at the specified id. The default
 id of -1 is for backwards compatibility only, you should always specify
 the id.
     
*/
	public native String title( int identifier);

/** 
 Returns the icon of the title item at the specified id.
     
*/
	public native QPixmap titlePixmap( int identifier);

/** 
 Obsolete method provided for backwards compatibility only. Use the
 normal constructor and insertTitle instead.
     
*/
	private native void newKPopupMenu( String title, QWidget parent, String name);
	public KPopupMenu( String title, QWidget parent, String name) {
		super((Class) null);
		newKPopupMenu( title, parent, name);
	}
	private native void newKPopupMenu( String title);
	public KPopupMenu( String title) {
		super((Class) null);
		newKPopupMenu( title);
	}

/** 
 Obsolete method provided for backwards compatibility only. Use
 insertTitle and changeTitle instead.
     
*/
	public native void setTitle( String title);
}

/** Override these methods in subclasses of KPopupMenu to customise event handling behaviour */
interface KPopupMenuEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

