/***************************************************************************
                            KProgress.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 A stylized progress bar.

 KProgress is derived from {@link QFrame} and {@link QRangeControl}, so
 you can use all the methods from those classes. The only difference
 is that {@link #setValue} is now made a slot, so you can connect
 stuff to it.

 None of the constructors take line step and page step as arguments, 
 so by default they're set to 1 and 10 respectively.

 The Blocked style ignores the {@link #textEnabled} setting and displays
 no text, since it looks truly ugly (and for other reasons). Signal 
 {@link #percentageChanged} is emitted whenever the value changes so you
 can set up a different widget to display the current percentage complete
 and connect the signal to it. 

 @author Martynas Kunigelis

 @version $Id: KProgress.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short A progress indicator widget.

*/
public class KProgress extends QFrame implements  QRangeControlInterface {
	protected KProgress(Class dummy){super((Class) null);}


/**  
 Construct a horizontal progress bar.
  
*/
	private native void newKProgress( QWidget parent, String name);
	public KProgress( QWidget parent, String name) {
		super((Class) null);
		newKProgress( parent, name);
	}
	private native void newKProgress();
	public KProgress() {
		super((Class) null);
		newKProgress();
	}

/**  
 Construct a progress bar with orientation <code>orient.</code> 
  
*/
	private native void newKProgress( int orient, QWidget parent, String name);
	public KProgress( int orient, QWidget parent, String name) {
		super((Class) null);
		newKProgress( orient, parent, name);
	}
	private native void newKProgress( int orient);
	public KProgress( int orient) {
		super((Class) null);
		newKProgress( orient);
	}

/**  
 Construct a progress bar with minimum, maximum and initial values.
  
*/
	private native void newKProgress( int minValue, int maxValue, int value, int arg1, QWidget parent, String name);
	public KProgress( int minValue, int maxValue, int value, int arg1, QWidget parent, String name) {
		super((Class) null);
		newKProgress( minValue, maxValue, value, arg1, parent, name);
	}
	private native void newKProgress( int minValue, int maxValue, int value, int arg1);
	public KProgress( int minValue, int maxValue, int value, int arg1) {
		super((Class) null);
		newKProgress( minValue, maxValue, value, arg1);
	}

/**  
 Destruct the progress bar.
   
*/
	protected native void finalize() throws InternalError;

/**  
 Set the progress bar style.

 Allowed values are <code>Solid</code> and <code>Blocked.</code>
  
*/
	public native void setBarStyle( int style);

/**  
 Set the color of the progress bar. 
  
*/
	public native void setBarColor( QColor arg1);

/**  
 Set a pixmap to be shown in the progress bar. 
  
*/
	public native void setBarPixmap( QPixmap arg1);

/**  
 Set the orientation of the progress bar. 

 Allowed values are <code>Horizontal</code> and <code>Vertical.</code> 
  
*/
	public native void setOrientation( int arg1);

/** 
 If this is set to <code>true</code>, the progress text will be displayed.

   
*/
	public native void setTextEnabled( boolean arg1);

/**  
 Retrieve the bar style.

*/
	public native int barStyle();

/**  
 Retrieve the bar color.

*/
	public native QColor barColor();

/**  
 Retrieve the bar pixmap.

*/
	public native QPixmap barPixmap();

/**  
 Retrive the orientation of the progress bar.

*/
	public native int orientation();

/** 
 Returns <code>true</code> if progress text will be displayed,
 <code>false</code> otherwise.

*/
	public native boolean textEnabled();

/** 
 Set the format of the text to use to display status.

 The default format is "%p%" (which looks like "42%".)

*/
	public native void setFormat( String format);

/** 
 Retrieve the current format for printing status text.

*/
	public native String format();

/** 
 Set the current value of the progress bar to <code>value.</code>

 This must be a number in the range 0..100.

*/
	public native void setValue( int value);

/** 
 Advance the progress bar by <code>prog.</code>

 This method is
 provided for convenience and is equivalent with
 {@link #setValue}+prog).

*/
	public native void advance( int prog);
	public static final int Solid = 0;
	public static final int Blocked = 1;

        // From QRangeControl

        public native int value();
        public native void addPage();
        public native void subtractPage();
        public native void addLine();
        public native void subtractLine();
        public native int minValue();
        public native int maxValue();
        public native void setRange( int minValue, int maxValue);
        public native int lineStep();
        public native int pageStep();
        public native void setSteps( int line, int page);
        public native int bound( int arg1);
        protected native int positionFromValue( int val, int space);
        protected native int valueFromPosition( int pos, int space);
        protected native void directSetValue( int val);
        protected native int prevValue();
        protected native void valueChange();
        protected native void rangeChange();
        protected native void stepChange();

}

/** Override these methods in subclasses of KProgress to customise event handling behaviour */
interface KProgressEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

