/***************************************************************************
                            KRestrictedLine.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 The KRestrictedLine widget is a variant of {@link QLineEdit} which
 accepts only a restricted set of characters as input. 
 All other characters will be discarded and the signal {@link #invalidChar} 
 will be emitted for each of them.

 Valid characters can be passed as a String to the constructor
 or set afterwards via {@link #setValidChars}.
 The default key bindings of {@link QLineEdit} are still in effect.

 @author Michael Wiedmann <mw@miwie.in-berlin.de>

 @version 0.0.1
 
 @short A line editor for restricted character sets.

*/
public class KRestrictedLine extends KLineEdit  {
	protected KRestrictedLine(Class dummy){super((Class) null);}


/** 
 Constructor: This contructor takes three - optional - arguments.
  The first two parameters are simply passed on to {@link QLineEdit}.

*/
	private native void newKRestrictedLine( QWidget parent, String name, String valid);
	public KRestrictedLine( QWidget parent, String name, String valid) {
		super((Class) null);
		newKRestrictedLine( parent, name, valid);
	}
	private native void newKRestrictedLine();
	public KRestrictedLine() {
		super((Class) null);
		newKRestrictedLine();
	}

/** 
 Destructs the restricted line editor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 All characters in the string valid are treated as 
 acceptable characters.
   
*/
	public native void setValidChars( String valid);

/** 

*/
	public native String validChars();
}

/** Override these methods in subclasses of KRestrictedLine to customise event handling behaviour */
interface KRestrictedLineEventHandling {

/** 

   
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);

/** 
 Re-implemented for internal reasons.  API not affected.

 See {@link QLineEdit#mousePressEvent}.
    
*/
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);

/** 
 Re-implemented to handle URI drops.

 See {@link QLineEdit#dropEvent}.
    
*/
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

