/***************************************************************************
                            KRuler.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A ruler widget.

 The vertical ruler looks similar to this:

<pre>
    meters                       inches

    ------   <--- end mark  --. ------
        --                            -
        --   <---little mark--.     --
        --                            -
        --                          ---
       ---   <---medium mark          -
        --                           --
        --        tiny mark---.      -
        --                         ----
        --                            -
      ----   <-----big mark          --
        --                            -
      |>--   <--ruler pointer-.   |>--

 </pre>

 There are tiny marks, little marks, medium marks, and big marks along the
  ruler.

 To receive mouse clicks or mouse moves,
 the class has to be overloaded.

 For performance reasons, the public methods don't call {@link QWidget#repaint}.
 (Slots do, see documentation below.)
 All the changed settings will be painted once after leaving
 to the main event loop.
 For performance painting the slot methods should be used,
 they do a fast {@link QWidget#repaint} call after changing the values.
 For setting multiple values like {@link #minValue}, {@link #maxValue}, {@link #offset} etc.
 using the public methods is recommended
 so the widget will be painted only once when entering the main event loop.

 @author Jrg Habenicht
 
 @short A ruler widget.

*/
public class KRuler extends QFrame  {
	protected KRuler(Class dummy){super((Class) null);}


/** 
 Constructs a horizontal ruler.
   
*/
	private native void newKRuler( QWidget parent, String name);
	public KRuler( QWidget parent, String name) {
		super((Class) null);
		newKRuler( parent, name);
	}
	private native void newKRuler();
	public KRuler() {
		super((Class) null);
		newKRuler();
	}

/** 
 Constructs a ruler with orientation <code>orient.</code>

 <code>parent</code>, <code>name</code> and <code>f</code> are passed to QFrame.
 The default look is a raised widget
 but may be changed with the inherited {@link QFrame} methods.

*/
	private native void newKRuler( int orient, QWidget parent, String name, int f);
	public KRuler( int orient, QWidget parent, String name, int f) {
		super((Class) null);
		newKRuler( orient, parent, name, f);
	}
	private native void newKRuler( int orient);
	public KRuler( int orient) {
		super((Class) null);
		newKRuler( orient);
	}

/** 
 Constructs a ruler with orientation <code>orient</code> and initial width <code>widgetWidth.</code>

 The width sets the fixed width of the widget. This is useful if you
 want to draw the ruler bigger or smaller than the default size.
 Note: The size of the marks doesn't change.
 <code>parent</code>, <code>name</code> and <code>f</code> are passed to {@link QFrame}.

   
*/
	private native void newKRuler( int orient, int widgetWidth, QWidget parent, String name, int f);
	public KRuler( int orient, int widgetWidth, QWidget parent, String name, int f) {
		super((Class) null);
		newKRuler( orient, widgetWidth, parent, name, f);
	}
	private native void newKRuler( int orient, int widgetWidth);
	public KRuler( int orient, int widgetWidth) {
		super((Class) null);
		newKRuler( orient, widgetWidth);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Set the minimal value of the ruler pointer (default is 0).

 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.

*/
	public native void setMinValue( int arg1);

/** 
 Retrieve the minimal value of the ruler pointer.

*/
	public native int minValue();

/** 
 Set the maximum value of the ruler pointer (default is 100).

 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.
   
*/
	public native void setMaxValue( int arg1);

/**  returns the maximal value of the ruler pointer.
   
*/
	public native int maxValue();

/** 
 Set minimum and maxmimum values of the ruler pointer.

 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.
   
*/
	public native void setRange( int min, int max);

/** 
 Set the value of the ruler pointer.

 The value is indicated by painting the ruler pointer at the
 corresponding position.
 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.
   
*/
	public native void setValue( int arg1);
	public native int value();

/** 
 Set distance between tiny marks.

 This is mostly used in the English system (inches) with distance of 1. 
   
*/
	public native void setTinyMarkDistance( int arg1);

/** 
 Retrieve the distance between tiny marks.

*/
	public native int tinyMarkDistance();

/**  
 Set the distance between little marks.

 The default value is 1 in the metric system and 2 in the English (inches) system.
   
*/
	public native void setLittleMarkDistance( int arg1);

/**  
 Retrieve the distance between little marks.
   
*/
	public native int littleMarkDistance();

/** 
 Set the distance between medium marks.

 For English (inches) styles it defaults to twice the little mark distance.
 For metric styles it defaults to five times the little mark distance.

*/
	public native void setMediumMarkDistance( int arg1);
	public native int mediumMarkDistance();

/**  
 Set distance between big marks.

 For English (inches) or metric styles it is twice the medium mark distance.

*/
	public native void setBigMarkDistance( int arg1);

/** 
 Retrieve the distance between big marks.

*/
	public native int bigMarkDistance();

/** 
 Show/hide tiny marks.

*/
	public native void setShowTinyMarks( boolean arg1);
	public native boolean showTinyMarks();

/** 
 Show/hide little marks.

*/
	public native void setShowLittleMarks( boolean arg1);
	public native boolean showLittleMarks();

/** 
 Show/hide medium marks.

*/
	public native void setShowMediumMarks( boolean arg1);
	public native boolean showMediumMarks();

/** 
 Show/hide big marks.

*/
	public native void setShowBigMarks( boolean arg1);
	public native boolean showBigMarks();

/** 
 Show/hide end marks.

*/
	public native void setShowEndMarks( boolean arg1);
	public native boolean showEndMarks();

/** 
 Show/hide the pointer.
   
*/
	public native void setShowPointer( boolean arg1);
	public native boolean showPointer();

/** 
 Sets the value that is shown per little mark.

 For metric systems this is 1 per mark.
 Note: If you set the value for little marks the values for 
 medium and big marks are updated according to the
 the values set in the setXXMarkDistance(int) methods.

*/
	public native void setValuePerLittleMark( int arg1);

/** 
 Sets the value that is shown per medium mark.

 For metric systems this is 5.
 Display of little marks is automatically disabled and
 big marks are updated according to 
 the values set in the {@link #setBigMarkDistance} method.

*/
	public native void setValuePerMediumMark( int arg1);

/** 
 Sets the value that is shown per big mark.

 For metric systems this is 1
 Display of little and medium marks marks is disabled.
   
*/
	public native void setValuePerBigMark( int arg1);

/** 
 Show/hide number values of the end marks.

 Default is <code>false.</code>

*/
	public native void setShowEndLabel( boolean arg1);
	public native boolean showEndLabel();

/** 
 Set the label this is drawn at the beginning of the visible part
 of the ruler.

*/
	public native void setEndLabel( String arg1);
	public native String endLabel();

/** 
 Set up the necessary tasks for the provided styles.

 A convenience method.

*/
	public native void setRulerMetricStyle( int arg1);

/** 
 Set the number of pixels between two base marks.

 Calling this method stretches or shrinks your ruler.

 For pixel display ({@link metric_style}) the value is 10.0 marks
 per pixel ;-)
 For English (inches) it is 9.0, and for centimetres ~2.835 . 3.0 .
 If you want to magnify your part of display, you have to
 adjust the mark distance <code>here.</code>
 Notice: The double type is only supported to give the possibility
         of having some double values.
         It should be used with care.  Using values below 10.0
         shows visible jumps of markpositions (e.g. 2.345).
         Using whole numbers is highly recommended.
 To use <code>int</code> values use setPixelPerMark((int)your_int_value);
 default: 1 mark per 10 pixels 
   
*/
	public native void setPixelPerMark( double arg1);

/** 
 Retrieve the number of pixels between two base marks.

*/
	public native double pixelPerMark();

/** 
 sets the length of the ruler, i.e. the difference between
 the begin mark and the end mark of the ruler.

 Same as (width() - offset())

 when the length is not locked, it gets adjusted with the
 length of the widget.
   
*/
	public native void setLength( int arg1);
	public native int length();

/** 
 locks the length of the ruler, i.e. the difference between
 the two end marks doesn't change when the widget is resized.

*/
	public native void setLengthFixed( boolean fix);
	public native boolean lengthFixed();

/** 
 Set the number of pixels by which the ruler may slide up or left.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
	public native void slideUp( int count);
	public native void slideUp();

/** 
 Set the number of pixels by which the ruler may slide down or right.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
	public native void slideDown( int count);
	public native void slideDown();

/** 
 Set ruler slide offset.

 This is like {@link #slideup} or {@link #slidedown} with an absolute offset
 from the start of the ruler.

*/
	public native void setOffset( int offset);

/** 
 Get the current ruler offset.

*/
	public native int offset();
	public native int endOffset();

/** 
 Sets the pointer to a new position.

 The offset is NOT updated.
 {@link QWidget#repaint} is called afterwards.

*/
	public native void slotNewValue( int arg1);

/** 
 Sets the ruler marks to a new position.

 The pointer is NOT updated.
 {@link QWidget#repaint} is called afterwards.

*/
	public native void slotNewOffset( int arg1);
	public native void slotEndOffset( int arg1);
	public static final int Custom = 0;
	public static final int Pixel = 0;
	public static final int Inch = 1;
	public static final int Millimetres = 2;
	public static final int Centimetres = 3;
	public static final int Metres = 4;
}

/** Override these methods in subclasses of KRuler to customise event handling behaviour */
interface KRulerEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

