/***************************************************************************
                            KSaveFile.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KSaveFile class has been made to write out changes to an existing
 file atomically.
 This means that EITHER:
 a)
   All changes have been written successfully to the file.

 b)
   Some error occured, no changes have been written whatsoever and the 
   old file is still in place.
 
 @short 
 The KSaveFile class has been made to write out changes to an existing
 file atomically.
*/
public class  KSaveFile implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KSaveFile(Class dummy){}

	private native void newKSaveFile( String filename, int mode);
	public KSaveFile( String filename, int mode) {
		newKSaveFile( filename, mode);
	}
	private native void newKSaveFile( String filename);
	public KSaveFile( String filename) {
		newKSaveFile( filename);
	}

/** 
 The destructor closes the file.

*/
	protected native void finalize() throws InternalError;

/** 
 Returns the status of the file based on errno. (see errno.h) 
 0 means OK.

 You should check the status after object creation to check 
 whether a file could be created in the first place.

 You may check the status after closing the file to verify that
 the file has indeed been written correctly.

*/
	public native int status();

/** 
 The name of the file as passed to the constructor.

*/
	public native String name();

/** 
 An integer file descriptor open for writing to the file 

*/
	public native int handle();

/** 
 A FILE stream open for writing to the file

*/
//	public native FILE* fstream();

/** 
 A QFile open for writing to the file

*/
	public native QFile file();

/** 
 A QTextStream open for writing to the file

*/
	public native QTextStream textStream();

/** 
 A QDataStream open for writing to the file

*/
	public native QDataStream dataStream();

/** 
 Aborts the write operation and removes any intermediate files 
 This implies a close.

*/
	public native void abort();

/** 
 Closes the file and makes the changes definitive.
 Returns 'true' is successfull, or 'false' if an error has occured.
 See status() for details about errors.

*/
	public native boolean close();
}
