/***************************************************************************
                            KService.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Represent a service, i.e. an application bound to one or several mimetypes
 (or servicetypes) as written in its desktop entry file.

 A service may be a library, too.
 The starting point you need is often the static methods.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Represent a service, i.
*/
public class KService extends KSycocaEntry  {
	protected KService(Class dummy){super((Class) null);}


/** 
 Construct a service and take all information from a config file.

*/
	private native void newKService( String _fullpath);
	public KService( String _fullpath) {
		super((Class) null);
		newKService( _fullpath);
	}

/** 
 Construct a service and take all information from a desktop file.
   
*/
	private native void newKService( KDesktopFile config);
	public KService( KDesktopFile config) {
		super((Class) null);
		newKService( config);
	}

/** 

 Construct a service from a stream.
 The stream must already be positionned at the correct offset.
   
*/
	private native void newKService( QDataStream _str, int offset);
	public KService( QDataStream _str, int offset) {
		super((Class) null);
		newKService( _str, offset);
	}
	protected native void finalize() throws InternalError;

/** 
 Returns the type of the service ("Application" or "Service").
   
*/
	public native String type();

/** 
 Returns the name of the service.
   
*/
	public native String name();

/** 
 Returns the command that the service executes.
   
*/
	public native String exec();

/** 
 Returns the name of the library that contains the services
         implementation.
   
*/
	public native String library();

/** 
 Returns the name of the init function to call in this service
 during startup of KDE. (KControl modules only)
   
*/
	public native String init();

/** 

   
*/
	public native int libraryMajor();
	public native int libraryMinor();
	public native ArrayList libraryDependencies();

/** 
 Returns the icon associated with the service.
   
*/
	public native String icon();

/** 
 Returns a pixmap for this service (finds and loads icon())
   
*/
	public native QPixmap pixmap( int _group, int _force_size, int _state, String _path);
	public native QPixmap pixmap( int _group);

/** 
 Returns <code>true</code> is the service is run in a terminal.
   
*/
	public native boolean terminal();

/** 
 Returns any options associated with the terminal the service
 runs in, if it requires a terminal.

 The service must be a tty-oriented program.
   
*/
	public native String terminalOptions();

/** 
 Returns <code>true</code> if the service has to be run under a different uid.
   
*/
	public native boolean substituteUid();

/** 
 Returns the username under which the service has to be run.
   
*/
	public native String username();

/** 
 Returns the path to the location where the service desktop entry
 is stored.

 This is a relative path if the desktop entry was found in any
 of the locations pointed to by $KDEDIRS (e.g. "Internet/kppp.desktop")
 It is a full path if the desktop entry originates from another
 location.
   
*/
	public native String desktopEntryPath();

/** 
 Returns the filename of the service desktop entry without any
 extension. E.g. "kppp"
   
*/
	public native String desktopEntryName();

/** 
 Returns The {@link DCOPServiceType} supported by this service.
   
*/
	public native int DCOPServiceType();

/** 
 Returns the working directory to run the program in.
   
*/
	public native String path();

/** 
 Returns the descriptive comment for the service, if there is one.
   
*/
	public native String comment();

/** 
 Returns a list of descriptive keywords the service, if there are any.
   
*/
	public native ArrayList keywords();

/** 
 Returns whether map notification should be used with this service.
   
*/
	public native boolean mapNotify();

/** 
 Returns the service types that this service supports.
   
*/
	public native ArrayList serviceTypes();

/** 

*/
	public native boolean hasServiceType( String _service);

/** 
 Returns <code>true</code> if the service may be used as a default setting, for
         example in a file manager. Usually that is the case, but
         some services may only be started when the user selected
         them. This kind of services returns <code>false</code> here.
   
*/
	public native boolean allowAsDefault();

/** 
 What preference to associate with this service initially (before
 the user has had any chance to define a profile for it)
 The bigger the value, the most preferred the service is.
   
*/
	public native int initialPreference();

/** 
 Returns the requested properties. Some often used properties
         have convenience access functions like {@link #exec},
         {@link serviceTypes} etc.

         It depends upon the {@link #serviceTypes} of this service which
         properties a service can have.

*/
	public native QVariant property( String _name);

/** 
 Returns the list of all properties that this service can have.
         That means, that some properties may be empty.
   
*/
	public native ArrayList propertyNames();

/** 
 Returns <code>true</code> if the service is valid (e.g. name is not empty)
   
*/
	public native boolean isValid();

/** 

 Load the service from a stream.
   
*/
	public native void load( QDataStream arg1);

/** 

 Save the service to a stream.
   
*/
	public native void save( QDataStream arg1);

/** 
 Find a service by name, i.e. the translated Name field. You should
 really not use this method, since the name is translated.

 Returns a pointer to the requested service or 0 if the service is
         unknown.
 <em>Very</em> <em>important</em>: Don't store the result in a {@link KService}  !
   
*/
	public static native int serviceByName( String _name);

/** 
 Find a service by its relative path to the applnk or services
 directory, for instance "Internet/konqbrowser.desktop". Better not use
 it for menu entries though, since the user can move them.
 It's ok to use it for services though (e.g. "http_cache_cleaner.desktop")

 Returns a pointer to the requested service or 0 if the service is
         unknown.
 <em>Very</em> <em>important</em>: Don't store the result in a {@link KService}  !
   
*/
	public static native int serviceByDesktopPath( String _name);

/** 
 Find a service by the name of its desktop file, not depending on
 its actual location (as long as it's under the applnk or service
 directories). For instance "konqbrowser" or "kcookiejar". Note that
 the ".desktop" extension is implicit.

 This is the recommended method (safe even if the user moves stuff)
 but note that it assumes that no two entries have the same filename.

 Returns a pointer to the requested service or 0 if the service is
         unknown.
 <em>Very</em> <em>important</em>: Don't store the result in a {@link KService}  !
   
*/
	public static native int serviceByDesktopName( String _name);

/** 
 Returns the whole list of services.

  Useful for being able to
 to display them in a list box, for example.
 More memory consuming than the ones above, don't use unless
 really necessary.
   
*/
	public static native List allServices();

/**  
 Returns all services that require initialisation.

 Only needed by "kcminit"
   
*/
	public static native List allInitServices();
	protected native void init( KDesktopFile config);
	protected native ArrayList accessServiceTypes();
	public static final int DCOP_None = 0;
	public static final int DCOP_Unique = 0;
	public static final int DCOP_Multi = 1;
	public static final int DCOP_Wait = 2;
}
