/***************************************************************************
                            KSimpleConfig.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 KDE Configuration entries

 This is a trivial extension of {@link KConfig} for applications that need
 only one configuration file and no default system.  It also adds
 the ability to delete keys and/or groups.  Lastly, when the data in
 memory is written back out by {@link #sync}, it is not merged with
 what is on disk.  Whatever is in memory simply replaces what is on
 disk entirely.

 @author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

 @version $Id: KSimpleConfig.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short KDE Configuration Management class with deletion ability.
*/
public class KSimpleConfig extends KConfig  {
	protected KSimpleConfig(Class dummy){super((Class) null);}


/**  
 Construct a KSimpleConfig object and make it either read-write
 or read-only.  

*/
	private native void newKSimpleConfig( String pFileName, boolean bReadOnly);
	public KSimpleConfig( String pFileName, boolean bReadOnly) {
		super((Class) null);
		newKSimpleConfig( pFileName, bReadOnly);
	}
	private native void newKSimpleConfig( String pFileName);
	public KSimpleConfig( String pFileName) {
		super((Class) null);
		newKSimpleConfig( pFileName);
	}

/**  
 Destructor. 

 Writes back any dirty configuration entries.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Delete a configuration entry.

*/
	public native String deleteEntry( String pKey, boolean bLocalized);
//	public native String deleteEntry( String pKey, boolean bLocalized);

/** 
 Delete a configuration entry group

 If the group is not empty and bDeep is false, nothing gets
 deleted and false is returned.
 If this group is the current group and it is deleted, the
 current group is undefined and should be set with setGroup()
 before the next operation on the configuration object.

*/
	public native boolean deleteGroup( String pGroup, boolean bDeep);
	public native boolean deleteGroup( String pGroup);
	public native void sync();
}

/** Override these methods in subclasses of KSimpleConfig to customise event handling behaviour */
interface KSimpleConfigEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

