/***************************************************************************
                            KTarGz.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 @author Torben Weis <weis@kde.org>, David Faure <faure@kde.org>
 
 @short A class for reading/writing optionnally-gzipped tar balls.
 Should be named KTar and be merged back with KTarBase - in KDE 3.0.

*/
public class KTarGz extends KTarBase  {
	protected KTarGz(Class dummy){super((Class) null);}


/** 
 Creates an instance that operates on the given filename.

*/
	private native void newKTarGz( String filename);
	public KTarGz( String filename) {
		super((Class) null);
		newKTarGz( filename);
	}

/** 
 Creates an instance that operates on the given file,
 using the compression filter associated to given mimetype.

*/
	private native void newKTarGz( String filename, String mimetype);
	public KTarGz( String filename, String mimetype) {
		super((Class) null);
		newKTarGz( filename, mimetype);
	}

/** 
 Creates an instance that operates on the given device.
 The device can be compressed (KFilterDev) or not (QFile, etc.).
   
*/
	private native void newKTarGz( QIODeviceInterface dev);
	public KTarGz( QIODeviceInterface dev) {
		super((Class) null);
		newKTarGz( dev);
	}

/** 
 If the tar ball is still opened, then it will be
 closed automatically by the destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
 The name of the tar file, as passed to the constructor
 Null if you used the QIODevice constructor.
   
*/
	public native String fileName();

/** 
 Special function for setting the "original file name" in the gzip header,
 when writing a tar.gz file. It appears when using in the "file" command,
 for instance. Should only be called if the underlying device is a KFilterDev!
   
*/
	public native void setOrigFileName( String fileName);
}
