/***************************************************************************
                            KTempFile.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KTempFile class creates and opens a unique file for temporary use.

 This is especially useful if you need to create a file in a world
 writable directory like /tmp without being vulnerable to so called
 symlink attacks.

 KDE applications, however, shouldn't create files in /tmp in the first 
 place but use the "tmp" resource instead. The standard KTempFile 
 constructor will do that by default.

 To create a temporary file that starts with a certain name
 in the "tmp" resource, one should use:
 KTempFile(locateLocal("tmp", prefix), extension);

 KTempFile does not create any missing directories, but locateLocal() does.

 See also {@link KStandardDirs}

 @author Waldo Bastian <bastian@kde.org>
 
 @short 
 The KTempFile class creates and opens a unique file for temporary use.
*/
public class  KTempFile implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KTempFile(Class dummy){}


/** 
 Create a temporary file with the name:
  <filePrefix><some number><fileExtension>

 The default <code>filePrefix</code> is "$KDEHOME/tmp-$HOST/appname"
 The default <code>fileExtension</code> is ".tmp"

 Note that the use of 'X' is forbidden in <code>fileExtension</code>

*/
	private native void newKTempFile( String filePrefix, String fileExtension, int mode);
	public KTempFile( String filePrefix, String fileExtension, int mode) {
		newKTempFile( filePrefix, fileExtension, mode);
	}
	private native void newKTempFile();
	public KTempFile() {
		newKTempFile();
	}

/** 
 The destructor closes the file.
 If autoDelete is enabled the file gets unlinked as well.

*/
	protected native void finalize() throws InternalError;

/** 
 Turn automatic deletion on or off.
 Automatic deletion is off by default.

*/
	public native void setAutoDelete( boolean autoDelete);

/** 
 Returns the status of the file based on errno. (see errno.h) 
 0 means OK.

 You should check the status after object creation to check 
 whether a file could be created in the first place.

 You may check the status after closing the file to verify that
 the file has indeed been written correctly.

*/
	public native int status();

/** 
 The name of the file.

*/
	public native String name();

/** 
 An integer file descriptor open for writing to the file 

*/
	public native int handle();

/** 

*/
//	public native FILE* fstream();

/** 

*/
	public native QTextStream textStream();

/** 

*/
	public native QDataStream dataStream();

/** 
 A QFile open for writing to the file

*/
	public native QFile file();

/** 
 Unlinks the file from the directory. The file is
 deleted once the last reader/writer closes it.

*/
	public native void unlink();

/** 
 Closes the file.
 Returns 'true' is successfull, or 'false' if an error has occured.
 See status() for details about errors.

*/
	public native boolean close();

/** 
 Constructor used by KSaveFile

*/
	private native void newKTempFile( boolean arg1);
	public KTempFile( boolean arg1) {
		newKTempFile( arg1);
	}

/** 

 Create function used internally by KTempFile and KSaveFile

*/
	protected native boolean create( String filePrefix, String fileExtension, int mode);
	protected native void setError( int error);
}
