/***************************************************************************
                            KTextBrowser.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An extended {@link QTextBrowser}.

 By default it will
 invoke the system mailer or the system browser when a link is
 activated, or it can emit the signal {@link #urlClick} or {@link #mailClick}
 when a link is activated.

 @author Espen Sand (espensa@online.no)

 @version $Id: KTextBrowser.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short Extended QTextBrowser.

*/
public class KTextBrowser extends QTextBrowser  {
	protected KTextBrowser(Class dummy){super((Class) null);}


/** 
 Constructor.

*/
	private native void newKTextBrowser( QWidget parent, String name, boolean notifyClick);
	public KTextBrowser( QWidget parent, String name, boolean notifyClick) {
		super((Class) null);
		newKTextBrowser( parent, name, notifyClick);
	}
	private native void newKTextBrowser();
	public KTextBrowser() {
		super((Class) null);
		newKTextBrowser();
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Decide whether a click on a link should be handled internally
 or if a signal should be emitted.

*/
	public native void setNotifyClick( boolean notifyClick);

/** 
 Returns whether a click on a link should be handled internally
 or if a signal should be emitted.
     
*/
	public native boolean isNotifyClick();

/** 
       Reimplemented to NOT set the source but to do the special handling.
       Do not call.
     
*/
	public native void setSource( String name);
}

/** Override these methods in subclasses of KTextBrowser to customise event handling behaviour */
interface KTextBrowserEventHandling {

/** 
 Makes sure Key_Escape is ignored
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void contentsDropEvent(QDropEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void contentsDragLeaveEvent(QDragLeaveEvent arg1);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);
	void contentsMouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);

/** 
 Make sure we use our own hand cursor
     
*/
	void viewportMouseMoveEvent(QMouseEvent e);
	void mouseMoveEvent(QMouseEvent arg1);
	void contentsDragMoveEvent(QDragMoveEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void contentsMouseReleaseEvent(QMouseEvent arg1);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void contentsDragEnterEvent(QDragEnterEvent arg1);
	void contentsMouseMoveEvent(QMouseEvent arg1);
	void contentsMousePressEvent(QMouseEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void viewportPaintEvent(QPaintEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void viewportResizeEvent(QResizeEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

