/***************************************************************************
                            KTipDialog.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A Tip-of-the-Day dialog.

 This dialog class presents a tip-of-the-day.

 @author Matthias Hoelzer-Kluepfel <mhk@caldera.de>
 
 @short 
 A Tip-of-the-Day dialog.
*/
public class KTipDialog extends KDialog  {
	protected KTipDialog(Class dummy){super((Class) null);}


/** 
 Show a tip.

 This static method is all that is needed to add a tip-of-the-day
 dialog to an application. It will pop up the dialog, unless the
 user has asked that the dialog does not pop up on startup.

 Note that you probably want an item in the help menu calling
 this method with force=true.

*/
	public static native void showTip( QWidget parent, String tipFile, boolean force);
	public static native void showTip( QWidget parent);

/** 
 Show a tip.

 This methods calls showTip() with the applications main window as parent.

   
*/
	public static native void showTip( String tipFile, boolean force);
	public static native void showTip();

/** 
 Toggle the start behaviour.

 Normally, the user can disable the display of the tip in the dialog.
 This is just a way to change this setting from outside.
   
*/
	public static native void setShowOnStart( boolean show);
	private native void newKTipDialog( KTipDatabase db, QWidget parent, String name);
	public KTipDialog( KTipDatabase db, QWidget parent, String name) {
		super((Class) null);
		newKTipDialog( db, parent, name);
	}
	private native void newKTipDialog( KTipDatabase db);
	public KTipDialog( KTipDatabase db) {
		super((Class) null);
		newKTipDialog( db);
	}
}

/** Override these methods in subclasses of KTipDialog to customise event handling behaviour */
interface KTipDialogEventHandling {

/** 

     
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

