/***************************************************************************
                            KToolBarButton.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A toolbar button. This is used internally by {@link KToolBar}, use the
 KToolBar methods instead.

 
 @short 
 A toolbar button.
*/
public class KToolBarButton extends QToolButton  {
	protected KToolBarButton(Class dummy){super((Class) null);}


/** 
 Construct a button with an icon loaded by the button itself.
 This will trust the button to load the correct icon with the
 correct size.

*/
	private native void newKToolBarButton( String icon, int identifier, QWidget parent, String name, String txt, KInstance _instance);
	public KToolBarButton( String icon, int identifier, QWidget parent, String name, String txt, KInstance _instance) {
		super((Class) null);
		newKToolBarButton( icon, identifier, parent, name, txt, _instance);
	}
	private native void newKToolBarButton( String icon, int identifier, QWidget parent);
	public KToolBarButton( String icon, int identifier, QWidget parent) {
		super((Class) null);
		newKToolBarButton( icon, identifier, parent);
	}

/** 
 Construct a button with an existing pixmap.  It is not
 recommended that you use this as the internal icon loading code
 will almost always get it "right".

*/
	private native void newKToolBarButton( QPixmap pixmap, int identifier, QWidget parent, String name, String txt);
	public KToolBarButton( QPixmap pixmap, int identifier, QWidget parent, String name, String txt) {
		super((Class) null);
		newKToolBarButton( pixmap, identifier, parent, name, txt);
	}
	private native void newKToolBarButton( QPixmap pixmap, int identifier, QWidget parent);
	public KToolBarButton( QPixmap pixmap, int identifier, QWidget parent) {
		super((Class) null);
		newKToolBarButton( pixmap, identifier, parent);
	}

/** 
 Construct a separator button

*/
	private native void newKToolBarButton( QWidget parent, String name);
	public KToolBarButton( QWidget parent, String name) {
		super((Class) null);
		newKToolBarButton( parent, name);
	}
	private native void newKToolBarButton();
	public KToolBarButton() {
		super((Class) null);
		newKToolBarButton();
	}

/** 
 Standard destructor
   
*/
	protected native void finalize() throws InternalError;

/** 
 Enable/Disable this button

*/
	public native void setEnabled( boolean enable);
	public native void setEnabled();

/** 
 Set the pixmap directly for this button.  This pixmap should be
 the active one... the dimmed and disabled pixmaps are constructed
 based on this one.  However, don't use this function unless you
 are positive that you don't want to use {@link setIcon}.

*/
	public native void setPixmap( QPixmap pixmap);

/** 
 Set the pixmap directly for this button.  This pixmap should be
 the active one.. however, the disabled and default pixmaps will
 only be constructed if {@link #generate} is true.  In any event,
 don't use this function unless you are positive that you don't
 want to use {@link setIcon}.

*/
	public native void setPixmap( QPixmap pixmap, boolean generate);

/** 
 Force the button to use this pixmap as the default one rather
 then generating it using effects.

*/
	public native void setDefaultPixmap( QPixmap pixmap);

/** 
 Force the button to use this pixmap when disabled one rather then
 generating it using effects.

*/
	public native void setDisabledPixmap( QPixmap pixmap);

/** 
 Set the text for this button.  The text will be either used as a
 tooltip (IconOnly) or will be along side the icon

*/
	public native void setText( String text);

/** 
 Set the icon for this button.  This icon should be the active
 one... the dimmed and disabled icons are constructed based on
 this one.  The actual pixmap will be loaded internally.  This
 function is preferred over {@link setPixmap}

*/
	public native void setIcon( String icon);

/** 
 Set the active icon for this button.  The pixmap itself is loaded
 internally based on the icon size...  .. the disabled and default
 pixmaps, however will only be constructed if {@link #generate} is
 true.  This function is preferred over {@link setPixmap}

*/
	public native void setIcon( String icon, boolean generate);

/** 
 Force the button to use this icon as the default one rather
 then generating it using effects.

*/
	public native void setDefaultIcon( String icon);

/** 
 Force the button to use this icon when disabled one rather then
 generating it using effects.

*/
	public native void setDisabledIcon( String icon);

/** 
 Set the pixmaps for this toolbar button from a QIconSet.
 If you call this you don't need to call any of the other methods
 that set icons or pixmaps.

*/
	public native void setIconSet( QIconSet iconset, boolean on);
	public native void setIconSet( QIconSet iconset);

/** 
 Turn this button on or off

*/
	public native void on( boolean flag);
	public native void on();

/** 
 Toggle this button
   
*/
	public native void toggle();

/** 
 Turn this button into a toggle button or disable the toggle
 aspects of it.  This does not toggle the button itself.  Use {@link toggle} for that.

*/
	public native void setToggle( boolean toggle);
	public native void setToggle();

/** 
 Return a pointer to this button's popup menu (if it exists)
   
*/
	public native QPopupMenu popup();

/** 
 Give this button a popup menu.  There will not be a delay when
 you press the button.  Use {@link setDelayedPopup} if you want that
 behavior

*/
	public native void setPopup( QPopupMenu p);

/** 
 See {@link setDelayedPopup} for a description of toggle
   
*/
	public native void setPopup( QPopupMenu p, boolean toggle);

/** 
 Gives this button a delayed popup menu.

 This function allows you to add a delayed popup menu to the button.
 The popup menu is then only displayed when the button is pressed and
 held down for about half a second.  You can also make the poup-menu
 "sticky", i.e. visible until a selection is made or the mouse is
 clikced elsewhere, by simply setting the second argument to true.
 This "sticky" button feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.

*/
	public native void setDelayedPopup( QPopupMenu p, boolean toggle);
	public native void setDelayedPopup( QPopupMenu p);

/** 
 Turn this button into a radio button

*/
	public native void setRadio( boolean f);
	public native void setRadio();

/** 
 Toolbar buttons naturally will assume the global styles
 concerning icons, icons sizes, etc.  You can use this function to
 explicitely turn this off, if you like.

*/
	public native void setNoStyle( boolean no_style);
	public native void setNoStyle();

/** 
 This slot should be called whenever the toolbar mode has
 potentially changed.  This includes such events as text changing,
 orientation changing, etc.
   
*/
	public native void modeChange();
	public native void setTextLabel( String arg1);
	protected native void paletteChange( QPalette arg1);
	protected native void drawButton( QPainter p);
	public native boolean eventFilter( QObject o, QEvent e);
	protected native void showMenu();
	protected native void makeDefaultPixmap();
	protected native void makeDisabledPixmap();
	protected native void slotClicked();
	protected native void slotPressed();
	protected native void slotReleased();
	protected native void slotToggled();
	protected native void slotDelayTimeout();
}

/** Override these methods in subclasses of KToolBarButton to customise event handling behaviour */
interface KToolBarButtonEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent e);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent e);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

