/***************************************************************************
                            KToolBarPopupAction.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu. This action is designed
 for history actions (back/forward, undo/redo) and for any other action
 that has more detail in a toolbar than in a menu (e.g. tool chooser
 with "Other" leading to a dialog...).
 
 @short 
 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu.
*/
public class KToolBarPopupAction extends KAction  {
	protected KToolBarPopupAction(Class dummy){super((Class) null);}


/** 
 Create a KToolBarPopupAction, with a text, an icon, an optionnal accelerator,
 parent and name.

*/
	private native void newKToolBarPopupAction( String text, String icon, int accel, QObject parent, String name);
	public KToolBarPopupAction( String text, String icon, int accel, QObject parent, String name) {
		super((Class) null);
		newKToolBarPopupAction( text, icon, accel, parent, name);
	}
	private native void newKToolBarPopupAction( String text, String icon);
	public KToolBarPopupAction( String text, String icon) {
		super((Class) null);
		newKToolBarPopupAction( text, icon);
	}

/** 
 Create a KToolBarPopupAction, with a text, an icon, an accelerator,
 a slot connected to the action, parent and name.

 If you do not want or have a keyboard accelerator, set the
 <code>accel</code> param to 0.

*/
	private native void newKToolBarPopupAction( String text, String icon, int accel, QObject receiver, String slot, QObject parent, String name);
	public KToolBarPopupAction( String text, String icon, int accel, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKToolBarPopupAction( text, icon, accel, receiver, slot, parent, name);
	}
//	private native void newKToolBarPopupAction( String text, String icon, int accel, QObject receiver, String slot);
//	public KToolBarPopupAction( String text, String icon, int accel, QObject receiver, String slot) {
//		super((Class) null);
//		newKToolBarPopupAction( text, icon, accel, receiver, slot);
//	}
	protected native void finalize() throws InternalError;
	public native int plug( QWidget widget, int index);
	public native int plug( QWidget widget);
	public native void unplug( QWidget widget);

/** 
 The popup menu that is shown when clicking (some time) on the toolbar
 button. You may want to plug items into it on creation, or connect to
 aboutToShow for a more dynamic menu.
     
*/
	public native KPopupMenu popupMenu();

/** 
 Returns true if this action creates a delayed popup menu
 when plugged in a KToolbar.
     
*/
	public native boolean delayed();

/** 
 If set to true, this action will create a delayed popup menu
 when plugged in a KToolbar. Otherwise it creates a normal popup.
 Default: delayed.
     
*/
	public native void setDelayed( boolean delayed);

/** 
 Returns true if this action creates a sticky popup menu.
 See {@link setStickyMenu}.
     
*/
	public native boolean stickyMenu();

/** 
 If set to true, this action will create a sticky popup menu
 when plugged in a KToolbar.
 "Sticky", means it's visible until a selection is made or the mouse is
 clicked elsewhere. This feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.
 Only available if delayed() is true.
 Default: sticky.
     
*/
	public native void setStickyMenu( boolean sticky);
}

/** Override these methods in subclasses of KToolBarPopupAction to customise event handling behaviour */
interface KToolBarPopupActionEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

