/***************************************************************************
                            KTrader.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A Trader interface, similar to the CORBA Trader.

 Basically, it provides a way for an application to query
 all KDE services (that is, applications and components) that match
 a specific set of requirements.  This allows you to find an
 application in real-time without you having to hard-code the name
 and/or path of the application.  It is mostly used when you want to
 do complex queries that {@link KServiceTypeProfile} can't handle.

 A few examples will make this a lot more clear.

 Say you have an application that will display HTML.  In this
 example, you don't want to link to khtml... and furthermore, you
 really don't care if the HTML browser is ours or not, as long as
 it works.  The way that you formulate your query as well as the way
 that you execute the browser depends on whether or not you want the
 browser to run stand-alone or embedded.

 If you want the browser to run standalone, then you will limit the
 query to search for all services that handle 'text/html' <em>and</em>,
 furthermore, they must be applications (Type=Application).  You
 then will use {@link KRun#run} to invoke the application.  In "trader-speak",
 this looks like so:
 <PRE>
 KTrader.OfferList offers = KTrader.self().query("text/plain", "Type == 'Application'");
 KService.Ptr ptr = offers.first();
 KURL.List lst;
 lst.append("http://www.kde.org/index.html");
 KRun.run(ptr, lst);
 </PRE>

 It should be noted that in the above example, using
 {@link KServiceTypeProfile} would be the better choice since you would
 probably want the preferred service and the trader doesn't take
 this into account.  The trader does allow you to do more complex
 things, though.  Say, for instance, you want to only choose
 Netscape.  You can do it with the constraint: "(Type ==
 'Application') and (Name == 'Netscape')"

 More the likely, though, you will only use the trader for such
 things as finding components.  In our continuing example, we say
 that we want to load any KParts component that can handle HTML.  We
 will need to use the {@link KLibFactory} and {@link KLibLoader} to
 actually do something with our query, then.  Our code would look
 like so:
 <PRE>
 KTrader.OfferList offers = KTrader.self().query("text/html", "'KParts/ReadOnlyPart' in ServiceTypes");
 KService.Ptr ptr = offers.begin();
 KLibFactory factory = KLibLoader.self().factory( ptr.library() );
 if (factory)
   part = static_cast<KParts.ReadOnlyPart >(factory.create(this, ptr.name(), "KParts.ReadOnlyPart"));
 </PRE>

 Please note that when including property names containing arithmetic operators like - or +, then you have
 to put brackets around the property name, in order to correctly separate arithmetic operations from
 the name. So for example a constraint expression like
  X-KDE-Blah < 4
 needs to be written as
 [X-KDE-Blah] < 4
 otherwise it could also be interpreted as
 Substract the numeric value of the property "KDE" and "Blah" from the property "X" and make sure it
 is less than 4.
 Instead of the other meaning, make sure that the numeric value of "X-KDE-Blah" is less than 4.

 @author Torben Weis <weis@kde.org>
 
 @short Provides a way to query the KDE infrastructure for specific
        applications or components.

*/
public class KTrader extends QObject  {
	protected KTrader(Class dummy){super((Class) null);}


/** 
 Standard destructor
     
*/
	protected native void finalize() throws InternalError;

/** 
 The main function in the KTrader class.

 It will return a list of services that match your
 specifications.  The only required parameter is the service
 type.  This is something like 'text/plain' or 'text/html'.  The
 constraint parameter is used to limit the possible choices
 returned based on the constraints you give it.

 The constraint language is rather full.  The most common
 keywords are AND, OR, NOT, IN, and EXIST.. all used in an
 almost spoken-word form.  An example is:
 <PRE>
 (Type == 'Service') and (('KPart.ReadOnlyPart in 'ServiceType') or (exist Exec))
 </PRE>

 The keys used in the query (Type, ServiceType, Exec) are all
 fields found in the .desktop files.

*/
	public native ArrayList query( String servicetype, String constraint, String preferences);
	
	public ArrayList query( String servicetype, String constraint)
	{
		return query(servicetype, constraint, null);
	} 	
	
	public ArrayList query( String servicetype)
	{
		return query(servicetype, null, null);
	} 	

/** 
 A variant of query, that takes two service types as an input.
 It is not exactly the same as adding the second service type
 in the constraints of the other query call, because this one
 takes into account user preferences for this combination of service types.

 Typically, this is used for getting the list of embeddable components
 that can handle a given mimetype.
 In that case, <code>servicetype</code> is the mimetype and <code>genericServiceType</code> is "KParts/ReadOnlyPart".
     
*/
	public native ArrayList query( String servicetype, String genericServiceType, String constraint, String preferences);

/** 
 This is a static pointer to a {@link KTrader} instance.

  You will need
 to use this to access the KTrader functionality since the
 constuctors are protected.

*/
	public static native KTrader self();

/** 

     
*/
	private native void newKTrader();
	public KTrader() {
		super((Class) null);
		newKTrader();
	}
}

/** Override these methods in subclasses of KTrader to customise event handling behaviour */
interface KTraderEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

