/***************************************************************************
                            KURLCompletion.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class does completion of URLs including user directories (~user)
 and environment variables.  Remote URLs are passed to KIO.

 @author David Smith <dsmith@algonet.se>

 @version $Id: KURLCompletion.java,v 1.3 2001/05/16 22:52:51 rdale Exp $
 
 @short Completion of a single URL.
*/
public class KURLCompletion extends KCompletion  {
	protected KURLCompletion(Class dummy){super((Class) null);}

	private native void newKURLCompletion();
	public KURLCompletion() {
		super((Class) null);
		newKURLCompletion();
	}

/** 
 This overloaded constructor allows you to set the Mode to ExeCompletion
 or FileCompletion without using {@link setMode}. Default is FileCompletion
	 
*/
	private native void newKURLCompletion( int arg1);
	public KURLCompletion( int arg1) {
		super((Class) null);
		newKURLCompletion( arg1);
	}
	protected native void finalize() throws InternalError;

/** 
 Find completions to the given text

 Remote URLs are listed with KIO. For performance reasons, local files
 are listed with KIO only if KURLCOMPLETION_LOCAL_KIO is set.
 The completion is done asyncronously if KIO is used.

 Returns the first match for user, environment, and local dir completion
 and String.null for asyncronous completion (KIO)
	 
*/
	public native String makeCompletion( String arg1);

/** 
 Set the current directory (used as base for completion)
 Default = $HOME
	 
*/
	public native void setDir( String dir);

/** 
 Get the current directory
	 
*/
	public native String dir();

/** 
 Returns true if asyncronous completion is in progress
	 
*/
	public native boolean isRunning();

/** 
 Stop asyncronous copmpletion
	 
*/
	public native void stop();

/** 
 Return completion mode: exe or file completion (default FileCompletion)
	 
*/
	public native int mode();

/** 
 Change completion mode: exe or file completion
	 
*/
	public native void setMode( int mode);

/** 
 Returns whether environment variables are completed and
 whether they are replaced internally while finding completions.
 Default is enabled.
	 
*/
	public native boolean replaceEnv();

/** 
 Enables/disables completion and replacement (internally) of
 environment variables in URLs. Default is enabled.
	 
*/
	public native void setReplaceEnv( boolean replace);

/** 
 Returns whether ~username is completed and whether ~username
 is replaced internally with the user's home directory while
 finding completions. Default is enabled.
	 
*/
	public native boolean replaceHome();

/** 
 Enables/disables completion of ~username and replacement
 (internally) of ~username with the user's home directory.
 Default is enabled.
	 
*/
	public native void setReplaceHome( boolean replace);

/** 
 Replaces username and/or environment variables, depending on the
 current settings and returns the filtered url. Only works with
 local files, i.e. returns back the original string for non-local
 urls.
	 
*/
	public native String replacedPath( String text);
	protected native void postProcessMatch( String match);
	protected native void postProcessMatches( String[] matches);
//	protected native void slotEntries( Job arg1, UDSEntryList arg2);
	protected native void slotIOFinished( Job arg1);
	public static final int ExeCompletion = 1;
	public static final int FileCompletion = 0;
}

/** Override these methods in subclasses of KURLCompletion to customise event handling behaviour */
interface KURLCompletionEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

