/***************************************************************************
                            KURLDrag.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is to be used instead of QUriDrag when using KURL.
 The reason is : QUriDrag (and the XDND/W3C standards) expect URLs to
 be encoded in UTF-8 (unicode), but KURL uses the current locale
 by default.
 The other reason for using this class is that it exports text/plain
 (for dropping/pasting into lineedits, mails etc.)

 To create a drag object, use KURLDrag.newDrag with a list of KURLs.
 To decode a drop, use KURLDrag.decode or QUriDrag.decodeLocalFiles.
 
 @short 
 This class is to be used instead of QUriDrag when using KURL.
*/
public class KURLDrag extends QUriDrag  {
	protected KURLDrag(Class dummy){super((Class) null);}


/** 
 Constructs an object to drag the list of URLs in urls.
 The dragSource and name arguments are passed on to QUriDrag,
 and the list of urls is converted to UTF-8 before being passed
 to QUriDrag.
   
*/
	public static native QUriDrag newDrag( ArrayList urls, QWidget dragSource, String name);
	public static native QUriDrag newDrag( ArrayList urls);

/** 
 Convenience method that decodes the contents of <code>e</code>
 into a list of KURLs.
   
*/
	public static native boolean decode( QMimeSourceInterface e, ArrayList urls);

/** 
 Protected constructor - use {@link newDrag}
   
*/
	private native void newKURLDrag( String[] urls, QWidget dragSource, String name);
	public KURLDrag( String[] urls, QWidget dragSource, String name) {
		super((Class) null);
		newKURLDrag( urls, dragSource, name);
	}
	private native void newKURLDrag();
	public KURLDrag() {
		super((Class) null);
		newKURLDrag();
	}
	public native String format( int i);
	public native byte[] encodedData( String mime);
}

/** Override these methods in subclasses of KURLDrag to customise event handling behaviour */
interface KURLDragEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

