/***************************************************************************
                            NamedNodeMap.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Objects implementing the <code> NamedNodeMap </code> interface are
 used to represent collections of nodes that can be accessed by
 name. Note that <code> NamedNodeMap </code> does not inherit from
 <code> NodeList </code> ; <code> NamedNodeMap </code> s are not
 maintained in any particular order. Objects contained in an object
 implementing <code> NamedNodeMap </code> may also be accessed by an
 ordinal index, but this is simply to allow convenient enumeration
 of the contents of a <code> NamedNodeMap </code> , and does not
 imply that the DOM specifies an order to these Nodes.

 
 @short 
 Objects implementing the <code> NamedNodeMap </code> interface are
 used to represent collections of nodes that can be accessed by
 name.
*/
public class  NamedNodeMap implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected NamedNodeMap(Class dummy){}

	private native void newNamedNodeMap();
	public NamedNodeMap() {
		newNamedNodeMap();
	}
	private native void newNamedNodeMap( NamedNodeMap other);
	public NamedNodeMap( NamedNodeMap other) {
		newNamedNodeMap( other);
	}
	protected native void finalize() throws InternalError;

/** 
 The number of nodes in the map. The range of valid child node
 indices is 0 to <code> length-1 </code> inclusive.

     
*/
	public native long length();

/** 
 Retrieves a node specified by name.

     
*/
	public native DOMNode getNamedItem( String name);

/** 
 Adds a node using its <code> nodeName </code> attribute.

  As the <code> nodeName </code> attribute is used to derive the
 name which the node must be stored under, multiple nodes of
 certain types (those that have a "special" string value) cannot
 be stored as the names would clash. This is seen as preferable
 to allowing nodes to be aliased.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this <code>
 NamedNodeMap </code> is readonly.

  INUSE_ATTRIBUTE_ERR: Raised if <code> arg </code> is an <code>
 Attr </code> that is already an attribute of another <code>
 Element </code> object. The DOM user must explicitly clone
 <code> Attr </code> nodes to re-use them in other elements.

     
*/
	public native DOMNode setNamedItem( DOMNode arg);

/** 
 Removes a node specified by name. If the removed node is an
 <code> Attr </code> with a default value it is immediately
 replaced.

     
*/
	public native DOMNode removeNamedItem( String name);

/** 
 Returns the <code> index </code> th item in the map. If <code>
 index </code> is greater than or equal to the number of nodes
 in the map, this returns <code> null </code> .

     
*/
	public native DOMNode item( long index);

/** 

 not part of the DOM
     
*/
//	public native NamedNodeMapImpl handle();
	public native boolean isNull();
//	private native void newNamedNodeMap( NamedNodeMapImpl i);
//	public NamedNodeMap( NamedNodeMapImpl i) {
//		newNamedNodeMap( i);
//	}
}
