/***************************************************************************
                            PtyProcess.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Synchronous communication with tty programs.

 PtyProcess provides synchronous communication with tty based programs. 
 The communications channel used is a pseudo tty (as opposed to a pipe) 
 This means that programs which require a terminal will work.
 
 @short 
 Synchronous communication with tty programs.
*/
public class  PtyProcess implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected PtyProcess(Class dummy){}

	private native void newPtyProcess();
	public PtyProcess() {
		newPtyProcess();
	}
	protected native void finalize() throws InternalError;

/** 
 Fork off and execute a command. The command's standard in and output 
 are connected to the pseudo tty. They are accessible with {@link #readLine} 
 and {@link #writeLine.}

*/
	public native int exec( String command, String args);

/** 
 Read a line from the program's standard out. Depending on the <em>block</em> 
 parameter, this call blocks until a single, full line is read. 

*/
	public native String readLine( boolean block);

/** 
 Write a line of text to the program's standard in.

*/
	public native void writeLine( String line, boolean addNewline);
	public native void writeLine( String line);

/** 
 Put back a line of input.

*/
	public native void unreadLine( String line, boolean addNewline);
	public native void unreadLine( String line);

/** 
 Set exit string. If a line of program output matches this,
 {@link #waitForChild} will terminate the program and return.
     
*/
	public native void setExitString( String exit);

/** 
 Wait for the child to exit. See also {@link #setExitString.}
     
*/
	public native int waitForChild();

/** 
 Wait until the pty has cleared the ECHO flag. This is usefull 
 when programs write a password prompt before they disable ECHO.
 Disabling it might flush any input that was written.
     
*/
	public native int WaitSlave();

/**  Enables/disables local echo on the pseudo tty. 
*/
	public native int enableLocalEcho( boolean enable);
	public native int enableLocalEcho();

/**  Enable/disable terminal output. Relevant only to some subclasses. 
*/
	public native void setTerminal( boolean terminal);

/**  Overwritte the password as soon as it is used. Relevant only to
 some subclasses. 
*/
	public native void setErase( boolean erase);

/**  Return the filedescriptor of the process. 
*/
	public native int fd();

/**  Return the pid of the process. 
*/
	public native int pid();
}
