/***************************************************************************
                            ReadOnlyPart.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Base class for any "viewer" part.

 This class takes care of network transparency for you,
 in the simplest way (synchronously).
 To use the built-in network transparency, you only need to implement
 {@link #openFile}, not {@link #openURL}.
 To prevent network transparency, or to implement it another way
 (e.g. asynchronously), override openURL().

 KParts Application can use the signals to show feedback while the URL is being loaded.

 ReadOnlyPart handles the window caption by setting it to the current URL
 (set in {@link #openURL}, and each time the part is activated).
 If you want another caption, set it in {@link #openFile} and
 (if the part might ever be used with a part manager) in {@link #guiActivateEvent}
 
 @short 
 Base class for any "viewer" part.
*/
public class ReadOnlyPart extends Part  {
	protected ReadOnlyPart(Class dummy){super((Class) null);}


/** 
 Constructor
 See also {@link Part} for the setXXX methods to call.
   
*/

/** 
 Destructor
   
*/
	protected native void finalize() throws InternalError;

/** 
 Call this to turn off the progress info dialog used by
 the internal KIO job. Use this if you provide another way
 of displaying progress info (e.g. a statusbar), using the
 signals emitted by this class, and/or those emitted by
 the Job given by {@link started}.
   
*/
	public native void showProgressInfo( boolean show);

/** 
  Retrieves the currently in part used URL.

*/
	public native KURL url();

/** 
 Called when closing the current url (e.g. document), for instance
 when switching to another url (note that {@link #openURL} calls it
 automatically in this case).
 If the current URL is not fully loaded yet, aborts loading.
 Deletes the temporary file used when the url is remote.

*/
	public native boolean closeURL();

/** 
 Only reimplement openURL if you don't want synchronous network transparency
 Otherwise, reimplement {@link #openFile} only .

 If you reimplement it, don't forget to set the caption, usually with
 emit setWindowCaption( url.prettyURL() );
   
*/
	public native boolean openURL( KURL url);

}
