/***************************************************************************
                            SynthOut.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Synth (AWE) device output class . SynthOut is used to send MIDI events to
 a general synthesizer, such as AWE synth.

 SynthOut inherits {@link MidiOut} and supports the same simple API.

 The preferred way to use this class is by selecting a synth (or AWE)
 device with {@link MidiManager#setDefaultDevice}, and use a 
 {@link MidiManager} object.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to AWE synthesizers.
*/
public class SynthOut extends MidiOut  {
	protected SynthOut(Class dummy){super((Class) null);}


/** 
 Constructor. See {@link MidiOut#MidiOut} for more information.
     
*/
	private native void newSynthOut( int d);
	public SynthOut( int d) {
		super((Class) null);
		newSynthOut( d);
	}
	private native void newSynthOut();
	public SynthOut() {
		super((Class) null);
		newSynthOut();
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 See {@link MidiOut#openDev}
     
*/
	public native void openDev( int sqfd);

/** 
 See {@link MidiOut#closeDev}
     
*/
	public native void closeDev();

/** 
 See {@link MidiOut#initDev}
     
*/
	public native void initDev();

/** 
 See {@link MidiOut#noteOn}
     
*/
	public native void noteOn( String chn, String note, String vel);

/** 
 See {@link MidiOut#noteOff}
     
*/
	public native void noteOff( String chn, String note, String vel);

/** 
 See {@link MidiOut#keyPressure}
     
*/
	public native void keyPressure( String chn, String note, String vel);

/** 
 See {@link MidiOut#chnPatchChange}
     
*/
	public native void chnPatchChange( String chn, String patch);

/** 
 See {@link MidiOut#chnPressure}
     
*/
	public native void chnPressure( String chn, String vel);

/** 
 See {@link MidiOut#chnPitchBender}
     
*/
	public native void chnPitchBender( String chn, String lsb, String msb);

/** 
 See {@link MidiOut#chnController}
     
*/
	public native void chnController( String chn, String ctl, String v);

/** 
 It's an empty function, as AWE devices don't support System Exclusive
 messages
     
*/
	public native void sysex( String data, long size);
}
