/***************************************************************************
                            TransferJob.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The transfer job pumps data into and/or out of a Slave.
 Data is sent to the slave on request of the slave ({@link dataReq}).
 If data coming from the slave can not be handled, the
 reading of data from the slave should be suspended.
     
 @short 
 The transfer job pumps data into and/or out of a Slave.
*/
public class TransferJob extends SimpleJob  {
	protected TransferJob(Class dummy){super((Class) null);}

	private native void newTransferJob( KURL url, int command, byte[] packedArgs, byte[] _staticData, boolean showProgressInfo);
	public TransferJob( KURL url, int command, byte[] packedArgs, byte[] _staticData, boolean showProgressInfo) {
		super((Class) null);
		newTransferJob( url, command, packedArgs, _staticData, showProgressInfo);
	}
	public native void start( Slave slave);

/** 
 Called when m_subJob finishes.
         
*/
	public native void slotResult( Job job);

/** 
 Flow control. Suspend data processing from the slave.
         
*/
	public native void suspend();

/** 
 Flow control. Resume data processing from the slave.
         
*/
	public native void resume();

/** 
 Set meta data to be sent to the slave.
         
*/
//	public native void setMetaData( MetaData arg1);

/** 
 Add key/value pair to the meta data that is sent to the slave.
         
*/
	public native void addMetaData( String key, String value);

/** 

         
*/
//	public native MetaData outgoingMetaData();

/** 
 Get meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
//	public native MetaData metaData();

/** 
 Query meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
	public native String queryMetaData( String key);

/** 

*/
	public native boolean isErrorPage();
	protected native void slotRedirection( KURL url);
	protected native void slotFinished();
	protected native void slotData( byte[] data);
	protected native void slotDataReq();
	protected native void slotMimetype( String mimetype);
//	protected native void slotMetaData( MetaData _metaData);
	protected native void slotNeedSubURLData();
	protected native void slotSubURLData( Job arg1, byte[] arg2);
	protected native void slotErrorPage();
	protected native void slotCanResume( long offset);
}

/** Override these methods in subclasses of TransferJob to customise event handling behaviour */
interface TransferJobEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

