/***************************************************************************
                            View.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The View class encapsulates a single view into the document.
 
 @short 
 The View class encapsulates a single view into the document.
*/
public class View extends QWidget implements  KXMLGUIClientInterface {
	protected View(Class dummy){super((Class) null);}


/** 
 Create a new view to the given document. The document must be non-null.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Acessor to the parent Document.
   
*/
	public native DOMDocument document();
	public native void setCursorPosition( int line, int col, boolean mark);
	public native void setCursorPosition( int line, int col);
	public native void getCursorPosition( int[] line, int[] col);

/** 
  Inserts text at the current cursor position into the document
   
*/
	public native void insertText( String text, boolean mark);
	public native void insertText( String text);

/** 
 Overwrite mode is where the char under the cursor is replaced with the
 char typed by the user
   
*/
	public native boolean isOverwriteMode();

/** 
 You should reimplement this method.
 If the internal popupmenu property is enabled, then the implementation
 is free to handle/use/implement/show a context popupmenu ( see also
 KContextMenuManager class in kdeui ). If disabled, then the
 implementation should emit the {@link contextPopupMenu} signal.
   
*/
	public native void setInternalContextMenuEnabled( boolean b);
	public native boolean internalContextMenuEnabled();

/** 
 Create a new view to the given document. The document must be non-null.
   
*/
//	protected native void finalize() throws InternalError;

/** 
 Acessor to the parent Document.
   
*/
//	public native DOMDocument document();
//	public native void setCursorPosition( int line, int col, boolean mark);
//	public native void setCursorPosition( int line, int col);
//	public native void getCursorPosition( int[] line, int[] col);

/** 
  Inserts text at the current cursor position into the document
   
*/
//	public native void insertText( String text, boolean mark);
//	public native void insertText( String text);

/** 
 Overwrite mode is where the char under the cursor is replaced with the
 char typed by the user
   
*/
//	public native boolean isOverwriteMode();

/** 
 You should reimplement this method.
 If the internal popupmenu property is enabled, then the implementation
 is free to handle/use/implement/show a context popupmenu ( see also
 KContextMenuManager class in kdeui ). If disabled, then the
 implementation should emit the {@link contextPopupMenu} signal.
   
*/
//	public native void setInternalContextMenuEnabled( boolean b);
//	public native boolean internalContextMenuEnabled();
	public native void setOverwriteMode( boolean b);
//	public native void setOverwriteMode( boolean b);

// From KXMLGUIClientInterface...

/**
 Retrieve an action of the client by name.
 This method is provided for convenience, as it uses {@link #actionCollection}
 to get the action object.

*/
	public native KAction action( String name);

/**
 Retrieve an action for a given {@link QDomElement}. The default
 implementation uses the "name" attribute to query the action
 object via the other action() method.

*/
	public native KAction action( QDomElement element);

/**
 Retrieve the entire action collection for the GUI client

*/
	public native KActionCollection actionCollection();

/**

*/
	public native KInstanceInterface instance();

/**

*/
	public native QDomDocument domDocument();

/**
 This will return the name of the XML file as set by {@link #setXMLFile}.
 If {@link #setXML} is used directly, then this will return NULL.

 The filename that this returns is obvious for components as each
 component has exactly one XML file.  In non-components, however,
 there are usually two: the global file and the local file.  This
 function doesn't really care about that, though.  It will always
 return the last XML file set.  This, in almost all cases, will
 be the local XML file.

*/
	public native String xmlFile();
	public native String localXMLFile();

/**


*/
	public native void setXMLGUIBuildDocument( QDomDocument doc);

/**


*/
	public native QDomDocument xmlguiBuildDocument();

/**
 This method is called by the {@link KXMLGUIFactory} as soon as the client
 is added to the KXMLGUIFactory's GUI.

*/
	public native void setFactory( KXMLGUIFactory factory);

/**
 Retrieve a pointer to the {@link KXMLGUIFactory} this client is
 associated with (will return 0L if the client's GUI has not been built
 by a KXMLGUIFactory.

*/
	public native KXMLGUIFactory factory();

/**
 KXMLGUIClients can form a simple child/parent object tree. This
 method returns a pointer to the parent client or 0L if it has no
 parent client assigned.

*/
	public native KXMLGUIClientInterface parentClient();

/**
 Use this method to make a client a child client of another client.
 Usually you don't need to call this method, as it is called
 automatically when using the second constructor, which takes a
 arent argument.

*/
	public native void insertChildClient( KXMLGUIClientInterface child);

/**
 Remove the given <code>child</code> from the client's children list.

*/
	public native void removeChildClient( KXMLGUIClientInterface child);

/**
 A client can have an own {@link KXMLGUIBuilder}.
 Use this method to assign your builder instance to the client (so that the
 {@link KXMLGUIFactory} can use it when building the client's GUI)

 Client specific guibuilders are useful if you want to create
 custom container widgets for your GUI.

*/
	public native void setClientBuilder( KXMLGUIBuilderInterface builder);

/**
 Retrieve the client's GUI builder or 0L if no client specific
 uilder has been assigned via {@link #setClientBuilder}

*/
	public native KXMLGUIBuilderInterface clientBuilder();

/**
 Force this client to re-read its XML resource file.  This is
 intended to be used when you know that the resource file has
 changed and you will soon be rebuilding the GUI.  It has no
 useful effect with non-KParts GUIs, so don't bother using it
 unless your app is component based.

*/
	public native void reloadXML();
	public native void unplugActionList( String name);
	public static native String findMostRecentXMLFile( String[] files, String doc);

/**
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor.
 (At least before {@link #setXMLFile}.)

*/
	public native void setInstance( KInstanceInterface instance);

/**
 Set the name of the rc file containing the XML for the part.

 Call this in the Part-inherited class constructor.

*/
	protected native void setXMLFile( String file, boolean merge, boolean setXMLDoc);
	protected native void setXMLFile( String file);
	protected native void setLocalXMLFile( String file);

/**
 Set the XML for the part.

 Call this in the Part-inherited class constructor if you
  don't call {@link #setXMLFile}.

*/
	protected native void setXML( String document, boolean merge);
	protected native void setXML( String document);

/**
 Set the Document for the part, describing the layout of the GUI.

 Call this in the Part-inherited class constructor if you don't call
 {@link setXMLFile} or {@link setXML} .

*/
	protected native void setDOMDocument( QDomDocument document, boolean merge);
	protected native void setDOMDocument( QDomDocument document);

/**
 This function will attempt to give up some memory after the GUI
 is built.  It should never be used in apps where the GUI may be
 rebuilt at some later time (components, for instance).

*/
	protected native void conserveMemory();
}
