/***************************************************************************
                            QObject.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.qt;

import java.util.*;
import java.lang.Error;

/**

 $Id: QObject.java,v 1.3 2001/07/22 13:28:18 rdale Exp $

 Macros and definitions related to QObject

 Created : 930419

 Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.

 This file is part of the kernel module of the Qt GUI Toolkit.

 This file may be distributed under the terms of the Q Public License
 as defined by Trolltech AS of Norway and appearing in the file
 LICENSE.QPL included in the packaging of this file.

 This file may be distributed and/or modified under the terms of the
 GNU General Public License version 2 as published by the Free Software
 Foundation and appearing in the file LICENSE.GPL included in the
 packaging of this file.

 Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
 licenses may use this file in accordance with the Qt Commercial License
 Agreement provided with the Software.

 This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

 See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
   information about Qt Commercial License Agreements.
 See http://www.trolltech.com/qpl/ for QPL licensing information.
 See http://www.trolltech.com/gpl/ for GPL licensing information.

 Contact info@trolltech.com if any conditions of this licensing are
 not clear to you.


 @short 
* $Id: qt/src/kernel/qobjectdefs.
*/
public class QObject extends Qt  {
	protected QObject(Class dummy){super((Class) null);}

	private native void newQObject( QObject parent, String name);
	public QObject( QObject parent, String name) {
		super((Class) null);
		newQObject( parent, name);
	}
	private native void newQObject();
	public QObject() {
		super((Class) null);
		newQObject();
	}
	protected native void finalize() throws InternalError;
	public native boolean event( QEvent arg1);
	public native boolean eventFilter( QObject arg1, QEvent arg2);
	public native QMetaObject metaObject();
	public native String className();
	public native boolean isA( String arg1);
	public native boolean inherits( String arg1);
	public native String name();
	public native String name( String defaultName);
	public native void setName( String name);
	public native boolean isWidgetType();
	public native boolean highPriority();
	public native boolean signalsBlocked();
	public native void blockSignals( boolean b);
	public native int startTimer( int interval);
	public native void killTimer( int identifier);
	public native void killTimers();
	public native QObject child( String name, String type);
	public native QObject child( String name);
	public native ArrayList children();
	public native ArrayList queryList( String inheritsClass, String objName, boolean regexpMatch, boolean recursiveSearch);
	public native void insertChild( QObject arg1);
	public native void removeChild( QObject arg1);
	public native void installEventFilter( QObject arg1);
	public native void removeEventFilter( QObject arg1);
	public native boolean connect( QObject sender, String signal, String member);
	public native boolean disconnect( QObject sender, String signal, String member);
	public native boolean disconnect();
	public native boolean disconnect( QObject receiver, String member);
	public native boolean disconnect( QObject receiver);
	public native void dumpObjectTree();
	public native void dumpObjectInfo();
	public native boolean setProperty( String name, QVariant value);
	public native QVariant property( String name);
	public native QObject parent();
	public native ArrayList superClasses( boolean includeThis);
	public static native String tr( String arg1);
	public static native String tr( String arg1, String arg2);
	public static native ArrayList objectTrees();
	public static native boolean connect( QObject sender, String signal, QObject receiver, String member);
	public static native boolean disconnect( QObject sender, String signal, QObject receiver, String member);
	protected native boolean activate_filters( QEvent arg1);
//	protected native QConnectionList receivers( String signal);
	protected native void activate_signal( String signal);
	protected native void activate_signal( String signal, short arg1);
	protected native void activate_signal( String signal, int arg1);
	protected native void activate_signal( String signal, long arg1);
	protected native void activate_signal( String signal, String arg1);
	protected native void activate_signal_bool( String signal, boolean arg1);
	protected native void activate_signal_string( String signal, String arg1);
	protected native void activate_signal_strref( String signal, String arg1);
	protected native QObject sender();
	protected native void initMetaObject();
	protected native void connectNotify( String signal);
	protected native void disconnectNotify( String signal);
	protected native boolean checkConnectArgs( String signal, QObject receiver, String member);
//	protected static native QMetaObject staticMetaObject();
//	protected static native String normalizeSignalSlot( String signalSlot);
//	protected static native void badSuperclassWarning( String className, String superclassName);

	public native void emit(String signal, Object[] args);
	
	protected void emit(String signal) {
		Object[] args = new Object[0];
		emit("2" + signal.trim() + "()", args);
	}
	
	protected void emit(String signal, Object value) {
		Object[] args = new Object[1];
		args[0] = value;
		emit("2" + signal.trim() + "(" + value.getClass().getName() + ")", args);
	}
	
	protected void emit(String signal, Object value1, Object value2) {
		Object[] args = new Object[2];
		args[0] = value1;
		args[1] = value2;
		emit("2" + signal.trim() + "(" 	+ value1.getClass().getName() + ","
										+ value2.getClass().getName()
										+ ")", args);
	}
	
	protected void emit(String signal, Object value1, Object value2, Object value3) {
		Object[] args = new Object[3];
		args[0] = value1;
		args[1] = value2;
		args[2] = value3;
		emit("2" + signal.trim() + "("	+ value1.getClass().getName() + ","
										+ value2.getClass().getName() + ","
										+ value3.getClass().getName()
										+ ")", args);
	}
	
	protected void emit(String signal, Object value1, Object value2, Object value3, Object value4) {
		Object[] args = new Object[4];
		args[0] = value1;
		args[1] = value2;
		args[2] = value3;
		args[3] = value4;
		emit("2" + signal.trim() + "("	+ value1.getClass().getName() + ","
										+ value2.getClass().getName() + ","
										+ value3.getClass().getName() + ","
										+ value4.getClass().getName()
										+ ")", args);
	}
	
	protected void emit(String signal, boolean value) {
		Object[] args = new Object[1];
		args[0] = new Boolean(value);
		emit("2" + signal.trim() + "(bool)", args);
	}
	
	protected void emit(String signal, char value) {
		Object[] args = new Object[1];
		args[0] = new Character(value);
		emit("2" + signal.trim() + "(const QChar)", args);
	}
	
	protected void emit(String signal, byte value) {
		Object[] args = new Object[1];
		args[0] = new Byte(value);
		emit("2" + signal.trim() + "(unsigned char)", args);
	}
	
	protected void emit(String signal, short value) {
		Object[] args = new Object[1];
		args[0] = new Short(value);
		emit("2" + signal.trim() + "(short)", args);
	}
	
	protected void emit(String signal, int value) {
		Object[] args = new Object[1];
		args[0] = new Integer(value);
		emit("2" + signal.trim() + "(int)", args);
	}
	
	protected void emit(String signal, int value1, int value2) {
		Object[] args = new Object[2];
		args[0] = new Integer(value1);
		args[1] = new Integer(value2);
		emit("2" + signal.trim() + "(int,int)", args);
	}
	
	protected void emit(String signal, int value1, int value2, int value3) {
		Object[] args = new Object[3];
		args[0] = new Integer(value1);
		args[1] = new Integer(value2);
		args[2] = new Integer(value3);
		emit("2" + signal.trim() + "(int,int,int)", args);
	}
	
	protected void emit(String signal, int value1, int value2, int value3, Object value4) {
		Object[] args = new Object[4];
		args[0] = new Integer(value1);
		args[1] = new Integer(value2);
		args[2] = new Integer(value3);
		args[3] = value4;
		emit("2" + signal.trim() + "(int,int,int," + value4.getClass().getName() + ")", args);
	}
	
	protected void emit(String signal, int value1, Object value2, Object value3) {
		Object[] args = new Object[3];
		args[0] = new Integer(value1);
		args[1] = value2;
		args[2] = value3;
		emit("2" + signal.trim()	+ "(int,"
									+ value2.getClass().getName() + ","
									+ value3.getClass().getName()
									+ ")", args);
	}
	
	protected void emit(String signal, int value1, Object value2, Object value3, int value4) {
		Object[] args = new Object[4];
		args[0] = new Integer(value1);
		args[1] = value2;
		args[2] = value3;
		args[3] = new Integer(value4);
		emit("2" + signal.trim()	+ "(int,"
									+ value2.getClass().getName() + ","
									+ value3.getClass().getName()
									+ ",int)", args);
	}
	
	protected void emit(String signal, int value1, boolean value2) {
		Object[] args = new Object[2];
		args[0] = new Integer(value1);
		args[1] = new Boolean(value2);
		emit("2" + signal.trim() + "(int,bool)", args);
	}
	
	protected void emit(String signal, long value) {
		Object[] args = new Object[1];
		args[0] = new Long(value);
		emit("2" + signal.trim() + "(long)", args);
	}
	
	protected void emit(String signal, float value) {
		Object[] args = new Object[1];
		args[0] = new Float(value);
		emit("2" + signal.trim() + "(float)", args);
	}
	
	protected void emit(String signal, double value) {
		Object[] args = new Object[1];
		args[0] = new Double(value);
		emit("2" + signal.trim() + "(double)", args);
	}
	
	
}

/** Override these methods in subclasses of QObject to customise event handling behaviour */
interface QObjectEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

