#***************************************************************************
#                            kdocCxxHTML.pm -  Generates JNI wrappers for C++ headers
#                             -------------------
#    begin                : Fri Oct 20 12:00:00 2000
#    copyright            : (C) 2000-2001 Lost Highway Ltd. All Rights Reserved.
#    email                : Richard_Dale@tipitina.demon.co.uk
#    author               : Richard Dale.
#***************************************************************************/

#/***************************************************************************
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License as published by  *
# *   the Free Software Foundation; either version 2 of the License, or     *
# *   (at your option) any later version.                                   *
# *                                                                         *
#***************************************************************************/

package kdocCxxHTML;

use File::Path;
use File::Basename;

use Carp;
use Ast;
use kdocAstUtil;
use kdocHTMLutil;
use kdocUtil; 
use Iter;

use strict;
no strict "subs";

use vars qw/ @clist $host $who $now $gentext %interfacemap %ctypemap %functionId $qtdocTop $kdedocTop
	$lib $rootnode $outputdir $opt $debug $typeprefix $eventHandlerCount $constructorCount *JNISOURCE *CLASS *INTERFACE /;




BEGIN
{


	@clist = ();

%interfacemap = (
'QPaintDevice' => 'QPaintDeviceInterface',
'QMenuData' => 'QMenuDataInterface',
'QRangeControl' => 'QRangeControlInterface',
'QMimeSource' => 'QMimeSourceInterface',
'QLayoutItem' => 'QLayoutItemInterface',
'QUrl' => 'QUrlInterface',
'QIODevice' => 'QIODeviceInterface',
'QXmlContentHandler' => 'QXmlContentHandlerInterface',
'QXmlErrorHandler' => 'QXmlErrorHandlerInterface',
'QXmlDTDHandler' => 'QXmlDTDHandlerInterface',
'QXmlEntityResolver' => 'QXmlEntityResolverInterface',
'QXmlLexicalHandler' => 'QXmlLexicalHandlerInterface',
'QXmlDeclHandler' => 'QXmlDeclHandlerInterface',
'KInstance' => 'KInstanceInterface',
'QwAbsSpriteFieldView' => 'QwAbsSpriteFieldViewInterface',
'PartBase' => 'PartBaseInterface',
'KCompletionBase' => 'KCompletionBaseInterface',
'KDirNotify' => 'KDirNotifyInterface',
'KXMLGUIClient' => 'KXMLGUIClientInterface',
'KFileView' => 'KFileViewInterface',
'KXMLGUIBuilder' => 'KXMLGUIBuilderInterface',
'DCOPObject' => 'DCOPObjectInterface',
'KDevCore' => 'KDevCoreInterface',
'QAccessibleInterface' => 'QAccessibleInterface',
'QSqlQuery' => 'QSqlQueryInterface',

);

# A hard coded type translation table (the idea from the Roberto Alsina's Qtc
# python conversion scripts). The particular format used here makes it possible to use
# the same table with three different kdoc based Qt/KDE language binding generators;
# C, Objective-C and this one, Java.
%ctypemap = (
'ASConsumer*' => 'kde_ASConsumer*',
'ASProducer*' => 'kde_ASProducer*',
'ASYNC'  =>  'void' ,
'Address&'  =>  'kde_Address*' ,
'Address*' => 'kde_Address*',
'AddressBook*' => 'kde_AddressBook*',
'AddressBook::Entry&'  =>  'kde_Entry*' ,
'AlsaOut*' => 'kde_AlsaOut*',
'AnyConstRef&' => 'kde_AnyConstRef*',
'AnyConstRef*' => 'kde_AnyConstRef*',
'AnyRef&' => 'kde_AnyRef*',
'AnyRef*' => 'kde_AnyRef*',
'AnyRefBase&' => 'kde_AnyRefBase*',
'AnyRefBase*' => 'kde_AnyRefBase*',
'ArgList'  =>  'int' ,
'ArrowType'  =>  'int' ,
'Arts*' => 'kde_Arts*',
'Arts::AudioManagerClient' => 'int',
'Arts::Buffer&' => 'kde_Arts_Buffer*',
'Arts::Buffer*' => 'kde_Arts_Buffer*',
'Arts::ByteSoundProducer' => 'kde_Arts_ByteSoundProducer*',
'Arts::Connection*' => 'kde_Arts_Connection*',
'Arts::DynamicCast&' => 'kde_Arts_DynamicCast*',
'Arts::FlowSystemReceiver' => 'kde_Arts_FlowSystemReceiver*',
'Arts::FlowSystemSender' => 'kde_Arts_FlowSystemSender*',
'Arts::Format&' => 'kde_Arts_Format*',
'Arts::Format' => 'kde_Arts_Format',
'Arts::GenericAsyncStream*' => 'kde_Arts_GenericAsyncStream*',
'Arts::GenericDataChannel*' => 'kde_Arts_GenericDataChannel*',
'Arts::InterfaceDef' => 'kde_Arts_InterfaceDef*',
'Arts::MethodDef&' => 'kde_Arts_MethodDef*',
'Arts::ModuleDef&' => 'kde_Arts_ModuleDef*',
'Arts::Notification&' => 'kde_Arts_Notification*',
'Arts::Object' => 'kde_Arts_Object*',
'Arts::Object::Pool&' => 'kde_Arts_Object_Pool*',
'Arts::ObjectReference' => 'kde_Arts_ObjectReference*',
'Arts::PlayObject' => 'kde_Arts_PlayObject*',
'Arts::Reference&' => 'kde_Arts_Reference*',
'Arts::StereoEffect' => 'kde_Arts_StereoEffect*',
'Arts::StereoEffectStack' => 'kde_Arts_StereoEffectStack*',
'Arts::SubClass&' => 'kde_Arts_SubClass*',
'Arts::TypeDef' => 'kde_Arts_TypeDef*',
'Arts::poTime&' => 'kde_Arts_poTime*',
'Arts::poTime' => 'kde_Arts_poTime',
'AsyncStream*' => 'kde_AsyncStream*',
'Attr&' => 'kde_Attr*',
'Attr' => 'kde_Attr*',
'Attr*' => 'kde_Attr*',
'AttrImpl*' => 'kde_AttrImpl*',
'AttributeDef&' => 'kde_AttributeDef*',
'AttributeDef*' => 'kde_AttributeDef*',
'AudioManager&' => 'kde_AudioManager*',
'AudioManager' => 'kde_AudioManager*',
'AudioManager*' => 'kde_AudioManager*',
'AudioManagerClient&' => 'kde_AudioManagerClient*',
'AudioManagerClient' => 'kde_AudioManagerClient*',
'AudioManagerClient*' => 'kde_AudioManagerClient*',
'AudioManagerClient_base*' => 'kde_AudioManagerClient_base*',
'AudioManagerClient_skel*' => 'kde_AudioManagerClient_skel*',
'AudioManagerClient_stub*' => 'kde_AudioManagerClient_stub*',
'AudioManagerInfo&' => 'kde_AudioManagerInfo*',
'AudioManagerInfo*' => 'kde_AudioManagerInfo*',
'AudioManager_base*' => 'kde_AudioManager_base*',
'AudioManager_skel*' => 'kde_AudioManager_skel*',
'AudioManager_stub*' => 'kde_AudioManager_stub*',
'AudioPort*' => 'kde_AudioPort*',
'AudioSubSystem*' => 'kde_AudioSubSystem*',
'AudioSubSystemStart*' => 'kde_AudioSubSystemStart*',
'AuthAccept&' => 'kde_AuthAccept*',
'AuthAccept*' => 'kde_AuthAccept*',
'BGMode' => 'int',
'BMToken*' => 'kde_BMToken*',
'BackgroundMode' => 'int',
'BookmarkTokenizer*' => 'kde_BookmarkTokenizer*',
'Bool'  =>  'int' ,
'Boolean*' => 'kde_Boolean*',
'BrowserExtension*' => 'kde_BrowserExtension*',
'BrowserHostExtension*' => 'kde_BrowserHostExtension*',
'BrushStyle' => 'int',
'Buffer&' => 'kde_Buffer*',
'Buffer*' => 'kde_Buffer*',
'ButtonCode'  =>  'int' ,
'ButtonState'  =>  'int' ,
'ByteAsyncStream*' => 'kde_ByteAsyncStream*',
'ByteDataPacket*' => 'kde_ByteDataPacket*',
'ByteSoundProducer&' => 'kde_ByteSoundProducer*',
'ByteSoundProducer' => 'kde_ByteSoundProducer*',
'ByteSoundProducer*' => 'kde_ByteSoundProducer*',
'ByteSoundProducer_base*' => 'kde_ByteSoundProducer_base*',
'ByteSoundProducer_skel*' => 'kde_ByteSoundProducer_skel*',
'ByteSoundProducer_stub*' => 'kde_ByteSoundProducer_stub*',
'ByteStreamToAudio&' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio*' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio_base*' => 'kde_ByteStreamToAudio_base*',
'ByteStreamToAudio_skel*' => 'kde_ByteStreamToAudio_skel*',
'ByteStreamToAudio_stub*' => 'kde_ByteStreamToAudio_stub*',
'CDATASection&' => 'kde_CDATASection*',
'CDATASection' => 'kde_CDATASection*',
'CDATASection*' => 'kde_CDATASection*',
'CFlags' => 'int',
'COORD'  =>  'short' ,
'CSSCharsetRule&' => 'kde_CSSCharsetRule*',
'CSSCharsetRule*' => 'kde_CSSCharsetRule*',
'CSSCharsetRuleImpl*' => 'kde_CSSCharsetRuleImpl*',
'CSSException&' => 'kde_CSSException*',
'CSSException*' => 'kde_CSSException*',
'CSSFontFaceRule&' => 'kde_CSSFontFaceRule*',
'CSSFontFaceRule*' => 'kde_CSSFontFaceRule*',
'CSSFontFaceRuleImpl*' => 'kde_CSSFontFaceRuleImpl*',
'CSSImportRule&' => 'kde_CSSImportRule*',
'CSSImportRule*' => 'kde_CSSImportRule*',
'CSSImportRuleImpl*' => 'kde_CSSImportRuleImpl*',
'CSSMediaRule&' => 'kde_CSSMediaRule*',
'CSSMediaRule*' => 'kde_CSSMediaRule*',
'CSSMediaRuleImpl*' => 'kde_CSSMediaRuleImpl*',
'CSSPageRule&' => 'kde_CSSPageRule*',
'CSSPageRule*' => 'kde_CSSPageRule*',
'CSSPageRuleImpl*' => 'kde_CSSPageRuleImpl*',
'CSSPrimitiveValue&' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValue' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValue*' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValueImpl*' => 'kde_CSSPrimitiveValueImpl*',
'CSSRule&' => 'kde_CSSRule*',
'CSSRule' => 'kde_CSSRule*',
'CSSRule*' => 'kde_CSSRule*',
'CSSRuleImpl*' => 'kde_CSSRuleImpl*',
'CSSRuleList&' => 'kde_CSSRuleList*',
'CSSRuleList' => 'kde_CSSRuleList*',
'CSSRuleList*' => 'kde_CSSRuleList*',
'CSSRuleListImpl*' => 'kde_CSSRuleListImpl*',
'CSSStyleDeclaration&' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclaration' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclaration*' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclarationImpl*' => 'kde_CSSStyleDeclarationImpl*',
'CSSStyleRule&' => 'kde_CSSStyleRule*',
'CSSStyleRule*' => 'kde_CSSStyleRule*',
'CSSStyleRuleImpl*' => 'kde_CSSStyleRuleImpl*',
'CSSStyleSheet&' => 'kde_CSSStyleSheet*',
'CSSStyleSheet' => 'kde_CSSStyleSheet*',
'CSSStyleSheet*' => 'kde_CSSStyleSheet*',
'CSSStyleSheetImpl*' => 'kde_CSSStyleSheetImpl*',
'CSSUnknownRule&' => 'kde_CSSUnknownRule*',
'CSSUnknownRule*' => 'kde_CSSUnknownRule*',
'CSSUnknownRuleImpl*' => 'kde_CSSUnknownRuleImpl*',
'CSSValue&' => 'kde_CSSValue*',
'CSSValue' => 'kde_CSSValue*',
'CSSValue*' => 'kde_CSSValue*',
'CSSValueImpl*' => 'kde_CSSValueImpl*',
'CSSValueList&' => 'kde_CSSValueList*',
'CSSValueList*' => 'kde_CSSValueList*',
'CSSValueListImpl*' => 'kde_CSSValueListImpl*',
'CString&' => 'kde_CString*',
'CString' => 'kde_CString*',
'CString*' => 'kde_CString*',
'Cache*' => 'kde_Cache*',
'CachedObject*' => 'kde_CachedObject*',
'CachedWav*' => 'kde_CachedWav*',
'Cardinal'  =>  'int' ,
'CharSet' => 'int',
'CharacterData&' => 'kde_CharacterData*',
'CharacterData*' => 'kde_CharacterData*',
'CharacterDataImpl*' => 'kde_CharacterDataImpl*',
'ClassStore*' => 'kde_ClassStore*',
'ClassTreeNode*' => 'kde_ClassTreeNode*',
'ClientHello&' => 'kde_ClientHello*',
'ClientHello*' => 'kde_ClientHello*',
'ColorMode' => 'int',
'Comment&' => 'kde_Comment*',
'Comment' => 'kde_Comment*',
'Comment*' => 'kde_Comment*',
'CommentImpl*' => 'kde_CommentImpl*',
'ComparisonFlags' => 'int',
'Compl' => 'kde_Compl',
'Completion*' => 'kde_Completion*',
'ComplexControl' => 'int',
'Connection*' => 'kde_Connection*',
'ConstIterator'  =>  'int' ,
'Constructor' => 'kde_Constructor*',
'Constructor*' => 'kde_Constructor*',
'ConstructorImp*' => 'kde_ConstructorImp*',
'ContentsType' => 'int',
'Context*' => 'kde_Context*',
'ControlElement' => 'int',
'CopyInfo*' => 'kde_CopyInfo*',
'CopyJob*' => 'kde_CopyJob*',
'Core*' => 'kde_Core*',
'Counter&' => 'kde_Counter*',
'Counter' => 'kde_Counter*',
'Counter*' => 'kde_Counter*',
'DCOPClient*' => 'kde_DCOPClient*',
'DCOPClientTransaction*'  =>  'kde_DCOPClientTransaction*' ,
'DCOPObject*' => 'kde_DCOPObject*',
'DCOPObjectProxy*' => 'kde_DCOPObjectProxy*',
'DCOPRef&'  =>  'kde_DCOPRef*' ,
'DCOPRef*' => 'kde_DCOPRef*',
'DCOPStub*' => 'kde_DCOPStub*',
'DOM*' => 'kde_DOM*',
'DOM::CSSProperty*'  =>  'kde_CSSProperty*' ,
'DOM::DOMString&'  =>  'kde_DOMString*' ,
'DOM::DOMString'  =>  'kde_DOMString*' ,
'DOM::Document&'  =>  'kde_DOMDocument*' ,
'DOM::Document'  =>  'kde_DOMDocument*' ,
'DOM::Document*'  =>  'kde_DOMDocument*' ,
'DOM::ElementImpl*'  =>  'kde_DOM_ElementImpl*' ,
'DOM::HTMLDocument'  =>  'kde_HTMLDocument*' ,
'DOM::MediaList&' => 'kde_MediaList*',
'DOM::MediaList' => 'kde_MediaList',
'DOM::MediaList*' => 'kde_MediaList*',
'DOM::Node&'  =>  'kde_DOMNode*' ,
'DOM::Node'  =>  'kde_DOMNode*' ,
'DOM::NodeList&' => 'kde_NodeList*',
'DOM::NodeList' => 'kde_NodeList*',
'DOM::NodeList*' => 'kde_NodeList*',
'DOM::Range'  =>  'kde_DOM_Range*' ,
'DOM::StyleSheetList&' => 'kde_StyleSheetList*',
'DOM::StyleSheetList' => 'kde_StyleSheetList',
'DOM::StyleSheetList*' => 'kde_StyleSheetList*',
'DOMException&' => 'kde_DOMException*',
'DOMException*' => 'kde_DOMException*',
'DOMImplementation&' => 'kde_DOMImplementation*',
'DOMImplementation' => 'kde_DOMImplementation*',
'DOMImplementation*' => 'kde_DOMImplementation*',
'DOMImplementationImpl*' => 'kde_DOMImplementationImpl*',
'DOMString&' => 'kde_DOMString*',
'DOMString' => 'kde_DOMString*',
'DOMString*' => 'kde_DOMString*',
'DOMStringImpl*' => 'kde_DOMStringImpl*',
'DW_EXPORT*' => 'void*',
'DataPacket*' => 'kde_DataPacket*',
'Debug*' => 'kde_Debug*',
'DecoderFn'  =>  'int' ,
'DefaultProgress*' => 'kde_DefaultProgress*',
'DeleteJob*' => 'kde_DeleteJob*',
'DeviceManager*' => 'kde_DeviceManager*',
'Direction' => 'int',
'DispatchFunction' => 'kde_DispatchFunction*',
'Dispatcher*' => 'kde_Dispatcher*',
'Display' => 'Display',
'Display*' => 'Display*',
'Dock&' => 'int',
'Dock' => 'int',
'DockMainWindow*' => 'kde_DockMainWindow*',
'DockPosData&'  =>  'kde_DockPosData*' ,
'DockPosData*' => 'kde_DockPosData*',
'DockWindowData*' => 'long',
'Document&' => 'kde_Document*',
'Document' => 'kde_Document*',
'Document*' => 'kde_Document*',
'DocumentFragment&' => 'kde_DocumentFragment*',
'DocumentFragment' => 'kde_DocumentFragment*',
'DocumentFragment*' => 'kde_DocumentFragment*',
'DocumentFragmentImpl*' => 'kde_DocumentFragmentImpl*',
'DocumentImpl*' => 'kde_DocumentImpl*',
'DocumentStyle&' => 'kde_DocumentStyle*',
'DocumentStyle*' => 'kde_DocumentStyle*',
'DocumentType&' => 'kde_DocumentType*',
'DocumentType' => 'kde_DocumentType*',
'DocumentType*' => 'kde_DocumentType*',
'DocumentationContext*' => 'kde_DocumentationContext*',
'DomShared*' => 'kde_DomShared*',
'DrageMode' => 'int',
'DrawContentsEvent*' => 'kde_DrawContentsEvent*',
'DwAddress&' => 'kde_DwAddress*',
'DwAddress*' => 'kde_DwAddress*',
'DwAddressList&' => 'kde_DwAddressList*',
'DwAddressList*' => 'kde_DwAddressList*',
'DwBody&' => 'kde_DwBody*',
'DwBody*' => 'kde_DwBody*',
'DwBodyPart&' => 'kde_DwBodyPart*',
'DwBodyPart*' => 'kde_DwBodyPart*',
'DwBool' => 'int',
'DwDateTime&' => 'kde_DwDateTime*',
'DwDateTime*' => 'kde_DwDateTime*',
'DwDispositionType&' => 'kde_DwDispositionType*',
'DwDispositionType*' => 'kde_DwDispositionType*',
'DwEntity&' => 'kde_DwEntity*',
'DwField&' => 'kde_DwField*',
'DwField*' => 'kde_DwField*',
'DwFieldBody&' => 'kde_DwFieldBody*',
'DwFieldBody*' => 'kde_DwFieldBody*',
'DwGroup&' => 'kde_DwGroup*',
'DwGroup*' => 'kde_DwGroup*',
'DwHeaders&' => 'kde_DwHeaders*',
'DwHeaders*' => 'kde_DwHeaders*',
'DwInt32' => 'int',
'DwMailbox&' => 'kde_DwMailbox*',
'DwMailbox*' => 'kde_DwMailbox*',
'DwMailboxList&' => 'kde_DwMailboxList*',
'DwMailboxList*' => 'kde_DwMailboxList*',
'DwMechanism&' => 'kde_DwMechanism*',
'DwMechanism*' => 'kde_DwMechanism*',
'DwMediaType&' => 'kde_DwMediaType*',
'DwMediaType*' => 'kde_DwMediaType*',
'DwMessage&' => 'kde_DwMessage*',
'DwMessage*' => 'kde_DwMessage*',
'DwMessageComponent&' => 'kde_DwMessageComponent*',
'DwMessageComponent*' => 'kde_DwMessageComponent*',
'DwMime*' => 'kde_DwMime*',
'DwMsgId&' => 'kde_DwMsgId*',
'DwMsgId*' => 'kde_DwMsgId*',
'DwObserver*' => 'kde_DwObserver*',
'DwParameter&' => 'kde_DwParameter*',
'DwParameter*' => 'kde_DwParameter*',
'DwProtocolClient*' => 'kde_DwProtocolClient*',
'DwString&' => 'kde_DwString*',
'DwString' => 'kde_DwString',
'DwString*' => 'kde_DwString*',
'DwText&' => 'kde_DwText*',
'DwText*' => 'kde_DwText*',
'DwTokenizer&' => 'kde_DwTokenizer*',
'DwUint16' => 'unsigned short',
'DwUint32' => 'unsigned int',
'DwUint8' => 'unsigned char',
'DynamicCast*' => 'kde_DynamicCast*',
'DynamicRequest&' => 'kde_DynamicRequest*',
'DynamicRequest*' => 'kde_DynamicRequest*',
'EXPORT_DOCKCLASS*' => 'kde_EXPORT_DOCKCLASS*',
'EchoMode' => 'int',
'EditorContext*' => 'kde_EditorContext*',
'Element&' => 'kde_Element*',
'Element' => 'kde_Element*',
'Element*' => 'kde_Element*',
'ElementImpl*' => 'kde_ElementImpl*',
'EncoderFn'  =>  'int' ,
'Endian' => 'int',
'Entity&' => 'kde_Entity*',
'Entity*' => 'kde_Entity*',
'EntityReference&' => 'kde_EntityReference*',
'EntityReference' => 'kde_EntityReference*',
'EntityReference*' => 'kde_EntityReference*',
'Entry&'  =>  'kde_Entry*' ,
'Entry*' => 'kde_Entry*',
'Entry::Address&'  =>  'kde_EntryAddress' ,
'EnumComponent&' => 'kde_EnumComponent*',
'EnumComponent*' => 'kde_EnumComponent*',
'EnumDef&' => 'kde_EnumDef*',
'EnumDef*' => 'kde_EnumDef*',
'EnumEntry*' => 'kde_EnumEntry*',
'Error*' => 'kde_Error*',
'Event*' => 'kde_Event*',
'ExtensionLoader*' => 'kde_ExtensionLoader*',
'FALSE' => '0',
'FILE*' => 'FILE*',
'FMOut*' => 'kde_FMOut*',
'Factory*' => 'kde_Factory*',
'False' => '0',
'FileCopyJob*' => 'kde_FileCopyJob*',
'FileProtocol*' => 'kde_FileProtocol*',
'FileView&'  =>  'int' ,
'FloatAsyncStream*' => 'kde_FloatAsyncStream*',
'FloatDataPacket*' => 'kde_FloatDataPacket*',
'FlowSystem&' => 'kde_FlowSystem*',
'FlowSystem' => 'kde_FlowSystem*',
'FlowSystem*' => 'kde_FlowSystem*',
'FlowSystemReceiver&' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver*' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver_base*' => 'kde_FlowSystemReceiver_base*',
'FlowSystemReceiver_skel*' => 'kde_FlowSystemReceiver_skel*',
'FlowSystemReceiver_stub*' => 'kde_FlowSystemReceiver_stub*',
'FlowSystemSender&' => 'kde_FlowSystemSender*',
'FlowSystemSender' => 'kde_FlowSystemSender*',
'FlowSystemSender*' => 'kde_FlowSystemSender*',
'FlowSystemSender_base*' => 'kde_FlowSystemSender_base*',
'FlowSystemSender_skel*' => 'kde_FlowSystemSender_skel*',
'FlowSystemSender_stub*' => 'kde_FlowSystemSender_stub*',
'FlowSystem_base*' => 'kde_FlowSystem_base*',
'FlowSystem_impl*' => 'kde_FlowSystem_impl*',
'FlowSystem_skel*' => 'kde_FlowSystem_skel*',
'FlowSystem_stub*' => 'kde_FlowSystem_stub*',
'FocusPolicy' => 'int',
'Format&' => 'kde_Format*',
'Format*' => 'kde_Format*',
'Function*' => 'kde_Function*',
'FunctionImp*' => 'kde_FunctionImp*',
'GCI&'  =>  'GCI*' ,
'GCI'  =>  'GCI*' ,
'GCI*'  =>  'GCI*' ,
'GUIActivateEvent*' => 'kde_GUIActivateEvent*',
'GUIStyle' => 'int',
'GUSOut*' => 'kde_GUSOut*',
'GenericAsyncStream*' => 'kde_GenericAsyncStream*',
'GenericDataChannel*' => 'kde_GenericDataChannel*',
'GenericDataPacket*' => 'kde_GenericDataPacket*',
'Global*' => 'kde_Global*',
'GlobalComm&' => 'kde_GlobalComm*',
'GlobalComm' => 'kde_GlobalComm*',
'GlobalComm*' => 'kde_GlobalComm*',
'GlobalComm_base*' => 'kde_GlobalComm_base*',
'GlobalComm_skel*' => 'kde_GlobalComm_skel*',
'GlobalComm_stub*' => 'kde_GlobalComm_stub*',
'HANDLE' => 'unsigned int',
'HBITMAP'  =>  'void *' ,
'HCURSOR'  =>  'void *' ,
'HDC'  =>  'void *' ,
'HFONT'  =>  'void *' ,
'HPALETTE'  =>  'void *' ,
'HRGN'  =>  'void *' ,
'HTMLAnchorElement&' => 'kde_HTMLAnchorElement*',
'HTMLAnchorElement*' => 'kde_HTMLAnchorElement*',
'HTMLAnchorElementImpl*' => 'kde_HTMLAnchorElementImpl*',
'HTMLAppletElement&' => 'kde_HTMLAppletElement*',
'HTMLAppletElement*' => 'kde_HTMLAppletElement*',
'HTMLAppletElementImpl*' => 'kde_HTMLAppletElementImpl*',
'HTMLAreaElement&' => 'kde_HTMLAreaElement*',
'HTMLAreaElement*' => 'kde_HTMLAreaElement*',
'HTMLAreaElementImpl*' => 'kde_HTMLAreaElementImpl*',
'HTMLBRElement&' => 'kde_HTMLBRElement*',
'HTMLBRElement*' => 'kde_HTMLBRElement*',
'HTMLBRElementImpl*' => 'kde_HTMLBRElementImpl*',
'HTMLBaseElement&' => 'kde_HTMLBaseElement*',
'HTMLBaseElement*' => 'kde_HTMLBaseElement*',
'HTMLBaseElementImpl*' => 'kde_HTMLBaseElementImpl*',
'HTMLBaseFontElement&' => 'kde_HTMLBaseFontElement*',
'HTMLBaseFontElement*' => 'kde_HTMLBaseFontElement*',
'HTMLBaseFontElementImpl*' => 'kde_HTMLBaseFontElementImpl*',
'HTMLBlockquoteElement&' => 'kde_HTMLBlockquoteElement*',
'HTMLBlockquoteElement*' => 'kde_HTMLBlockquoteElement*',
'HTMLBlockquoteElementImpl*' => 'kde_HTMLBlockquoteElementImpl*',
'HTMLBodyElement&' => 'kde_HTMLBodyElement*',
'HTMLBodyElement*' => 'kde_HTMLBodyElement*',
'HTMLBodyElementImpl*' => 'kde_HTMLBodyElementImpl*',
'HTMLButtonElement&' => 'kde_HTMLButtonElement*',
'HTMLButtonElement*' => 'kde_HTMLButtonElement*',
'HTMLButtonElementImpl*' => 'kde_HTMLButtonElementImpl*',
'HTMLCollection&' => 'kde_HTMLCollection*',
'HTMLCollection' => 'kde_HTMLCollection*',
'HTMLCollection*' => 'kde_HTMLCollection*',
'HTMLCollectionImpl*' => 'kde_HTMLCollectionImpl*',
'HTMLDListElement&' => 'kde_HTMLDListElement*',
'HTMLDListElement*' => 'kde_HTMLDListElement*',
'HTMLDListElementImpl*' => 'kde_HTMLDListElementImpl*',
'HTMLDirectoryElement&' => 'kde_HTMLDirectoryElement*',
'HTMLDirectoryElement*' => 'kde_HTMLDirectoryElement*',
'HTMLDirectoryElementImpl*' => 'kde_HTMLDirectoryElementImpl*',
'HTMLDivElement&' => 'kde_HTMLDivElement*',
'HTMLDivElement*' => 'kde_HTMLDivElement*',
'HTMLDivElementImpl*' => 'kde_HTMLDivElementImpl*',
'HTMLDocument&' => 'kde_HTMLDocument*',
'HTMLDocument*' => 'kde_HTMLDocument*',
'HTMLDocumentImpl*' => 'kde_HTMLDocumentImpl*',
'HTMLElement&' => 'kde_HTMLElement*',
'HTMLElement' => 'kde_HTMLElement*',
'HTMLElement*' => 'kde_HTMLElement*',
'HTMLElementImpl*' => 'kde_HTMLElementImpl*',
'HTMLFieldSetElement&' => 'kde_HTMLFieldSetElement*',
'HTMLFieldSetElement*' => 'kde_HTMLFieldSetElement*',
'HTMLFieldSetElementImpl*' => 'kde_HTMLFieldSetElementImpl*',
'HTMLFontElement&' => 'kde_HTMLFontElement*',
'HTMLFontElement*' => 'kde_HTMLFontElement*',
'HTMLFontElementImpl*' => 'kde_HTMLFontElementImpl*',
'HTMLFormElement&' => 'kde_HTMLFormElement*',
'HTMLFormElement' => 'kde_HTMLFormElement*',
'HTMLFormElement*' => 'kde_HTMLFormElement*',
'HTMLFormElementImpl*' => 'kde_HTMLFormElementImpl*',
'HTMLFrameElement&' => 'kde_HTMLFrameElement*',
'HTMLFrameElement*' => 'kde_HTMLFrameElement*',
'HTMLFrameElementImpl*' => 'kde_HTMLFrameElementImpl*',
'HTMLFrameSetElement&' => 'kde_HTMLFrameSetElement*',
'HTMLFrameSetElement*' => 'kde_HTMLFrameSetElement*',
'HTMLFrameSetElementImpl*' => 'kde_HTMLFrameSetElementImpl*',
'HTMLHRElement&' => 'kde_HTMLHRElement*',
'HTMLHRElement*' => 'kde_HTMLHRElement*',
'HTMLHRElementImpl*' => 'kde_HTMLHRElementImpl*',
'HTMLHeadElement&' => 'kde_HTMLHeadElement*',
'HTMLHeadElement*' => 'kde_HTMLHeadElement*',
'HTMLHeadElementImpl*' => 'kde_HTMLHeadElementImpl*',
'HTMLHeadingElement&' => 'kde_HTMLHeadingElement*',
'HTMLHeadingElement*' => 'kde_HTMLHeadingElement*',
'HTMLHeadingElementImpl*' => 'kde_HTMLHeadingElementImpl*',
'HTMLHtmlElement&' => 'kde_HTMLHtmlElement*',
'HTMLHtmlElement*' => 'kde_HTMLHtmlElement*',
'HTMLHtmlElementImpl*' => 'kde_HTMLHtmlElementImpl*',
'HTMLIFrameElement&' => 'kde_HTMLIFrameElement*',
'HTMLIFrameElement*' => 'kde_HTMLIFrameElement*',
'HTMLIFrameElementImpl*' => 'kde_HTMLIFrameElementImpl*',
'HTMLImageElement&' => 'kde_HTMLImageElement*',
'HTMLImageElement*' => 'kde_HTMLImageElement*',
'HTMLImageElementImpl*' => 'kde_HTMLImageElementImpl*',
'HTMLInputElement&' => 'kde_HTMLInputElement*',
'HTMLInputElement*' => 'kde_HTMLInputElement*',
'HTMLInputElementImpl*' => 'kde_HTMLInputElementImpl*',
'HTMLIsIndexElement&' => 'kde_HTMLIsIndexElement*',
'HTMLIsIndexElement*' => 'kde_HTMLIsIndexElement*',
'HTMLIsIndexElementImpl*' => 'kde_HTMLIsIndexElementImpl*',
'HTMLLIElement&' => 'kde_HTMLLIElement*',
'HTMLLIElement*' => 'kde_HTMLLIElement*',
'HTMLLIElementImpl*' => 'kde_HTMLLIElementImpl*',
'HTMLLabelElement&' => 'kde_HTMLLabelElement*',
'HTMLLabelElement*' => 'kde_HTMLLabelElement*',
'HTMLLabelElementImpl*' => 'kde_HTMLLabelElementImpl*',
'HTMLLegendElement&' => 'kde_HTMLLegendElement*',
'HTMLLegendElement*' => 'kde_HTMLLegendElement*',
'HTMLLegendElementImpl*' => 'kde_HTMLLegendElementImpl*',
'HTMLLinkElement&' => 'kde_HTMLLinkElement*',
'HTMLLinkElement*' => 'kde_HTMLLinkElement*',
'HTMLLinkElementImpl*' => 'kde_HTMLLinkElementImpl*',
'HTMLMapElement&' => 'kde_HTMLMapElement*',
'HTMLMapElement*' => 'kde_HTMLMapElement*',
'HTMLMapElementImpl*' => 'kde_HTMLMapElementImpl*',
'HTMLMenuElement&' => 'kde_HTMLMenuElement*',
'HTMLMenuElement*' => 'kde_HTMLMenuElement*',
'HTMLMenuElementImpl*' => 'kde_HTMLMenuElementImpl*',
'HTMLMetaElement&' => 'kde_HTMLMetaElement*',
'HTMLMetaElement*' => 'kde_HTMLMetaElement*',
'HTMLMetaElementImpl*' => 'kde_HTMLMetaElementImpl*',
'HTMLModElement&' => 'kde_HTMLModElement*',
'HTMLModElement*' => 'kde_HTMLModElement*',
'HTMLModElementImpl*' => 'kde_HTMLModElementImpl*',
'HTMLOListElement&' => 'kde_HTMLOListElement*',
'HTMLOListElement*' => 'kde_HTMLOListElement*',
'HTMLOListElementImpl*' => 'kde_HTMLOListElementImpl*',
'HTMLObjectElement&' => 'kde_HTMLObjectElement*',
'HTMLObjectElement*' => 'kde_HTMLObjectElement*',
'HTMLObjectElementImpl*' => 'kde_HTMLObjectElementImpl*',
'HTMLOptGroupElement&' => 'kde_HTMLOptGroupElement*',
'HTMLOptGroupElement*' => 'kde_HTMLOptGroupElement*',
'HTMLOptGroupElementImpl*' => 'kde_HTMLOptGroupElementImpl*',
'HTMLOptionElement&' => 'kde_HTMLOptionElement*',
'HTMLOptionElement*' => 'kde_HTMLOptionElement*',
'HTMLOptionElementImpl*' => 'kde_HTMLOptionElementImpl*',
'HTMLParagraphElement&' => 'kde_HTMLParagraphElement*',
'HTMLParagraphElement*' => 'kde_HTMLParagraphElement*',
'HTMLParagraphElementImpl*' => 'kde_HTMLParagraphElementImpl*',
'HTMLParamElement&' => 'kde_HTMLParamElement*',
'HTMLParamElement*' => 'kde_HTMLParamElement*',
'HTMLParamElementImpl*' => 'kde_HTMLParamElementImpl*',
'HTMLPreElement&' => 'kde_HTMLPreElement*',
'HTMLPreElement*' => 'kde_HTMLPreElement*',
'HTMLPreElementImpl*' => 'kde_HTMLPreElementImpl*',
'HTMLQuoteElement&' => 'kde_HTMLQuoteElement*',
'HTMLQuoteElement*' => 'kde_HTMLQuoteElement*',
'HTMLQuoteElementImpl*' => 'kde_HTMLQuoteElementImpl*',
'HTMLScriptElement&' => 'kde_HTMLScriptElement*',
'HTMLScriptElement*' => 'kde_HTMLScriptElement*',
'HTMLScriptElementImpl*' => 'kde_HTMLScriptElementImpl*',
'HTMLSelectElement&' => 'kde_HTMLSelectElement*',
'HTMLSelectElement*' => 'kde_HTMLSelectElement*',
'HTMLSelectElementImpl*' => 'kde_HTMLSelectElementImpl*',
'HTMLStyleElement&' => 'kde_HTMLStyleElement*',
'HTMLStyleElement*' => 'kde_HTMLStyleElement*',
'HTMLStyleElementImpl*' => 'kde_HTMLStyleElementImpl*',
'HTMLTableCaptionElement&' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement*' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElementImpl*' => 'kde_HTMLTableCaptionElementImpl*',
'HTMLTableCellElement&' => 'kde_HTMLTableCellElement*',
'HTMLTableCellElement*' => 'kde_HTMLTableCellElement*',
'HTMLTableCellElementImpl*' => 'kde_HTMLTableCellElementImpl*',
'HTMLTableColElement&' => 'kde_HTMLTableColElement*',
'HTMLTableColElement*' => 'kde_HTMLTableColElement*',
'HTMLTableColElementImpl*' => 'kde_HTMLTableColElementImpl*',
'HTMLTableElement&' => 'kde_HTMLTableElement*',
'HTMLTableElement*' => 'kde_HTMLTableElement*',
'HTMLTableElementImpl*' => 'kde_HTMLTableElementImpl*',
'HTMLTableRowElement&' => 'kde_HTMLTableRowElement*',
'HTMLTableRowElement*' => 'kde_HTMLTableRowElement*',
'HTMLTableRowElementImpl*' => 'kde_HTMLTableRowElementImpl*',
'HTMLTableSectionElement&' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElement' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElement*' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElementImpl*' => 'kde_HTMLTableSectionElementImpl*',
'HTMLTextAreaElement&' => 'kde_HTMLTextAreaElement*',
'HTMLTextAreaElement*' => 'kde_HTMLTextAreaElement*',
'HTMLTextAreaElementImpl*' => 'kde_HTMLTextAreaElementImpl*',
'HTMLTitleElement&' => 'kde_HTMLTitleElement*',
'HTMLTitleElement*' => 'kde_HTMLTitleElement*',
'HTMLTitleElementImpl*' => 'kde_HTMLTitleElementImpl*',
'HTMLUListElement&' => 'kde_HTMLUListElement*',
'HTMLUListElement*' => 'kde_HTMLUListElement*',
'HTMLUListElementImpl*' => 'kde_HTMLUListElementImpl*',
'HandlerType'  =>  'qt_HandlerType*' ,
'HashEntry*' => 'kde_HashEntry*',
'HashTable*' => 'kde_HashTable*',
'Header&' => 'kde_Header*',
'Header*' => 'kde_Header*',
'HostImp*' => 'kde_HostImp*',
'IDLFileReg*' => 'kde_IDLFileReg*',
'IOManager*' => 'kde_IOManager*',
'IONotify*' => 'kde_IONotify*',
'IOType*' => 'kde_IOType*',
'IOWatchFD*' => 'kde_IOWatchFD*',
'Icon' => 'int',
'IconListBox*' => 'kde_IconListBox*',
'Imp*' => 'void*',
'Info*' => 'kde_Info*',
'InterfaceDef&' => 'kde_InterfaceDef*',
'InterfaceDef' => 'kde_InterfaceDef*',
'InterfaceDef*' => 'kde_InterfaceDef*',
'InterfaceEntry*' => 'kde_InterfaceEntry*',
'InterfaceRepo&' => 'kde_InterfaceRepo*',
'InterfaceRepo' => 'kde_InterfaceRepo*',
'InterfaceRepo*' => 'kde_InterfaceRepo*',
'InterfaceRepo_base*' => 'kde_InterfaceRepo_base*',
'InterfaceRepo_impl*' => 'kde_InterfaceRepo_impl*',
'InterfaceRepo_skel*' => 'kde_InterfaceRepo_skel*',
'InterfaceRepo_stub*' => 'kde_InterfaceRepo_stub*',
'InternalFunctionImp*' => 'kde_InternalFunctionImp*',
'Invocation&' => 'kde_Invocation*',
'Invocation*' => 'kde_Invocation*',
'Item&'  =>  'Item*' ,
'Item'  =>  'Item*' ,
'Item*'  =>  'Item*' ,
'Iterator'  =>  'Iterator*' ,
'Job*' => 'void*',
'K&'  =>  'K*' ,
'KAboutApplication*' => 'kde_KAboutApplication*',
'KAboutContainer*'  =>  'kde_KAboutContainer*' ,
'KAboutData*'  =>  'kde_KAboutData*' ,
'KAboutDialog*' => 'kde_KAboutDialog*',
'KAboutKDE*' => 'kde_KAboutKDE*',
'KAboutPerson*' => 'kde_KAboutPerson*',
'KAboutWidget*' => 'kde_KAboutWidget*',
'KAccel*'  =>  'kde_KAccel*' ,
'KAccelMenu*' => 'kde_KAccelMenu*',
'KAction*'  =>  'kde_KAction*' ,
'KActionCollection&'  => 'kde_KActionCollection*' ,
'KActionCollection'  => 'kde_KActionCollection*' ,
'KActionCollection*'  => 'kde_KActionCollection*' ,
'KActionMenu*' => 'kde_KActionMenu*',
'KActionSeparator*' => 'kde_KActionSeparator*',
'KAnimWidget*'  =>  'kde_KAnimWidget*' ,
'KAppTreeListItem*'  =>  'kde_KAppTreeListItem*' ,
'KApplication*'  =>  'kde_KApplication*' ,
'KApplicationPropsPlugin*' => 'kde_KApplicationPropsPlugin*',
'KApplicationTree*' => 'kde_KApplicationTree*',
'KAudioPlayer*' => 'kde_KAudioPlayer*',
'KAuthIcon*' => 'kde_KAuthIcon*',
'KAutoMount*' => 'kde_KAutoMount*',
'KAutoUnmount*' => 'kde_KAutoUnmount*',
'KBindingPropsPlugin*' => 'kde_KBindingPropsPlugin*',
'KBugReport*' => 'kde_KBugReport*',
'KButtonBox*' => 'kde_KButtonBox*',
'KCModule*'  =>  'kde_KCModule*' ,
'KCharSelect*' => 'kde_KCharSelect*',
'KCharSelectTable*' => 'kde_KCharSelectTable*',
'KCharsets*'  =>  'kde_KCharsets*' ,
'KCmdLineArgs*'  =>  'kde_KCmdLineArgs*' ,
'KCmdLineOptions*'  => 'kde_KCmdLineOptions*' ,
'KColor&'  => 'kde_KColor*' ,
'KColor*' => 'kde_KColor*',
'KColorButton*' => 'kde_KColorButton*',
'KColorCells*' => 'kde_KColorCells*',
'KColorCombo*' => 'kde_KColorCombo*',
'KColorDialog*' => 'kde_KColorDialog*',
'KColorDrag*'  =>  'kde_KColorDrag*' ,
'KColorPatch*' => 'kde_KColorPatch*',
'KCombiView*' => 'kde_KCombiView*',
'KComboBox*'  =>  'kde_KComboBox*' ,
'KCompletion*'  =>  'kde_KCompletion*' ,
'KCompletionBase*' => 'kde_KCompletionBase*',
'KCompletionBase::KeyBindingType'  => 'kde_KCompletionBase_KeyBindingType*' ,
'KConfig*'  => 'kde_KConfig*' ,
'KConfigBackEnd*' => 'kde_KConfigBackEnd*',
'KConfigBase*'  => 'kde_KConfigBase*' ,
'KConfigBase::ConfigState'  => 'kde_KConfigBase_ConfigState' ,
'KConfigGroupSaver*' => 'kde_KConfigGroupSaver*',
'KConfigINIBackEnd*' => 'kde_KConfigINIBackEnd*',
'KContainerLayout*' => 'kde_KContainerLayout*',
'KContainerLayoutItem*'  => 'kde_KContainerLayoutItem*' ,
'KContextMenuManager*' => 'kde_KContextMenuManager*',
'KCookie*' => 'kde_KCookie*',
'KCrash*' => 'kde_KCrash*',
'KCursor*' => 'kde_KCursor*',
'KDBGFUNC'  => 'void *' ,
'KDCOPActionProxy*' => 'kde_KDCOPActionProxy*',
'KDCOPPropertyProxy*' => 'kde_KDCOPPropertyProxy*',
'KDEAniMenu*' => 'kde_KDEAniMenu*',
'KDEDesktopMimeType*' => 'kde_KDEDesktopMimeType*',
'KDEDesktopMimeType::Service&'  => 'kde_KDEDesktopMimeType_Service*' ,
'KDEStyle*' => 'kde_KDEStyle*',
'KDEsuClient*' => 'kde_KDEsuClient*',
'KDateInternalMonthPicker*' => 'kde_KDateInternalMonthPicker*',
'KDateInternalYearSelector*' => 'kde_KDateInternalYearSelector*',
'KDatePicker*' => 'kde_KDatePicker*',
'KDateTable*' => 'kde_KDateTable*',
'KDateValidator*' => 'kde_KDateValidator*',
'KDesktopFile*'  => 'kde_KDesktopFile*' ,
'KDevApi*' => 'kde_KDevApi*',
'KDevAppFrontend*' => 'kde_KDevAppFrontend*',
'KDevCompilerOptions*' => 'kde_KDevCompilerOptions*',
'KDevCore*' => 'kde_KDevCore*',
'KDevFactory*' => 'kde_KDevFactory*',
'KDevLanguageSupport*' => 'kde_KDevLanguageSupport*',
'KDevMakeFrontend*' => 'kde_KDevMakeFrontend*',
'KDevPart*' => 'kde_KDevPart*',
'KDevProject*' => 'kde_KDevProject*',
'KDevVersionControl*' => 'kde_KDevVersionControl*',
'KDevicePropsPlugin*' => 'kde_KDevicePropsPlugin*',
'KDialog*' => 'kde_KDialog*',
'KDialogBase*'  =>  'kde_KDialogBase*' ,
'KDialogBaseTile*' => 'kde_KDialogBaseTile*',
'KDirLister*' => 'kde_KDirLister*',
'KDirNotify*' => 'kde_KDirNotify*',
'KDirNotify_stub*' => 'kde_KDirNotify_stub*',
'KDirOperator*' => 'kde_KDirOperator*',
'KDirSize*'  =>  'kde_KDirSize*' ,
'KDirWatch*'  =>  'kde_KDirWatch*' ,
'KDirectionButton*' => 'kde_KDirectionButton*',
'KDockMainWindow*' => 'kde_KDockMainWindow*',
'KDockManager*'  => 'kde_KDockManager*' ,
'KDockTabBar*' => 'kde_KDockTabBar*',
'KDockTabBar::TabPos' => 'int',
'KDockTabBarPainter*' => 'kde_KDockTabBarPainter*',
'KDockTabCtl*' => 'kde_KDockTabCtl*',
'KDockTabCtl_PrivateStruct*'  =>  'kde_KDockTabCtl_PrivateStruct*' ,
'KDockTabGroup*'  =>  'kde_KDockTabGroup*' ,
'KDockWidget*'  => 'kde_KDockWidget*' ,
'KDockWidgetAbstractHeader*'  => 'kde_KDockWidgetAbstractHeader*' ,
'KDockWidgetAbstractHeaderDrag*' => 'kde_KDockWidgetAbstractHeaderDrag*',
'KDockWidgetHeader*' => 'kde_KDockWidgetHeader*',
'KDockWidgetHeaderDrag*' => 'kde_KDockWidgetHeaderDrag*',
'KDockWindow*' => 'kde_KDockWindow*',
'KDoubleNumInput*' => 'kde_KDoubleNumInput*',
'KDualColorButton*' => 'kde_KDualColorButton*',
'KEdFind*' => 'kde_KEdFind*',
'KEdGotoLine*' => 'kde_KEdGotoLine*',
'KEdReplace*' => 'kde_KEdReplace*',
'KEdit*' => 'kde_KEdit*',
'KEditToolbar*' => 'kde_KEditToolbar*',
'KEditToolbarWidget*' => 'kde_KEditToolbarWidget*',
'KEntry&'  => 'kde_KEntry*' ,
'KEntry'  => 'kde_KEntry*' ,
'KEntry*' => 'kde_KEntry*',
'KEntryKey&'  => 'kde_KEntryKey*' ,
'KEntryKey*' => 'kde_KEntryKey*',
'KEntryMap'  => 'kde_KEntryMap*' ,
'KEntryMap*'  => 'kde_KEntryMap*' ,
'KExecMimeType*' => 'kde_KExecMimeType*',
'KExecPropsPlugin*' => 'kde_KExecPropsPlugin*',
'KFile*' => 'kde_KFile*',
'KFile::FileView'  => 'int' ,
'KFile::Mode'  => 'int' ,
'KFile::SelectionMode'  => 'int' ,
'KFileBookmark*'  =>  'kde_KFileBookmark*' ,
'KFileBookmarkManager*' => 'kde_KFileBookmarkManager*',
'KFileComboBox*' => 'kde_KFileComboBox*',
'KFileDetailView*' => 'kde_KFileDetailView*',
'KFileDialog*'  =>  'kde_KFileDialog*' ,
'KFileFilter*' => 'kde_KFileFilter*',
'KFileIconView*' => 'kde_KFileIconView*',
'KFileIconViewItem*' => 'kde_KFileIconViewItem*',
'KFileItem&' => 'kde_KFileItem*',
'KFileItem*'  => 'kde_KFileItem*' ,
'KFileItemList&'  => 'kde_KFileItemList*' ,
'KFileItemList'  => 'kde_KFileItemList*' ,
'KFileItemList*'  => 'kde_KFileItemList*' ,
'KFileListViewItem*' => 'kde_KFileListViewItem*',
'KFileOpenWithHandler*' => 'kde_KFileOpenWithHandler*',
'KFilePermissionsPropsPlugin*' => 'kde_KFilePermissionsPropsPlugin*',
'KFilePreview*' => 'kde_KFilePreview*',
'KFilePropsPlugin*' => 'kde_KFilePropsPlugin*',
'KFileReader*'  => 'kde_KFileReader*' ,
'KFileView*'  => 'kde_KFileView*' ,
'KFileView::FileView' => 'int',
'KFileViewItem&' => 'kde_KFileViewItem*',
'KFileViewItem*'  => 'kde_KFileViewItem*' ,
'KFileViewItem**'  => 'kde_KFileViewItem**' ,
'KFileViewItemList&'  => 'kde_KFileViewItemList*' ,
'KFileViewItemList*'  => 'kde_KFileViewItemList*' ,
'KFileViewSignaler*' => 'kde_KFileViewSignaler*',
'KFloatValidator*' => 'kde_KFloatValidator*',
'KFolderType*' => 'kde_KFolderType*',
'KFontAction*' => 'kde_KFontAction*',
'KFontChooser*' => 'kde_KFontChooser*',
'KFontDialog*' => 'kde_KFontDialog*',
'KFontSizeAction*' => 'kde_KFontSizeAction*',
'KGlobal*' => 'kde_KGlobal*',
'KGlobalAccel*'  =>  'kde_KGlobalAccel*' ,
'KGlobalSettings*' => 'kde_KGlobalSettings*',
'KGlobalSettings::Completion'  => 'int' ,
'KGradientSelector*' => 'kde_KGradientSelector*',
'KHSSelector*' => 'kde_KHSSelector*',
'KHTMLPart*'  =>  'kde_KHTMLPart*' ,
'KHTMLSettings*'  => 'kde_KHTMLSettings*' ,
'KHTMLView*'  => 'kde_KHTMLView*' ,
'KHelpMenu*' => 'kde_KHelpMenu*',
'KHistoryCombo*' => 'kde_KHistoryCombo*',
'KIO*' => 'kde_KIO*',
'KIO::CopyJob*'  => 'kde_CopyJob*' ,
'KIO::DeleteJob*'  => 'kde_DeleteJob*' ,
'KIO::Job*'  => 'kde_Job*' ,
'KIO::ListJob*'  => 'kde_ListJob*' ,
'KIO::MetaData&' => 'kde_MetaData*',
'KIO::RenameDlg_Mode' => 'int',
'KIO::RenameDlg_Result' => 'int',
'KIO::SkipDlg_Result' => 'int',
'KIO::UDSEntry&'  => 'kde_UDSEntry*' ,
'KIO::UDSEntryList&'  => 'kde_UDSEntryList*' ,
'KIPC*' => 'kde_KIPC*',
'KIcon'  => 'kde_KIcon*' ,
'KIcon*' => 'kde_KIcon*',
'KIconButton*' => 'kde_KIconButton*',
'KIconCanvas*' => 'kde_KIconCanvas*',
'KIconDialog*' => 'kde_KIconDialog*',
'KIconEffect*'  =>  'kde_KIconEffect*' ,
'KIconLoader*'  => 'kde_KIconLoader*' ,
'KIconTheme*'  => 'kde_KIconTheme*' ,
'KIconView*' => 'kde_KIconView*',
'KImageEffect*' => 'kde_KImageEffect*',
'KImageIO*' => 'kde_KImageIO*',
'KInstance&'  => 'kde_KInstance*' ,
'KInstance'  => 'kde_KInstance*' ,
'KInstance*'  => 'kde_KInstance*' ,
'KIntNumInput*' => 'kde_KIntNumInput*',
'KIntSpinBox*' => 'kde_KIntSpinBox*',
'KIntValidator*' => 'kde_KIntValidator*',
'KJS*' => 'kde_KJS*',
'KJS::KJSO&' => 'kde_KJS_KJSO*',
'KJS::UString&' => 'kde_KJS_UString*',
'KJSO&' => 'kde_KJSO*',
'KJSO' => 'kde_KJSO*',
'KJSO*' => 'kde_KJSO*',
'KJScript*' => 'kde_KJScript*',
'KJanusWidget*' => 'kde_KJanusWidget*',
'KJavaApplet*'  =>  'kde_KJavaApplet*' ,
'KJavaAppletContext*'  => 'kde_KJavaAppletContext*' ,
'KJavaAppletServer*'  =>  'kde_KJavaAppletServer*' ,
'KJavaAppletWidget*' => 'kde_KJavaAppletWidget*',
'KJavaProcess*' => 'kde_KJavaProcess*',
'KJavaScriptAdvice&'  => 'kde_KJavaScriptAdvice*' ,
'KKeyChooser*' => 'kde_KKeyChooser*',
'KKeyDialog*' => 'kde_KKeyDialog*',
'KKeyEntry&'  => 'kde_KKeyEntry*' ,
'KKeyEntry*' => 'kde_KKeyEntry*',
'KKeyEntryMap&'  => 'kde_KKeyEntryMap*' ,
'KKeyEntryMap'  => 'kde_KKeyEntryMap*' ,
'KKeyEntryMap*'  => 'kde_KKeyEntryMap*' ,
'KLed*' => 'kde_KLed*',
'KLibFactory*'  =>  'kde_KLibFactory*' ,
'KLibLoader*'  =>  'kde_KLibLoader*' ,
'KLibrary*'  => 'kde_KLibrary*' ,
'KLineEdit*'  =>  'kde_KLineEdit*' ,
'KLineEditDlg*' => 'kde_KLineEditDlg*',
'KListAction*' => 'kde_KListAction*',
'KListBox*' => 'kde_KListBox*',
'KListView*'  => 'kde_KListView*' ,
'KLocale&'  => 'kde_KLocale*' ,
'KLocale*'  => 'kde_KLocale*' ,
'KMainWindow*' => 'kde_KMainWindow*',
'KMenuBar*'  => 'kde_KMenuBar*' ,
'KMessageBox*' => 'kde_KMessageBox*',
'KMidSimpleAPI*' => 'kde_KMidSimpleAPI*',
'KMimeMagic*'  =>  'kde_KMimeMagic*' ,
'KMimeMagicResult*'  => 'kde_KMimeMagicResult*' ,
'KMimeSourceFactory*'  => 'kde_KMimeSourceFactory*' ,
'KMimeType*' => 'kde_KMimeType*',
'KMimeType::List&'  => 'kde_KMimeType_List*' ,
'KMimeType::Ptr&'  => 'kde_KMimeType_Ptr*' ,
'KMimeType::Ptr'  => 'kde_KMimeType_Ptr' ,
'KNDBGFUNC'  => 'void *' ,
'KNotifyClient*' => 'kde_KNotifyClient*',
'KNumInput*'  => 'kde_KNumInput*' ,
'KOpenWithDlg*' => 'kde_KOpenWithDlg*',
'KOpenWithHandler*'  =>  'kde_KOpenWithHandler*' ,
'KPalette&'  => 'kde_KPalette*' ,
'KPalette*' => 'kde_KPalette*',
'KPaletteTable*' => 'kde_KPaletteTable*',
'KPanelApplet*' => 'kde_KPanelApplet*',
'KPanelMenu*'  =>  'kde_KPanelMenu*' ,
'KParts*' => 'kde_KParts*',
'KParts::BrowserExtension*'  => 'kde_BrowserExtension*' ,
'KParts::GUIActivateEvent*'  => 'kde_GUIActivateEvent*' ,
'KParts::Part*' => 'kde_Part*',
'KParts::PartManager*'  => 'kde_PartManager*' ,
'KParts::ReadOnlyPart*'  => 'kde_ReadOnlyPart*' ,
'KParts::URLArgs&'  => 'kde_URLArgs*' ,
'KPasswordDialog*' => 'kde_KPasswordDialog*',
'KPasswordEdit*' => 'kde_KPasswordEdit*',
'KPixmap&'  => 'kde_KPixmap*' ,
'KPixmap'  => 'kde_KPixmap*' ,
'KPixmap*' => 'kde_KPixmap*',
'KPixmapEffect*' => 'kde_KPixmapEffect*',
'KPixmapIO*' => 'kde_KPixmapIO*',
'KPixmapProvider*'  => 'kde_KPixmapProvider*' ,
'KPopupFrame*' => 'kde_KPopupFrame*',
'KPopupMenu*'  => 'kde_KPopupMenu*' ,
'KPopupTitle*' => 'kde_KPopupTitle*',
'KProcIO*'  =>  'kde_KProcIO*' ,
'KProcess&'  => 'kde_KProcess*' ,
'KProcess*'  => 'kde_KProcess*' ,
'KProcessController*' => 'kde_KProcessController*',
'KProcessRunner*' => 'kde_KProcessRunner*',
'KProgress*' => 'kde_KProgress*',
'KPropertiesDialog*'  => 'kde_KPropertiesDialog*' ,
'KPropsDlgPlugin*'  => 'kde_KPropsDlgPlugin*' ,
'KProtocolInfo*' => 'kde_KProtocolInfo*',
'KProtocolManager*' => 'kde_KProtocolManager*',
'KRFCDate*' => 'kde_KRFCDate*',
'KRadioAction*' => 'kde_KRadioAction*',
'KRandomSequence*' => 'kde_KRandomSequence*',
'KRecentDocument*' => 'kde_KRecentDocument*',
'KRecentFilesAction*'  =>  'kde_KRecentFilesAction*' ,
'KRegExp*' => 'kde_KRegExp*',
'KRestrictedLine*' => 'kde_KRestrictedLine*',
'KRootPermsIcon*' => 'kde_KRootPermsIcon*',
'KRootPixmap*' => 'kde_KRootPixmap*',
'KRootProp*' => 'kde_KRootProp*',
'KRuler*' => 'kde_KRuler*',
'KRun*' => 'kde_KRun*',
'KSSL&' => 'kde_KSSL*',
'KSSL*' => 'kde_KSSL*',
'KSSLCertificate&' => 'kde_KSSLCertificate*',
'KSSLCertificate*' => 'kde_KSSLCertificate*',
'KSSLCertificateCache*' => 'kde_KSSLCertificateCache*',
'KSSLCertificateFactory*' => 'kde_KSSLCertificateFactory*',
'KSSLCertificateHome*' => 'kde_KSSLCertificateHome*',
'KSSLConnectionInfo*' => 'kde_KSSLConnectionInfo*',
'KSSLInfoDlg*' => 'kde_KSSLInfoDlg*',
'KSSLPeerInfo*' => 'kde_KSSLPeerInfo*',
'KSSLSettings*' => 'kde_KSSLSettings*',
'KSSLX509Map*' => 'kde_KSSLX509Map*',
'KSaveFile*' => 'kde_KSaveFile*',
'KSelectAction*' => 'kde_KSelectAction*',
'KSelector*' => 'kde_KSelector*',
'KSeparator*' => 'kde_KSeparator*',
'KServerSocket*' => 'kde_KServerSocket*',
'KService&'  => 'kde_KService*' ,
'KService*' => 'kde_KService*',
'KService::List'  => 'kde_KService_List*' ,
'KService::Ptr'  => 'kde_KService_Ptr*' ,
'KServiceGroup*' => 'kde_KServiceGroup*',
'KServiceOffer&'  => 'kde_KServiceOffer*' ,
'KServiceOffer*' => 'kde_KServiceOffer*',
'KServiceType*' => 'kde_KServiceType*',
'KServiceTypeProfile*'  =>  'kde_KServiceTypeProfile*' ,
'KSessionManaged*' => 'kde_KSessionManaged*',
'KShared&'  => 'kde_KShared*' ,
'KShared*' => 'kde_KShared*',
'KSharedPixmap*' => 'kde_KSharedPixmap*',
'KSharedPtr&'  => 'kde_KSharedPtr*' ,
'KSharedPtr*' => 'kde_KSharedPtr*',
'KShellCompletion*' => 'kde_KShellCompletion*',
'KShellProcess*' => 'kde_KShellProcess*',
'KShred*' => 'kde_KShred*',
'KSimpleConfig&'  => 'kde_KSimpleConfig*' ,
'KSimpleConfig*' => 'kde_KSimpleConfig*',
'KSocket*' => 'kde_KSocket*',
'KSpell*' => 'kde_KSpell*',
'KSpellConfig&'  => 'kde_KSpellConfig*' ,
'KSpellConfig'  => 'kde_KSpellConfig*' ,
'KSpellConfig*'  => 'kde_KSpellConfig*' ,
'KSpellDlg*' => 'kde_KSpellDlg*',
'KStandardDirs*'  => 'kde_KStandardDirs*' ,
'KStaticDeleter*' => 'kde_KStaticDeleter*',
'KStaticDeleterBase*'  => 'kde_KStaticDeleterBase*' ,
'KStatusBar*'  => 'kde_KStatusBar*' ,
'KStatusBar::BarStatusstat::Toggle'  =>  'int' ,
'KStatusBarLabel*' => 'kde_KStatusBarLabel*',
'KStdAccel*' => 'kde_KStdAccel*',
'KStdAccel::StdAccel'  => 'int' ,
'KStdAction*' => 'kde_KStdAction*',
'KStringHandler*' => 'kde_KStringHandler*',
'KStyle*'  => 'kde_KStyle*' ,
'KSycoca*'  =>  'kde_KSycoca*' ,
'KSycocaEntry*'  => 'kde_KSycocaEntry*' ,
'KSycocaFactory*'  => 'kde_KSycocaFactory*' ,
'KSycocaFactoryId'  => 'kde_KSycocaFactoryId' ,
'KSycocaType&'  => 'kde_KSycocaType*' ,
'KSycocaType'  => 'kde_KSycocaType*' ,
'KSystemTray*' => 'kde_KSystemTray*',
'KTMainWindow*' => 'kde_KTMainWindow*',
'KTabButton*' => 'kde_KTabButton*',
'KTabCtl*' => 'kde_KTabCtl*',
'KTarBase*'  =>  'kde_KTarBase*' ,
'KTarData*' => 'kde_KTarData*',
'KTarDirectory*'  => 'kde_KTarDirectory*' ,
'KTarEntry*'  => 'kde_KTarEntry*' ,
'KTarFile*' => 'kde_KTarFile*',
'KTarGz*' => 'kde_KTarGz*',
'KTempFile*' => 'kde_KTempFile*',
'KTextBrowser*' => 'kde_KTextBrowser*',
'KTextEditor*' => 'kde_KTextEditor*',
'KTextEditor__View&'  =>  'kde_KTextEditor__View*',
'KTextEditor__View'  =>  'kde_KTextEditor__View*',
'KTextEditor__View*'  =>  'kde_KTextEditor__View*',
'KThemeBase*'  =>  'kde_KThemeBase*', ,
'KThemeCache*'  =>  'kde_KThemeCache*',
'KThemePixmap&'  => 'kde_KThemePixmap*' ,
'KThemePixmap*'  => 'kde_KThemePixmap*' ,
'KThemeStyle*' => 'kde_KThemeStyle*',
'KToggleAction*'  => 'kde_KToggleAction*' ,
'KToolBar*'  => 'kde_KToolBar*' ,
'KToolBar::BarStatus' => 'int',
'KToolBar::BarStatusstat::Toggle'  =>  'int' ,
'KToolBarButton*'  => 'kde_KToolBarButton*' ,
'KToolBarButtonList*' => 'kde_KToolBarButtonList*',
'KToolBarPos'  => 'int' ,
'KToolBarRadioGroup*' => 'kde_KToolBarRadioGroup*',
'KToolBarSeparator*' => 'kde_KToolBarSeparator*',
'KToolButtonType'  => 'int' ,
'KTrader*'  =>  'kde_KTrader*' ,
'KURIFilter*'  =>  'kde_KURIFilter*' ,
'KURIFilterData&'  => 'kde_KURIFilterData*' ,
'KURIFilterData*' => 'kde_KURIFilterData*',
'KURIFilterPlugin*' => 'kde_KURIFilterPlugin*',
'KURIFilterPluginList*' => 'kde_KURIFilterPluginList*',
'KURL& url ()' => 'kde_KURL*',
'KURL& urlName ()' => 'kde_KURL*',
'KURL&'  => 'kde_KURL*' ,
'KURL'  => 'kde_KURL*' ,
'KURL*' => 'kde_KURL*',
'KURL::List&'  => 'kde_KURL_List*' ,
'KURL::List'  => 'kde_KURL_List*' ,
'KURLComboBox*' => 'kde_KURLComboBox*',
'KURLComboItem*'  => 'kde_KURLComboItem*' ,
'KURLCompletion*' => 'kde_KURLCompletion*',
'KURLDrag*' => 'kde_KURLDrag*',
'KURLLabel*' => 'kde_KURLLabel*',
'KURLPixmapProvider*' => 'kde_KURLPixmapProvider*',
'KURLPropsPlugin*' => 'kde_KURLPropsPlugin*',
'KURLRequester*' => 'kde_KURLRequester*',
'KURLRequesterDlg*' => 'kde_KURLRequesterDlg*',
'KUniqueApplication*' => 'kde_KUniqueApplication*',
'KValueSelector*' => 'kde_KValueSelector*',
'KWin*' => 'kde_KWin*',
'KWinModule*' => 'kde_KWinModule*',
'KWizard*' => 'kde_KWizard*',
'KWritePermsIcon*' => 'kde_KWritePermsIcon*',
'KXMLGUIBuilder*'  =>  'kde_KXMLGUIBuilder*' ,
'KXMLGUIClient*'  => 'kde_KXMLGUIClient*' ,
'KXMLGUIFactory*'  => 'kde_KXMLGUIFactory*' ,
'KXYSelector*' => 'kde_KXYSelector*',
'KZoneAllocator*' => 'kde_KZoneAllocator*',
'KabAPI*' => 'kde_KabAPI*',
'KabKey&'  => 'kde_KabKey*' ,
'KabKey'  => 'kde_KabKey*' ,
'KabKey*' => 'kde_KabKey*',
'Key&'  =>  'Key*' ,
'KeyBindingMap'  => 'kde_KeyBindingMap*' ,
'KeyValueMap&'  => 'kde_KeyValueMap*' ,
'KeyValueMap*&'  => 'kde_KeyValueMap*' ,
'KeyValueMap*'  => 'kde_KeyValueMap*' ,
'Keymap*' => 'kde_Keymap*',
'LinkStyle&' => 'kde_LinkStyle*',
'LinkStyle*' => 'kde_LinkStyle*',
'List&' => 'kde_List*',
'List' => 'kde_List',
'List*' => 'kde_List*',
'ListIterator&' => 'kde_ListIterator*',
'ListIterator' => 'kde_ListIterator',
'ListIterator*' => 'kde_ListIterator*',
'ListJob*' => 'kde_ListJob*',
'ListNode*' => 'kde_ListNode*',
'ListProgress*' => 'kde_ListProgress*',
'Lookup*' => 'kde_Lookup*',
'MCOPConfig*' => 'kde_MCOPConfig*',
'MCOPUtils*' => 'kde_MCOPUtils*',
'MSG*'  =>  'MSG*' ,
'MailServer&'  =>  'MailServer*' ,
'MailServer*' => 'kde_MailServer*',
'MainWindow*' => 'kde_MainWindow*',
'MediaAsyncStream*' => 'kde_MediaAsyncStream*',
'MediaDataPacket*' => 'kde_MediaDataPacket*',
'MediaFrame*' => 'kde_MediaFrame*',
'MediaList&' => 'kde_MediaList*',
'MediaList' => 'kde_MediaList',
'MediaList*' => 'kde_MediaList*',
'MediaListImpl*' => 'kde_MediaListImpl*',
'MediaModule&' => 'kde_MediaModule*',
'MediaModule' => 'kde_MediaModule*',
'MediaModule*' => 'kde_MediaModule*',
'MediaModule_base*' => 'kde_MediaModule_base*',
'MediaModule_skel*' => 'kde_MediaModule_skel*',
'MediaModule_stub*' => 'kde_MediaModule_stub*',
'MenuDockData*' => 'kde_MenuDockData*',
'MetaData' => 'kde_MetaData*',
'MetaData*' => 'kde_MetaData*',
'MethodDef&' => 'kde_MethodDef*',
'MethodDef*' => 'kde_MethodDef*',
'MidiEvent*' => 'kde_MidiEvent*',
'MidiFileInfo*' => 'kde_MidiFileInfo*',
'MidiMapper*' => 'kde_MidiMapper*',
'MidiOut*' => 'kde_MidiOut*',
'MidiPlayer*' => 'kde_MidiPlayer*',
'MidiStatus*' => 'kde_MidiStatus*',
'MidiTrack*' => 'kde_MidiTrack*',
'MimetypeJob*' => 'kde_MimetypeJob*',
'Mode' => 'int',
'ModuleDef&' => 'kde_ModuleDef*',
'ModuleDef*' => 'kde_ModuleDef*',
'MouseDoubleClickEvent*' => 'kde_MouseDoubleClickEvent*',
'MouseEvent*' => 'kde_MouseEvent*',
'MouseMoveEvent*' => 'kde_MouseMoveEvent*',
'MousePressEvent*' => 'kde_MousePressEvent*',
'MouseReleaseEvent*' => 'kde_MouseReleaseEvent*',
'MultiPort*' => 'kde_MultiPort*',
'NET*' => 'kde_NET*',
'NET::WindowType'  =>  'int' ,
'NETIcon'  =>  'kdeNETIcon*' ,
'NETIcon*' => 'kde_NETIcon*',
'NETPoint&'  =>  'kde_NETPoint*' ,
'NETPoint'  =>  'kde_NETPoint*' ,
'NETPoint*' => 'kde_NETPoint*',
'NETRect&'  =>  'kde_NETRect*' ,
'NETRect'  =>  'kde_NETRect*' ,
'NETRect*' => 'kde_NETRect*',
'NETRootInfo&'  =>  'kde_NETRootInfo*' ,
'NETRootInfo*' => 'kde_NETRootInfo*',
'NETRootInfoPrivate*' => 'kde_NETRootInfoPrivate*',
'NETSize&'  =>  'kde_NETSize*' ,
'NETSize'  =>  'kde_NETSize*' ,
'NETSize*' => 'kde_NETSize*',
'NETStrut'  =>  'kde_NETStrut*' ,
'NETStrut*' => 'kde_NETStrut*',
'NETWinInfo&'  =>  'kde_NETWinInfo*' ,
'NETWinInfo*' => 'kde_NETWinInfo*',
'NETWinInfoPrivate*' => 'kde_NETWinInfoPrivate*',
'NamedNodeMap&' => 'kde_NamedNodeMap*',
'NamedNodeMap' => 'kde_NamedNodeMap*',
'NamedNodeMap*' => 'kde_NamedNodeMap*',
'NamedNodeMapImpl*' => 'kde_NamedNodeMapImpl*',
'NetAccess*' => 'kde_NetAccess*',
'Node&' => 'kde_DOMNode*',
'Node' => 'kde_DOMNode*',
'Node*' => 'kde_DOMNode*',
'NodeFilter&' => 'kde_NodeFilter*',
'NodeFilter' => 'kde_NodeFilter*',
'NodeFilter*' => 'kde_NodeFilter*',
'NodeFilterImpl*' => 'kde_NodeFilterImpl*',
'NodeImpl*' => 'kde_NodeImpl*',
'NodeIterator&' => 'kde_NodeIterator*',
'NodeIterator' => 'kde_NodeIterator*',
'NodeIterator*' => 'kde_NodeIterator*',
'NodeIteratorImpl*' => 'kde_NodeIteratorImpl*',
'NodeList&' => 'kde_NodeList*',
'NodeList' => 'kde_NodeList*',
'NodeList*' => 'kde_NodeList*',
'NodeListImpl*' => 'kde_NodeListImpl*',
'NodePtr'  =>  'int' ,
'NodeType'  =>  'int' ,
'Notation&' => 'kde_Notation*',
'Notation*' => 'kde_Notation*',
'NoteArray*' => 'kde_NoteArray*',
'Notification&' => 'kde_Notification*',
'Notification' => 'kde_Notification*',
'Notification*' => 'kde_Notification*',
'NotificationClient*' => 'kde_NotificationClient*',
'NotificationManager*' => 'kde_NotificationManager*',
'Null*' => 'null',
'Number*' => 'kde_Number*',
'Object&' => 'kde_Object*',
'Object' => 'kde_Object*',
'Object*' => 'kde_Object*',
'ObjectImp*' => 'kde_ObjectImp*',
'ObjectManager*' => 'kde_ObjectManager*',
'ObjectReference&' => 'kde_ObjectReference*',
'ObjectReference*' => 'kde_ObjectReference*',
'Object_base*' => 'kde_Object_base*',
'Object_skel*' => 'kde_Object_skel*',
'Object_stub*' => 'kde_Object_stub*',
'Observer*' => 'kde_Observer*',
'OfferList'  =>  'kde_OfferList*' ,
'Offset' => 'int',
'OnewayDispatchFunction' => 'kde_OnewayDispatchFunction*',
'OnewayInvocation&' => 'kde_OnewayInvocation*',
'OnewayInvocation*' => 'kde_OnewayInvocation*',
'OpenURLEvent*' => 'kde_OpenURLEvent*',
'Orientation' => 'int',
'PFlags' => 'int',
'PIAccess' => 'int',
'PIAccess' => 'kde_PIAccess',
'PID' => 'long',
'PIType' => 'int',
'PIType' => 'kde_PIType',
'PTY*' => 'kde_PTY*',
'PageSize' => 'int',
'ParamDef&' => 'kde_ParamDef*',
'ParamDef*' => 'kde_ParamDef*',
'ParsedArgument*' => 'kde_ParsedArgument*',
'ParsedAttribute*' => 'kde_ParsedAttribute*',
'ParsedClass&' => 'kde_ParsedClass&',
'ParsedClass*' => 'kde_ParsedClass*',
'ParsedClassContainer*' => 'kde_ParsedClassContainer*',
'ParsedContainer*' => 'kde_ParsedContainer*',
'ParsedItem*' => 'kde_ParsedItem*',
'ParsedMethod*' => 'kde_ParsedMethod*',
'ParsedParent*' => 'kde_ParsedParent*',
'ParsedScopeContainer*' => 'kde_ParsedScopeContainer*',
'ParsedSignalSlot*' => 'kde_ParsedSignalSlot*',
'ParsedStruct*' => 'kde_ParsedStruct*',
'Part*' => 'kde_Part*',
'PartActivateEvent*' => 'kde_PartActivateEvent*',
'PartBase*' => 'kde_PartBase*',
'PartManager*' => 'kde_PartManager*',
'PartSelectEvent*' => 'kde_PartSelectEvent*',
'PassDlg*' => 'kde_PassDlg*',
'PenCapStyle'  =>  'int' ,
'PenJoinStyle'  =>  'int' ,
'PenStyle' => 'int',
'PersistantClassStore*' => 'kde_PersistantClassStore*',
'PipeBuffer*' => 'kde_PipeBuffer*',
'PipeSegment*' => 'kde_PipeSegment*',
'Pix&'  =>  'kde_Pix*' ,
'Pix'  =>  'kde_Pix*' ,
'PixelMetric' => 'int',
'PlayObject&' => 'kde_PlayObject*',
'PlayObject' => 'kde_PlayObject*',
'PlayObject*' => 'kde_PlayObject*',
'PlayObjectFactory&' => 'kde_PlayObjectFactory*',
'PlayObjectFactory' => 'kde_PlayObjectFactory',
'PlayObjectFactory*' => 'kde_PlayObjectFactory*',
'PlayObjectFactory_base*' => 'kde_PlayObjectFactory_base*',
'PlayObjectFactory_skel*' => 'kde_PlayObjectFactory_skel*',
'PlayObjectFactory_stub*' => 'kde_PlayObjectFactory_stub*',
'PlayObject_base*' => 'kde_PlayObject_base*',
'PlayObject_private&' => 'kde_PlayObject_private*',
'PlayObject_private' => 'kde_PlayObject_private',
'PlayObject_private*' => 'kde_PlayObject_private*',
'PlayObject_private_base*' => 'kde_PlayObject_private_base*',
'PlayObject_private_skel*' => 'kde_PlayObject_private_skel*',
'PlayObject_private_stub*' => 'kde_PlayObject_private_stub*',
'PlayObject_skel*' => 'kde_PlayObject_skel*',
'PlayObject_stub*' => 'kde_PlayObject_stub*',
'PlayerController*' => 'kde_PlayerController*',
'Plugin*' => 'kde_Plugin*',
'PluginInfo*' => 'kde_PluginInfo*',
'Policy' => 'int',
'Pool&' => 'kde_Pool*',
'Pool*' => 'kde_Pool*',
'Port*' => 'kde_Port*',
'PrimitiveElement' => 'int',
'ProcessingInstruction&' => 'kde_ProcessingInstruction*',
'ProcessingInstruction' => 'kde_ProcessingInstruction*',
'ProcessingInstruction*' => 'kde_ProcessingInstruction*',
'ProgressBase*' => 'kde_ProgressBase*',
'ProgressItem*' => 'kde_ProgressItem*',
'PropagationMode' => 'int',
'Ptr' => 'void *',
'PtyProcess*' => 'kde_PtyProcess*',
'QAccel*' => 'qt_QAccel*',
'QAccessible*' => 'qt_QAccessible*',
'QAccessibleFactoryInterface*' => 'qt_QAccessibleFactoryInterface*',
'QAccessibleInterface*' => 'qt_QAccessibleInterface*',
'QAccessibleInterface**' => 'qt_QAccessibleInterface**',
'QAccessibleObject*' => 'qt_QAccessibleObject*',
'QAction*'  =>  'qt_QAction*' ,
'QActionGroup*' => 'qt_QActionGroup*',
'QApplication*'  => 'qt_QApplication*' ,
'QArabicCodec*' => 'qt_QArabicCodec*',
'QArray*' => 'qt_QArray*',
'QAsciiBucket*' => 'qt_QAsciiBucket*',
'QAsciiCache*' => 'qt_QAsciiCache*',
'QAsciiCacheIterator*' => 'qt_QAsciiCacheIterator*',
'QAsciiDict*' => 'qt_QAsciiDict*',
'QAsciiDictIterator*' => 'qt_QAsciiDictIterator*',
'QAsyncIO*' => 'qt_QAsyncIO*',
'QAuBucket*'  =>  'qt_QAuBucket*' ,
'QAuServer*' => 'qt_QAuServer*',
'QBaseBucket*'  =>  'qt_QBaseBucket*' ,
'QBig5Codec*' => 'qt_QBig5Codec*',
'QBitArray&'  => 'qt_QBitArray*' ,
'QBitArray'  => 'qt_QBitArray*' ,
'QBitArray*'  =>  'qt_QBitArray*' ,
'QBitVal&'  => 'qt_QBitVal*' ,
'QBitVal'  => 'qt_QBitVal*' ,
'QBitVal*' => 'qt_QBitVal*',
'QBitmap&' => 'qt_QBitmap *',
'QBitmap' => 'qt_QBitmap *',
'QBitmap*' => 'qt_QBitmap *',
'QBoxLayout*' => 'qt_QBoxLayout*',
'QBrush&' => 'qt_QBrush *',
'QBrush'  =>  'qt_QBrush*' ,
'QBrush*'  => 'qt_QBrush*' ,
'QBrushData*' => 'qt_QBrushData*',
'QBuffer*' => 'qt_QBuffer*',
'QButton*' => 'qt_QButton *',
'QButtonGroup*'  =>  'qt_QButtonGroup*' ,
'QByteArray& arr ()' => 'qt_QByteArray*',
'QByteArray&'  => 'qt_QByteArray*' ,
'QByteArray' => 'qt_QByteArray*',
'QByteArray*' => 'qt_QByteArray*',
'QCDEStyle*' => 'qt_QCDEStyle*',
'QCOORD&' => 'short',
'QCOORD' => 'short',
'QCOORD*' => 'short *',
'QCString&'  =>  'qt_QCString*' ,
'QCString'  =>  'qt_QCString*' ,
'QCString*'  =>  'qt_QCString*' ,
'QCStringLess*'  =>  'qt_QCStringLess*' ,
'QCStringList'  => 'kde_QCStringList*' ,
'QCache*' => 'qt_QCache*',
'QCacheIterator*' => 'qt_QCacheIterator*',
'QCanvas*'  =>  'qt_QCanvas*' ,
'QCanvasEllipse*' => 'qt_QCanvasEllipse*',
'QCanvasItem*'  =>  'qt_QCanvasItem*' ,
'QCanvasItemList'  =>  'qt_QCanvasItemList*' ,
'QCanvasItemList*' => 'qt_QCanvasItemList*',
'QCanvasLine*' => 'qt_QCanvasLine*',
'QCanvasPixmap*'  =>  'qt_QCanvasPixmap*' ,
'QCanvasPixmapArray*'  =>  'qt_QCanvasPixmapArray*' ,
'QCanvasPolygon*' => 'qt_QCanvasPolygon*',
'QCanvasPolygonalItem*' => 'qt_QCanvasPolygonalItem*',
'QCanvasRectangle*' => 'qt_QCanvasRectangle*',
'QCanvasSpline*' => 'qt_QCanvasSpline*',
'QCanvasSprite*' => 'qt_QCanvasSprite*',
'QCanvasText*' => 'qt_QCanvasText*',
'QCanvasView*'  =>  'qt_QCanvasView*' ,
'QChain*'  => 'qt_QChain*' ,
'QChar&'  =>  'qt_QChar*' ,
'QChar'  =>  'qt_QChar*' ,
'QChar*'  =>  'qt_QChar*' ,
'QChar::Category'  =>  'int' ,
'QChar::Decomposition'  =>  'int' ,
'QChar::Direction'  =>  'int' ,
'QChar::Joining'  =>  'int' ,
'QCharRef&'  =>  'qt_QCharRef*' ,
'QCharRef'  =>  'qt_QCharRef*' ,
'QCharRef*' => 'qt_QCharRef*',
'QCheckBox*' => 'qt_QCheckBox*',
'QCheckListItem*' => 'qt_QCheckListItem *',
'QCheckTableItem*' => 'qt_QCheckTableItem*',
'QChildEvent*'  => 'qt_QChildEvent*' ,
'QClassInfo*'  =>  'qt_QClassInfo*' ,
'QCleanupHandler*' => 'qt_QCleanupHandler*',
'QClipboard*' => 'qt_QClipboard *',
'QCloseEvent*'  => 'qt_QCloseEvent*' ,
'QCollection&'  => 'qt_QCollection*' ,
'QCollection*' => 'qt_QCollection*',
'QCollection::Item&'  =>  'void *' ,
'QCollection::Item'  =>  'void *' ,
'QColor &' => 'qt_QColor *',
'QColor&' => 'qt_QColor *',
'QColor&fillColor::white'  =>  'int' ,
'QColor&linkColor::blue'  =>  'int' ,
'QColor' => 'qt_QColor *',
'QColor*'  => 'qt_QColor*' ,
'QColorDialog*' => 'qt_QColorDialog*',
'QColorDrag*' => 'qt_QColorDrag*',
'QColorGroup&' => 'qt_QColorGroup *',
'QColorGroup'  =>  'qt_QColorGroup*' ,
'QColorGroup*'  => 'qt_QColorGroup*' ,
'QColorGroup::ColorRole'  => 'int' ,
'QComboBox*'  =>  'qt_QComboBox*' ,
'QComboBox::Policy'  => 'int' ,
'QComboBox::Policypolicy::AtBottom'  => 'int' ,
'QComboTableItem*' => 'qt_QComboTableItem*',
'QCommonStyle*' => 'qt_QCommonStyle*',
'QCompactStyle*' => 'qt_QCompactStyle*',
'QComponentFactory*' => 'qt_QComponentFactory*',
'QComponentFactoryInterface*' => 'qt_QComponentFactoryInterface*',
'QComponentInterface*' => 'qt_QComponentInterface*',
'QComponentRegistration*' => 'qt_QComponentRegistration*',
'QComponentServerInterface*' => 'qt_QComponentServerInterface*',
'QConfigDB*'  =>  'qt_QConfigDB*' ,
'QConfigDB*'  => 'qt_QConfigDB*' ,
'QConnection*' => 'qt_QConnection*',
'QConnectionList&'  => 'qt_QConnectionList*' ,
'QConnectionList*'  =>  'qt_QConnectionList*' ,
'QConnectionListIt&'  => 'qt_QConnectionListIt*' ,
'QConnectionListIt*' => 'qt_QConnectionListIt*',
'QConstString' => 'qt_QConstString*',
'QConstString*' => 'qt_QConstString*',
'QContextMenuEvent*' => 'qt_QContextMenuEvent*',
'QCursor&' => 'qt_QCursor *',
'QCursor'  =>  'qt_QCursor*' ,
'QCursor*' => 'qt_QCursor *',
'QCustomEvent*'  =>  'qt_QCustomEvent*' ,
'QCustomMenuItem*'  =>  'qt_QCustomMenuItem*' ,
'QDOM_NodeListPrivate*'  =>  'void*' ,
'QDOM_NodePrivate*'  =>  'void*' ,
'QDataBrowser*' => 'qt_QDataBrowser*',
'QDataPump*' => 'qt_QDataPump*',
'QDataSink*'  => 'qt_QDataSink*' ,
'QDataSource*'  => 'qt_QDataSource*' ,
'QDataStream&' => 'qt_QDataStream *',
'QDataStream*'  => 'qt_QDataStream*' ,
'QDataTable*' => 'qt_QDataTable*',
'QDataView*' => 'qt_QDataView*',
'QDate &' => 'qt_QDate *',
'QDate date()' => 'qt_QDate*',
'QDate&' => 'qt_QDate *',
'QDate' => 'qt_QDate *',
'QDate*' => 'qt_QDate*',
'QDateEdit*' => 'qt_QDateEdit*',
'QDateTime&' => 'qt_QDateTime *',
'QDateTime' => 'qt_QDateTime *',
'QDateTime*'  => 'qt_QDateTime*' ,
'QDateTimeEdit*' => 'qt_QDateTimeEdit*',
'QDateTimeEditBase*' => 'qt_QDateTimeEditBase*',
'QDesktopWidget*' => 'qt_QDesktopWidget*',
'QDial*' => 'qt_QDial*',
'QDialog*' => 'qt_QDialog*',
'QDict*' => 'qt_QDict*',
'QDictIterator*' => 'qt_QDictIterator*',
'QDir&' => 'qt_QDir *',
'QDir' => 'qt_QDir *',
'QDir*' => 'qt_QDir *',
'QDir::SortSpec&'  => 'int' ,
'QDir::SortSpec'  => 'int' ,
'QDirSortItem*' => 'qt_QDirSortItem*',
'QDispatchInterface*' => 'qt_QDispatchInterface*',
'QDns*' => 'qt_QDns*',
'QDnsSocket*' => 'qt_QDnsSocket*',
'QDockArea*' => 'qt_QDockArea*',
'QDockAreaLayout*' => 'qt_QDockAreaLayout*',
'QDockWindow*' => 'qt_QDockWindow*',
'QDomAttr&'  =>  'qt_QDomAttr*' ,
'QDomAttr'  =>  'qt_QDomAttr*' ,
'QDomAttr*' => 'qt_QDomAttr*',
'QDomCDATASection&'  =>  'qt_QDomCDATASection*' ,
'QDomCDATASection'  =>  'qt_QDomCDATASection*' ,
'QDomCDATASection*' => 'qt_QDomCDATASection*',
'QDomCharacterData&'  =>  'qt_QDomCharacterData*' ,
'QDomCharacterData'  =>  'qt_QDomCharacterData*' ,
'QDomCharacterData*' => 'qt_QDomCharacterData*',
'QDomComment&'  =>  'qt_QDomComment*' ,
'QDomComment'  =>  'qt_QDomComment*' ,
'QDomComment*' => 'qt_QDomComment*',
'QDomDocument&'  =>  'qt_QDomDocument*' ,
'QDomDocument'  =>  'qt_QDomDocument*' ,
'QDomDocument*' => 'qt_QDomDocument*',
'QDomDocumentFragment&'  =>  'qt_QDomDocumentFragment*' ,
'QDomDocumentFragment'  =>  'qt_QDomDocumentFragment*' ,
'QDomDocumentFragment*' => 'qt_QDomDocumentFragment*',
'QDomDocumentType&'  =>  'qt_QDomDocumentType*' ,
'QDomDocumentType'  =>  'qt_QDomDocumentType*' ,
'QDomDocumentType*' => 'qt_QDomDocumentType*',
'QDomElement&'  =>  'qt_QDomElement*' ,
'QDomElement'  =>  'qt_QDomElement*' ,
'QDomElement*' => 'qt_QDomElement*',
'QDomEntity&'  =>  'qt_QDomEntity*' ,
'QDomEntity'  =>  'qt_QDomEntity*' ,
'QDomEntity*' => 'qt_QDomEntity*',
'QDomEntityReference&'  =>  'qt_QDomEntityReference*' ,
'QDomEntityReference'  =>  'qt_QDomEntityReference*' ,
'QDomEntityReference*' => 'qt_QDomEntityReference*',
'QDomImplementation&'  =>  'qt_QDomImplementation*' ,
'QDomImplementation'  =>  'qt_QDomImplementation*' ,
'QDomImplementation*' => 'qt_QDomImplementation*',
'QDomNamedNodeMap&'  =>  'qt_QDomNamedNodeMap*' ,
'QDomNamedNodeMap'  =>  'qt_QDomNamedNodeMap*' ,
'QDomNamedNodeMap*' => 'qt_QDomNamedNodeMap*',
'QDomNode&'  =>  'qt_QDomNode*' ,
'QDomNode'  =>  'qt_QDomNode*' ,
'QDomNode*' => 'qt_QDomNode*',
'QDomNode::NodeType' => 'int',
'QDomNodeList&'  =>  'qt_QDomNodeList*' ,
'QDomNodeList'  =>  'qt_QDomNodeList*' ,
'QDomNodeList*' => 'qt_QDomNodeList*',
'QDomNodePrivate*' => 'qt_QDomNodePrivate*',
'QDomNotation&'  =>  'qt_QDomNotation*' ,
'QDomNotation'  =>  'qt_QDomNotation*' ,
'QDomNotation*' => 'qt_QDomNotation*',
'QDomProcessingInstruction&'  =>  'qt_QDomProcessingInstruction*' ,
'QDomProcessingInstruction'  =>  'qt_QDomProcessingInstruction*' ,
'QDomProcessingInstruction*' => 'qt_QDomProcessingInstruction*',
'QDomText&'  =>  'qt_QDomText*' ,
'QDomText'  =>  'qt_QDomText*' ,
'QDomText*' => 'qt_QDomText*',
'QDoubleValidator*' => 'qt_QDoubleValidator*',
'QDragEnterEvent*'  => 'qt_QDragEnterEvent*' ,
'QDragLeaveEvent*'  => 'qt_QDragLeaveEvent*' ,
'QDragManager*' => 'qt_QDragManager*',
'QDragMoveEvent*'  => 'qt_QDragMoveEvent*' ,
'QDragObject*'  => 'qt_QDragObject*' ,
'QDragResponseEvent*' => 'qt_QDragResponseEvent*',
'QDropEvent*'  => 'qt_QDropEvent*' ,
'QDropSite*' => 'qt_QDropSite*',
'QEditorFactory*' => 'qt_QEditorFactory*',
'QErrorMessage*' => 'qt_QErrorMessage*',
'QEucJpCodec*' => 'qt_QEucJpCodec*',
'QEucKrCodec*' => 'qt_QEucKrCodec*',
'QEvent*' => 'qt_QEvent *',
'QFeatureListInterface*' => 'qt_QFeatureListInterface*',
'QFile&' => 'qt_QFile *',
'QFile*'  => 'qt_QFile*' ,
'QFileDialog*' => 'qt_QFileDialog*',
'QFileIconProvider*'  => 'qt_QFileIconProvider*' ,
'QFileInfo&' => 'qt_QFileInfo *',
'QFileInfo*' => 'qt_QFileInfo*',
'QFileInfoList*'  => 'qt_QFileInfoList*' ,
'QFilePreview*'  =>  'qt_QFilePreview*' ,
'QFocusData*'  =>  'qt_QFocusData*' ,
'QFocusEvent*'  => 'qt_QFocusEvent*' ,
'QFont&' => 'qt_QFont *',
'QFont' => 'qt_QFont *',
'QFont*' => 'qt_QFont *',
'QFont::CharSet' => 'int',
'QFont::CharSetcharset::Unicode'  => 'int' ,
'QFont::StyleHint' => 'int',
'QFontData&'  => 'qt_QFontData*' ,
'QFontDatabase*' => 'qt_QFontDatabase*',
'QFontDialog*' => 'qt_QFontDialog*',
'QFontInfo&' => 'qt_QFontInfo *',
'QFontInfo' => 'qt_QFontInfo *',
'QFontInfo*' => 'qt_QFontInfo*',
'QFontMetrics&' => 'qt_QFontMetrics *',
'QFontMetrics' => 'qt_QFontMetrics *',
'QFontMetrics*' => 'qt_QFontMetrics*',
'QFrame*'  => 'qt_QFrame*' ,
'QFtp*' => 'qt_QFtp*',
'QGArray&'  => 'qt_QGArray*' ,
'QGArray*' => 'qt_QGArray*',
'QGCache&'  => 'qt_QGCache*' ,
'QGCache*' => 'qt_QGCache*',
'QGCacheIterator&'  => 'qt_QGCacheIterator*' ,
'QGCacheIterator*' => 'qt_QGCacheIterator*',
'QGDict&'  => 'qt_QGDict*' ,
'QGDict*' => 'qt_QGDict*',
'QGDictIterator&'  => 'qt_QGDictIterator*' ,
'QGDictIterator*' => 'qt_QGDictIterator*',
'QGL*' => 'qt_QGL*',
'QGLColormap&' => 'qt_QGLColormap*',
'QGLColormap*' => 'qt_QGLColormap*',
'QGLContext*'  =>  'qt_QGLContext*' ,
'QGLFormat&'  =>  'qt_QGLFormat*' ,
'QGLFormat'  =>  'qt_QGLFormat*' ,
'QGLFormat*' => 'qt_QGLFormat*',
'QGLWidget*'  =>  'qt_QGLWidget*' ,
'QGLayoutIterator*'  =>  'qt_QGLayoutIterator*' ,
'QGList&'  => 'qt_QGList*' ,
'QGList*'  =>  'qt_QGList*' ,
'QGListIterator&'  => 'qt_QGListIterator*' ,
'QGListIterator*' => 'qt_QGListIterator*',
'QGPluginManager*' => 'qt_QGPluginManager*',
'QGVector&'  => 'qt_QGVector*' ,
'QGVector*'  => 'qt_QGVector*' ,
'QGbkCodec*' => 'qt_QGbkCodec*',
'QGfx*'  =>  'qt_QGfx*' ,
'QGrid*'  => 'qt_QGrid*' ,
'QGrid::Direction'  => 'int' ,
'QGridLayout*' => 'qt_QGridLayout*',
'QGridView*' => 'qt_QGridView*',
'QGroupBox*' => 'qt_QGroupBox*',
'QGuardedPtr*' => 'qt_QGuardedPtr*',
'QGuardedPtrPrivate*' => 'qt_QGuardedPtrPrivate*',
'QHBox*'  => 'qt_QHBox*' ,
'QHBoxLayout*'  =>  'qt_QHBoxLayout*' ,
'QHButtonGroup*' => 'qt_QHButtonGroup*',
'QHGroupBox*' => 'qt_QHGroupBox*',
'QHeader*' => 'qt_QHeader *',
'QHebrewCodec*' => 'qt_QHebrewCodec*',
'QHideEvent*'  => 'qt_QHideEvent*' ,
'QHostAddress&'  =>  'qt_QHostAddress*' ,
'QHostAddress'  =>  'qt_QHostAddress*' ,
'QHostAddress*'  =>  'qt_QHostAddress*' ,
'QHttp*' => 'qt_QHttp*',
'QIMEvent*' => 'qt_QIMEvent*',
'QIODevice*' => 'qt_QIODevice *',
'QIODeviceSource*' => 'qt_QIODeviceSource*',
'QIOManager*' => 'qt_QIOManager*',
'QIOWatch*' => 'qt_QIOWatch*',
'QIconDrag*' => 'qt_QIconDrag*',
'QIconDragItem&'  =>  'qt_QIconDragItem*' ,
'QIconDragItem*' => 'qt_QIconDragItem*',
'QIconSet&'  => 'qt_QIconSet*' ,
'QIconSet'  => 'qt_QIconSet*' ,
'QIconSet*'  =>  'qt_QIconSet*' ,
'QIconView*'  => 'qt_QIconView*' ,
'QIconViewItem*'  =>  'qt_QIconViewItem*' ,
'QImage&' => 'qt_QImage *',
'QImage' => 'qt_QImage *',
'QImage*'  => 'qt_QImage*' ,
'QImageConsumer*'  =>  'qt_QImageConsumer*' ,
'QImageData*' => 'qt_QImageData*',
'QImageDecoder*' => 'qt_QImageDecoder*',
'QImageDrag*' => 'qt_QImageDrag*',
'QImageFormat*'  =>  'qt_QImageFormat*' ,
'QImageFormatInterface*' => 'qt_QImageFormatInterface*',
'QImageFormatType*'  => 'qt_QImageFormatType*' ,
'QImageIO*' => 'qt_QImageIO*',
'QImageTextKeyLang&'  =>  'qt_QImageTextKeyLang*' ,
'QImageTextKeyLang*' => 'qt_QImageTextKeyLang*',
'QInputDialog*' => 'qt_QInputDialog*',
'QIntBucket*' => 'qt_QIntBucket*',
'QIntCache*' => 'qt_QIntCache*',
'QIntCacheIterator*' => 'qt_QIntCacheIterator*',
'QIntDict*' => 'qt_QIntDict*',
'QIntDictIterator*' => 'qt_QIntDictIterator*',
'QIntValidator*' => 'qt_QIntValidator*',
'QInterfaceListInterface*' => 'qt_QInterfaceListInterface*',
'QInterfacePtr*' => 'qt_QInterfacePtr*',
'QInterlaceStyle*' => 'qt_QInterlaceStyle*',
'QInternal*' => 'qt_QInternal*',
'QJisCodec*' => 'qt_QJisCodec*',
'QJpUnicodeConv*'  =>  'qt_QJpUnicodeConv*' ,
'QKeyEvent*'  => 'qt_QKeyEvent*' ,
'QKoi8Codec*' => 'qt_QKoi8Codec*',
'QLCDNumber*' => 'qt_QLCDNumber*',
'QLNode*'  => 'qt_QLNode*' ,
'QLabel*' => 'qt_QLabel *',
'QLayout*' => 'qt_QLayout *',
'QLayoutItem*'  =>  'qt_QLayoutItem*' ,
'QLayoutIterator&'  =>  'qt_QLayoutIterator*' ,
'QLayoutIterator'  =>  'qt_QLayoutIterator*' ,
'QLayoutIterator*' => 'qt_QLayoutIterator*',
'QLibrary*' => 'qt_QLibrary*',
'QLibrary::Policy' => 'int',
'QLibraryInterface*' => 'qt_QLibraryInterface*',
'QLineEdit*'  =>  'qt_QLineEdit*' ,
'QLineEdit::EchoMode'  =>  'int' ,
'QList*' => 'qt_QList*',
'QListBox*' => 'qt_QListBox *',
'QListBoxItem*' => 'qt_QListBoxItem *',
'QListBoxPixmap*' => 'qt_QListBoxPixmap*',
'QListBoxText*' => 'qt_QListBoxText*',
'QListIterator*' => 'qt_QListIterator*',
'QListView*' => 'qt_QListView *',
'QListViewItem*' => 'qt_QListViewItem *',
'QListViewItemIterator&'  =>  'qt_QListViewItemIterator*' ,
'QListViewItemIterator'  =>  'qt_QListViewItemIterator*' ,
'QListViewItemIterator*' => 'qt_QListViewItemIterator*',
'QLocalFs*' => 'qt_QLocalFs*',
'QMCPI*' => 'qt_QMCPI*',
'QMSG*'  => 'QMSG*' ,
'QMainWindow*'  =>  'qt_QMainWindow*' ,
'QMainWindow::ToolBarDock::Top'  =>  'int' ,
'QMap&'  =>  'qt_QMap*' ,
'QMap*' => 'qt_QMap*',
'QMapConstIterator*' => 'qt_QMapConstIterator*',
'QMapIterator*' => 'qt_QMapIterator*',
'QMapNode*' => 'qt_QMapNode*',
'QMapNodeBase*&'  =>  'qt_QMapNodeBase*' ,
'QMapNodeBase*'  =>  'qt_QMapNodeBase*' ,
'QMapPrivate*' => 'qt_QMapPrivate*',
'QMapPrivateBase*'  =>  'qt_QMapPrivateBase*' ,
'QMemArray*' => 'qt_QMemArray*',
'QMember'  => 'qt_QMember*' ,
'QMember*'  => 'qt_QMember*' ,
'QMenuBar*' => 'qt_QMenuBar *',
'QMenuData*' => 'qt_QMenuData*',
'QMenuData**'  => 'qt_QMenuData**' ,
'QMenuItem*' => 'qt_QMenuItem *',
'QMessageBox*' => 'qt_QMessageBox*',
'QMetaData*'  =>  'qt_QMetaData*' ,
'QMetaData::Access*'  =>  'int*' ,
'QMetaEnum*'  =>  'qt_QMetaEnum*' ,
'QMetaEnum::Item*'  =>  'int*' ,
'QMetaObject*&' => 'qt_QMetaObject*',
'QMetaObject*' => 'qt_QMetaObject *',
'QMetaObjectCleanUp*' => 'qt_QMetaObjectCleanUp*',
'QMetaObjectInit*' => 'qt_QMetaObjectInit*',
'QMetaProperty*'  =>  'qt_QMetaProperty*' ,
'QMimeSource*'  =>  'qt_QMimeSource*' ,
'QMimeSourceFactory*'  =>  'qt_QMimeSourceFactory*' ,
'QMotifPlusStyle*' => 'qt_QMotifPlusStyle*',
'QMotifStyle*' => 'qt_QMotifStyle*',
'QMouseEvent*'  => 'qt_QMouseEvent*' ,
'QMoveEvent*'  =>  'qt_QMoveEvent*' ,
'QMovie&' => 'qt_QMovie *',
'QMovie*' => 'qt_QMovie *',
'QMultiLineEdit*' => 'qt_QMultiLineEdit*',
'QMultiLineEditRow*' => 'qt_QMultiLineEditRow*',
'QMutex*' => 'qt_QMutex*',
'QNPInstance*' => 'qt_QNPInstance*',
'QNPStream*' => 'qt_QNPStream*',
'QNPWidget*' => 'qt_QNPWidget*',
'QNPlugin*' => 'qt_QNPlugin*',
'QNetworkOperation*'  =>  'qt_QNetworkOperation*' ,
'QNetworkProtocol*'  =>  'qt_QNetworkProtocol*' ,
'QNetworkProtocol::Operation'  =>  'int' ,
'QNetworkProtocol::State'  =>  'int' ,
'QNetworkProtocolFactory*' => 'qt_QNetworkProtocolFactory*',
'QNetworkProtocolFactoryBase*'  =>  'qt_QNetworkProtocolFactoryBase*' ,
'QObject*' => 'qt_QObject *',
'QObjectCleanupHandler*' => 'qt_QObjectCleanupHandler*',
'QObjectDictionary&'  => 'qt_QObjectDictionary*' ,
'QObjectDictionary*' => 'qt_QObjectDictionary*',
'QObjectInterface*' => 'qt_QObjectInterface*',
'QObjectList&'  => 'qt_QObjectList*' ,
'QObjectList*' => 'qt_QObjectList *',
'QObjectListIt&'  => 'qt_QObjectListIt*' ,
'QObjectListIt*' => 'qt_QObjectListIt*',
'QPDevCmdParam*'  =>  'qt_QPDevCmdParam*' ,
'QPNGImagePacker*' => 'qt_QPNGImagePacker*',
'QPNGImageWriter*' => 'qt_QPNGImageWriter*',
'QPaintDevice*' => 'qt_QPaintDevice *',
'QPaintDeviceMetrics*' => 'qt_QPaintDeviceMetrics*',
'QPaintDeviceX11Data*'  =>  'qt_QPaintDeviceX11Data*' ,
'QPaintEvent*'  => 'qt_QPaintEvent*' ,
'QPainter&'  =>  'qt_QPainter*' ,
'QPainter*' => 'qt_QPainter *',
'QPair*' => 'qt_QPair*',
'QPalData*' => 'qt_QPalData*',
'QPalette&' => 'qt_QPalette *',
'QPalette' => 'qt_QPalette *',
'QPalette*' => 'qt_QPalette *',
'QPen&' => 'qt_QPen *',
'QPen'  =>  'qt_QPen*' ,
'QPen*' => 'qt_QPen*',
'QPenData*' => 'qt_QPenData*',
'QPicture&' => 'qt_QPicture *',
'QPicture*' => 'qt_QPicture*',
'QPixmap& pixmap()' => 'kde_QPixmap*',
'QPixmap&' => 'qt_QPixmap *',
'QPixmap' => 'qt_QPixmap *',
'QPixmap*' => 'qt_QPixmap *',
'QPixmap::Optimization'  =>  'int' ,
'QPixmap::Optimization' => 'int',
'QPixmap::Optimization::DefaultOptim'  =>  'int' ,
'QPixmapCache*' => 'qt_QPixmapCache*',
'QPixmapData*' => 'qt_QPixmapData*',
'QPlatinumStyle*' => 'qt_QPlatinumStyle*',
'QPluginManager*' => 'qt_QPluginManager*',
'QPoint&' => 'qt_QPoint*',
'QPoint&pos()'  =>  'int' ,
'QPoint&pos::pos()'  =>  'int' ,
'QPoint' => 'qt_QPoint*',
'QPoint*'  => 'qt_QPoint*' ,
'QPointArray&' => 'qt_QPointArray*',
'QPointArray' => 'qt_QPointArray*',
'QPointArray*' => 'qt_QPointArray*',
'QPointVal&'  => 'qt_QPointVal*' ,
'QPointVal'  => 'qt_QPointVal*' ,
'QPolygonScanner*' => 'qt_QPolygonScanner*',
'QPopupMenu*' => 'qt_QPopupMenu*',
'QPrintDialog*' => 'qt_QPrintDialog*',
'QPrinter*'  => 'qt_QPrinter*' ,
'QProcess*' => 'qt_QProcess*',
'QProgressBar*' => 'qt_QProgressBar*',
'QProgressDialog*' => 'qt_QProgressDialog*',
'QPtrBucket*' => 'qt_QPtrBucket*',
'QPtrCollection&' => 'qt_QPtrCollection*',
'QPtrCollection*' => 'qt_QPtrCollection*',
'QPtrDict*' => 'qt_QPtrDict*',
'QPtrDictIterator*' => 'qt_QPtrDictIterator*',
'QPtrList*' => 'qt_QPtrList*',
'QPtrListIterator*' => 'qt_QPtrListIterator*',
'QPtrQueue*' => 'qt_QPtrQueue*',
'QPtrStack*' => 'qt_QPtrStack*',
'QPtrVector*' => 'qt_QPtrVector*',
'QPushButton*' => 'qt_QPushButton*',
'QQueue*' => 'qt_QQueue*',
'QRESULT' => 'long',
'QRadioButton*' => 'qt_QRadioButton*',
'QRangeControl*' => 'qt_QRangeControl*',
'QRect&' => 'qt_QRect*',
'QRect' => 'qt_QRect*',
'QRect*' => 'qt_QRect*',
'QRegExp&' => 'qt_QRegExp*',
'QRegExp*' => 'qt_QRegExp*',
'QRegExpValidator*' => 'qt_QRegExpValidator*',
'QRegion&' => 'qt_QRegion *',
'QRegion' => 'qt_QRegion *',
'QRegion*' => 'qt_QRegion*',
'QRegionData*' => 'qt_QRegionData*',
'QResizeEvent*'  => 'qt_QResizeEvent*' ,
'QRgb' => 'unsigned int',
'QRgb*' => 'int *',
'QRichText&'  =>  'qt_QRichText*' ,
'QSGIStyle*' => 'qt_QSGIStyle*',
'QScrollBar&'  =>  'qt_QScrollBar*' ,
'QScrollBar*'  =>  'qt_QScrollBar*' ,
'QScrollView*' => 'qt_QScrollView*',
'QSemaphore*' => 'qt_QSemaphore*',
'QSemiModal*' => 'qt_QSemiModal*',
'QSenderObject*' => 'qt_QSenderObject*',
'QServerSocket*' => 'qt_QServerSocket*',
'QSessionManager&'  =>  'qt_QSessionManager*' ,
'QSessionManager*' => 'qt_QSessionManager*',
'QSettings*' => 'qt_QSettings*',
'QShared*' => 'qt_QShared*',
'QShowEvent*'  =>  'qt_QShowEvent*' ,
'QSignal*' => 'qt_QSignal *',
'QSignalDict&'  => 'qt_QSignalDict*' ,
'QSignalDict*' => 'qt_QSignalDict*',
'QSignalDictIt&'  => 'qt_QSignalDictIt*' ,
'QSignalDictIt*' => 'qt_QSignalDictIt*',
'QSignalMapper*' => 'qt_QSignalMapper*',
'QSignalVec&' => 'qt_QSignalVec*',
'QSignalVec*' => 'qt_QSignalVec*',
'QSimpleRichText*' => 'qt_QSimpleRichText*',
'QSize&' => 'qt_QSize *',
'QSize' => 'qt_QSize *',
'QSize*'  => 'qt_QSize*' ,
'QSizeGrip*' => 'qt_QSizeGrip*',
'QSizePolicy&'  =>  'qt_QSizePolicy*' ,
'QSizePolicy'  =>  'qt_QSizePolicy*' ,
'QSizePolicy*' => 'qt_QSizePolicy*',
'QSizePolicy::ExpandData'  =>  'int' ,
'QSizePolicy::SizeTypehData::Minimum'  =>  'int' ,
'QSizePolicy::SizeTypevData::Minimum'  =>  'int' ,
'QSjisCodec*' => 'qt_QSjisCodec*',
'QSlider*' => 'qt_QSlider*',
'QSmartPtr&'  =>  'qt_QSmartPtr*' ,
'QSmartPtr*' => 'qt_QSmartPtr*',
'QSmartPtrPrivate*' => 'qt_QSmartPtrPrivate*',
'QSocket*' => 'qt_QSocket*',
'QSocketDevice*'  =>  'qt_QSocketDevice*' ,
'QSocketNotifier*' => 'qt_QSocketNotifier*',
'QSocketNotifier::Type' => 'int',
'QSortedList*' => 'qt_QSortedList*',
'QSound*' => 'qt_QSound*',
'QSpacerItem*'  =>  'qt_QSpacerItem*' ,
'QSpinBox*' => 'qt_QSpinBox*',
'QSpinWidget*' => 'qt_QSpinWidget*',
'QSplitter*' => 'qt_QSplitter*',
'QSql*' => 'qt_QSql*',
'QSql::Confirm' => 'int',
'QSql::Op' => 'int',
'QSqlCursor&' => 'qt_QSqlCursor*',
'QSqlCursor' => 'qt_QSqlCursor*',
'QSqlCursor*' => 'qt_QSqlCursor*',
'QSqlDatabase*' => 'qt_QSqlDatabase*',
'QSqlDriver*' => 'qt_QSqlDriver*',
'QSqlDriverCreator*' => 'qt_QSqlDriverCreator*',
'QSqlDriverCreatorBase*' => 'qt_QSqlDriverCreatorBase*',
'QSqlDriverFactoryInterface*' => 'qt_QSqlDriverFactoryInterface*',
'QSqlEditorFactory*' => 'qt_QSqlEditorFactory*',
'QSqlError&' => 'qt_QSqlError*',
'QSqlError' => 'qt_QSqlError*',
'QSqlError*' => 'qt_QSqlError*',
'QSqlField&' => 'qt_QSqlField*',
'QSqlField' => 'qt_QSqlField*',
'QSqlField*' => 'qt_QSqlField*',
'QSqlForm' => 'qt_QSqlForm*',
'QSqlForm*' => 'qt_QSqlForm*',
'QSqlIndex&' => 'qt_QSqlIndex*',
'QSqlIndex' => 'qt_QSqlIndex*',
'QSqlIndex*' => 'qt_QSqlIndex*',
'QSqlPropertyMap*' => 'qt_QSqlPropertyMap*',
'QSqlQuery&' => 'qt_QSqlQuery*',
'QSqlQuery' => 'qt_QSqlQuery*',
'QSqlQuery*' => 'qt_QSqlQuery*',
'QSqlRecord&' => 'qt_QSqlRecord*',
'QSqlRecord' => 'qt_QSqlRecord*',
'QSqlRecord*' => 'qt_QSqlRecord*',
'QSqlRecordPrivate*' => 'qt_QSqlRecordPrivate*',
'QSqlRecordShared*' => 'qt_QSqlRecordShared*',
'QSqlResult' => 'qt_QSqlResult*',
'QSqlResult*' => 'qt_QSqlResult*',
'QSqlResultShared*' => 'qt_QSqlResultShared*',
'QStack*' => 'qt_QStack*',
'QStatusBar*'  => 'qt_QStatusBar*' ,
'QStoredDrag*' => 'qt_QStoredDrag*',
'QStrIList*' => 'qt_QStrIList*',
'QStrIVec*' => 'qt_QStrIVec*',
'QStrList&' => 'qt_QStrList *',
'QStrList' => 'qt_QStrList *',
'QStrList*' => 'qt_QStrList *',
'QStrListIterator*' => 'qt_QStrListIterator*',
'QStrVec*' => 'qt_QStrVec*',
'QString&' => 'qt_QString *',
'QString&::null'  =>  'qt_QString*' ,
'QString&button0Text::null'  =>  'qt_QString*' ,
'QString&button1Text::null'  =>  'qt_QString*' ,
'QString&button2Text::null'  =>  'qt_QString*' ,
'QString&buttonText::null'  =>  'qt_QString*' ,
'QString&caption::null'  =>  'qt_QString*' ,
'QString&charSet::null'  =>  'qt_QString*' ,
'QString&context::null'  =>  'qt_QString*' ,
'QString&defValue::null'  =>  'qt_QString*' ,
'QString&dir::null'  =>  'qt_QString*' ,
'QString&directory::null'  =>  'qt_QString*' ,
'QString&filter::null'  =>  'qt_QString*' ,
'QString&initially::null'  =>  'qt_QString*' ,
'QString&location::null'  =>  'qt_QString*' ,
'QString&n::null'  =>  'qt_QString*' ,
'QString&nameFilter::null'  =>  'qt_QString*' ,
'QString&noButtonText::null'  =>  'qt_QString*' ,
'QString&search_delimiters::null'  =>  'qt_QString*' ,
'QString&style::null'  =>  'qt_QString*' ,
'QString&suffix::null'  =>  'qt_QString*' ,
'QString&text::null'  =>  'qt_QString*' ,
'QString&text_::null'  =>  'qt_QString*' ,
'QString&translation::null'  =>  'qt_QString*' ,
'QString&yesButtonText::null'  =>  'qt_QString*' ,
'QString' => 'qt_QString *',
'QString*'  => 'qt_QString*' ,
'QString::null'  =>  'qt_QString_null()' ,
'QStringBucket*' => 'qt_QStringBucket*',
'QStringData*' => 'qt_QStringData*',
'QStringList&'  =>  'qt_QStringList*' ,
'QStringList'  =>  'qt_QStringList*' ,
'QStringList*'  => 'qt_QStringList*' ,
'QStringcharSetName::null'  =>  'qt_QStringcharSetName*' ,
'QStyle&'  =>  'qt_QStyle*' ,
'QStyle*'  =>  'qt_QStyle*' ,
'QStyle::ScrollControl'  => 'int' ,
'QStyle::StylePixmap' => 'int',
'QStyle::SubControl' => 'int',
'QStyle::SubRect' => 'int',
'QStyleFactory*' => 'qt_QStyleFactory*',
'QStyleFactoryInterface*' => 'qt_QStyleFactoryInterface*',
'QStyleSheet*'  =>  'qt_QStyleSheet*' ,
'QStyleSheetItem&'  =>  'qt_QStyleSheetItem*' ,
'QStyleSheetItem*'  =>  'qt_QStyleSheetItem*' ,
'QStyleSheetItem::DisplayMode*' => 'int',
'QStyleSheetItem::ListStyle*' => 'int',
'QTLWExtra*'  =>  'qt_QTLWExtra*' ,
'QTSCIICodec*' => 'qt_QTSCIICodec*',
'QTSMFI'  =>  'int' ,
'QTSManip*' => 'qt_QTSManip*',
'QTab*' => 'void *',
'QTabBar*'  =>  'qt_QTabBar*' ,
'QTabBar::Shape'  => 'int' ,
'QTabDialog*' => 'qt_QTabDialog*',
'QTabWidget*' => 'qt_QTabWidget*',
'QTable*'  =>  'qt_QTable*' ,
'QTableHeader*' => 'qt_QTableHeader*',
'QTableItem*'  =>  'qt_QTableItem*' ,
'QTableSelection&'  =>  'qt_QTableSelection*' ,
'QTableSelection'  =>  'qt_QTableSelection*' ,
'QTableSelection*' => 'qt_QTableSelection*',
'QTableView*' => 'qt_QTableView*',
'QTabletEvent*' => 'qt_QTabletEvent*',
'QTextBrowser*' => 'qt_QTextBrowser*',
'QTextCodec*'  =>  'qt_QTextCodec*' ,
'QTextCodecFactory*' => 'qt_QTextCodecFactory*',
'QTextCodecFactoryInterface*' => 'qt_QTextCodecFactoryInterface*',
'QTextCursor*' => 'qt_QTextCursor*',
'QTextDecoder*'  =>  'qt_QTextDecoder*' ,
'QTextDocument*' => 'qt_QTextDocument*',
'QTextDrag*' => 'qt_QTextDrag*',
'QTextEdit*' => 'qt_QTextEdit*',
'QTextEncoder*'  =>  'qt_QTextEncoder*' ,
'QTextFormat*' => 'qt_QTextFormat*',
'QTextIStream*' => 'qt_QTextIStream*',
'QTextOStream&'  =>  'qt_QTextOStream*' ,
'QTextOStream*' => 'qt_QTextOStream*',
'QTextOStreamIterator*' => 'qt_QTextOStreamIterator*',
'QTextParag**' => 'qt_QTextParag**',
'QTextStream&'  => 'qt_QTextStream*' ,
'QTextStream*'  => 'qt_QTextStream*' ,
'QTextView*' => 'qt_QTextView*',
'QThread*' => 'qt_QThread*',
'QThreadData*' => 'qt_QThreadData*',
'QThreadEvent*' => 'qt_QThreadEvent*',
'QTime&' => 'qt_QTime *',
'QTime' => 'qt_QTime *',
'QTime*' => 'qt_QTime*',
'QTimeEdit*' => 'qt_QTimeEdit*',
'QTimeWatch*' => 'qt_QTimeWatch*',
'QTimer*' => 'qt_QTimer*',
'QTimerEvent*'  => 'qt_QTimerEvent*' ,
'QToolBar*'  => 'qt_QToolBar*' ,
'QToolButton*'  =>  'qt_QToolButton*' ,
'QToolTip*' => 'qt_QToolTip*',
'QToolTipGroup*' => 'qt_QToolTipGroup *',
'QTranslator*'  =>  'qt_QTranslator*' ,
'QTranslatorMessage&'  =>  'qt_QTranslatorMessage*' ,
'QTranslatorMessage'  =>  'qt_QTranslatorMessage*' ,
'QTranslatorMessage*' => 'qt_QTranslatorMessage*',
'QTsciiCodec*' => 'qt_QTsciiCodec*',
'QUnknownInterface*' => 'qt_QUnknownInterface*',
'QUnknownInterface**' => 'qt_QUnknownInterface**',
'QUriDrag*' => 'qt_QUriDrag*',
'QUrl&'  =>  'qt_QUrl*' ,
'QUrl'  =>  'qt_QUrl*' ,
'QUrl*' => 'qt_QUrl*',
'QUrlInfo&'  =>  'qt_QUrlInfo*' ,
'QUrlInfo'  =>  'qt_QUrlInfo*' ,
'QUrlInfo*' => 'qt_QUrlInfo*',
'QUrlOperator&'  =>  'qt_QUrlOperator*' ,
'QUrlOperator*'  =>  'qt_QUrlOperator*' ,
'QUtf16Codec*' => 'qt_QUtf16Codec*',
'QUtf8Codec*' => 'qt_QUtf8Codec*',
'QUuid&' => 'qt_QUuid*',
'QUuid*' => 'qt_QUuid*',
'QVBox*'  => 'qt_QVBox*' ,
'QVBoxLayout*' => 'qt_QVBoxLayout*',
'QVButtonGroup*' => 'qt_QVButtonGroup*',
'QVFbHeader*' => 'qt_QVFbHeader*',
'QVFbKeyData*' => 'qt_QVFbKeyData*',
'QVGroupBox*' => 'qt_QVGroupBox*',
'QValidator*' => 'qt_QValidator *',
'QValidator::State' => 'int',
'QValueList*' => 'qt_QValueList*',
'QValueListConstIterator*' => 'qt_QValueListConstIterator*',
'QValueListIterator*' => 'qt_QValueListIterator*',
'QValueListNode*' => 'qt_QValueListNode*',
'QValueListPrivate*' => 'qt_QValueListPrivate*',
'QValueStack*' => 'qt_QValueStack*',
'QValueVector*' => 'qt_QValueVector*',
'QValueVectorPrivate*' => 'qt_QValueVectorPrivate*',
'QVariant&' => 'qt_QVariant *',
'QVariant' => 'qt_QVariant *',
'QVariant*' => 'qt_QVariant*',
'QVariant::Type'  => 'int' ,
'QVariantPrivate*'  =>  'qt_QVariantPrivate*' ,
'QVector*' => 'qt_QVector*',
'QWExtra*'  =>  'qt_QWExtra*' ,
'QWMatrix&' => 'qt_QWMatrix *',
'QWMatrix' => 'qt_QWMatrix *',
'QWMatrix*' => 'qt_QWMatrix*',
'QWSDecoration&'  =>  'qt_QWSDecoration*' ,
'QWSDecoration*'  =>  'qt_QWSDecoration*' ,
'QWSDisplay*'  =>  'qt_QWSDisplay*' ,
'QWSEvent*'  =>  'qt_QWSEvent*' ,
'QWaitCondition*' => 'qt_QWaitCondition*',
'QWhatsThis*' => 'qt_QWhatsThis*',
'QWheelEvent*'  =>  'qt_QWheelEvent*' ,
'QWidget *' => 'qt_QWidget *',
'QWidget' => 'qt_QWidget *',
'QWidget*' => 'qt_QWidget *',
'QWidgetIntDict&'  => 'qt_QWidgetIntDict*' ,
'QWidgetIntDict*' => 'qt_QWidgetIntDict*',
'QWidgetIntDictIt&'  => 'qt_QWidgetIntDictIt*' ,
'QWidgetIntDictIt*' => 'qt_QWidgetIntDictIt*',
'QWidgetItem*' => 'qt_QWidgetItem*',
'QWidgetList&'  => 'qt_QWidgetList *' ,
'QWidgetList&'  => 'qt_QWidgetList*' ,
'QWidgetList'  =>  'qt_QWidgetList *' ,
'QWidgetList'  =>  'qt_QWidgetList*' ,
'QWidgetList*' => 'qt_QWidgetList *',
'QWidgetList*' => 'qt_QWidgetList*',
'QWidgetListIt&'  => 'qt_QWidgetListIt*' ,
'QWidgetListIt*' => 'qt_QWidgetListIt*',
'QWidgetMapper*' => 'qt_QWidgetMapper*',
'QWidgetStack*' => 'qt_QWidgetStack*',
'QWindowsMime*'  =>  'qt_QWindowsMime*' ,
'QWindowsStyle*' => 'qt_QWindowsStyle*',
'QWizard*' => 'qt_QWizard*',
'QWorkspace*' => 'qt_QWorkspace*',
'QXEmbed*'  =>  'qt_QXEmbed*' ,
'QXmlAttributes&'  =>  'qt_QXmlAttributes*' ,
'QXmlAttributes*' => 'qt_QXmlAttributes*',
'QXmlContentHandler*'  =>  'qt_QXmlContentHandler*' ,
'QXmlDTDHandler*'  =>  'qt_QXmlDTDHandler*' ,
'QXmlDeclHandler*'  =>  'qt_QXmlDeclHandler*' ,
'QXmlDefaultHandler*' => 'qt_QXmlDefaultHandler*',
'QXmlEntityResolver*'  =>  'qt_QXmlEntityResolver*' ,
'QXmlErrorHandler*'  =>  'qt_QXmlErrorHandler*' ,
'QXmlInputSource&'  =>  'qt_QXmlInputSource*' ,
'QXmlInputSource*&' => 'qt_QXmlInputSource*',
'QXmlInputSource*'  =>  'qt_QXmlInputSource*' ,
'QXmlLexicalHandler*'  =>  'qt_QXmlLexicalHandler*' ,
'QXmlLocator*'  =>  'qt_QXmlLocator*' ,
'QXmlNamespaceSupport*' => 'qt_QXmlNamespaceSupport*',
'QXmlParseException&'  =>  'qt_QXmlParseException*' ,
'QXmlParseException*' => 'qt_QXmlParseException*',
'QXmlReader*' => 'qt_QXmlReader*',
'QXmlSimpleReader*'  =>  'qt_QXmlSimpleReader*' ,
'QXtApplication*' => 'qt_QXtApplication*',
'QXtWidget*' => 'qt_QXtWidget*',
'Q_INT16&' => 'short',
'Q_INT16' => 'short',
'Q_INT32&' => 'int',
'Q_INT32' => 'int',
'Q_INT8&' => 'char',
'Q_INT8' => 'char',
'Q_LONG&' => 'long',
'Q_LONG' => 'long',
'Q_PACKED*' => 'void*',
'Q_UINT16&' => 'unsigned short',
'Q_UINT16' => 'unsigned short',
'Q_UINT32&' => 'unsigned int',
'Q_UINT32' => 'unsigned int',
'Q_UINT8&' => 'unsigned char',
'Q_UINT8' => 'unsigned char',
'Q_UINT8*'  =>  'unsigned int*' ,
'Q_ULONG&' => 'long',
'Q_ULONG' => 'long',
'Qt*'  =>  'qt_Qt*' ,
'Qt::ArrowType'  =>  'int' ,
'Qt::BackgroundMode' => 'int',
'Qt::DateFormat' => 'int',
'Qt::GUIStyle'  => 'int' ,
'Qt::GUIStylecolorStyle::WindowsStyle'  => 'int' ,
'Qt::GUIStylestyle::WindowsStyle'  => 'int' ,
'Qt::Orientation'  =>  'int' ,
'Qt::RasterOp'  =>  'int' ,
'Qt::UIEffect'  =>  'int' ,
'Qt::WFlags'  =>  'int' ,
'QtMultiLineEdit*' => 'qt_QtMultiLineEdit*',
'QtMultiLineEditRow*' => 'qt_QtMultiLineEditRow*',
'QtTableView*' => 'qt_QtTableView*',
'QwAbsSpriteFieldView*'  =>  'qt_QwAbsSpriteFieldView*' ,
'QwClusterizer*'  =>  'qt_QwClusterizer*' ,
'QwEllipse*' => 'qt_QwEllipse*',
'QwImageSpriteField*' => 'qt_QwImageSpriteField*',
'QwMobilePositionedSprite*' => 'qt_QwMobilePositionedSprite*',
'QwMobileSprite*' => 'qt_QwMobileSprite*',
'QwPolygon*' => 'qt_QwPolygon*',
'QwPolygonalGraphic*' => 'qt_QwPolygonalGraphic*',
'QwPositionedSprite*' => 'qt_QwPositionedSprite*',
'QwPublicList*'  =>  'qt_QwPublicList*' ,
'QwRealMobileSprite*' => 'qt_QwRealMobileSprite*',
'QwRealSprite*' => 'qt_QwRealSprite*',
'QwRectangle*' => 'qt_QwRectangle*',
'QwScrollingSpriteFieldView*' => 'qt_QwScrollingSpriteFieldView*',
'QwSprite*' => 'qt_QwSprite*',
'QwSpriteField*'  =>  'qt_QwSpriteField*' ,
'QwSpriteField*'  => 'qt_QwSpriteField*' ,
'QwSpriteFieldGraphic&'  => 'qt_QwSpriteFieldGraphic*' ,
'QwSpriteFieldGraphic*'  =>  'qt_QwSpriteFieldGraphic*' ,
'QwSpriteFieldView*' => 'qt_QwSpriteFieldView*',
'QwSpritePixmap*'  =>  'qt_QwSpritePixmap*' ,
'QwSpritePixmapSequence*'  => 'qt_QwSpritePixmapSequence*' ,
'QwTextSprite*' => 'qt_QwTextSprite*',
'QwTiledSpriteField*' => 'qt_QwTiledSpriteField*',
'QwVirtualSprite*' => 'qt_QwVirtualSprite*',
'RArray*' => 'kde_RArray*',
'RGBColor&' => 'kde_RGBColor*',
'RGBColor' => 'kde_RGBColor*',
'RGBColor*' => 'kde_RGBColor*',
'Range&' => 'kde_Range*',
'Range' => 'kde_Range*',
'Range*' => 'kde_Range*',
'RangeException&' => 'kde_RangeException*',
'RangeException*' => 'kde_RangeException*',
'RangeImpl*' => 'kde_RangeImpl*',
'RasterOp' => 'int',
'RawDataPacket*' => 'kde_RawDataPacket*',
'ReadOnlyPart*' => 'kde_ReadOnlyPart*',
'ReadWritePart*' => 'kde_ReadWritePart*',
'Rect&' => 'kde_Rect*',
'Rect' => 'kde_Rect*',
'Rect*' => 'kde_Rect*',
'Reference&' => 'kde_Reference*',
'Reference*' => 'kde_Reference*',
'ReferenceClean*' => 'kde_ReferenceClean*',
'ReferenceHelper*' => 'kde_ReferenceHelper*',
'Region' => 'int',
'RegionType' => 'int',
'RemoteScheduleNode*' => 'kde_RemoteScheduleNode*',
'RenameDlg*' => 'kde_RenameDlg*',
'RenderStyle*'  =>  'kde_RenderStyle*' ,
'Rep*' => 'kde_Rep*',
'RunMode'  =>  'int' ,
'SButton*' => 'kde_SButton*',
'SCFlags' => 'int',
'ScheduleNode*' => 'kde_ScheduleNode*',
'ScrollBarMode' => 'int',
'ScrollControl'  =>  'int' ,
'Section&'  =>  'kde_Section*' ,
'Section*&'  =>  'kde_Section*' ,
'Section*'  =>  'kde_Section*' ,
'SegmentStyle' => 'int',
'Separator' => 'int',
'Server&'  =>  'Server*' ,
'Server*' => 'kde_Server*',
'ServerHello&' => 'kde_ServerHello*',
'ServerHello*' => 'kde_ServerHello*',
'Service*' => 'kde_Service*',
'SimpleJob*' => 'kde_SimpleJob*',
'SimpleSoundServer&' => 'kde_SimpleSoundServer*',
'SimpleSoundServer' => 'kde_SimpleSoundServer*',
'SimpleSoundServer*' => 'kde_SimpleSoundServer*',
'SimpleSoundServer_base*' => 'kde_SimpleSoundServer_base*',
'SimpleSoundServer_skel*' => 'kde_SimpleSoundServer_skel*',
'SimpleSoundServer_stub*' => 'kde_SimpleSoundServer_stub*',
'SkipDlg*' => 'kde_SkipDlg*',
'Slave*' => 'kde_Slave*',
'SlaveBase*' => 'kde_SlaveBase*',
'SlaveBasePrivate*' => 'kde_SlaveBasePrivate*',
'SlaveInterface*' => 'kde_SlaveInterface*',
'SocketConnection*' => 'kde_SocketConnection*',
'Spec' => 'int',
'SpecialEvent*' => 'kde_SpecialEvent*',
'SshProcess*' => 'kde_SshProcess*',
'SshProcessPrivate*' => 'kde_SshProcessPrivate*',
'StartupClass*' => 'kde_StartupClass*',
'StartupManager*' => 'kde_StartupManager*',
'StatJob*' => 'kde_StatJob*',
'State' => 'int',
'StatusbarProgress*' => 'kde_StatusbarProgress*',
'StdFlowSystem*' => 'kde_StdFlowSystem*',
'StdIOManager*' => 'kde_StdIOManager*',
'StdScheduleNode*' => 'kde_StdScheduleNode*',
'StdSynthModule*' => 'kde_StdSynthModule*',
'StereoEffect&' => 'kde_StereoEffect*',
'StereoEffect' => 'kde_StereoEffect*',
'StereoEffect*' => 'kde_StereoEffect*',
'StereoEffectStack&' => 'kde_StereoEffectStack*',
'StereoEffectStack' => 'kde_StereoEffectStack*',
'StereoEffectStack*' => 'kde_StereoEffectStack*',
'StereoEffectStack_base*' => 'kde_StereoEffectStack_base*',
'StereoEffectStack_skel*' => 'kde_StereoEffectStack_skel*',
'StereoEffectStack_stub*' => 'kde_StereoEffectStack_stub*',
'StereoEffect_base*' => 'kde_StereoEffect_base*',
'StereoEffect_skel*' => 'kde_StereoEffect_skel*',
'StereoEffect_stub*' => 'kde_StereoEffect_stub*',
'StereoFFTScope&' => 'kde_StereoFFTScope*',
'StereoFFTScope' => 'kde_StereoFFTScope*',
'StereoFFTScope*' => 'kde_StereoFFTScope*',
'StereoFFTScope_base*' => 'kde_StereoFFTScope_base*',
'StereoFFTScope_skel*' => 'kde_StereoFFTScope_skel*',
'StereoFFTScope_stub*' => 'kde_StereoFFTScope_stub*',
'StereoVolumeControl&' => 'kde_StereoVolumeControl*',
'StereoVolumeControl' => 'kde_StereoVolumeControl*',
'StereoVolumeControl*' => 'kde_StereoVolumeControl*',
'StereoVolumeControl_base*' => 'kde_StereoVolumeControl_base*',
'StereoVolumeControl_skel*' => 'kde_StereoVolumeControl_skel*',
'StereoVolumeControl_stub*' => 'kde_StereoVolumeControl_stub*',
'StreamMode&' => 'int',
'String*' => 'kde_String*',
'StringSectionMap::iterator&'  =>  'kde_StringSectionMap*' ,
'StringSectionMap::iterator'  =>  'kde_StringSectionMap*r' ,
'StubProcess*' => 'kde_StubProcess*',
'StyleHint' => 'int',
'StyleListImpl*' => 'kde_StyleListImpl*',
'StylePixmap' => 'int',
'StyleSheet&' => 'kde_StyleSheet*',
'StyleSheet' => 'kde_StyleSheet*',
'StyleSheet*' => 'kde_StyleSheet*',
'StyleSheetImpl*' => 'kde_StyleSheetImpl*',
'StyleSheetList&' => 'kde_StyleSheetList*',
'StyleSheetList' => 'kde_StyleSheetList',
'StyleSheetList*' => 'kde_StyleSheetList*',
'StyleSheetListImpl*' => 'kde_StyleSheetListImpl*',
'StyleStrategy' => 'int',
'SuProcess*' => 'kde_SuProcess*',
'SubClass&' => 'kde_SubClass*',
'SubClass*' => 'kde_SubClass*',
'SubControl' => 'int',
'SubRect' => 'int',
'SynthBuffer*' => 'kde_SynthBuffer*',
'SynthModule&' => 'kde_SynthModule*',
'SynthModule' => 'kde_SynthModule*',
'SynthModule*' => 'kde_SynthModule*',
'SynthModule_base*' => 'kde_SynthModule_base*',
'SynthModule_skel*' => 'kde_SynthModule_skel*',
'SynthModule_stub*' => 'kde_SynthModule_stub*',
'SynthOut*' => 'kde_SynthOut*',
'Synth_ADD&' => 'kde_Synth_ADD*',
'Synth_ADD' => 'kde_Synth_ADD*',
'Synth_ADD*' => 'kde_Synth_ADD*',
'Synth_ADD_base*' => 'kde_Synth_ADD_base*',
'Synth_ADD_skel*' => 'kde_Synth_ADD_skel*',
'Synth_ADD_stub*' => 'kde_Synth_ADD_stub*',
'Synth_AMAN_PLAY&' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY*' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY_base*' => 'kde_Synth_AMAN_PLAY_base*',
'Synth_AMAN_PLAY_skel*' => 'kde_Synth_AMAN_PLAY_skel*',
'Synth_AMAN_PLAY_stub*' => 'kde_Synth_AMAN_PLAY_stub*',
'Synth_AMAN_RECORD&' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD*' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD_base*' => 'kde_Synth_AMAN_RECORD_base*',
'Synth_AMAN_RECORD_skel*' => 'kde_Synth_AMAN_RECORD_skel*',
'Synth_AMAN_RECORD_stub*' => 'kde_Synth_AMAN_RECORD_stub*',
'Synth_BUS_DOWNLINK&' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK*' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK_base*' => 'kde_Synth_BUS_DOWNLINK_base*',
'Synth_BUS_DOWNLINK_skel*' => 'kde_Synth_BUS_DOWNLINK_skel*',
'Synth_BUS_DOWNLINK_stub*' => 'kde_Synth_BUS_DOWNLINK_stub*',
'Synth_BUS_UPLINK&' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK*' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK_base*' => 'kde_Synth_BUS_UPLINK_base*',
'Synth_BUS_UPLINK_skel*' => 'kde_Synth_BUS_UPLINK_skel*',
'Synth_BUS_UPLINK_stub*' => 'kde_Synth_BUS_UPLINK_stub*',
'Synth_FREQUENCY&' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY*' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY_base*' => 'kde_Synth_FREQUENCY_base*',
'Synth_FREQUENCY_skel*' => 'kde_Synth_FREQUENCY_skel*',
'Synth_FREQUENCY_stub*' => 'kde_Synth_FREQUENCY_stub*',
'Synth_MUL&' => 'kde_Synth_MUL*',
'Synth_MUL' => 'kde_Synth_MUL*',
'Synth_MUL*' => 'kde_Synth_MUL*',
'Synth_MULTI_ADD&' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD*' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD_base*' => 'kde_Synth_MULTI_ADD_base*',
'Synth_MULTI_ADD_skel*' => 'kde_Synth_MULTI_ADD_skel*',
'Synth_MULTI_ADD_stub*' => 'kde_Synth_MULTI_ADD_stub*',
'Synth_MUL_base*' => 'kde_Synth_MUL_base*',
'Synth_MUL_skel*' => 'kde_Synth_MUL_skel*',
'Synth_MUL_stub*' => 'kde_Synth_MUL_stub*',
'Synth_PLAY&' => 'kde_Synth_PLAY*',
'Synth_PLAY' => 'kde_Synth_PLAY*',
'Synth_PLAY*' => 'kde_Synth_PLAY*',
'Synth_PLAY_WAV&' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV*' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV_base*' => 'kde_Synth_PLAY_WAV_base*',
'Synth_PLAY_WAV_skel*' => 'kde_Synth_PLAY_WAV_skel*',
'Synth_PLAY_WAV_stub*' => 'kde_Synth_PLAY_WAV_stub*',
'Synth_PLAY_base*' => 'kde_Synth_PLAY_base*',
'Synth_PLAY_skel*' => 'kde_Synth_PLAY_skel*',
'Synth_PLAY_stub*' => 'kde_Synth_PLAY_stub*',
'Synth_RECORD&' => 'kde_Synth_RECORD*',
'Synth_RECORD' => 'kde_Synth_RECORD*',
'Synth_RECORD*' => 'kde_Synth_RECORD*',
'Synth_RECORD_base*' => 'kde_Synth_RECORD_base*',
'Synth_RECORD_skel*' => 'kde_Synth_RECORD_skel*',
'Synth_RECORD_stub*' => 'kde_Synth_RECORD_stub*',
'Synth_WAVE_SIN&' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN*' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN_base*' => 'kde_Synth_WAVE_SIN_base*',
'Synth_WAVE_SIN_skel*' => 'kde_Synth_WAVE_SIN_skel*',
'Synth_WAVE_SIN_stub*' => 'kde_Synth_WAVE_SIN_stub*',
'T&'  =>  'T*' ,
'T'  =>  'T*' ,
'T*'  =>  'T*' ,
'TCPConnection*' => 'kde_TCPConnection*',
'TCPServer*' => 'kde_TCPServer*',
'TCPSlaveBase*' => 'kde_TCPSlaveBase*',
'TRUE' => '1',
'Task*' => 'kde_Task*',
'Text&' => 'kde_Text*',
'Text' => 'kde_Text*',
'Text*' => 'kde_Text*',
'TextFormat'  =>  'int' ,
'TextImpl*' => 'kde_TextImpl*',
'TickSetting' => 'int',
'TimeNotify*' => 'kde_TimeNotify*',
'TimeWatcher*' => 'kde_TimeWatcher*',
'TmpGlobalComm&' => 'kde_TmpGlobalComm*',
'TmpGlobalComm' => 'kde_TmpGlobalComm*',
'TmpGlobalComm*' => 'kde_TmpGlobalComm*',
'TmpGlobalComm_base*' => 'kde_TmpGlobalComm_base*',
'TmpGlobalComm_skel*' => 'kde_TmpGlobalComm_skel*',
'TmpGlobalComm_stub*' => 'kde_TmpGlobalComm_stub*',
'ToolBarDock&'  =>  'int' ,
'ToolBarDock' => 'int',
'TraderOffer&' => 'kde_TraderOffer*',
'TraderOffer' => 'kde_TraderOffer*',
'TraderOffer*' => 'kde_TraderOffer*',
'TraderOffer_base*' => 'kde_TraderOffer_base*',
'TraderOffer_skel*' => 'kde_TraderOffer_skel*',
'TraderOffer_stub*' => 'kde_TraderOffer_stub*',
'TraderQuery&' => 'kde_TraderQuery*',
'TraderQuery' => 'kde_TraderQuery*',
'TraderQuery*' => 'kde_TraderQuery*',
'TraderQuery_base*' => 'kde_TraderQuery_base*',
'TraderQuery_skel*' => 'kde_TraderQuery_skel*',
'TraderQuery_stub*' => 'kde_TraderQuery_stub*',
'TransferJob*' => 'kde_TransferJob*',
'TreeWalker&' => 'kde_TreeWalker*',
'TreeWalker' => 'kde_TreeWalker*',
'TreeWalker*' => 'kde_TreeWalker*',
'TreeWalkerImpl*' => 'kde_TreeWalkerImpl*',
'True' => '1',
'Type&' => 'kde_Type*',
'Type' => 'int',
'Type*' => 'kde_Type*',
'TypeComponent&' => 'kde_TypeComponent*',
'TypeComponent*' => 'kde_TypeComponent*',
'TypeDef&' => 'kde_TypeDef*',
'TypeDef' => 'kde_TypeDef*',
'TypeDef*' => 'kde_TypeDef*',
'TypeEntry*' => 'kde_TypeEntry*',
'TypeInfo*' => 'kde_TypeInfo*',
'UChar&' => 'kde_UChar*',
'UChar' => 'kde_UChar*',
'UChar*' => 'kde_UChar*',
'UCharReference&' => 'kde_UCharReference*',
'UCharReference' => 'kde_UCharReference*',
'UCharReference*' => 'kde_UCharReference*',
'UDSAtom*' => 'kde_UDSAtom*',
'UDSEntry&' => 'kde_UDSEntry*',
'UDSEntryList&' => 'kde_UDSEntryList*',
'UIServer*' => 'kde_UIServer*',
'UIServer_stub*' => 'kde_UIServer_stub*',
'ULONG_MAX' => 'ULONG_MAX',
'URLArgs&' => 'kde_URLArgs*',
'URLArgs' => 'kde_URLArgs*',
'URLArgs*' => 'kde_URLArgs*',
'UString&' => 'kde_UString*',
'UString' => 'kde_UString*',
'UString*' => 'kde_UString*',
'Undefined*' => 'kde_Undefined*',
'UndoRedoInfo*' => 'int*',
'UnixConnection*' => 'kde_UnixConnection*',
'UnixServer*' => 'kde_UnixServer*',
'VPort*' => 'kde_VPort*',
'VerticalAlignment*' => 'int*',
'View*'  =>  'kde_View*' ,
'VoiceManager*' => 'kde_VoiceManager*',
'WFlags' => 'int',
'WId' => 'unsigned int',
'WState' => 'int',
'WavPlayObject&' => 'kde_WavPlayObject*',
'WavPlayObject' => 'kde_WavPlayObject*',
'WavPlayObject*' => 'kde_WavPlayObject*',
'WavPlayObject_base*' => 'kde_WavPlayObject_base*',
'WavPlayObject_skel*' => 'kde_WavPlayObject_skel*',
'WavPlayObject_stub*' => 'kde_WavPlayObject_stub*',
'WeakReference*' => 'kde_WeakReference*',
'WeakReferenceBase*' => 'kde_WeakReferenceBase*',
'Widget'  =>  'int' ,
'WidgetClass'  =>  'int' ,
'WidthMode' => 'int',
'Window' => 'kde_Window*',
'Window*' => 'kde_Window*',
'WindowArgs&' => 'kde_WindowArgs*',
'WindowArgs*' => 'kde_WindowArgs*',
'WindowsVersion'  =>  'int' ,
'XEvent *' => 'XEvent *',
'XEvent*' => 'XEvent*',
'XrmOptionDescRec*'  =>  'XrmOptionDescRec*' ,
'_AF_VirtualFile*' => 'kde__AF_VirtualFile*',
'_IceConn*'  =>  'qt__IceConn*' ,
'_KURLComboItem*' => 'kde__KURLComboItem*',
'_QwSpritePixmapSequence*'  =>  'qt__QwSpritePixmapSequence*' ,
'_QwTextSprite*'  =>  'qt__QwTextSprite*' ,
'_QwTiledSpriteField*'  =>  'qt__QwTiledSpriteField*' ,
'_QwVirtualSprite*'  =>  'qt__QwVirtualSprite*' ,
'array_data*'  =>  'void*' ,
'bitarr_data*' => 'void*',
'bool&'  =>  'int' ,
'bool' => 'int',
'bool*' => 'int*',
'char *' => 'char *',
'char&'  =>  'char' ,
'char' => 'char',
'char* bugsEmailAddress @bugs.kde.org"' => 'String',
'char*&' => 'char*',
'char*' => 'char*',
'char**' => 'char**',
'char*xpm[]'  =>  'char**' ,
'classConnection*' => 'kde_classConnection*',
'classDeviceManager*' => 'kde_classDeviceManager*',
'classExtensionLoader*' => 'kde_classExtensionLoader*',
'classMidiStatus*' => 'kde_classMidiStatus*',
'classObjectReference' => 'kde_classObjectReference*',
'classQPainter*' => 'kde_classQPainter*',
'classStartupClass*' => 'kde_classStartupClass*',
'double d .0' => 'double',
'double nDefault .0' => 'double',
'double pri .0' => 'double',
'double&'  =>  'double' ,
'double' => 'double',
'double*'  =>  'double*' ,
'false' => '0',
'float desat .3' => 'float',
'float&'  =>  'float' ,
'float' => 'float',
'float*' => 'float*',
'image_io_handler'  =>  'int' ,
'int a  |' => 'int',
'int buttonMask|Apply|Cancel' => 'int',
'int buttonMask|No|Cancel' => 'int',
'int desktop' => 'int',
'int&' => 'int',
'int' => 'int',
'int*' => 'int*',
'kdbgstream&'  => 'kde_Kdbgstream*' ,
'kdbgstream*'  =>  'kde_kdbgstream*',
'khtml*'  =>  'kde_khtml*',
'khtml::ChildFrame*'  => 'kde_khtml_ChildFrame*' ,
'khtml::DrawContentsEvent*'  => 'kde_khtml_DrawContentsEvent*' ,
'khtml::MouseDoubleClickEvent*'  => 'kde_khtml_MouseDoubleClickEvent*' ,
'khtml::MouseMoveEvent*'  => 'kde_khtml_MouseMoveEvent*' ,
'khtml::MousePressEvent*'  => 'kde_khtml_MousePressEvent*' ,
'khtml::MouseReleaseEvent*'  => 'kde_khtml_MouseReleaseEvent*' ,
'khtml::RenderObject*'  => 'kde_khtml_RenderObject*' ,
'khtml::RenderStyle*'  => 'kde_khtml_RenderStyle*' ,
'khtml__DrawContentsEvent*'  =>  'kde_khtml__DrawContentsEvent*',
'khtml__MouseDoubleClickEvent*'  =>  'kde_khtml__MouseDoubleClickEvent*',
'khtml__MouseEvent*'  =>  'kde_khtml__MouseEvent*',
'khtml__MouseMoveEvent*'  =>  'kde_khtml__MouseMoveEvent*',
'khtml__MousePressEvent*'  =>  'kde_khtml__MousePressEvent*',
'khtml__MouseReleaseEvent*'  =>  'kde_khtml__MouseReleaseEvent*',
'kndbgstream&'  => 'void**' ,
'kndbgstream*'  =>  'kde_kndbgstream*',
'ksockaddr_in*'  => 'void*' ,
'long _blockSize *' => 'long *',
'long int' => 'long',
'long unsigned int' => 'long',
'long&'  =>  'long' ,
'long' => 'long',
'long_blockSize*'  =>  'long_blockSize*' ,
'longint' => 'long',
'longunsigned int' => 'unsigned long',
'lt_dlhandle'  =>  'void *' ,
'lt_user_dlloader*'  =>  'kde_lt_user_dlloader*',
'mcopbyte&' => 'void *',
'mcopbyte' => 'unsigned char',
'mode_t _mode (mode_t) -1' => 'int',
'mode_t'  =>  'long' ,
'noteCmd' => 'kde_noteCmd*',
'noteCmd*' => 'kde_noteCmd*',
'ostream&' => 'int',
'ostream*' => 'int',
'pid_t'  =>  'long' ,
'poTime&' => 'kde_poTime*',
'poTime*' => 'kde_poTime*',
'short unsigned' => 'short',
'short' => 'short',
'short*' => 'short*',
'shortunsigned' => 'unsigned short',
'signed int&'  =>  'signed int' ,
'signed long&'  =>  'signed long' ,
'signed short&'  =>  'signed short' ,
'signed'  =>  'signed' ,
'size_t'  =>  'long' ,
'size_t*' => 'int*',
'snd_seq_event_t*' => 'int*',
'ssize_t' => 'int',
'std*' => 'kde_std*',
'std::string&'  =>  'char *' ,
'std::string'  =>  'char *' ,
'time_t'  =>  'long' ,
'timeval&' => 'int',
'true' => '1',
'type&'  =>  'int' ,
'type*'  =>  'int*' ,
'type**'  =>  'int**' ,
'uchar&'  =>  'unsigned char' ,
'uchar'  =>  'unsigned char' ,
'uchar*' => 'unsigned char*',
'uchar**' => 'unsigned char**',
'uint&' => 'unsigned int',
'uint' => 'unsigned int',
'uint*'  =>  'unsigned int*' ,
'uintf~0'  =>  'unsigned int' ,
'ulong' => 'unsigned long',
'unsigned char&' => 'unsigned char',
'unsigned char'  =>  'unsigned char' ,
'unsigned char*'  =>  'unsigned char*' ,
'unsigned int&'  =>  'unsigned int' ,
'unsigned int'  =>  'unsigned int' ,
'unsigned int*'  =>  'int*' ,
'unsigned long int' => 'long',
'unsigned long&'  =>  'unsigned long' ,
'unsigned long'  =>  'unsigned long' ,
'unsigned short int'  =>  'unsigned short' ,
'unsigned short&'  =>  'unsigned short' ,
'unsigned short'  =>  'unsigned short' ,
'unsigned short*'  =>  'short*' ,
'unsigned shortint'  =>  'unsigned short' ,
'unsigned'  =>  'unsigned int' ,
'ushort' => 'unsigned short',
'ushort*'  =>  'short*' ,
'voice*' => 'int',
'void' => 'void',
'void(*)()'  =>  'void(*)()' ,
'void*' => 'void*',
'~' => '~',

);

	# Page footer

	$who = kdocUtil::userName();
	$host = kdocUtil::hostName();
	$now = localtime;
	$gentext = "$who\@$host on $now, using kdoc parser\/custom Java conversion backend.";

	$qtdocTop = <<EOF;
                             -------------------
    begin                : $now
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway\@tipitina.demon.co.uk
    generated by         : $gentext
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

EOF

	$kdedocTop = <<EOF;
                             -------------------
    begin                : $now
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale\@tipitina.demon.co.uk
    generated by         : $gentext
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

EOF

}

sub cplusplusToJava
{
	my ( $cplusplusType )  = @_;

	if ( $cplusplusType =~ /bool/ && $ctypemap{$cplusplusType} eq "int" ) {
		return "boolean";
	} elsif ( $ctypemap{$cplusplusType} =~ /^void\s*\*/ ) {
		return "int";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*int\s*\*/ ) {
		return "int[]";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*double\s*\*/ ) {
		return "double[]";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*short\s*\*/ ) {
		return "short[]";
	} elsif ( 	$ctypemap{$cplusplusType} =~ /qt_QStringList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QStrList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_QCStringList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QObjectList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QDomNodeList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QWidgetList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_KURL_List\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_KMainWindow\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_KFileItemList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_KFileViewItemList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_NodeList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_StyleSheetList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_MediaList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_OfferList\s*\*/ ) {
		return "ArrayList"
	} elsif ( $cplusplusType =~ /(DOM::)?DOMString/ || $cplusplusType =~ /QString/ || $cplusplusType =~ /QCString/ || $ctypemap{$cplusplusType} =~ /^char\s*\*/ ) {
		return "String"
	} elsif ( $cplusplusType =~ /QTime/ ) {
		return "Date"
	} elsif ( $cplusplusType =~ /QDateTime/ || $cplusplusType =~ /QTime/ || $cplusplusType =~ /QDate/ ) {
		return "Calendar"
	} elsif ( $cplusplusType =~ /QPaintDevice/ ) {
		return "QPaintDeviceInterface"
	} elsif ( $cplusplusType =~ /QByteArray/ ) {
		return "byte[]"
	} elsif ( $ctypemap{$cplusplusType} =~ /qt_([^\*\s]*)(.*)$/ ) {
		if ( $interfacemap{$1} ne () ) {
			return $1."Interface";
        } else {
			return $1;
		}
	} elsif ( $ctypemap{$cplusplusType} =~ /kde_([^\*\s]*)(.*)$/ ) {
		if ( $interfacemap{$1} ne () ) {
			return $1."Interface";
        } else {
			return $1;
		}
	} elsif ( $ctypemap{$cplusplusType} =~ /(const)? char *\s*/ ) {
		return "String";
	} elsif ( $ctypemap{$cplusplusType} =~ /(unsigned )?(.*)/ ) {
		return $2;
	} else {
		return $ctypemap{$cplusplusType};
	}

}

sub cplusplusToJNI
{
	my ( $cplusplusType )  = @_;

	if ( $cplusplusType =~ /bool/ && $ctypemap{$cplusplusType} eq "int" ) {
		return "jboolean";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*void\s*\*/ ) {
		return "jint";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*int\s*\*/ ) {
		return "jintArray";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*double\s*\*/ ) {
		return "jdoubleArray";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*short\s*\*/ ) {
		return "jshortArray";
	} elsif ( 	$ctypemap{$cplusplusType} =~ /qt_QStringList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QStrList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_QCStringList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QObjectList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QDomNodeList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_NodeList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_KFileItemList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_KFileItemViewList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_OfferList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_MediaList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_StyleSheetList\s*\*/
				|| $ctypemap{$cplusplusType} =~ /kde_KURL_List\s*\*/
				|| $ctypemap{$cplusplusType} =~ /qt_QWidgetList\s*\*/ ) {
		return "jobjectArray"
	} elsif ( $cplusplusType =~ /(DOM::)?DOMString/ || $cplusplusType =~ /QString/ || $cplusplusType =~ /QCString/ || $ctypemap{$cplusplusType} =~ /^char\s*\*/ ) {
		return "jstring"
	} elsif ( $ctypemap{$cplusplusType} =~ /qt_QDateTime\s*\*/ || $ctypemap{$cplusplusType} =~ /qt_QTime\s*\*/ || $ctypemap{$cplusplusType} =~ /qt_QDate\s*\*/ ) {
		return "jobject"
	} elsif ( $ctypemap{$cplusplusType} =~ /qt_QByteArray\s*\*/  ) {
		return "jbyteArray"
	} elsif ( $ctypemap{$cplusplusType} =~ /qt_([^\*]*)(.*)$/ ) {
		return "jobject";
	} elsif ( $ctypemap{$cplusplusType} =~ /kde_([^\*]*)(.*)$/ ) {
		return "jobject";
	} elsif ( $ctypemap{$cplusplusType} =~ /(const)? char *\s*/ ) {
		return "jstring";
	} elsif ( $ctypemap{$cplusplusType} =~ /(unsigned\s+)(.*)/ ) {
		return "j".$2;
	} elsif ( $cplusplusType eq "void" || $cplusplusType eq "" ) {
		return "void";
	} else {
		return "j".$ctypemap{$cplusplusType};
	}

}

sub cplusplusToJNISignature
{
	my ( $cplusplusType )  = @_;

	if ( cplusplusToJava( $cplusplusType ) =~ /Calendar/ ) {
		return "Ljava_util_Calendar_2"
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /Date/ ) {
		return "Ljava_util_Date_2"
	} elsif ( 	cplusplusToJava( $cplusplusType ) =~ /ArrayList/ ) {
		return "Ljava_util_ArrayList_2"
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /String/ ) {
		return "Ljava_lang_String_2";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /byte\[\]/ ) {
		return "_3B";
	} elsif ( $ctypemap{$cplusplusType} =~ /void\s*\*/ ) {
		return "I";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*int\s*\*/ ) {
		return "_3I";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*double\s*\*/ ) {
		return "_3D";
	} elsif ( $ctypemap{$cplusplusType} =~ /^\s*short\s*\*/ ) {
		return "_3S";
	} elsif ( $ctypemap{$cplusplusType} =~ /qt_([^\*\s]*)(.*)$/ ) {
		if ( $interfacemap{$1} ne () ) {
			return "Lorg_kde_qt_$1"."Interface_2";
        } else {
			return "Lorg_kde_qt_$1"."_2";
		}
	} elsif ( $ctypemap{$cplusplusType} =~ /kde_([^\*\s]*)(.*)$/ ) {
		if ( $interfacemap{$1} ne () ) {
			return "Lorg_kde_koala_$1"."Interface_2";
        } else {
			return "Lorg_kde_koala_$1"."_2";
		}
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^boolean\s*/ ) {
		return "Z";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^byte\s*/ ) {
		return "B";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^char\s*/ ) {
		return "C";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^short\s*/ ) {
		return "S";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^int\s*/ ) {
		return "I";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^long\s*/ ) {
		return "J";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^float\s*/ ) {
		return "F";
	} elsif ( cplusplusToJava( $cplusplusType ) =~ /^double\s*/ ) {
		return "D";
	} else {
		return "";
	}

}

sub writeDoc
{
	( $lib, $rootnode, $outputdir, $opt ) = @_;

	$debug = $main::debug;

	mkpath( $outputdir ) unless -f $outputdir;


	# Document all compound nodes
	Iter::LocalCompounds( $rootnode, sub { writeClassDoc( shift ); } );

}




=head2 writeClassDoc

	Write documentation for one compound node.

=cut

sub writeClassDoc
{
	my( $node ) = @_;

	print "Enter: $node->{astNodeName}\n" if $debug;

	my $typeName = $node->{astNodeName}."*";

	if ( $ctypemap{$typeName} eq () ) {
		$typeprefix = ($typeName =~ /^Q/ ? "qt_" : "kde_");
		$ctypemap{$typeName} = $typeprefix.$node->{astNodeName}."*";
		print "'$typeName' => '$typeprefix$typeName',\n";
	} elsif ( $ctypemap{$typeName} =~ /^qt_/ ) {
		$typeprefix = "qt_";
	} elsif ( $ctypemap{$typeName} =~ /^kde_/ ) {
		$typeprefix = "kde_";
	}

	my $docnode = $node->{DocNode};
	my @list = ();
	my $version = undef;
	my $author = undef;


	if( $#{$node->{Kids}} < 0 || $node->{Access} eq "private" || exists $node->{Tmpl} ) {
		return;
	}

	my $file = "$outputdir/".join("__", kdocAstUtil::heritage($node)).".java";
	open( CLASS, ">$file" ) || die "Couldn't create $file\n";

	$file = "$outputdir/".join("__", kdocAstUtil::heritage($node)).".cpp";
	open( JNISOURCE, ">$file" ) || die "Couldn't create $file\n";

	if ( $interfacemap{$node->{astNodeName}} ne () ) {
		$file = "$outputdir/".join("__", kdocAstUtil::heritage($node)).".java";
		$file =~ s/$node->{astNodeName}/$interfacemap{$node->{astNodeName}}/;
		open( INTERFACE, ">$file" ) || die "Couldn't create $file\n";
		print INTERFACE "/***************************************************************************\n";
		print INTERFACE "                            ", $interfacemap{$node->{astNodeName}}, ".java -  description\n";
		if ( $typeprefix eq "qt_" ) {
			print INTERFACE $qtdocTop;
			print INTERFACE "package org.kde.qt;\n\n";
        } else {
			print INTERFACE $kdedocTop;
			print INTERFACE "package org.kde.koala;\n\n";
			print INTERFACE "import org.kde.qt.*;\n";
 		}
 		print INTERFACE "public interface ", $interfacemap{$node->{astNodeName}}, " {\n";

	}

	my $short = "";
	my $extra = "";

	print CLASS "/***************************************************************************\n";
	print CLASS "                            ", $node->{astNodeName}, ".java -  description\n";
	if ( $typeprefix eq "qt_" ) {
		print CLASS $qtdocTop;
    } else {
		print CLASS $kdedocTop;
	}

	print JNISOURCE "/***************************************************************************\n";
	print JNISOURCE "                            ", $node->{astNodeName}, ".cpp -  description\n";
	if ( $typeprefix eq "qt_" ) {
		print JNISOURCE $qtdocTop;
		print CLASS "package org.kde.qt;\n\n";
    } else {
		print JNISOURCE $kdedocTop;
		print CLASS "package org.kde.koala;\n\n";
		print CLASS "import org.kde.qt.*;\n";
	}

	my $sourcename = $node->{Source}->{astNodeName};
	$sourcename =~ s!.*/(.*)!$1!m;

	print JNISOURCE "#define _BOOL_H_\n";
	print JNISOURCE "#include <",$sourcename , ">\n";
	print JNISOURCE "#include <qstring.h>\n";
	print JNISOURCE "#include <qcstring.h>\n\n";

	print JNISOURCE "#include <qtjava/QtSupport.h>\n";

	if ( $typeprefix eq "qt_" ) {
		print JNISOURCE "#include <qtjava/", $node->{astNodeName}, ".h>\n";
	} else {
		print JNISOURCE "#include <kdejava/", $node->{astNodeName}, ".h>\n";
	}

		# ancestors
	my @ancestors = ();
	Iter::Ancestors( $node, $rootnode, undef, undef,
		sub { # print
			my ( $ances, $name, $type, $template ) = @_;
			push @ancestors, $name;
			},
			undef
		);

	print CLASS "import java.util.*;\n";
	print CLASS "import java.lang.Error;\n\n";

	if ( defined $docnode ) {
		print CLASS "/**\n";
		if ( defined $docnode->{Text} ) {
			printJavadocComment( $docnode, \*CLASS );
		}

		exists $docnode->{Author} && print CLASS " \@author ", $docnode->{Author}, "\n";
		exists $docnode->{Version} && print CLASS " \@version ", $docnode->{Version}, "\n";
		exists $docnode->{ClassShort} && print CLASS " \@short ", $docnode->{ClassShort}, "\n";
		print CLASS "*/\n";
	}

	%functionId = ();
	$eventHandlerCount = 0;
	$constructorCount = 0;

	# Add any enums found to the %ctypemap
	Iter::MembersByType ( $node,
		sub { print CLASS "", $_[0], ""; print JNISOURCE "", $_[0], "";  },
		sub {	my ($node, $kid ) = @_;
                 preParseMember( $node, $kid );
               },
		sub { print CLASS ""; print JNISOURCE ""; }
	);

	if ( $#ancestors < 0 ) {
		print CLASS "public class  ", $node->{astNodeName}, " implements QtSupport";

		if ( $interfacemap{$node->{astNodeName}} ne () ) {
			print CLASS ", ".$interfacemap{$node->{astNodeName}};
		}

		print CLASS " {\n\tprivate long _qt;\n";
		print CLASS "\tprivate boolean _allocatedInJavaWorld = true;\n\n";
	} else {
		print CLASS "public class ", $node->{astNodeName}, " extends ";
		my $ancestor;
		foreach $ancestor ( @ancestors ) {
			if ( $interfacemap{$ancestor} eq () ) {
				print CLASS "$ancestor ";
				last;
           	} elsif ($ancestor eq @ancestors[$#ancestors] ) {
				print CLASS @ancestors[$#ancestors], " ";
			}
		}

		if ( $#ancestors >= 1 ) {
			print CLASS "implements ";
			foreach $ancestor ( @ancestors ) {
				if ( $interfacemap{$ancestor} ne () ) {
					print CLASS " ".$interfacemap{$ancestor};
				}
			}
        }

		if ( $interfacemap{$node->{astNodeName}} ne () ) {
			print CLASS ", ".$interfacemap{$node->{astNodeName}};
		}

		print CLASS " {\n";
	}

	if ( ! exists $node->{Pure} && $constructorCount > 0 ) {
		print JNISOURCE "\nclass ", $node->{astNodeName}, "JBridge : public ", $node->{astNodeName}, "\n{\npublic:\n";

		Iter::MembersByType ( $node,
			sub { print HEADER "", $_[0], ""; print CLASS "", $_[0], ""; },
			sub {	my ($node, $kid ) = @_;
                    generateBridgeClass( $node, $kid );
                 },
			sub { ; }
			);

		generateBridgeEventHandlers($node);
		
		print JNISOURCE "};\n\n";
	}

	if ( $#ancestors >= 0 ) {
		print CLASS "\tprotected ", $node->{astNodeName}, "(Class dummy){super((Class) null);}\n\n";
    } else {
		print CLASS "\tprotected ", $node->{astNodeName}, "(Class dummy){}\n\n";
	}

	Iter::MembersByType ( $node,
		sub { print CLASS "", $_[0], ""; print JNISOURCE "", $_[0], "";  },
		sub {	my ($node, $kid ) = @_;
                 parseMember( $node, $kid, $#ancestors );
               },
		sub { print CLASS ""; print JNISOURCE ""; }
	);


	Iter::MembersByType ( $node,
		sub { print CLASS "", $_[0], ""; print JNISOURCE "", $_[0], "";  },
		sub {	my ($node, $kid ) = @_;
                 generateClassMethodForEnum( $node, $kid );
               },
		sub { print CLASS ""; print JNISOURCE ""; }
	);

	print CLASS "}\n";

	if ( $eventHandlerCount > 0 ) {
		print CLASS "\n/\*\* Override these methods in subclasses of ",
			$node->{astNodeName}, " to customise event handling behaviour \*/\n";
		print CLASS "interface ", $node->{astNodeName}, "EventHandling {\n";
		generateEventHandlers($node);
		print CLASS "}\n\n";
	}

	close CLASS;
	print JNISOURCE "\n";
	close JNISOURCE;

	if ( $interfacemap{$node->{astNodeName}} ne () ) {
		print INTERFACE "}\n";
		close INTERFACE;
    }

}



sub generateEventHandlers
{
	my( $node ) = @_;
	my %allmem = ();
	my $key;
	
	my $m;
	my $name;

	kdocAstUtil::allMembers( \%allmem, $node );
	
	foreach $key (keys (%allmem)) {
		$m = $allmem{$key};
		$name = $m->{astNodeName} ;
		my $type = $m->{NodeType};
		my $docnode = $m->{DocNode};
		
	if( $type eq "method" && $m->{Access} eq "protected"  && $name =~ /.*Event$/
		&& $name !~ /qwsEvent/ && $name !~ /x11Event/ && $name !~ /winEvent/ && $name !~ /macEvent/  && $name !~ /movableDropEvent/ ) {
		
		
		my $cparams = $m->{Params};
		my $javaparams;
		$cparams =~ s/=\s*[-"\w]*//g;
		$cparams =~ s/\s+/ /g;
		$cparams =~ s/\s*([,\*\&])\s*/$1 /g;
		$cparams =~ s/^\s*void\s*$//;
		my $argId = 0;
		my @cargs = split(",", $cparams);
		$cparams = "";
		foreach my $arg ( @cargs ) {
			my $argType;
			my $cargType;
			$arg =~ s/\s*([^\s].*[^\s])\s*/$1/;
			if ( $arg =~ /(.*)\s+(\w+)$/ ) {
				$argType = $1;
				$arg = $2;
			} else {
				$argType = $arg;
				$argId++;
				$arg = "arg".$argId;
			}
			$argType =~ s/\*//;
			$javaparams .= $argType." ".$arg.", ";
			$cparams .= $arg.", ";
		}
		$cparams =~ s/, $//;
		$javaparams =~ s/, $//;

		if ( defined $docnode ) {
			if ( defined $docnode->{Text} ) {
				print CLASS "\n/** ";
				printJavadocComment( $docnode, \*CLASS );
				print CLASS "*/\n";
			}
		}
		
		print CLASS "\tvoid $name($javaparams);\n";
	}
	}

}

sub generateBridgeEventHandlers
{
	my( $node ) = @_;
	my %allmem = ();
	my $key;
	
	my $m;
	my $name;

	kdocAstUtil::allMembers( \%allmem, $node );
	
	foreach $key (keys (%allmem)) {
		$m = $allmem{$key};
		$name = $m->{astNodeName} ;
		my $type = $m->{NodeType};
		my $docnode = $m->{DocNode};
		my $cparams = $m->{Params};
		my $parent = $m->{Parent};
		my $cplusplusparams;
		
	if( $type eq "method" && $m->{Access} eq "protected"  && $name =~ /.*Event$/
		&& $name !~ /qwsEvent/ && $name !~ /x11Event/ && $name !~ /winEvent/ && $name !~ /macEvent/ && $name !~ /movableDropEvent/ ) {
			$cparams =~ s/=\s*[-"\w]*//g;
			$cparams =~ s/\s+/ /g;
			$cparams =~ s/\s*([,\*\&])\s*/$1 /g;
			$cparams =~ s/^\s*void\s*$//;
			$cparams =~ s/^\s*$//;
			my $argId = 0;
			my @cargs = split(",", $cparams);
			$cparams = "";
			foreach my $arg ( @cargs ) {
				my $argType;
				my $cargType;
				$arg =~ s/\s*([^\s].*[^\s])\s*/$1/;
				if ( $arg =~ /(.*)\s+(\w+)$/ ) {
					$argType = $1;
					$arg = $2;
				} else {
					$argType = $arg;
					$argId++;
					$arg = "arg".$argId;
				}
				$cplusplusparams .= $argType." ".$arg.", ";
				$cparams .= $arg.", ";
			}
			$cparams =~ s/, $//;
			$cplusplusparams =~ s/, $//;

			$eventHandlerCount++;
			my $eventType = $cplusplusparams;
			$eventType =~ s/(.*)\*.*$/$1/;
			$eventType =~ s/^([^Q].*)/org.kde.koala.$1/;
			$eventType =~ s/^(Q.*)/org.kde.qt.$1/;
			print JNISOURCE "\tvoid $name(", $cplusplusparams, ") {\n",
			"\t\tif (! QtSupport::eventDelegate(this, \"", $name, "\", $cparams, \"$eventType\")) {\n",
			"\t\t\t", $parent->{astNodeName}, "::", $name, "($cparams);\n",
			"\t\t}\n",
			"\t\treturn;\n\t}\n";
		}
	}

}


sub preParseMember
{
	my( $class, $m ) = @_;
	my $name = $m->{astNodeName};

	if( $m->{NodeType} eq "method" ) {
		if ( $functionId{$name} eq "" ) {
			$functionId{$name} = 0;
		} else {
			$functionId{$name}++;
		}

		# If there are any default parameters (ie '=' found), then an extra method call will be generated
		if ( $m->{Params} =~ /=/ ) {
			$functionId{$name}++;
		}
		
		# A JBridge class will only be generated if there is at least one
		# public or protected constructor
		if ( $name eq $class->{astNodeName} && $m->{Access} ne "private" ) {
			$constructorCount++;
		}
    }

	if( $m->{NodeType} eq "enum" ) {
		# Add a C++ to C type mapping for this enum - an int in C
		$name =~ s/\s//g;
		$ctypemap{$name} = 'int';
		$name = $class->{astNodeName}."::".$name;
		$ctypemap{$name} = 'int';
	}
}

sub generateBridgeClass
{
	my( $class, $m ) = @_;
	my $name;
    my $function;

	$name = $m->{astNodeName} ;
	my $type = $m->{NodeType};
	my $docnode = $m->{DocNode};

	if( $type eq "method" && $m->{Access} ne "private" && $m->{Access} ne "private_slots" && $m->{Access} ne "signals" ) {
		if ( $m->{ReturnType} =~ /[<>]/ || $m->{Params} =~ /[<>]/ ) {
#			print "template based method not converted: ", $m->{ReturnType}, " ", $m->{Params}, "\n";
			return;
		}

		my $returnType = $m->{ReturnType};
		my $cparams = $m->{Params};
		my $cplusplusparams;
		if ( $cparams =~ /\s*\)\s*:\s*/ ) {
#			print "found a constructor list: '$cparams'\n";
			$cparams =~ s/(.*)\s*\)\s*:\s*.*$/$1/;
		}

		$cparams =~ s/=\s*(("[^"]*")|(\'.\')|(([-\w:]*)\s*(\|\s*[-\w]*)*(\(\w*\))?))//g;
		$cparams =~ s/\s+/ /g;
		$cparams =~ s/\s*([,\*\&])\s*/$1 /g;
		$cparams =~ s/^\s*void\s*$//;
		$cparams =~ s/^\s*$//;
		my $argId = 0;
		my @cargs = split(",", $cparams);
		$cparams = "";
		foreach my $arg ( @cargs ) {
			my $argType;
			my $cargType;
			$arg =~ s/\s*([^\s].*[^\s])\s*/$1/;
			if ( $arg =~ /(.*)\s+(\w+)$/ ) {
				$argType = $1;
				$arg = $2;
			} else {
				$argType = $arg;
				$argId++;
				$arg = "arg".$argId;
			}
			$cplusplusparams .= $argType." ".$arg.", ";
			$cparams .= $arg.", ";
		}
		$cparams =~ s/, $//;
		$cplusplusparams =~ s/, $//;

		my $flags = $m->{Flags};

		if ( !defined $flags ) {
			warn "Method ".$m->{astNodeName}.  " has no flags\n";
		}

		my $extra = "";
		$extra .= "static " if $flags =~ "s";
		if ( $name =~ /operator/ || $extra =~ /friend|inline/ ) {
			return;
		}


		if ( $name eq $class->{astNodeName} ) {
			if ( $returnType =~ "~" ) {
				print JNISOURCE "\t~", $name, "JBridge() {}\n";
			} else {
				print JNISOURCE $extra,
					"\t", $name, "JBridge(", $cplusplusparams, ") : $name($cparams) {}\n";
			}
		} elsif( $type eq "method" && $m->{Access} eq "protected"  && $name =~ /.*Event$/ ) {
			;
		} elsif( $m->{Access} =~ /^protected/ ){
			if ( $returnType =~ "void" ) {
				print JNISOURCE "\tvoid protected_$name(", $cplusplusparams, ") {\n",
				"\t\t", $class->{astNodeName}, "::$name($cparams);\n",
				"\t\treturn;\n\t}\n";
			} else {
				print JNISOURCE "\t$returnType protected_$name(", $cplusplusparams, ") {\n",
				"\t\treturn ($returnType) ", $class->{astNodeName}, "::$name($cparams);\n\t}\n";
			}
		}
	}

}

sub parseMember
{
	my( $class, $m, $ancestorCount ) = @_;
	my $name;
    my $jniFunction;
	my $jniPackage;
    my $stringargs;
	my $cplusplusparams = $m->{Params};
	my $javaparams;
	my $jniparams;
	my $jnireturntype;
	my $javaaccess;
	my $javaargs;

	my $defaultstringargs;
	my $defaultcplusplusparams;
	my $defaultjavaparams;
	my $defaultjniFunction;
	my $defaultjniparams;
	my $defaultjavaargs;


	$name = $m->{astNodeName} ;
	my $type = $m->{NodeType};

	my $docnode = $m->{DocNode};

	if ( $m->{ReturnType} =~ /~/ ) {
		$name = "~".$name;
	}

	if( $type eq "method" && $m->{Access} ne "private" && $m->{Access} ne "private_slots" && $m->{Access} ne "signals" ) {
		if ( $m->{ReturnType} =~ /[<>]/ || $m->{Params} =~ /[<>]/  || $m->{Params} =~ /\.\.\./  ) {
			return;
		}

		my $returnType = $m->{ReturnType};

		$returnType =~ s/friend\s*//;
		$returnType =~ s/const\s*//;
		$returnType =~ s/inline\s*//;
		$returnType =~ s/Q_EXPORT\s*//;
		$returnType =~ s/\s*([,\*\&])\s*/$1/;
		$returnType =~ s/^\s*//;
		$returnType =~ s/\s*$//;

		if ( $returnType ne "" && cplusplusToJava($returnType) eq () ) {
			$returnType =~ s/^.*::.*$/int/;
		} else {
			$jnireturntype = cplusplusToJNI($returnType);
			if ( $jnireturntype =~ /jobjectArray/ ) {
				$jnireturntype = "jobject";
			}
			$returnType = cplusplusToJava($returnType);
		}

		$jniFunction = $class->{astNodeName};
		$jniFunction =~ s/_/_1/g;

		if ( $jniFunction =~ /^Q/ ) {
			$jniPackage = "Java_org_kde_qt_";
		} else {
			$jniPackage = "Java_org_kde_koala_";
		}

		$jniFunction = "\nJNIEXPORT $jnireturntype JNICALL\n".$jniPackage.$jniFunction."_$name";
		if ( $functionId{$name} > 0 ) {
			$jniFunction .= "__";
		}

		if ( $cplusplusparams =~ /\s*\)\s*:\s*/ ) {
#			print "found a constructor list: '$cplusplusparams'\n";
			$cplusplusparams =~ s/(.*)\s*\)\s*:\s*.*$/$1/;
		}

		$cplusplusparams =~ s/\s+/ /g;
		$cplusplusparams =~ s/\s*([,\*\&])\s*/$1 /g;
		$cplusplusparams =~ s/^\s*$//;
		$cplusplusparams =~ s/^\s*void\s*$//;
		my $argId = 0;
		my @cargs = split(",", $cplusplusparams);
		$cplusplusparams = "";
		foreach my $arg ( @cargs ) {
			my $argType;
			my $cargType;
			my $javaargType;
			$arg =~ s/\s*([^\s].*[^\s])\s*/$1/;
			$arg =~ s/(\w+)\[\]/\* $1/;

			# A '<arg> = <value>' default parameter
			if ( $arg =~ s/=\s*(("[^"]*")|(\'.\')|(([-\w:]*)\s*(\|\s*[-\w]*)*(\(\w*\))?))// ) {
				my $param = $1;
				if ( $defaultcplusplusparams eq "" ) {
					$defaultcplusplusparams = $cplusplusparams;
					$defaultjavaparams = $javaparams;
					$defaultstringargs = $stringargs;
					$defaultjniFunction = $jniFunction;
					$defaultjniparams = $jniparams;
					$defaultjavaargs = $javaargs;
				}

				if ( $param =~ /(.*)::(.*)/ && $ctypemap{$param} eq ()) {
					$defaultcplusplusparams .= "$1::$2, ";
				} else {
					if ( $ctypemap{$param} eq () ) {
						if ( $param =~ /^[A-Z]/ ) {
							$defaultcplusplusparams .= $class->{astNodeName}."::".$param.", ";
						} else {
							$defaultcplusplusparams .= $param.", ";
                    	}
					} else {
						$defaultcplusplusparams .= $param.", ";
					}
				}
			}

			if ( $arg =~ /^(.*)\s+(\w+)\s*$/ ) {
				$argType = $1;
				$arg = $2;
			} else {
				$argType = $arg;
				$argId++;
				$arg = "arg".$argId;
			}
			$arg =~ s/^id$/identifier/;
			$argType =~ s/\s*([^\s].*[^\s])\s*/$1/;
			$argType =~ s/\s*const//g;
			$argType =~ s/^\s*//;
			$argType =~ s/([\*\&])\s*([\*\&])/$1$2/;
			$cargType = $ctypemap{$argType};
			$javaargType = cplusplusToJava( $argType );
			if ( $javaargType eq "" ) {
				$javaargType = $argType;
				$javaargType =~ s/\&/\*/;
				$javaargType =~ s/^.*::.*$/int/;
			}

			$arg =~ s/^super$/superClass/;
			$jniparams .= ", ".cplusplusToJNI( $argType )." ".$arg;

			if ( $ctypemap{$argType} =~ /qt_QStr(ing)?List\s*\*/ ) {
				$javaparams .= " String[] $arg,";
			} else {
				$javaparams .= " $javaargType $arg,";
			}
			$javaargs .= " $arg,";
			if ( $functionId{$name} > 0 ) {
				# QStringList should be converted to String[] as arguments, but ArrayLists
				# as return types. Hence, this hack.
				if ( $ctypemap{$argType} =~ /qt_QStr(ing)?List\s*\*/ ) {
					$jniFunction .= "_3Ljava_lang_String_2";
				} else {
					$jniFunction .= cplusplusToJNISignature($argType);
				}
			}

			if ( $cargType eq "" ) {
				print "'$argType' => '$typeprefix$argType',\n";
				if ( $ctypemap{$argType} =~ /^qt_/ || $ctypemap{$argType} =~ /^kde_/ ) {
					$argType =~ s/\&//;
					$cplusplusparams .= "($argType) QtSupport::getQt(env, $arg), ";
				} else {
					$argType =~ s/\&//;
					$cplusplusparams .= "(".$argType.") ".$arg.", ";
				}
			} else {
				if ( $javaargType =~ /String/ ) {
					if ( $ctypemap{$argType} =~ /qt_QString\s*\*/ ) {
						$stringargs = "\nstatic QString * _qstring_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQString(env, $arg, &_qstring_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (QString *) QtSupport::toQString(env, $arg, &_qstring_$arg), ";
						}
					} elsif ( $ctypemap{$argType} =~ /qt_QCString\s*\*/ ) {
						$stringargs = "\nstatic QCString * _qcstring_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQCString(env, $arg, &_qcstring_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (QCString *) QtSupport::toQCString(env, $arg, &_qcstring_$arg), ";
						}
					} elsif ( $ctypemap{$argType} =~ /kde_DOMString\s*(\*)/ ) {
						$stringargs = "\nstatic DOM::DOMString * _domstring_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "(DOM::DOMString *) KDESupport::toDOMString(env, $arg, &_domstring_$arg), ";
						} else {
							$cplusplusparams .= "(DOM::DOMString) * (DOM::DOMString *) KDESupport::toDOMString(env, $arg, &_domstring_$arg), ";
						}
					} else {
						$stringargs = "\nstatic QCString * _qstring_$arg = 0;".$stringargs;
						$cplusplusparams .= "($argType) QtSupport::toCharString(env, $arg, &_qstring_$arg), ";
					}
				} elsif ( $javaargType =~ /byte\[\]/ ) {
						$stringargs = "\nstatic QByteArray * _qbyteArray_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQByteArray(env, $arg, &_qbyteArray_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (QByteArray *) QtSupport::toQByteArray(env, $arg, &_qbyteArray_$arg), ";
						}
				} elsif ( $javaargType =~ /Calendar/ ) {
					if ( $ctypemap{$argType} =~ /qt_QDateTime\s*\*/ ) {
						$stringargs = "\nstatic QDateTime * _qdate_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQDateTime(env, $arg, &_qdate_$arg), ";
                        } else {
							$cplusplusparams .= "($argType) * (QDateTime *) QtSupport::toQDateTime(env, $arg, &_qdate_$arg), ";
						}
					} elsif ( $ctypemap{$argType} =~ /qt_QTime\s*\*/ ) {
						$stringargs = "\nstatic QTime * _qdate_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQTime(env, $arg, &_qdate_$arg), ";
                        } else {
							$cplusplusparams .= "($argType) * (QTime *) QtSupport::toQTime(env, $arg, &_qdate_$arg), ";
						}
					} elsif ( $ctypemap{$argType} =~ /qt_QDate\s*\*/ ) {
						$stringargs = "\nstatic QDate * _qdate_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQDate(env, $arg, &_qdate_$arg), ";
                        } else {
							$cplusplusparams .= "($argType) * (QDate *) QtSupport::toQDate(env, $arg, &_qdate_$arg), ";
						}
					}
				} elsif ( $javaargType =~ /ArrayList/ && $ctypemap{$argType} =~ /qt_(QStrList)\s*\*/ ) {
						$stringargs = "\nstatic $1 * _qlist_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQStrList(env, $arg, &_qlist_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (QStrList *) QtSupport::toQStrList(env, $arg, &_qlist_$arg), ";
						}
				} elsif ( $javaargType =~ /ArrayList/ && $ctypemap{$argType} =~ /qt_(QStringList)\s*\*/ ) {
						$stringargs = "\nstatic $1 * _qlist_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) QtSupport::toQStringList(env, $arg, &_qlist_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (QStringList *) QtSupport::toQStringList(env, $arg, &_qlist_$arg), ";
						}
				} elsif ( $javaargType =~ /ArrayList/ && $ctypemap{$argType} =~ /kde_(KFileItemList)\s*\*/ ) {
						$stringargs = "\nstatic $1 * _qlist_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) KDESupport::toKFileItemList(env, $arg, &_qlist_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (KFileItemList *) KDESupport::toKFileItemList(env, $arg, &_qlist_$arg), ";
						}
				} elsif ( $javaargType =~ /ArrayList/ && $ctypemap{$argType} =~ /kde_(QCStringList)\s*\*/ ) {
						$stringargs = "\nstatic $1 * _qlist_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) KDESupport::toQCStringList(env, $arg, &_qlist_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (QCStringList *) KDESupport::toQCStringList(env, $arg, &_qlist_$arg), ";
						}
				} elsif ( $javaargType =~ /ArrayList/ && $ctypemap{$argType} =~ /kde_(KURL_List)\s*\*/ ) {
						$stringargs = "\nstatic KURL::List * _qlist_$arg = 0;".$stringargs;
						if ( $argType =~ /[\*]/ ) {
							$cplusplusparams .= "($argType) KDESupport::toKURLList(env, $arg, &_qlist_$arg), ";
						} else {
							$cplusplusparams .= "($argType) * (KURL::List *) KDESupport::toKURLList(env, $arg, &_qlist_$arg), ";
						}
				} elsif ( $javaargType =~ /^int\[\]/  ) {
					$cplusplusparams .= " ($argType) QtSupport::toIntPtr(env, $arg), ";
				} elsif ( $javaargType =~ /double\[\]/  ) {
					$cplusplusparams .= " ($argType) QtSupport::toDoublePtr(env, $arg), ";
				} elsif ( $javaargType =~ /short\[\]/  ) {
					$cplusplusparams .= " ($argType) QtSupport::toShortPtr(env, $arg), ";
				} elsif ( $argType =~ /QPaintDevice/  ) {
					$cplusplusparams .= "($argType) QtSupport::paintDevice(env, $arg), ";
				} elsif ( $ctypemap{$argType} =~ /^qt_/ || $ctypemap{$argType} =~ /^kde_/ ) {
					if ( $argType =~ /^([^\*\&]*)&?$/ ) {
						$cplusplusparams .= "($argType) *($1 *) QtSupport::getQt(env, $arg), ";
					} else {
						$cplusplusparams .= "($argType) QtSupport::getQt(env, $arg), ";
					}
				} elsif ( $argType =~ /^[A-Z][^:]*$/ && $cargType eq "int" && $ctypemap{$class->{astNodeName}."::".$argType} ne "" ) {
					$cplusplusparams .= "(".$class->{astNodeName}."::".$argType.") $arg, ";
				} elsif ( $argType =~ /^\s*WFlags\s*$/ ) {
					$cplusplusparams .= "(QWidget::WFlags) $arg, ";
				} elsif ( $argType =~ /^\s*ArrowType\s*$/ ) {
					$cplusplusparams .= "(Qt::ArrowType) $arg, ";
				} elsif ( $argType =~ /^\s*Orientation\s*$/ ) {
					$cplusplusparams .= "(Qt::Orientation) $arg, ";
				} elsif ( $argType =~ /^\s*BrushStyle\s*$/ ) {
					$cplusplusparams .= "(Qt::BrushStyle) $arg, ";
				} elsif ( $argType =~ /^\s*BGMode\s*$/ ) {
					$cplusplusparams .= "(Qt::BGMode) $arg, ";
				} elsif ( $argType =~ /^\s*PenCapStyle\s*$/ ) {
					$cplusplusparams .= "(Qt::PenCapStyle) $arg, ";
				} elsif ( $argType =~ /^\s*PenStyle\s*$/ ) {
					$cplusplusparams .= "(Qt::PenStyle) $arg, ";
				} elsif ( $argType =~ /^\s*PenJoinStyle\s*$/ ) {
					$cplusplusparams .= "(Qt::PenJoinStyle) $arg, ";
				} elsif ( $argType =~ /^\s*RasterOp\s*$/ ) {
					$cplusplusparams .= "(Qt::RasterOp) $arg, ";
				} elsif ( $argType =~ /^\s*TextFormat\s*$/ ) {
					$cplusplusparams .= "(Qt::TextFormat) $arg, ";
				} elsif ( $argType =~ /^\s*QDragMode\s*$/ ) {
					$cplusplusparams .= "(QDragObject::DragMode) $arg, ";
				} elsif ( $argType =~ /^\s*GUIStyle\s*$/ ) {
					$cplusplusparams .= "(Qt::GUIStyle) $arg, ";
				} elsif ( $argType =~ /^\s*Type\s*$/ ) {
					$cplusplusparams .= "(QEvent::Type) $arg, ";
				} elsif ( $argType =~ /^([^\*\&]*)&$/ ) {
					$cplusplusparams .= "($argType) * ($1 *) $arg, ";
				} else {
					$cplusplusparams .= "($argType) $arg, ";
				}
			}

		}
		$cplusplusparams =~ s/\s*,\s*$//;
		$javaparams =~ s/\s*,\s*$//;
		$javaargs =~ s/\s*,\s*$//;

		$defaultcplusplusparams =~ s/\s*,\s*$//;
		$defaultjavaparams =~ s/\s*,\s*$//;
		$defaultjavaargs =~ s/\s*,\s*$//;


		if ( $returnType =~ /String/ && $m->{ReturnType} =~ /QString(\s*\*)?/ ) {
			$stringargs = "\n\tQString $1 _qstring;".$stringargs;
		} elsif ( $returnType =~ /String/ && $m->{ReturnType} =~ /QCString(\s*\*)?/ ) {
			$stringargs = "\n\tQCString $1 _qcstring;".$stringargs;
		} elsif ( $returnType =~ /String/ && $m->{ReturnType} =~ /(DOM::)?DOMString(\s*\*)?/ ) {
			$stringargs = "\n\tDOM::DOMString $1 _domstring;".$stringargs;
		} elsif ( $returnType =~ /String/ && $m->{ReturnType} =~ /(const\s*)?char\s*\*\s*/  ) {
			$stringargs = "\n\t".$m->{ReturnType}." _qcstring;".$stringargs;
		} elsif (  $returnType =~ /byte\[\]/ && $m->{ReturnType} =~ /QByteArray(\s*\*)?/ ) {
			$stringargs = "\n\tQByteArray $1 _qbyteArray;".$stringargs;
		}


		if ( $m->{ReturnType} =~ /(QSqlIndex|QSqlRecord|QSqlQuery|QSqlError)\s*$/ ) {
			$stringargs = "\n\t$1  _qsql;".$stringargs;
		}

		if (  $returnType =~ /Calendar/ && $m->{ReturnType} =~ /(QDateTime|QTime|QDate)(\s*\*)?/ ) {
			$stringargs = "\n\t$1 $2 _qdate;".$stringargs;
		}

		if (  $returnType =~ /ArrayList/ && $m->{ReturnType} =~ /(QStrList|QStringList|QCStringList|QWidgetList|QObjectList|QDomNodeList|DOM::NodeList|NodeList|DOM::StyleSheetList|StyleSheetList|DOM::MediaList|MediaList|KFileItemList|KFileViewItemList|KURL::List|OfferList)(\s*\*)?/ ) {
			$stringargs = "\n\t$1 $2 _qlist;".$stringargs;
		}

		my $flags = $m->{Flags};

		if ( !defined $flags ) {
			warn "Method ".$m->{astNodeName}.  " has no flags\n";
		}


		my $extra = "";
		$extra .= "static " if $flags =~ "s";
		if ( $name =~ /operator/ ) {
			return;
		}

		if ( $m->{Access} =~ /protected/ && $name ne $class->{astNodeName}  ) {
			if ( $name =~ /.*Event$/ ) {
				return;
			}
			
			if ( $class->{Pure} ) {
				return;
			}

			$name = "protected_".$name;
		}

		$m->{Access} =~ /([^_]*)(.*)?\s*/;
		$javaaccess = $1;
		if ( $extra =~ /static/ ) {
			$javaaccess .= " static";
		}
		$javaaccess .= " native";

		if ( defined $docnode ) {
			if ( defined $docnode->{Text} ) {
				print CLASS "\n/** ";
				printJavadocComment( $docnode, \*CLASS );
				print CLASS "*/\n";
			}
		}

		if ( $name eq $class->{astNodeName} ) {
			if ( exists $class->{Pure} ) {
				return;
            }
			# Constructor
			print CLASS "\tprivate native void new$name($javaparams);\n";
			print CLASS "\tpublic $name($javaparams) {\n";
			if ($ancestorCount >= 0) {
				print CLASS "\t\tsuper((Class) null);\n";
            }
			print CLASS "\t\tnew$name($javaargs);\n\t}\n";
			$jniFunction =~ s/$name\_$name(__)?/$name\_new$name$1/;
			print JNISOURCE "$jniFunction(JNIEnv *env, jobject obj$jniparams)\n{$stringargs\n",
				"\tif (QtSupport::getQt(env, obj) == 0) {\n\t\tQtSupport::setQt(env, obj, new $name", "JBridge($cplusplusparams));\n",
				"\t\tQtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));\n\t}\n\treturn;\n}\n";

            if ( $defaultcplusplusparams ne "" ) {
				print CLASS "\tprivate native void new$name($defaultjavaparams);\n";
				print CLASS "\tpublic $name($defaultjavaparams) {\n";
				if ($ancestorCount >= 0) {
					print CLASS "\t\tsuper((Class) null);\n";
            	}
				print CLASS "\t\tnew$name($defaultjavaargs);\n\t}\n";
				$defaultjniFunction =~ s/$name\_$name(__)?/$name\_new$name$1/;
				print JNISOURCE "$defaultjniFunction(JNIEnv *env, jobject obj$defaultjniparams)\n{$defaultstringargs\n",
				"\tif (QtSupport::getQt(env, obj) == 0) {\n\t\tQtSupport::setQt(env, obj, new $name", "JBridge($defaultcplusplusparams));\n",
				"\t\tQtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));\n\t}\n\treturn;\n}\n";
 			}
		}
		elsif ( $m->{ReturnType} =~ /~/ ) {
			# Destructor
			print CLASS "\tprotected native void finalize() throws InternalError;\n";
			print JNISOURCE "\nJNIEXPORT void JNICALL\n", $jniPackage,  $class->{astNodeName}, "_finalize(JNIEnv *env, jobject obj)\n{";

			if ( $class->{astNodeName} =~ /^QWidget$/  || defined kdocAstUtil::findOverride( $rootnode, $class, "parentWidget" ) ) {
				print JNISOURCE "\n\tif (QtSupport::allocatedInJavaWorld(env, obj) && ((", $class->{astNodeName}, "*)QtSupport::getQt(env, obj))->parentWidget() == (QWidget *) 0) {\n";
			} else {
				print JNISOURCE "\n\tif (QtSupport::allocatedInJavaWorld(env, obj)) {\n";
			}
			print JNISOURCE "\t\tdelete (", $class->{astNodeName}, "*)QtSupport::getQt(env, obj);\n";
			print JNISOURCE "\t\tQtSupport::setQt(env, obj, 0);\n\t}\n\treturn;\n}\n";

		} else {
			# Class or instance method
			my $selfstring;

			if ( $javaaccess =~ /static/ ) {
 				$selfstring = $class->{astNodeName}.(exists $class->{Pure} || $constructorCount == 0 ? "::" : "JBridge::");
			} else {
 				$selfstring = "((".$class->{astNodeName}.(exists $class->{Pure} || $constructorCount == 0  ? "" : "JBridge")."*) QtSupport::getQt(env, obj))->";
			}

			if ( $javaaccess !~ /static/ && $javaaccess =~ /public/ && $interfacemap{$class->{astNodeName}} ne () ) {
				if ( defined $docnode->{Text} ) {
					print INTERFACE "\n/** ";
					printJavadocComment( $docnode, \*INTERFACE );
					print INTERFACE "*/\n";
				}
				print INTERFACE "\t$returnType ", $m->{astNodeName}, "($javaparams);\n";
			}

			print CLASS "\t$javaaccess $returnType ", $m->{astNodeName}, "($javaparams);\n";
 			print JNISOURCE "$jniFunction(JNIEnv *env, ", ($javaaccess =~ /static/ ? "jclass obj" : "jobject obj"), "$jniparams)\n{$stringargs\n";

			if ( $returnType eq "void" ) {
				print JNISOURCE "\t$selfstring$name\($cplusplusparams\);\n\treturn;\n}\n" ;
				if ( $defaultcplusplusparams ne "" ) {
					if ( $interfacemap{$class->{astNodeName}} ne () && $javaaccess !~ /static/ && $javaaccess =~ /public/ ) {
						print INTERFACE "\t$returnType $name($defaultjavaparams);\n";
					}
					print CLASS "\t$javaaccess void ", $m->{astNodeName}, "($defaultjavaparams);\n";
					print JNISOURCE "$defaultjniFunction(JNIEnv *env, ", ($javaaccess =~ /static/ ? "jclass obj" : "jobject obj"), "$defaultjniparams)\n{$defaultstringargs\n";
					print JNISOURCE "\t$selfstring$name\($defaultcplusplusparams\);\n\treturn;\n}\n" ;
				}
			} elsif ( $returnType =~ /String/ ) {
				if ( $m->{ReturnType} =~ /QString\s*[\*\&]?\s*$/ ) {
					print JNISOURCE "\t_qstring = $selfstring$name\($cplusplusparams\);\n";
					if ( $m->{ReturnType} =~ /\*/ ) {
						print JNISOURCE "\treturn QtSupport::fromQString(env, _qstring);\n}\n";
                    } else {
						print JNISOURCE "\treturn QtSupport::fromQString(env, &_qstring);\n}\n";
					}
				} elsif ( $m->{ReturnType} =~ /QCString\s*[\*\&]?\s*$/ ) {
					print JNISOURCE "\t_qcstring = $selfstring$name($cplusplusparams);\n";
					if ( $m->{ReturnType} =~ /\*/ ) {
						print JNISOURCE "\treturn QtSupport::fromQCString(env, _qcstring);\n}\n";
                    } else {
						print JNISOURCE "\treturn QtSupport::fromQCString(env, &_qcstring);\n}\n";
					}
				} elsif ( $m->{ReturnType} =~ /(DOM::)?DOMString\s*[\*\&]?\s*$/ ) {
					print JNISOURCE "\t_domstring = $selfstring$name\($cplusplusparams\);\n";
					if ( $m->{ReturnType} =~ /\*/ ) {
						print JNISOURCE "\treturn env->NewString((const jchar *)_domstring->unicode(), (long)_domstring->length());\n}\n";
					} else {
						print JNISOURCE "\treturn env->NewString((const jchar *)_domstring.unicode(), (long)_domstring.length());\n}\n";
					}
				} else {
					print JNISOURCE "\t_qcstring = (const char *)$selfstring$name\($cplusplusparams\);\n";
					print JNISOURCE "\treturn QtSupport::fromCharString(env, (char *) _qcstring);\n}\n";
				}
			} elsif ( $returnType =~ /byte\[\]/ ) {
					print JNISOURCE "\t_qbyteArray = $selfstring$name\($cplusplusparams\);\n";
					if ( $m->{ReturnType} =~ /\*/ ) {
						print JNISOURCE "\treturn QtSupport::fromQByteArray(env, _qbyteArray);\n}\n";
                    } else {
						print JNISOURCE "\treturn QtSupport::fromQByteArray(env, &_qbyteArray);\n}\n";
					}
			} elsif ( $returnType =~ /Calendar/ ) {
				if ( $m->{ReturnType} =~ /(QDateTime|QTime|QDate)\s*([\*\&])?\s*$/ ) {
					print JNISOURCE "\t_qdate = $selfstring$name($cplusplusparams);\n";
					if ( $m->{ReturnType} =~ /\*/ ) {
						print JNISOURCE "\treturn (jobject) QtSupport::from$1(env, ($1 *) _qdate);\n}\n";
					} else {
						print JNISOURCE "\treturn (jobject) QtSupport::from$1(env, ($1 *) &_qdate);\n}\n";
					}
				}
			} elsif ( $returnType =~ /ArrayList/ ) {
				if ( $m->{ReturnType} =~ /(QStrList|QStringList|QWidgetList|QDomNodeList|QObjectList)\s*([\*\&])?\s*$/ ) {
					print JNISOURCE "\t_qlist = $selfstring$name($cplusplusparams);\n";
					if ( $2 eq "\*" ) {
						print JNISOURCE "\treturn (jobject) QtSupport::arrayWith$1(env, ($1 *) _qlist);\n}\n";
					} else {
						print JNISOURCE "\treturn (jobject) QtSupport::arrayWith$1(env, ($1 *) &_qlist);\n}\n";
					}
				} elsif ( $m->{ReturnType} =~ /(QCStringList|DOM::NodeList|NodeList|DOM::StyleSheetList|StyleSheetList|DOM::MediaList|MediaList|KFileItemList|KFileViewItemList|OfferList|KURL::List)\s*([\*\&])?\s*$/ ) {
					print JNISOURCE "\t_qlist = $selfstring$name($cplusplusparams);\n";
					if ( $2 eq "\*" ) {
						print JNISOURCE "\treturn (jobject) KDESupport::arrayWith$1(env, ($1 *) _qlist);\n}\n";
					} else {
						print JNISOURCE "\treturn (jobject) KDESupport::arrayWith$1(env, ($1 *) &_qlist);\n}\n";
					}
			   }
			} elsif ( $m->{ReturnType} =~ /(QSqlIndex|QSqlRecord|QSqlQuery|QSqlError)\s*$/ ) {
				print JNISOURCE "\t_qsql = $selfstring$name($cplusplusparams);\n";
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new $1(_qsql), \"org.kde.qt.$1\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QBrush\s*$/ ) {
				print JNISOURCE "\tQBrush _b= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QBrush(_b.color(),_b.style()), \"org.kde.qt.QBrush\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QColorGroup\s*$/ ) {
				print JNISOURCE "\tQColorGroup _c= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QColorGroup(_c.foreground(),_c.background(),_c.light(),_c.dark(),_c.mid(),_c.text(),_c.base()), \"org.kde.qt.QColorGroup\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QDateTime\s*$/ ) {
				print JNISOURCE "\tQDateTime _dt= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QDateTime (_dt.date(),_dt.time()), \"org.kde.qt.QDateTime\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QDate\s*$/ ) {
				print JNISOURCE "\tQDate _d= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QDate(_d.year(),_d.month(),_d.day(), \"org.kde.qt.QDate\", TRUE));\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QPen\s*$/ ) {
				print JNISOURCE "\tQPen _b= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QPen(_b.color(),_b.width(),_b.style()), \"org.kde.qt.QPen\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QPoint\s*\&?\s*$/ ) {
				print JNISOURCE "\tQPoint _p= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QPoint(_p.x(),_p.y()), \"org.kde.qt.QPoint\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QRect\s*$/ ) {
				print JNISOURCE "\tQRect _r= $selfstring$name($cplusplusparams);\n";
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QRect(_r.left(),_r.top(),_r.width(),_r.height()), \"org.kde.qt.QRect\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QSizePolicy\s*$/ ) {
				print JNISOURCE "\tQSizePolicy _s= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QSizePolicy(_s.horData(),_s.verData(),_s.hasHeightForWidth()), \"org.kde.qt.QSizePolicy\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QSize\s*$/ ) {
				print JNISOURCE "\tQSize _s= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QSize(_s.width(),_s.height()), \"org.kde.qt.QSize\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QStyle\s*$/ ) {
				print JNISOURCE "\tQStyle * _s= \&$selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) _s;\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QTime\s*$/ ) {
				print JNISOURCE "\tQTime _t= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QTime(_t.hour(),_t.minute(),_t.second(),_t.msec()), \"java.util.Date\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*(const)?\s*?QWMatrix\s*$/ ) {
				print JNISOURCE "\tQWMatrix _m= $selfstring$name($cplusplusparams);\n" ;
				print JNISOURCE "\treturn (jobject) QtSupport::objectForQtKey(env, (void *)new QWMatrix(_m.m11(),_m.m12(),_m.m21(),_m.m22(),_m.dx(),_m.dy()), \"org.kde.qt.QWMatrix\", TRUE);\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*int\s*\*\s*$/ ) {
				print JNISOURCE "\treturn ($jnireturntype) QtSupport::fromIntPtr(env, $selfstring$name($cplusplusparams));\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*double\s*\*\s*$/ ) {
				print JNISOURCE "\treturn ($jnireturntype) QtSupport::fromDoublePtr(env, $selfstring$name($cplusplusparams));\n}\n" ;
			} elsif ( $m->{ReturnType} =~ /^\s*(inline)?\s*short\s*\*\s*$/ ) {
				print JNISOURCE "\treturn ($jnireturntype) QtSupport::fromShortPtr(env, $selfstring$name($cplusplusparams));\n}\n" ;
			} elsif ( $jnireturntype =~ /jobject/ ) {
				print JNISOURCE "\treturn ($jnireturntype) QtSupport::objectForQtKey(env, (void *)";
				my $fullyQualifiedReturnType = ($returnType =~ /^Q/ ? "org.kde.qt.$returnType" : "org.kde.koala.$returnType");
				if ( $m->{ReturnType} =~ /\&/ ) {
					print JNISOURCE "($returnType *) &$selfstring$name($cplusplusparams), \"$fullyQualifiedReturnType\");\n}\n";
				} elsif ( $m->{ReturnType} =~ /\*/ ) {
					print JNISOURCE "$selfstring$name($cplusplusparams), \"$fullyQualifiedReturnType\");\n}\n";
				} elsif ($m->{ReturnType} =~ /(.*)\s*\&?/) {
					print JNISOURCE "new $1($selfstring$name($cplusplusparams)), \"$fullyQualifiedReturnType\", TRUE);\n}\n";
				}
				if ( $defaultcplusplusparams ne "" ) {
					if ( $interfacemap{$class->{astNodeName}} ne () && $javaaccess !~ /static/ && $javaaccess =~ /public/ ) {
						print INTERFACE "\t$returnType ", $m->{astNodeName}, "($defaultjavaparams);\n";
					}
					print CLASS "\t$javaaccess $returnType ", $m->{astNodeName}, "($defaultjavaparams);\n";

					print JNISOURCE "$defaultjniFunction(JNIEnv *env, ", ($javaaccess =~ /static/ ? "jclass obj" : "jobject obj"), "$defaultjniparams)\n{$defaultstringargs\n";
					print JNISOURCE "\treturn ($jnireturntype) QtSupport::objectForQtKey(env, (void *)";
					if ( $m->{ReturnType} =~ /\*/ ) {
						print JNISOURCE "$selfstring$name($defaultcplusplusparams), \"$fullyQualifiedReturnType\");\n}\n";
					} else {
						print JNISOURCE "new $returnType($selfstring$name($defaultcplusplusparams)), \"$fullyQualifiedReturnType\", TRUE);\n}\n";
					}
				}
			} else {
				print JNISOURCE "\treturn ($jnireturntype) $selfstring$name($cplusplusparams);\n}\n" ;
				if ( $defaultcplusplusparams ne "" ) {
					if ( $interfacemap{$class->{astNodeName}} ne () && $javaaccess !~ /static/ && $javaaccess =~ /public/ ) {
						print INTERFACE "\t$returnType ", $m->{astNodeName}, "($defaultjavaparams);\n";
					}
					print CLASS "\t$javaaccess $returnType ", $m->{astNodeName}, "($defaultjavaparams);\n";
					print JNISOURCE "$defaultjniFunction(JNIEnv *env, ", ($javaaccess =~ /static/ ? "jclass obj" : "jobject obj"), "$defaultjniparams)\n{$defaultstringargs\n";
					print JNISOURCE "\treturn ($jnireturntype) $selfstring$name($defaultcplusplusparams);\n}\n";
				}
			}
		}
	}

}

sub generateClassMethodForEnum
{
	my( $class, $m ) = @_;

	if( $m->{NodeType} eq "enum" ) {
		my $enum = $m->{astNodeName};
		my @enums = split(",", $m->{Params});
		my $enumCount = 0;
		foreach my $enum ( @enums ) {
			$enum =~ s/\s//g;
			$enum =~ s/::/./g;
			if ( $enum =~ /(.*)=(.*)/ ) {
				print CLASS "\tpublic static final int $1 = $2;\n",;
			} else {
				print CLASS "\tpublic static final int $enum = $enumCount;\n";
				$enumCount++;
			}
		}
	}
}


=head2 printJavadocComment

	Parameters: docnode filehandle

	Converts a kdoc comment to javadoc format and prints it.
	@ref's are converted to @link's; @p's and @em's are converted
	to inline HTML.

=cut

sub printJavadocComment
{
	my( $docnode, $handle ) = @_;

	my $node;
	foreach $node ( @{$docnode->{Text}} ) {
		next if $node->{NodeType} ne "DocText";
		my $line = $node->{astNodeName};
		$line =~ s/argc, ?argv/args/g;
		$line =~ s/int argc, ?char ?\* ?argv(\[\])?/String[] args/g;
		$line =~ s/int argc, ?char ?\*\* ?argv/String[] args/g;
		$line =~ s/(const )?QString&?/String/g;
		$line =~ s/QByteArray/byte[]/g;
		$line =~ s/0L/null/g;
		$line =~ s/const char/String/g;
		$line =~ s/bool /boolean /g;
		$line =~ s/SLOT\(([^\)]*)\) ?\)/SLOT("$1)")/g;
		$line =~ s/SIGNAL\(([^\)]*)\) ?\)/SIGNAL("$1)")/g;
		$line =~ s/::/./g;
		$line =~ s/->/./g;
		$line =~ s/\*//g;
		$line =~ s/\@ref\s+([\w]+)\.([\w]+)\s*(\([^\)]*\))(\.)?/{\@link $1#$2}$4/g;
		$line =~ s/\@ref\s+#([\w\.]+)(\(\))?/{\@link #$1}/g;
		$line =~ s/\@ref\s+([\w]+)\s*(\([^\)]*\))/{\@link #$1}/g;
		$line =~ s/\@ref\s+([\w]+)\.([\w]+)/{\@link $1#$2}/g;
		$line =~ s/\@ref\s+([\w]+)/{\@link $1}/g;
		$line =~ s!\@p\s+([\w\._]*)!<code>$1</code>!g;
		$line =~ s!\@em\s+([\w\._]*)!<em>$1</em>!g;
		print $handle $line, "\n";
	}
}


=head2 printIndexEntry

	Parameters: member node

	Prints an index entry for a single node.

	TODO: stub

=cut

sub printIndexEntry
{
	my ( @node ) = @_;
}



sub writeSrcHTML
{
	my ( $outfile, $infile ) = @_;

	open ( OUT, ">$outfile" ) || die "Couldn't open $outfile for".
			"writing.\n";


	close OUT;
}

1;



