/***************************************************************************
                            HTMLTableElement.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The create and delete methods on the table allow authors to
 construct and modify tables. HTML 4.0 specifies that only one of
 each of the <code> CAPTION </code> , <code> THEAD </code> , and
 <code> TFOOT </code> elements may exist in a table. Therefore, if
 one exists, and the createTHead() or createTFoot() method is
 called, the method returns the existing THead or TFoot element. See
 the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TABLE">
 TABLE element definition </a> in HTML 4.0.

 
 @short 
 The create* and delete* methods on the table allow authors to
 construct and modify tables.
*/
public class HTMLTableElement extends HTMLElement  {
	protected HTMLTableElement(Class dummy){super((Class) null);}

	private native void newHTMLTableElement();
	public HTMLTableElement() {
		super((Class) null);
		newHTMLTableElement();
	}
	private native void newHTMLTableElement( HTMLTableElement other);
	public HTMLTableElement( HTMLTableElement other) {
		super((Class) null);
		newHTMLTableElement( other);
	}
	private native void newHTMLTableElement( DOMNode other);
	public HTMLTableElement( DOMNode other) {
		super((Class) null);
		newHTMLTableElement( other);
	}
	protected native void finalize() throws InternalError;

/** 
 Returns the table's <code> CAPTION </code> , or void if none
 exists.

     
*/
	public native HTMLTableCaptionElement caption();

/** 
 see {@link caption}
     
*/
	public native void setCaption( HTMLTableCaptionElement arg1);

/** 
 Returns the table's <code> THEAD </code> , or <code> null
 </code> if none exists.

     
*/
	public native HTMLTableSectionElement tHead();

/** 
 see {@link tHead}
     
*/
	public native void setTHead( HTMLTableSectionElement arg1);

/** 
 Returns the table's <code> TFOOT </code> , or <code> null
 </code> if none exists.

     
*/
	public native HTMLTableSectionElement tFoot();

/** 
 see {@link tFoot}
     
*/
	public native void setTFoot( HTMLTableSectionElement arg1);

/** 
 Returns a collection of all the rows in the table, including
 all in <code> THEAD </code> , <code> TFOOT </code> , all <code>
 TBODY </code> elements.

     
*/
	public native HTMLCollection rows();

/** 
 Returns a collection of the defined table bodies.

     
*/
	public native HTMLCollection tBodies();

/** 
 Specifies the table's position with respect to the rest of the
 document. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TABLE">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
	public native String align();

/** 
 see {@link align}
     
*/
	public native void setAlign( String arg1);

/** 
 Cell background color. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
	public native String bgColor();

/** 
 see {@link bgColor}
     
*/
	public native void setBgColor( String arg1);

/** 
 The width of the border around the table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-border-TABLE">
 border attribute definition </a> in HTML 4.0.

     
*/
	public native String border();

/** 
 see {@link border}
     
*/
	public native void setBorder( String arg1);

/** 
 Specifies the horizontal and vertical space between cell
 content and cell borders. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-cellpadding">
 cellpadding attribute definition </a> in HTML 4.0.

     
*/
	public native String cellPadding();

/** 
 see {@link cellPadding}
     
*/
	public native void setCellPadding( String arg1);

/** 
 Specifies the horizontal and vertical separation between cells.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-cellspacing">
 cellspacing attribute definition </a> in HTML 4.0.

     
*/
	public native String cellSpacing();

/** 
 see {@link cellSpacing}
     
*/
	public native void setCellSpacing( String arg1);

/** 
 Specifies which external table borders to render. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-frame">
 frame attribute definition </a> in HTML 4.0.

     
*/
	public native String frame();

/** 
 see {@link frame}
     
*/
	public native void setFrame( String arg1);

/** 
 Specifies which internal table borders to render. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-rules">
 rules attribute definition </a> in HTML 4.0.

     
*/
	public native String rules();

/** 
 see {@link rules}
     
*/
	public native void setRules( String arg1);

/** 
 Supplementary description about the purpose or structure of a
 table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-summary">
 summary attribute definition </a> in HTML 4.0.

     
*/
	public native String summary();

/** 
 see {@link summary}
     
*/
	public native void setSummary( String arg1);

/** 
 Specifies the desired table width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-width-TABLE">
 width attribute definition </a> in HTML 4.0.

     
*/
	public native String width();

/** 
 see {@link width}
     
*/
	public native void setWidth( String arg1);

/** 
 Create a table header row or return an existing one.

     
*/
	public native HTMLElement createTHead();

/** 
 Delete the header from the table, if one exists.

     
*/
	public native void deleteTHead();

/** 
 Create a table footer row or return an existing one.

     
*/
	public native HTMLElement createTFoot();

/** 
 Delete the footer from the table, if one exists.

     
*/
	public native void deleteTFoot();

/** 
 Create a new table caption object or return an existing one.

     
*/
	public native HTMLElement createCaption();

/** 
 Delete the table caption, if one exists.

     
*/
	public native void deleteCaption();

/** 
 Insert a new empty row in the table. Note. A table row cannot
 be empty according to HTML 4.0 Recommendation.

     
*/
	public native HTMLElement insertRow( long index);

/** 
 Delete a table row.

     
*/
	public native void deleteRow( long index);
//	private native void newHTMLTableElement( HTMLTableElementImpl impl);
//	public HTMLTableElement( HTMLTableElementImpl impl) {
//		super((Class) null);
//		newHTMLTableElement( impl);
//	}
}
