/***************************************************************************
                            Job.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The base class for all jobs.
 For all jobs created in an application, the code looks like

 <pre>
   KIO.Job  job = KIO.someoperation( some parameters );
   connect( job, SIGNAL(" result( KIO.Job  )"),
            this, SLOT(" slotResult( KIO.Job  )") );
 </pre>
   (other connects, specific to the job)

 And slotResult is usually at least:

 <pre>
  if ( job.error() )
      job.showErrorDialog( this or null  );
 </pre>

     
 @short 
 The base class for all jobs.
*/
public class Job extends QObject  {
	protected Job(Class dummy){super((Class) null);}

	protected native void finalize() throws InternalError;

/** 
 Abort this job.
 This kills all subjobs and deletes the job.

*/
	public native void kill( boolean quietly);
	public native void kill();

/** 

*/
	public native int error();

/** 

*/
	public native int progressId();

/** 

*/
	public native String errorText();

/** 
 Converts an error code and a non-i18n error message into an
 error message in the current language. The low level (non-i18n)
 error message (usually a url) is put into the translated error
 message using %1.
 Example for errid == ERR_CANNOT_OPEN_FOR_READING:
   i18n( "Could not read\n%1" ).arg( errortext );
 Use this to display the error yourself, but for a dialog box
 use {@link KIO#ErrorDialog}.
         
*/
	public native String errorString();

/** 
 Display a dialog box to inform the user of the error given by
 this job.
 Only call if {@link error} is not 0, and only in the slot connected
 to {@link result}.

*/
	public native void showErrorDialog( QWidget parent);
	public native void showErrorDialog();

/** 
 Associate this job with a window given by <code>window.</code>
         
*/
	public native void setWindow( QWidget window);

/** 
 Returns the window this job is associated with.
         
*/
	public native QWidget window();
	private native void newJob( boolean showProgressInfo);
	public Job( boolean showProgressInfo) {
		super((Class) null);
		newJob( showProgressInfo);
	}

/** 
 Add a job that has to be finished before a result
 is emitted. This has obviously to be called before
 the finish signal is emitted by the slave.
         
*/
	protected native void addSubjob( int job);

/** 
 Mark a sub job as being done. If it's the last to
 wait on the job will emit a result - jobs with
 two steps might want to override slotResult
 in order to avoid calling this method.
         
*/
	protected native void removeSubjob( int job);

/** 
 Utility function for inherited jobs.
 Emits the percent signal if bigger than m_percent,
 after calculating it from the parameters.
         
*/
	protected native void emitPercent( long processedSize, long totalSize);

/** 
 Utility function for inherited jobs.
 Emits the speed signal and starts the timer for removing that info
         
*/
	protected native void emitSpeed( long bytes_per_second);

/** 
 Utility function to emit the result signal, and suicide this job.
 It first tells the observer to hide the progress dialog for this job.
         
*/
	protected native void emitResult();

/** 
 Called whenever a subjob finishes.
 Default implementation checks for errors and propagates
 to parent job, then calls {@link removeSubjob}.
 Override if you don't want subjobs errors to be propagated.
         
*/
	protected native void slotResult( Job job);

/** 
 Forward signal from subjob.
         
*/
	protected native void slotSpeed( Job arg1, long bytes_per_second);

/** 
 Forward signal from subjob.
         
*/
	protected native void slotInfoMessage( Job arg1, String arg2);

/** 
 Remove speed information.
         
*/
	protected native void slotSpeedTimeout();
}

/** Override these methods in subclasses of Job to customise event handling behaviour */
interface JobEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

