/***************************************************************************
                            KAccelMenu.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Simplify the use of {@link KAccel} and {@link KKeyDialog} with menus.

 It also provides for the changing of menu item shortcuts by
 typing the key when the menu item is selected. 

 The exact method of setting shortcuts is the subject of some debate,
 currently the ' key will put up a message indicating the next key
 hit will change the shortcut.
 The Delete key removes the accelerator associated with the menu item.

 Previously: The quote key was required only for keys that
 are used for menu accelerators.

 filemenu = new KAccelMenu(keys);
 filemenu.insItem(i18n("&Open"), "&Open", kp ,SLOT("fileOpen()"),
                   KStdAccel.Open);
 filemenu.insItem(i18n("Open &URL"), "Open &URL", kp, SLOT("fileOpenUrl()"),
                   "CTRL+X");

 keys.readSettings();
 </pre>

 Calling the KKeyDialog:
 <pre>
 KKeyDialog.configureKeys( keys ); 
 </pre>

 On exit you need:
 <pre>
 keys.writeSettings();
 </pre>

 @short 
 Simplify the use of @ref KAccel and @ref KKeyDialog with menus.
*/
public class KAccelMenu extends KPopupMenu  {
	protected KAccelMenu(Class dummy){super((Class) null);}


/** 
   KAccelMenu constructor.

*/
	private native void newKAccelMenu( KAccel k, QWidget parent, String name);
	public KAccelMenu( KAccel k, QWidget parent, String name) {
		super((Class) null);
		newKAccelMenu( k, parent, name);
	}
	private native void newKAccelMenu( KAccel k);
	public KAccelMenu( KAccel k) {
		super((Class) null);
		newKAccelMenu( k);
	}

/** 
 Destructor.

*/
	protected native void finalize() throws InternalError;

/** 
  Insert a menu item with accelerator.

*/
	public native int insItem( QPixmap pixmap, String text, String action, QObject receiver, String member, String accel);
	public native int insItem( QPixmap pixmap, String text, String action, QObject receiver, String member);

/** 
  Insert a menu item with accelerator.

*/
	public native int insItem( String text, String action, QObject receiver, String member, String accel);
	public native int insItem( String text, String action, QObject receiver, String member);

/** 
   Insert a menu item with a standard accelerator

*/
	public native int insItem( QPixmap pixmap, String text, String action, QObject receiver, String member, int accel);

/** 
   Insert a menu item with a standard accelerator

*/
	public native int insItem( String text, String action, QObject receiver, String member, int accel);
	protected native String stripAnd( String str);
	protected native void popMsg();
	protected native void highl( int arg1);
	protected native void aboutTS();
}

/** Override these methods in subclasses of KAccelMenu to customise event handling behaviour */
interface KAccelMenuEventHandling {
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void dropEvent(QDropEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void showEvent(QShowEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

