/***************************************************************************
                            KConfigBackEnd.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Abstract base class for KDE configuration file loading/saving.

 This class forms the base for all classes that implement some
 manner of loading/saving to configuration files.  It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. As of right now, the only back end available
 is one to read/write to INI-style files, but in the future, other
 formats may be available, such as XML or a database.

 @author Preston Brown <pbrown@kde.org>, 
         Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KConfigBackEnd.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short KDE Configuration file loading/saving abstract base class.
*/
public class  KConfigBackEnd implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KConfigBackEnd(Class dummy){}


/** 
 Construct a configuration back end.

*/

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;

/**  
 Parse all configuration files for a configuration object.  This
 method must be reimplemented by the derived classes.

*/
	public native boolean parseConfigFiles();

/** 
 Write configuration data to file(s).  This method must be
 reimplemented by the derived classes.

*/
	public native void sync( boolean bMerge);
	public native void sync();

/** 
 change the filenames associated with this back end.  You should
 probably reparse your config info after doing this.

*/
	public native void changeFileName( String _fileName, String _resType, boolean _useKDEGlobals);

/** 
 Retrieve the state of the app-config object.

*/
	public native int getConfigState();

/** 

*/
	public native String filename();

/** 

*/
	public native String resource();
	public native void setLocaleString( String _localeString);
}
