/***************************************************************************
                            KDirectionButton.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDirectionButton was a helper class for KTabBar and KWizard which
 existed in the stone ages of KDE. The replacement QTabBar uses
 QToolButton for the direction buttons which have a look and feel
 that adjusts to the widget style in use.
 It
 provides the buttons used to scroll the tab bar and to change pages
 in KWizard.

 @author Thomas Tanghus <tanghus@earthling.net>

 @version 0.1

 @short Direction buttons.

*/
public class KDirectionButton extends QButton  {
	protected KDirectionButton(Class dummy){super((Class) null);}

	private native void newKDirectionButton( QWidget parent, String name);
	public KDirectionButton( QWidget parent, String name) {
		super((Class) null);
		newKDirectionButton( parent, name);
	}
	private native void newKDirectionButton();
	public KDirectionButton() {
		super((Class) null);
		newKDirectionButton();
	}
	private native void newKDirectionButton( int d, QWidget parent, String name);
	public KDirectionButton( int d, QWidget parent, String name) {
		super((Class) null);
		newKDirectionButton( d, parent, name);
	}
	private native void newKDirectionButton( int d);
	public KDirectionButton( int d) {
		super((Class) null);
		newKDirectionButton( d);
	}
	protected native void finalize() throws InternalError;
	public native void setDirection( int d);
	public native int direction();
	protected native void drawButton( QPainter arg1);
}

/** Override these methods in subclasses of KDirectionButton to customise event handling behaviour */
interface KDirectionButtonEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

