/***************************************************************************
                            KFileIconView.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class KFileIconView extends KIconView implements  KFileViewInterface {
	protected KFileIconView(Class dummy){super((Class) null);}

	private native void newKFileIconView( QWidget parent, String name);
	public KFileIconView( QWidget parent, String name) {
		super((Class) null);
		newKFileIconView( parent, name);
	}
	protected native void finalize() throws InternalError;
	public native QWidget widget();
	public native void clearView();
	public native void setAutoUpdate( boolean arg1);
	public native void updateView( boolean arg1);
	public native void updateView( KFileViewItem arg1);
	public native void removeItem( KFileViewItem arg1);
	public native void insertItem( KFileViewItem i);
	public native void setSelectionMode( int sm);
	public native void setSelected( KFileViewItem arg1, boolean arg2);
	public native boolean isSelected( KFileViewItem i);
	public native void clearSelection();
	public native void setIconSize( int size);
	public native int iconSize();
	public native void ensureItemVisible( KFileViewItem arg1);

/**
 inserts a list of items.

*/
	public native void addItemList( ArrayList list);

/**
 Inserts a list of items. Use this method <b>only</b> if you are sure
 that the list really contains KFileViewItems or items  subclassing
 KFileViewItem. You can use KDirLister to create a KFileItemList with
 any item, subclassing KFileItem. E.g. KFileReader creates KFileViewItems

*/
//	public native void addItemList( ArrayList list);


/**
 set the current item in the view.

 the normal use of this function is to use the parameter filename to
 set the highlight on this file.

 the extend use of this function is to set filename to 0. In this
 case the {@link KFileViewItem} is used to find out the position of the
 file. Since this is faster, this way is used in case a view has
 other child views.

*/
	public native void setCurrentItem( String filename, KFileViewItem entry);
	public native void setCurrentItem( String filename);

/**
 clears the view and all item lists

*/
	public native void clear();

/**
 does a repaint of the view.

 The default implementation calls
 <pre>widget().repaint(f)</pre>

*/
	public native void updateView();



/**
 specifies the sorting of the internal list. Newly added files
 are added through this sorting.

*/
	public native boolean sorting();

/**
 set the sorting of the view

 Default is QDir.Name | QDir.IgnoreCase | QDir.DirsFirst
 Don't use QDir.Reversed, use {@link #sortReversed} if you want to
 reverse the sort order.
 Calling this method keeps the reversed-setting
 If your view wants to get notified about sorting-changes (e.g. to show
 a sorting indicator), override this method and call this implementation
 in the beginning of your method.

*/
	public native void setSorting( int sort);

/**
 set the sorting mode. Default mode is Increasing. Affects only
 newly added items.

*/
	public native void setSortMode( int mode);

/**

*/
	public native int sortMode();

/**
 Toggles the current sort order, i.e. the order is reversed.

*/
	public native void sortReversed();

/**
 Tells whether the current items are in reversed order (= contrary to
 {@link sortMode}).

*/
	public native boolean isReversed();

/**

*/
	public native int count();

/**

*/
	public native int numFiles();

/**

*/
	public native int numDirs();
	public native int selectionMode();
	public native void setViewMode( int vm);
	public native int viewMode();

/**

*/
	public native String viewName();

/**
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".

*/
	public native void setViewName( String name);
	public native void setOperator( QObject ops);




/**
 Selects all items. You may want to override this, if you can implement
 it more efficiently than calling setSelected() with every item.
 This works only in Multiselection mode of course.

*/
	public native void selectAll();

/**
 Inverts the current selection, i.e. selects all items, that were up to
 now not selected and deselects the other.

*/
	public native void invertSelection();



/**

*/
	public native ArrayList selectedItems();

/**

*/
	public native ArrayList items();

/**
 Inserts "counter" KFileViewItems and sorts them conforming to the
 current sort-order.
 If you override this method, you have to call {@link #setFirstItem}
 afterwards, to set the first item of your newly sorted items.

*/
	public native void insertSorted( KFileViewItem tfirst, int counter);

/**

*/
	public native QIconViewItem firstItem();

/**
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.

*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/**

*/
	public native boolean onlyDoubleClickSelectsFiles();

/**
 increases the number of dirs and files.

*/
	public native boolean updateNumbers( KFileViewItem i);
	
	public native KActionCollection actionCollection();
}

/** Override these methods in subclasses of KFileIconView to customise event handling behaviour */
interface KFileIconViewEventHandling {

/** 
 Reimplemented to not let QIconView eat return-key events
     
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent fe);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);
	void leaveEvent(QEvent e);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent e);
	void contentsDropEvent(QDropEvent e);
	void focusInEvent(QFocusEvent e);
	void contentsDragLeaveEvent(QDragLeaveEvent e);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);
	void contentsMouseDoubleClickEvent(QMouseEvent e);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void viewportMouseMoveEvent(QMouseEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void contentsDragMoveEvent(QDragMoveEvent e);
	void moveEvent(QMoveEvent arg1);
	void contentsMouseReleaseEvent(QMouseEvent e);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Reimplemented to remove an eventual tooltip
     
*/
	void hideEvent(QHideEvent arg1);
	void contentsDragEnterEvent(QDragEnterEvent e);
	void contentsMouseMoveEvent(QMouseEvent e);
	void contentsMousePressEvent(QMouseEvent e);
	void closeEvent(QCloseEvent arg1);
	void viewportPaintEvent(QPaintEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void viewportResizeEvent(QResizeEvent arg1);
	void resizeEvent(QResizeEvent e);
}

