/***************************************************************************
                            KFileViewInterface.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import java.util.*;
import org.kde.qt.*;

public interface KFileViewInterface {

/** 
 inserts a list of items.

*/
	void addItemList( ArrayList list);

/** 
 Inserts a list of items. Use this method <b>only</b> if you are sure
 that the list really contains KFileViewItems or items  subclassing
 KFileViewItem. You can use KDirLister to create a KFileItemList with
 any item, subclassing KFileItem. E.g. KFileReader creates KFileViewItems

*/
//	void addItemList( ArrayList list);

/** 
 a pure virtual function to get a QWidget, that can be added to
 other widgets. This function is needed to make it possible for
 derived classes to derive from other widgets.

*/
	QWidget widget();

/** 
 As const-method, to be fixed in 3.0
     
*/
//	QWidget widget();

/** 
 set the current item in the view.

 the normal use of this function is to use the parameter filename to
 set the highlight on this file.

 the extend use of this function is to set filename to 0. In this
 case the {@link KFileViewItem} is used to find out the position of the
 file. Since this is faster, this way is used in case a view has
 other child views.

*/
	void setCurrentItem( String filename, KFileViewItem entry);
	void setCurrentItem( String filename);

/** 
 clears the view and all item lists
      
*/
	void clear();

/** 
 does a repaint of the view.

 The default implementation calls
 <pre>widget().repaint(f)</pre>

*/
	void updateView( boolean f);
	void updateView();
	void updateView( KFileViewItem arg1);

/** 
 Remove an item from the list; has to be implemented by the view.
 Call KFileView.removeItem( item ) after removing it.
     
*/
	void removeItem( KFileViewItem item);

/** 
 specifies the sorting of the internal list. Newly added files
 are added through this sorting.
      
*/
	boolean sorting();

/** 
 set the sorting of the view

 Default is QDir.Name | QDir.IgnoreCase | QDir.DirsFirst
 Don't use QDir.Reversed, use {@link #sortReversed} if you want to
 reverse the sort order.
 Calling this method keeps the reversed-setting
 If your view wants to get notified about sorting-changes (e.g. to show
 a sorting indicator), override this method and call this implementation
 in the beginning of your method.

*/
	void setSorting( int sort);

/** 
 set the sorting mode. Default mode is Increasing. Affects only
 newly added items.

*/
	void setSortMode( int mode);

/** 

*/
	int sortMode();

/** 
 Toggles the current sort order, i.e. the order is reversed.

*/
	void sortReversed();

/** 
 Tells whether the current items are in reversed order (= contrary to
 {@link sortMode}).
     
*/
	boolean isReversed();

/** 

*/
	int count();

/** 

*/
	int numFiles();

/** 

*/
	int numDirs();
	void setSelectionMode( int sm);
	int selectionMode();
	void setViewMode( int vm);
	int viewMode();

/** 

*/
	String viewName();

/** 
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".
     
*/
	void setViewName( String name);
	void setOperator( QObject ops);

/** 
 The derived view must implement this function to add
 the file in the widget.

*/
	void insertItem( KFileViewItem i);

/** 
 pure virtual function, that should be implemented to clear
 the view. At this moment the list is already empty

*/
	void clearView();

/** 
 pure virtual function, that should be implemented to make item i
 visible, i.e. by scrolling the view appropriately.
     
*/
	void ensureItemVisible( KFileViewItem i);

/** 
 Clear any selection, unhighlight everything. Must be implemented by the
 view.
     
*/
	void clearSelection();

/** 
 Selects all items. You may want to override this, if you can implement
 it more efficiently than calling setSelected() with every item.
 This works only in Multiselection mode of course.
     
*/
	void selectAll();

/** 
 Inverts the current selection, i.e. selects all items, that were up to
 now not selected and deselects the other.
     
*/
	void invertSelection();

/** 
 Tells the view that it should highlight the item.
 This function must be implemented by the view

*/
	void setSelected( KFileViewItem arg1, boolean enable);

/** 

*/
	boolean isSelected( KFileViewItem arg1);

/** 

*/
	ArrayList selectedItems();

/** 

*/
	ArrayList items();

/** 
 Inserts "counter" KFileViewItems and sorts them conforming to the
 current sort-order.
 If you override this method, you have to call {@link #setFirstItem}
 afterwards, to set the first item of your newly sorted items.
     
*/
	void insertSorted( KFileViewItem tfirst, int counter);

/** 

*/
	QIconViewItem firstItem();
//	KFileViewItem firstItem();

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.
     
*/
	void setOnlyDoubleClickSelectsFiles( boolean enable);

/** 

*/
	boolean onlyDoubleClickSelectsFiles();

/** 
 increases the number of dirs and files.

*/
	boolean updateNumbers( KFileViewItem i);

/** 

*/
	KActionCollection actionCollection();
}
