/***************************************************************************
                            KFilterDev.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A class for reading and writing compressed data onto a device
 (e.g. file, but other usages are possible, like a buffer or a socket)

 To simply read/write compressed files, @see deviceForFile.

 @author David Faure <faure@kde.org>
 
 @short 
 A class for reading and writing compressed data onto a device
 (e.
*/
public class KFilterDev extends QIODevice  {
	protected KFilterDev(Class dummy){super((Class) null);}


/** 
 Create a KFilterDev for a given filter (e.g. gzip, bzip2 etc.)
     
*/
	private native void newKFilterDev( KFilterBase filter);
	public KFilterDev( KFilterBase filter) {
		super((Class) null);
		newKFilterDev( filter);
	}

/** 
 Create a KFilterDev for a given filter (e.g. gzip, bzip2 etc.)
 Call this with autodeleteFilterBase so that the KFilterDev owns the KFilterBase.
     
*/
	private native void newKFilterDev( KFilterBase filter, boolean autodeleteFilterBase);
	public KFilterDev( KFilterBase filter, boolean autodeleteFilterBase) {
		super((Class) null);
		newKFilterDev( filter, autodeleteFilterBase);
	}
	protected native void finalize() throws InternalError;
	public native boolean open( int mode);
	public native void close();
	public native void flush();

/** 
 For writing gzip compressed files only:
 set the name of the original file, to be used in the gzip header.
     
*/
	public native void setOrigFileName( String fileName);
	public native int size();
	public native int at();

/** 
 That one can be quite slow, when going back. Use with care.
     
*/
	public native boolean at( int arg1);
	public native boolean atEnd();
	public native int readBlock( String data, int maxlen);
	public native int writeBlock( String data, int len);
	public native int getch();
	public native int putch( int arg1);
	public native int ungetch( int arg1);

/** 
 Call this to create the appropriate filter device for <code>base</code>
 working on <code>file</code> . The returned QIODevice has to be deleted
 after using.

     
*/
	public static native QIODeviceInterface createFilterDevice( KFilterBase base, QFile file);

/** 
 Return an i/o device that is able to read from <code>fileName</code>,
 whether it's compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined from the <code>fileName</code>
 if <code>mimetype</code> is empty. Pass "application/x-gzip" or "application/x-bzip2"
 to force the corresponding decompression filter, if available.

 Warning: application/x-bzip2 may not be available.
 In that case a QFile opened on the compressed data will be returned !
 Use KFilterBase.findFilterByMimeType and code similar to what
 deviceForFile is doing, to better control what's happening.

 The returned QIODevice has to be deleted after using.
     
*/
	public static native QIODeviceInterface deviceForFile( String fileName, String mimetype, boolean forceFilter);
	public static native QIODeviceInterface deviceForFile( String fileName);
}
