/***************************************************************************
                            KGlobalAccel.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KGlobalAccel class handles global keyboard accelerators, allowing a
 user to configure key bindings through application configuration files or
 through the KKeyChooser GUI.

 A KGlobalAccel contains a list of accelerator items. Each accelerator item
 consists of an action name and a keyboard code combined with modifiers
 (SHIFT, CTRL and ALT.)

 For example, "CTRL+SHIFT+M" could be a shortcut for popping-up a menu of
 monitor setting choices anywhere on the desktop. The key codes are listed
 in kckey.cpp. "Monitor settings" could be the action name for this
 accelerator. The action name indentifies the key binding in configuration
 files and the KKeyChooser GUI.

 When pressed,an accelerator key calls the slot to which it has been
 connected. Accelerator items can be connected so that a key will activate
 two different slots.

 Key binding configuration during run time can be prevented by specifying
 that an accelerator item is not configurable when it is inserted.

 It is possible for a user to choose to have no key associated with an action.

 The translated first argument for insertItem is only used in the
 configuration dialog.

 ...

 ga = new KGlobalAccel();
 ga.insertItem( i18n("Monitor settings"), "Monitor settings", "CTRL+SHIFT+M" );
 ga.connectItem( "Monitor settings", myObject, SLOT(" popupMenu()") );

 ga.readSettings();

 @short 
 The KGlobalAccel class handles global keyboard accelerators, allowing a
 user to configure key bindings through application configuration files or
 through the KKeyChooser GUI.
*/
public class KGlobalAccel extends QObject  {
	protected KGlobalAccel(Class dummy){super((Class) null);}


/** 
 Creates a KGlobalAccel object.
	 
*/
	private native void newKGlobalAccel( boolean _do_not_grab);
	public KGlobalAccel( boolean _do_not_grab) {
		super((Class) null);
		newKGlobalAccel( _do_not_grab);
	}
	private native void newKGlobalAccel();
	public KGlobalAccel() {
		super((Class) null);
		newKGlobalAccel();
	}

/** 
	   Creates a KGlobalAccel object with a parent and a name. The
	   parent has the only effect that the KGlobalAccel object
	   will be automatically destroyed in the parent's destructor,
	   thus releaseing the keys.
	
*/
	private native void newKGlobalAccel( QWidget parent, String name, boolean _do_not_grab);
	public KGlobalAccel( QWidget parent, String name, boolean _do_not_grab) {
		super((Class) null);
		newKGlobalAccel( parent, name, _do_not_grab);
	}
	private native void newKGlobalAccel( QWidget parent);
	public KGlobalAccel( QWidget parent) {
		super((Class) null);
		newKGlobalAccel( parent);
	}

/** 
 Destroys the accelerator object.and ungrabs any allocated key bindings.
	 
*/
	protected native void finalize() throws InternalError;

/** 
 Removes all accelerator items.
	 
*/
	public native void clear();

/** 
 Connect an accelerator item to a slot/signal in another object.

 Arguments:

*/
	public native void connectItem( String action, QObject receiver, String member, boolean activate);
	public native void connectItem( String action, QObject receiver, String member);

/** 
 Returns the number of accelerator items.
	
*/
	public native int count();

/** 
 Returns the key code of the accelerator item with the action name
 action, or zero if either the action name cannot be found or the current
 key is set to no key.
	
*/
	public native int currentKey( String action);

/** 
 Returns the default key code of the accelerator item with the action name
 action, or zero if the action name cannot be found.
	
*/
	public native int defaultKey( String action);

/** 
 Disconnects an accelerator item from a function in another object.
	 
*/
	public native void disconnectItem( String action, QObject receiver, String member);

/** 
 Returns that identifier of the accelerator item with the keycode key,
 or zero if the item cannot be found.
	 
*/
	public native String findKey( int key);

/** 
 Attempts to make a passive X server grab of the key specified by key symbol
 keysym and modifier mod. Returns false if unsuccessful.

 Modifications with num lock and caps lock are also grabbed.

	 
*/
	public native boolean grabKey( int keysym, int mod);

/** 
 Inserts an accelerator item and returns false if the key code
 	defaultKeyCode is not valid.

 Arguments:

 If an action already exists the old association and connections will be
 removed..

	 
*/
	public native boolean insertItem( String descr, String action, int defaultKeyCode, boolean configurable);
	public native boolean insertItem( String descr, String action, int defaultKeyCode);

/** 
 Inserts an accelerator item and returns false if the key code
 	defaultKeyCode is not valid.

 Arguments:

 If an action already exists the old association and connections
 will be removed..

	 
*/
	public native boolean insertItem( String descr, String action, String defaultKeyCode, boolean configurable);
	public native boolean insertItem( String descr, String action, String defaultKeyCode);
	public native boolean isEnabled();
	public native boolean isItemEnabled( String action);

/** 
 Returns the dictionary of accelerator action names and KKeyEntry
 objects. Note that only a shallow copy is returned so that
 items will be lost when the KKeyEntry objects are deleted.
	
*/
//	public native KKeyEntryMap keyDict();

/** 
 Reads all key associations from the application's configuration
 files.
	 
*/
	public native void readSettings();

/** 
 Removes the accelerator item with the action name action.
	 
*/
	public native void removeItem( String action);
	public native void setConfigGroup( String group);
	public native String configGroup();

/** 
 Enables the accelerator if activate is true, or disables it if
 activate is false...

 Individual keys can also be enabled or disabled.
	 
*/
	public native void setEnabled( boolean activate);

/** 
 Enables or disables an accelerator item.

 Arguments:

*/
	public native void setItemEnabled( String action, boolean activate);

/** 
 Sets the dictionary of accelerator action names and KKeyEntry
 objects to nKeyMap. Note that only a shallow copy is made so that items will be
 lost when the KKeyEntry objects are deleted.
	
*/
//	public native boolean setKeyDict( KKeyEntryMap nKeyMap);

/** 
 Ungrabs the key specified by key symbol
 keysym and modifier mod. Returns false if unsuccessful.

 Modifications with num lock and caps lock are also ungrabbed.

	 
*/
	public native boolean ungrabKey( int keysym, int mod);

/** 
 Writes the current configurable associations to the application's
 configuration files
	 
*/
	public native void writeSettings();

/** 
 Filters X11 events ev for key bindings in the accelerator dictionary.
 If a match is found the activated activated is emitted and the function
 returns true. Return false if the event is not processed.

 This is public for compatibility only. You do not need to call it.
	 
*/
//	public native boolean x11EventFilter( XEvent* arg1);
}

/** Override these methods in subclasses of KGlobalAccel to customise event handling behaviour */
interface KGlobalAccelEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

