/***************************************************************************
                            KHistoryCombo.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A combobox which implements a history like a unix shell. You can navigate
 through all the items by using the Up or Down arrows (configurable of
 course). Additionally, weighted completion is available. So you should
 load and save the completion list to preserve the weighting between
 sessions.

 @author Carsten Pfeiffer <pfeiffer@kde.org>

 @short A combobox for offering a history and completion.
*/
public class KHistoryCombo extends KComboBox  {
	protected KHistoryCombo(Class dummy){super((Class) null);}


/** 
 Constructs a "read-write" combobox. A read-only history combobox
 doesn't make much sense, so it is only available as read-write.
 Completion will be used automatically for the items in the combo.

 The insertion-policy is set to NoInsertion, you have to add the items
 yourself via the slot {@link addToHistory}. If you want every item added,
 use

 <pre>
 connect( combo, SIGNAL(" activated( String )"),
          combo, SLOT(" addToHistory( String )"));
 </pre>

 Use {@link QComboBox#setMaxCount} to limit the history.

 <code>parent</code> the parent object of this widget.
 <code>name</code> the name of this widget.
     
*/
	private native void newKHistoryCombo( QWidget parent, String name);
	public KHistoryCombo( QWidget parent, String name) {
		super((Class) null);
		newKHistoryCombo( parent, name);
	}
	private native void newKHistoryCombo();
	public KHistoryCombo() {
		super((Class) null);
		newKHistoryCombo();
	}

/** 
 Same as the previous constructor, but additionally has the option
 to specify whether you want to let KHistoryCombo handle completion
 or not. If set to <code>true</code>, KHistoryCombo will sync the completion to the
 contents of the combobox.
     
*/
	private native void newKHistoryCombo( boolean useCompletion, QWidget parent, String name);
	public KHistoryCombo( boolean useCompletion, QWidget parent, String name) {
		super((Class) null);
		newKHistoryCombo( useCompletion, parent, name);
	}
	private native void newKHistoryCombo( boolean useCompletion);
	public KHistoryCombo( boolean useCompletion) {
		super((Class) null);
		newKHistoryCombo( useCompletion);
	}

/** 
 Destructs the combo, the completion-object and the pixmap-provider
     
*/
	protected native void finalize() throws InternalError;

/** 
 Inserts <code>items</code> into the combobox. <code>items</code> might get
 truncated if it is longer than {@link #maxCount}

*/
	public native void setHistoryItems( String[] items);

/** 
 Inserts <code>items</code> into the combobox. <code>items</code> might get
 truncated if it is longer than {@link #maxCount}

 Set <code>setCompletionList</code> to true, if you don't have a list of
 completions. This tells KHistoryCombo to use all the items for the
 completion object as well.
 You won't have the benefit of weighted completion though, so normally
 you should do something like
 <pre>
 KConfig config = kapp.config();
 StringList list;

 // load the history and completion list after creating the history combo
 list = config.readListEntry( "Completion list" );
 combo.completionObject().setItems( list );
 list = config.readListEntry( "History list" );
 combo.setHistoryItems( list );

 [...]

 // save the history and completion list when the history combo is
 // destroyed
 list = combo.completionObject().items()
 config.writeEntry( "Completion list", list );
 list = combo.historyItems();
 config.writeEntry( "History list", list );
 </pre>

 Be sure to use different names for saving with KConfig if you have more
 than one KHistoryCombo.

 Note: When <code>setCompletionList</code> is true, the items are inserted into the
 KCompletion object with mode KCompletion.Insertion and the mode is set
 to KCompletion.Weighted afterwards.

*/
	public native void setHistoryItems( String[] items, boolean setCompletionList);

/** 
 Returns the list of history items. Empty, when this is not a read-write
 combobox.

*/
	public native ArrayList historyItems();

/** 
 Remove all items named <code>item.</code>

*/
	public native boolean removeFromHistory( String item);

/** 
 Sets a pixmap provider, so that items in the combobox can have a pixmap.
 {@link KPixmapProvider} is just an abstract class with the one pure virtual
 method {@link KPixmapProvider#pixmapFor}. This method is called whenever
 an item is added to the KHistoryComboBox. Implement it to return your
 own custom pixmaps, or use the {@link KURLPixmapProvider} from libkio,
 which uses {@link KMimeType#pixmapForURL} to resolve icons.

 Set <code>prov</code> to null if you want to disable pixmaps. Default no pixmaps.

*/
	public native void setPixmapProvider( KPixmapProvider prov);

/** 

*/
	public native KPixmapProvider pixmapProvider();

/** 
 Resets the current position of the up/down history. Call this
 when you manually call {@link #setCurrentItem} or {@link #clearEdit}.
     
*/
	public native void reset();

/** 
 Adds an item to the end of the history list and to the completion list.
 If {@link #maxCount} is reached, the first item of the list will be
 removed.

 If the last inserted item is the same as <code>item</code>, it will not be
 inserted again.

 If {@link #duplicatesEnabled} is false, any equal existing item will be
 removed before <code>item</code> is added.

 Note: By using this method and not the Q and KComboBox insertItem()
 methods, you make sure that the combobox stays in sync with the
 completion. It would be annoying if completion would give an item
 not in the combobox, and vice versa.

*/
	public native void addToHistory( String item);

/** 
 Clears the history and the completion list.
     
*/
	public native void clearHistory();

/** 
 Inserts <code>items</code> into the combo, honouring {@link #pixmapProvider}
 Does not update the completionObject.

 Note: {@link #duplicatesEnabled} is not honored here.

 Called from {@link #setHistoryItems} and {@link #setPixmapProvider}
     
*/
	protected native void insertItems( String[] items);

/** 

*/
	protected native boolean useCompletion();
}

/** Override these methods in subclasses of KHistoryCombo to customise event handling behaviour */
interface KHistoryComboEventHandling {

/** 
 Handling key-events, the shortcuts to rotate the items.
     
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent e);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

