/***************************************************************************
                            KLineEditDlg.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog for user to enter a single line of text.

 @author David Faure <faure@kde.org>, layout management by Preston Brown <pbrown@kde.org>
 
 @version $Id: KLineEditDlg.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short 
 Dialog for user to enter a single line of text.
*/
public class KLineEditDlg extends KDialogBase  {
	protected KLineEditDlg(Class dummy){super((Class) null);}


/** 
 Create a dialog that asks for a single line of text. _value is the initial
 value of the line. _text appears as label on top of the entry box.

*/
	private native void newKLineEditDlg( String _text, String _value, QWidget parent);
	public KLineEditDlg( String _text, String _value, QWidget parent) {
		super((Class) null);
		newKLineEditDlg( _text, _value, parent);
	}
	protected native void finalize() throws InternalError;

/** 

*/
	public native String text();

/** 
 Clears the edit widget
   
*/
	public native void slotClear();

/** 
 Static convenience function to get a textual input from the user.

*/
	public static native String getText( String _text, String _value, int[] ok, QWidget parent);
}

/** Override these methods in subclasses of KLineEditDlg to customise event handling behaviour */
interface KLineEditDlgEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

