/***************************************************************************
                            KPixmap.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Off-screen paint device with extended features.

 KPixmap has two new color modes, WebColor and LowColor, applicable
 to 8bpp displays.

 In WebColor mode all images are dithered to the Netscape palette,
 even when they have their own color table. WebColor is the default
 mode for KPixmap so that standard applications can share the Netscape
 palette across the desktop.

 In LowColor mode images are checked to see if their color table
 matches the KDE icon palette. If the color tables do not match, the
 images are dithered to a minimal 3x3x3 color cube. LowColor mode can
 be used to load icons, background images etc. so that components of
 the desktop which are always present use no more than 40 colors.

 @author Mark Donohoe (donohoe@kde.org)

 @version $Id: KPixmap.java,v 1.2 2001/05/07 01:30:47 rdale Exp $
 
 @short 
 Off-screen paint device with extended features.
*/
public class KPixmap extends QPixmap  {
	protected KPixmap(Class dummy){super((Class) null);}


/** 
 Create a null pixmap.
	 
*/
	private native void newKPixmap();
	public KPixmap() {
		super((Class) null);
		newKPixmap();
	}

/** 
 Destroy the pixmap.
	 
*/
	protected native void finalize() throws InternalError;

/** 
 Copy the QPixmap <code>pix.</code>
         
*/
	private native void newKPixmap( QPixmap pix);
	public KPixmap( QPixmap pix) {
		super((Class) null);
		newKPixmap( pix);
	}

/** 
 Convert an image and sets this pixmap. 

 The conversion_flags argument is a bitwise-OR from the
 following choices. The options marked (default) are the
 choice if no other choice from the list is included (they
 are zero):

 Color/Mono preference

 Dithering mode preference, for RGB channels

 Dithering mode preference, for alpha channel

 Color matching versus dithering preference

 Passing 0 for <code>conversion_flags</code> gives all the default
 options.

*/
	public native boolean convertFromImage( QImage img, int conversion_flags);

/** 
 This is an overloaded member function, provided for
 convenience. It differs from the above function only in
 what argument(s) it accepts.

*/
//	public native boolean convertFromImage( QImage img, int mode);
	public native boolean convertFromImage( QImage img);

/** 
 Loads a pixmap from the file <code>fileName.</code>

 If format is specified, the loader attempts to read the
 pixmap using the specified format. If format is not
 specified (default), the loader reads a few bytes from the
 header to guess the file format.

 See the {@link #convertFromImage} documentation for a description
 of the conversion_flags argument.

 The {@link QImageIO} documentation lists the supported image
 formats and explains how to add extra formats.

*/
	public native boolean load( String fileName, String format, int conversion_flags);

/** 
 This is an overloaded member function, provided for
 convenience. It differs from the above function only in
 what argument(s) it accepts.

*/
//	public native boolean load( String fileName, String format, int mode);
	public native boolean load( String fileName);

/** 
 Returns true if the image posesses a color table that
 matches the Icon palette or false otherwise.

 An image with one color not found in the Icon palette is
 considered to be a match, since this extra color may be a
 transparent background.

*/
	public native boolean checkColorTable( QImage image);
	public static final int Auto = 0;
	public static final int Color = 1;
	public static final int Mono = 2;
	public static final int LowColor = 3;
	public static final int WebColor = 4;
	public static final int Horizontal = 0;
	public static final int Vertical = 1;
	public static final int Diagonal = 2;
	public static final int CrossDiagonal = 3;
}
