/***************************************************************************
                            KSharedPixmap.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Shared pixmap client.

 A shared pixmap is a pixmap that resides on the X server, is referenced
 by a global id string, and can be accessed by all X clients.

 This class is a client class to shared pixmaps in KDE. You can use it
 to copy (a part of) a shared pixmap into. KSharedPixmap inherits KPixmap
 for that purpose.

 The server part of shared pixmaps is not implemented here. 
 That part is provided by KPixmapServer, in the source file:
 kdebase/kdesktop/pixmapserver.cc.

 An example: copy from a shared pixmap:
 <pre>
   KSharedPixmap pm = new KSharedPixmap;
   connect(pm, SIGNAL("done(bool)"), SLOT("slotDone(bool)"));
   pm.loadFromShared("My Pixmap");
 </pre>

 
 @author Geert Jansen <jansen@kde.org>

 @version $Id: KSharedPixmap.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short 
 Shared pixmap client.
*/
public class KSharedPixmap extends KPixmap  {
	protected KSharedPixmap(Class dummy){super((Class) null);}


/** 
 Construct an empty pixmap.
     
*/
	private native void newKSharedPixmap();
	public KSharedPixmap() {
		super((Class) null);
		newKSharedPixmap();
	}

/** 
 Destroys the pixmap.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Load from a shared pixmap reference. The signal done() is emitted
 when the operation has finished.

*/
	public native boolean loadFromShared( String name, QRect arg1);
	public native boolean loadFromShared( String name);

/** 
 Check whether a shared pixmap is available.

*/
	public native boolean isAvailable( String name);
}

/** Override these methods in subclasses of KSharedPixmap to customise event handling behaviour */
interface KSharedPixmapEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

