/***************************************************************************
                            KStdAction.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Convenience methods to access all standard KDE actions.

 These actions should be used instead of hardcoding menubar and
 toolbar items.  Using these actions helps your application easily
 conform to the KDE UI Style Guide

 All of the documentation for {@link KAction} holds for {@link KStdAction}
 also.  When in doubt on how things work, check the {@link KAction}
 documention first.

 In general, using standard actions should be a drop in replacement
 for regular actions.  For example, if you previously had:

 <PRE>
 KAction newAct = new KAction(i18n("&New"), QIconSet(BarIcon("filenew")),
                               KStdAccel.key(KStdAccel.New), this,
                               SLOT("fileNew()"), actionCollection());
 </PRE>

 You could drop that and replace it with:

 <PRE>
 KAction newAct = KStdAction.openNew(this, SLOT("fileNew()"),
                                       actionCollection());
 </PRE>

 It is possible to use the standard actions in various
 non-recommended ways.  Say, for instance, you wanted to have a
 standard action (with the associated correct text and icon and
 accelerator, etc) but you didn't want it to go in the standard
 place (this is not recommended, by the way).  One way to do this is
 to simply not use the XML UI framework and plug it into wherever
 you want.  If you do want to use the XML UI framework (good!), then
 it is still possible.

 Basically, the XML building code matches names in the XML code with
 the internal names of the actions.  You can find out the internal
 names of each of the standard actions by using the {@link stdName}
 action like so: {@link KStdAction#stdName} would return
 'edit_cut'.  The XML building code will match 'edit_cut' to the
 attribute in the global XML file and place your action there.

 However, you can change the internal name.  In this example, just
 do something like:

 <PRE>
 (void)KStdAction.cut(this, SLOT("editCut()"), actionCollection(), "my_cut");
 </PRE>

 Now, in your local XML resource file (e.g., yourappui.rc), simply
 put 'my_cut' where you want it to go.

 Another non-standard usage concerns getting a pointer to an
 existing action if, say, you want to enable or disable the action.
 You could do it the recommended way and just grab a pointer when
 you instantiate it as in the the 'openNew' example above... or you
 could do it the hard way:

 <pre>
 KAction cut = actionCollection().action(KStdAction.stdName(KStdAction.Cut));
 </pre>

 Another non-standard usage concerns instantiating the action in the
 first place.  Usually, you would use the static member functions as
 shown above (e.g., KStdAction.cut(this, SLOT, parent)).  You
 may, however, do this using the enums provided.  This author can't
 think of a reason why you would want to, but, hey, if you do,
 here's how:

 <pre>
 (void)KStdAction.action(KStdAction.New, this, SLOT("fileNew()"), actionCollection());
 (void)KStdAction.action(KStdAction.Cut, this, SLOT("editCut()"), actionCollection());
 </pre>

 @author Kurt Granroth <granroth@kde.org>
 
 @short 
 Convenience methods to access all standard KDE actions.
*/
public class  KStdAction implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KStdAction(Class dummy){}


/** 
 Constructor.

*/
	private native void newKStdAction();
	public KStdAction() {
		newKStdAction();
	}

/** 
 Destructor.

*/
	protected native void finalize() throws InternalError;

/** 
 Retrieve the action corresponding to the
 {@link KStdAction#StdAction} enum.
     
*/
	public static native KAction action( int act_enum, QObject recvr, String slot, QObject parent, String name);
	public static KAction action( int act_enum, QObject recvr, String slot, QObject parent)
	{
		return action(act_enum, recvr, slot, parent, null);
	}
	public static native KAction action( int act_enum);

/** 
 This will return the internal name of a given standard action.
     
*/
	public static native String stdName( int act_enum);

/**  Create a new document or window. 
*/
	public static native KAction openNew( QObject recvr, String slot, QObject parent, String name);
	public static KAction openNew( QObject recvr, String slot, QObject parent)
	{
		return openNew(recvr, slot, parent, null);
	}
	public static native KAction openNew();

/** 
 Open an existing file.
     
*/
	public static native KAction open( QObject recvr, String slot, QObject parent, String name);
	public static KAction open( QObject recvr, String slot, QObject parent)
	{
		return open(recvr, slot, parent, null);
	}
	public static native KAction open();

/** 
 Open a recently used document.

*/
	public static native KRecentFilesAction openRecent( QObject recvr, String slot, QObject parent, String name);
	public static KAction openRecent( QObject recvr, String slot, QObject parent)
	{
		return openRecent(recvr, slot, parent, null);
	}
	public static native KRecentFilesAction openRecent();

/** 
 Save the current document.
     
*/
	public static native KAction save( QObject recvr, String slot, QObject parent, String name);
	public static KAction save( QObject recvr, String slot, QObject parent)
	{
		return save(recvr, slot, parent, null);
	}
	public static native KAction save();

/** 
 Save the current document under a different name.
     
*/
	public static native KAction saveAs( QObject recvr, String slot, QObject parent, String name);
	public static KAction saveAs( QObject recvr, String slot, QObject parent)
	{
		return saveAs(recvr, slot, parent, null);
	}
	public static native KAction saveAs();

/** 
 Revert the current document to the last saved version
 (essentially will undo all changes).
     
*/
	public static native KAction revert( QObject recvr, String slot, QObject parent, String name);
	public static KAction revert( QObject recvr, String slot, QObject parent)
	{
		return revert(recvr, slot, parent, null);
	}
	public static native KAction revert();

/** 
 Close the current document.
     
*/
	public static native KAction close( QObject recvr, String slot, QObject parent, String name);
	public static KAction close( QObject recvr, String slot, QObject parent)
	{
		return close(recvr, slot, parent, null);
	}
	public static native KAction close();

/** 
 Print the current document.
     
*/
	public static native KAction print( QObject recvr, String slot, QObject parent, String name);
	public static KAction print( QObject recvr, String slot, QObject parent)
	{
		return print(recvr, slot, parent, null);
	}
	public static native KAction print();

/** 
 Show a print preview of the current document.
     
*/
	public static native KAction printPreview( QObject recvr, String slot, QObject parent, String name);
	public static KAction printPreview( QObject recvr, String slot, QObject parent)
	{
		return printPreview(recvr, slot, parent, null);
	}
	public static native KAction printPreview();

/** 
 Mail this document.
     
*/
	public static native KAction mail( QObject recvr, String slot, QObject parent, String name);
	public static KAction mail( QObject recvr, String slot, QObject parent)
	{
		return mail(recvr, slot, parent, null);
	}
	public static native KAction mail();

/** 
 Quit the program.
     
*/
	public static native KAction quit( QObject recvr, String slot, QObject parent, String name);
	public static KAction quit( QObject recvr, String slot, QObject parent)
	{
		return quit(recvr, slot, parent, null);
	}
	public static native KAction quit();

/** 
 Undo the last operation.
     
*/
	public static native KAction undo( QObject recvr, String slot, QObject parent, String name);
	public static KAction undo( QObject recvr, String slot, QObject parent)
	{
		return undo(recvr, slot, parent, null);
	}
	public static native KAction undo();

/** 
 Redo the last operation.
     
*/
	public static native KAction redo( QObject recvr, String slot, QObject parent, String name);
	public static KAction redo( QObject recvr, String slot, QObject parent)
	{
		return redo(recvr, slot, parent, null);
	}
	public static native KAction redo();

/** 
 Cut selected area and store it in the clipboard.
     
*/
	public static native KAction cut( QObject recvr, String slot, QObject parent, String name);
	public static KAction cut( QObject recvr, String slot, QObject parent)
	{
		return cut(recvr, slot, parent, null);
	}
	public static native KAction cut();

/** 
 Copy the selected area into the clipboard.
     
*/
	public static native KAction copy( QObject recvr, String slot, QObject parent, String name);
	public static KAction copy( QObject recvr, String slot, QObject parent)
	{
		return copy(recvr, slot, parent, null);
	}
	public static native KAction copy();

/** 
 Paste the contents of clipboard at the current mouse or cursor
 position.
     
*/
	public static native KAction paste( QObject recvr, String slot, QObject parent, String name);
	public static KAction paste( QObject recvr, String slot, QObject parent)
	{
		return paste(recvr, slot, parent, null);
	}
	public static native KAction paste();

/** 
 Select all elements in the current document.
     
*/
	public static native KAction selectAll( QObject recvr, String slot, QObject parent, String name);
	public static KAction selectAll( QObject recvr, String slot, QObject parent)
	{
		return selectAll(recvr, slot, parent, null);
	}
	public static native KAction selectAll();

/** 
 Initiate a 'find' request in the current document.
     
*/
	public static native KAction find( QObject recvr, String slot, QObject parent, String name);
	public static KAction find( QObject recvr, String slot, QObject parent)
	{
		return find(recvr, slot, parent, null);
	}
	public static native KAction find();

/** 
 Find the next instance of a stored 'find'.
     
*/
	public static native KAction findNext( QObject recvr, String slot, QObject parent, String name);
	public static KAction findNext( QObject recvr, String slot, QObject parent)
	{
		return findNext(recvr, slot, parent, null);
	}
	public static native KAction findNext();

/** 
 Find a previous instance of a stored 'find'.
     
*/
	public static native KAction findPrev( QObject recvr, String slot, QObject parent, String name);
	public static KAction findPrev( QObject recvr, String slot, QObject parent)
	{
		return findPrev(recvr, slot, parent, null);
	}
	public static native KAction findPrev();

/** 
 Find and replace matches.
     
*/
	public static native KAction replace( QObject recvr, String slot, QObject parent, String name);
	public static KAction replace( QObject recvr, String slot, QObject parent)
	{
		return replace(recvr, slot, parent, null);
	}
	public static native KAction replace();

/** 
 View the document at its actual size.
     
*/
	public static native KAction actualSize( QObject recvr, String slot, QObject parent, String name);
	public static KAction actualSize( QObject recvr, String slot, QObject parent)
	{
		return actualSize(recvr, slot, parent, null);
	}
	public static native KAction actualSize();

/** 
 Fit the document view to the size of the current window.
     
*/
	public static native KAction fitToPage( QObject recvr, String slot, QObject parent, String name);
	public static KAction fitToPage( QObject recvr, String slot, QObject parent)
	{
		return fitToPage(recvr, slot, parent, null);
	}
	public static native KAction fitToPage();

/** 
 Fit the document view to the width of the current window.
     
*/
	public static native KAction fitToWidth( QObject recvr, String slot, QObject parent, String name);
	public static KAction fitToWidth( QObject recvr, String slot, QObject parent)
	{
		return fitToWidth(recvr, slot, parent, null);
	}
	public static native KAction fitToWidth();

/** 
 Fit the document view to the height of the current window.
     
*/
	public static native KAction fitToHeight( QObject recvr, String slot, QObject parent, String name);
	public static KAction fitToHeight( QObject recvr, String slot, QObject parent)
	{
		return fitToHeight(recvr, slot, parent, null);
	}
	public static native KAction fitToHeight();

/** 
 Zoom in.
     
*/
	public static native KAction zoomIn( QObject recvr, String slot, QObject parent, String name);
	public static KAction zoomIn( QObject recvr, String slot, QObject parent)
	{
		return zoomIn(recvr, slot, parent, null);
	}
	public static native KAction zoomIn();

/** 
 Zoom out.
     
*/
	public static native KAction zoomOut( QObject recvr, String slot, QObject parent, String name);
	public static KAction zoomOut( QObject recvr, String slot, QObject parent)
	{
		return zoomOut(recvr, slot, parent, null);
	}
	public static native KAction zoomOut();

/** 
 Popup a zoom dialog.
     
*/
	public static native KAction zoom( QObject recvr, String slot, QObject parent, String name);
	public static KAction zoom( QObject recvr, String slot, QObject parent)
	{
		return zoom(recvr, slot, parent, null);
	}
	public static native KAction zoom();

/** 
 Redisplay or redraw the document.
     
*/
	public static native KAction redisplay( QObject recvr, String slot, QObject parent, String name);
	public static KAction redisplay( QObject recvr, String slot, QObject parent)
	{
		return redisplay(recvr, slot, parent, null);
	}
	public static native KAction redisplay();

/** 
 Move up (web style menu).
     
*/
	public static native KAction up( QObject recvr, String slot, QObject parent, String name);
	public static KAction up( QObject recvr, String slot, QObject parent)
	{
		return up(recvr, slot, parent, null);
	}
	public static native KAction up();

/** 
 Move back (web style menu).
     
*/
	public static native KAction back( QObject recvr, String slot, QObject parent, String name);
	public static KAction back( QObject recvr, String slot, QObject parent)
	{
		return back(recvr, slot, parent, null);
	}
	public static native KAction back();

/** 
 Move forward (web style menu).
     
*/
	public static native KAction forward( QObject recvr, String slot, QObject parent, String name);
	public static KAction forward( QObject recvr, String slot, QObject parent)
	{
		return forward(recvr, slot, parent, null);
	}
	public static native KAction forward();

/** 
 Go to the "Home" position or document.
     
*/
	public static native KAction home( QObject recvr, String slot, QObject parent, String name);
	public static KAction home( QObject recvr, String slot, QObject parent)
	{
		return home(recvr, slot, parent, null);
	}
	public static native KAction home();

/** 
 Scroll up one page.
     
*/
	public static native KAction prior( QObject recvr, String slot, QObject parent, String name);
	public static KAction prior( QObject recvr, String slot, QObject parent)
	{
		return prior(recvr, slot, parent, null);
	}
	public static native KAction prior();

/** 
 Scroll down one page.
     
*/
	public static native KAction next( QObject recvr, String slot, QObject parent, String name);
	public static KAction next( QObject recvr, String slot, QObject parent)
	{
		return next(recvr, slot, parent, null);
	}
	public static native KAction next();

/** 
 Go to somewhere in general.
     
*/
	public static native KAction goTo( QObject recvr, String slot, QObject parent, String name);
	public static KAction goTo( QObject recvr, String slot, QObject parent)
	{
		return goTo(recvr, slot, parent, null);
	}
	public static native KAction goTo();

/** 
 Go to a specific page (dialog).
     
*/
	public static native KAction gotoPage( QObject recvr, String slot, QObject parent, String name);
	public static KAction gotoPage( QObject recvr, String slot, QObject parent)
	{
		return gotoPage(recvr, slot, parent, null);
	}
	public static native KAction gotoPage();

/** 
 Go to a specific line (dialog).
     
*/
	public static native KAction gotoLine( QObject recvr, String slot, QObject parent, String name);
	public static KAction gotoLine( QObject recvr, String slot, QObject parent)
	{
		return gotoLine(recvr, slot, parent, null);
	}
	public static native KAction gotoLine();

/** 
 Jump to the first page.
     
*/
	public static native KAction firstPage( QObject recvr, String slot, QObject parent, String name);
	public static KAction firstPage( QObject recvr, String slot, QObject parent)
	{
		return firstPage(recvr, slot, parent, null);
	}
	public static native KAction firstPage();

/** 
 Jump to the last page.
     
*/
	public static native KAction lastPage( QObject recvr, String slot, QObject parent, String name);
	public static KAction lastPage( QObject recvr, String slot, QObject parent)
	{
		return lastPage(recvr, slot, parent, null);
	}
	public static native KAction lastPage();

/** 
 Add the current page to the bookmarks tree.
     
*/
	public static native KAction addBookmark( QObject recvr, String slot, QObject parent, String name);
	public static KAction addBookmark( QObject recvr, String slot, QObject parent)
	{
		return addBookmark(recvr, slot, parent, null);
	}
	public static native KAction addBookmark();

/** 
 Edit the application bookmarks.
     
*/
	public static native KAction editBookmarks( QObject recvr, String slot, QObject parent, String name);
	public static KAction editBookmarks( QObject recvr, String slot, QObject parent)
	{
		return editBookmarks(recvr, slot, parent, null);
	}
	public static native KAction editBookmarks();

/** 
 Pop up the spell checker.
     
*/
	public static native KAction spelling( QObject recvr, String slot, QObject parent, String name);
	public static KAction spelling( QObject recvr, String slot, QObject parent)
	{
		return spelling(recvr, slot, parent, null);
	}
	public static native KAction spelling();

/** 
 Show/Hide the menubar.
     
*/
	public static native KToggleAction showMenubar( QObject recvr, String slot, QObject parent, String name);
	public static KToggleAction showMenubar( QObject recvr, String slot, QObject parent)
	{
		return showMenubar(recvr, slot, parent, null);
	}
	public static native KToggleAction showMenubar();

/** 
 Show/Hide the primary toolbar.
     
*/
	public static native KToggleAction showToolbar( QObject recvr, String slot, QObject parent, String name);
	public static KToggleAction showToolbar( QObject recvr, String slot, QObject parent)
	{
		return showToolbar(recvr, slot, parent, null);
	}
	public static native KToggleAction showToolbar();

/** 
 Show/Hide the statusbar.
     
*/
	public static native KToggleAction showStatusbar( QObject recvr, String slot, QObject parent, String name);
	public static KToggleAction showStatusbar( QObject recvr, String slot, QObject parent)
	{
		return showStatusbar(recvr, slot, parent, null);
	}
	public static native KToggleAction showStatusbar();

/** 
 Display the save options dialog.
     
*/
	public static native KAction saveOptions( QObject recvr, String slot, QObject parent, String name);
	public static KAction saveOptions( QObject recvr, String slot, QObject parent)
	{
		return saveOptions(recvr, slot, parent, null);
	}
	public static native KAction saveOptions();

/** 
 Display the configure key bindings dialog.
     
*/
	public static native KAction keyBindings( QObject recvr, String slot, QObject parent, String name);
	public static KAction keyBindings( QObject recvr, String slot, QObject parent)
	{
		return keyBindings(recvr, slot, parent, null);
	}
	public static native KAction keyBindings();

/** 
 Display the preferences/options dialog.
     
*/
	public static native KAction preferences( QObject recvr, String slot, QObject parent, String name);
	public static KAction preferences( QObject recvr, String slot, QObject parent)
	{
		return preferences(recvr, slot, parent, null);
	}
	public static native KAction preferences();

/** 
 The Customize Toolbar dialog.
     
*/
	public static native KAction configureToolbars( QObject recvr, String slot, QObject parent, String name);
	public static KAction configureToolbars( QObject recvr, String slot, QObject parent)
	{
		return configureToolbars(recvr, slot, parent, null);
	}
	public static native KAction configureToolbars();

/** 
 Display the help.
     
*/
	public static native KAction help( QObject recvr, String slot, QObject parent, String name);
	public static KAction help( QObject recvr, String slot, QObject parent)
	{
		return help(recvr, slot, parent, null);
	}
	public static native KAction help();

/** 
 Display the help contents.
     
*/
	public static native KAction helpContents( QObject recvr, String slot, QObject parent, String name);
	public static KAction helpContents( QObject recvr, String slot, QObject parent)
	{
		return helpContents(recvr, slot, parent, null);
	}
	public static native KAction helpContents();

/** 
 Trigger the What's This cursor.
     
*/
	public static native KAction whatsThis( QObject recvr, String slot, QObject parent, String name);
	public static KAction whatsThis( QObject recvr, String slot, QObject parent)
	{
		return whatsThis(recvr, slot, parent, null);
	}
	public static native KAction whatsThis();

/** 
 Open up the Report Bug dialog.
     
*/
	public static native KAction reportBug( QObject recvr, String slot, QObject parent, String name);
	public static KAction reportBug( QObject recvr, String slot, QObject parent)
	{
		return reportBug(recvr, slot, parent, null);
	}
	public static native KAction reportBug();

/** 
 Display the application's About box.
     
*/
	public static native KAction aboutApp( QObject recvr, String slot, QObject parent, String name);
	public static KAction aboutApp( QObject recvr, String slot, QObject parent)
	{
		return aboutApp(recvr, slot, parent, null);
	}
	public static native KAction aboutApp();

/** 
 Display the About KDE dialog.
     
*/
	public static native KAction aboutKDE( QObject recvr, String slot, QObject parent, String name);
	public static KAction aboutKDE( QObject recvr, String slot, QObject parent)
	{
		return aboutKDE(recvr, slot, parent, null);
	}
	public static native KAction aboutKDE();
	public static final int New = 1;
	public static final int Open = 0;
	public static final int OpenRecent = 1;
	public static final int Save = 2;
	public static final int SaveAs = 3;
	public static final int Revert = 4;
	public static final int Close = 5;
	public static final int Print = 6;
	public static final int PrintPreview = 7;
	public static final int Mail = 8;
	public static final int Quit = 9;
	public static final int Undo = 10;
	public static final int Redo = 11;
	public static final int Cut = 12;
	public static final int Copy = 13;
	public static final int Paste = 14;
	public static final int SelectAll = 15;
	public static final int Find = 16;
	public static final int FindNext = 17;
	public static final int FindPrev = 18;
	public static final int Replace = 19;
	public static final int ActualSize = 20;
	public static final int FitToPage = 21;
	public static final int FitToWidth = 22;
	public static final int FitToHeight = 23;
	public static final int ZoomIn = 24;
	public static final int ZoomOut = 25;
	public static final int Zoom = 26;
	public static final int Redisplay = 27;
	public static final int Up = 28;
	public static final int Back = 29;
	public static final int Forward = 30;
	public static final int Home = 31;
	public static final int Prior = 32;
	public static final int Next = 33;
	public static final int Goto = 34;
	public static final int GotoPage = 35;
	public static final int GotoLine = 36;
	public static final int FirstPage = 37;
	public static final int LastPage = 38;
	public static final int AddBookmark = 39;
	public static final int EditBookmarks = 40;
	public static final int Spelling = 41;
	public static final int ShowMenubar = 42;
	public static final int ShowToolbar = 43;
	public static final int ShowStatusbar = 44;
	public static final int SaveOptions = 45;
	public static final int KeyBindings = 46;
	public static final int Preferences = 47;
	public static final int ConfigureToolbars = 48;
	public static final int Help = 49;
	public static final int HelpContents = 50;
	public static final int WhatsThis = 51;
	public static final int ReportBug = 52;
	public static final int AboutApp = 53;
	public static final int AboutKDE = 54;
	public static final int NULL1 = 55;
	public static final int NULL2 = 56;
	public static final int NULL3 = 57;
	public static final int NULL4 = 58;
	public static final int NULL5 = 59;
	public static final int NULL6 = 60;
	public static final int NULL7 = 61;
	public static final int NULL8 = 62;
	public static final int NULL9 = 63;
	public static final int NULL10 = 64;
	public static final int NULL11 = 65;
	public static final int NULL12 = 66;
	public static final int NULL13 = 67;
	public static final int NULL14 = 68;
	public static final int NULL15 = 69;
	public static final int NULL16 = 70;
	public static final int NULL17 = 71;
	public static final int NULL18 = 72;
	public static final int NULL19 = 73;
	public static final int NULL20 = 74;
}
