/***************************************************************************
                            KURIFilterPlugin.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Base class for URI filter plugins.

 This class applies a single filter to a URI.  All
 plugins designed to provide URI filtering functionalities
 should inherit from this abstract class and provide a
 specific filtering implementation.

 All inheriting classes need to implement the pure
 virtual function {@link filterURI}.  Otherwise, they
 would also become abstract.

 @short Abstract class for URI filter plugins.
 
*/
public class KURIFilterPlugin extends QObject  {
	protected KURIFilterPlugin(Class dummy){super((Class) null);}


/** 
 Constructor to create a filter plugin with a given name and
 priority.

*/

/** 
 Return the filter's name.

*/
	public native String name();

/** 
 Return the filter's .

 Each filter has an assigned priority, a float from 0 to 1. Filters
 with the lowest priority are first given a chance to filter a URI.

*/
	public native double priority();

/** 
 Filters a URI.

*/
	public native boolean filterURI( KURIFilterData data);

/** 
 Returns a configuration module for the filter.

 It is the responsability of the caller to delete the module
 once it is not needed anymore.

*/
	public native KCModule configModule( QWidget arg1, String arg2);

/** 
 Returns the name of the configuration module for the filter.

*/
	public native String configName();
}
