/***************************************************************************
                            KabAPI.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 The class KabAPI provides a public interface to access the 
 users address database created using kab. The complete 
 functionality regarding database operations provided by kab is
 available using an object of this class.

 The class is derived from the class KDialogBase, thus objects
 can be used as a KDE dialog where the user may select a person
 out of the entries in his personal database. 
 The following code may be used to let the user select an address:
 <pre>
 KabAPI kabapi(this);
 if(dialog.init()!=KabAPI.NoError)
   {
     ... error handling
   }
 AddressBook.Entry entry;
 if(kabapi.exec())
   {
     if(!kabapi.getEntry(entry))
       {
         // ... the database is empty
       } else {
         // ... use the entry
       }
   }
 ...
 </pre>
 Some methods declared here return keys of entries. The keys are of the 
 datatype KabKey. Every key
 is (of course) unique and identifying. If you store it, you can access 
 the entry it represents with it. Be careful that the entry may have been 
 deleted by another program instance meanwhile!
 <tt>Please be careful to test for the return code NotImplemented as 
 long the kab API is not completely finished.</tt>

 @author Mirko Boehm <mirko@kde.org>

 @version $Id: KabAPI.java,v 1.3 2001/05/16 22:52:51 rdale Exp $

 @short The class KabAPI defines the API to access user address databases.

*/
public class KabAPI extends KDialogBase  {
	protected KabAPI(Class dummy){super((Class) null);}


/**  The constructor creates a KabAPI object, but it does not load the
 database itselfes, as you could not query if this could be done 
 without failures. Thus you have to call {@link #init} before you can 
 use the database.

*/
	private native void newKabAPI( QWidget parent, String name);
	public KabAPI( QWidget parent, String name) {
		super((Class) null);
		newKabAPI( parent, name);
	}
	private native void newKabAPI();
	public KabAPI() {
		super((Class) null);
		newKabAPI();
	}

/**  You must call init before accessing the database. init opens the
 database file (usually $HOME/.kde/share/apps/kab/addressbook.database)
 and loads its contents.

*/
	public native int init();

/**  Get the addressbook object of this API. This is probably the most powerful
  method in the KabAPI since it allows you to access the database backend
  itselfes.
  If the API has not been initialized (using #init) before, zero is returned.

*/
	public native AddressBook addressbook();

/**  Save the database to the file.
  This method is used to force the database to save its contents.
  If force is true, the method will try to get writing permissions to
  the file if the database is opened readonly. After finishing saving,
  the r/o state is reset. This allows easier file sharing, since by default,
  all files are opened readonly aand closed after all read accesses. 
*/
	public native int save( boolean force);
	public native int save();

/**  The method getEntry returns the selected entry. 

*/
	public native int getEntry( Entry entry, KabKey key);

/**  The method requires that the database is not opened readonly.

*/
	public native int add( Entry entry, KabKey key, boolean update);
	public native int add( Entry entry, KabKey key);

/**  If the preferences of kab say to query before deleting, the user has
 to click "yes" on a message box that appeares.
 If called for a read only database, the method will return 
 PermDenied.

*/
	public native int remove( KabKey key);

/**  Execute this dialog. This overloads QDialog.exec to fill the list box
  before showing. 
*/
	public native int exec();

/**  Capture selections in the dialog (listbox). 
*/
	protected native void entrySelected( int arg1);

/**  Capture status messages from book. 
*/
	protected native void setStatusSlot( String arg1);
}

/** Override these methods in subclasses of KabAPI to customise event handling behaviour */
interface KabAPIEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

