/***************************************************************************
                            KeyValueMap.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 The class KeyValueMap is used for managing key-value-pairs
  WITHOUT any hierarchical structure.   Objects of it can be
  used as they are or in conjunction with the  configuration
  database class.
  While the first version used the string class, this second
  uses the QCString class.
  The class uses pairs of methods for each datatype, they are 
  called .get and .insert. Every overloaded version of this 
  methods get the key of the settings and a reference to the
  value to set or to store it in. A boolean result reports if
  there where errors or if the key already existed. Keys must
  of course be unique. Please note that the map does NOT store type 
  information for the keys. You may retrieve a boolean value for a string,
  it will work if the string is either "true" or "false".
  See the different get- and insert-methods for details.

  Capabilities of the class are:
  <OL> 
  <LI> storing of any key-value-pair that is storable in 
    string values (no binary objects currently), </LI>
  <LI> key-value-pairs are saved in human-readable text files
    when saving to disk, </LI>
  <LI> the values may contain newline and tabulator characters
    which will still be there after saving and rereading, </LI>
  <LI> supports the following datatypes: <OL> 
    <LI> strings (of course), </LI>
    <LI> integers, </LI>
    <LI> floating point values and </LI>
    <LI> boolean states </LI> </OL> </LI> 
  <LI> supports storing and retrieving of lists of values of the 
    following datatypes: <OL> 
    <LI> strings, </LI>
    <LI> integers and </LI>
    <LI> floating point values </LI> </OL> 
    (boolean lists supported in future when requested) </LI> 
  <LI> easy syntax of files, in general it is supposed to be a 
    kind of guarantee  (you know that free software  never 
    guarantees anything, don't you?)  that every value that 
    has been  stored  by one of the member functions of the 
    class like <BR>
      <TT> insert(const QCString& key, [value&]); </TT> <BR>
    can also be retrieved using <BR>
      <TT> get(const QCString& key, [value&]);</TT> <BR>
    without being modified. <BR>
    (Please report anything that does not do so!) </LI> </OL> 
  The class is used to implement the #QConfigDB class. 
 @short  The class KeyValueMap is used for managing key-value-pairs
  WITHOUT any hierarchical structure.
*/
public class  KeyValueMap implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KeyValueMap(Class dummy){}


/**  The default constructor. 
*/
	private native void newKeyValueMap();
	public KeyValueMap() {
		newKeyValueMap();
	}

/**  The copy constructor. 
*/
	private native void newKeyValueMap( KeyValueMap arg1);
	public KeyValueMap( KeyValueMap arg1) {
		newKeyValueMap( arg1);
	}

/**  The virtual destructor. 
*/
	protected native void finalize() throws InternalError;

/**  Debugging aid: returns true if object is OK. 
*/
	public native boolean invariant();

/**  Returns the number of key-value-pairs in the map. 
*/
	public native int size();

/**  Delete all entries. 
*/
	public native void clear();

/**  Fills the map with the files contents.
  If the parameter \a force is true, it overrides keys that are
  already declared in the database and are declared again in the file.
  If \a relax is true, the value of a string may be empty. 
*/
	public native boolean fill( String arg1, boolean force, boolean relax);
	public native boolean fill( String arg1);

/**  Saves the database to a file. 
  Only overrides existing files if force is true. 
*/
	public native boolean save( String arg1, boolean force);
	public native boolean save( String arg1);

/**  Saves contents to an already open text stream.
 \a count spaces are inserted before each line. This method is 
 called when save hierarchical databases.

*/
	public native boolean get( String key, String value);

/**  Insert a string value for the given key. 
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
	public native boolean insert( String key, String value, boolean force);
	public native boolean insert( String key, String value);

/**  Insert a character pointer  for the given key. 
  pgcc treats character pointers as boolean objects, not as strings.
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
//	public native boolean insert( String key, String value, boolean force);
//	public native boolean insert( String key, String value);

/**  Insert a line like "key_a="Hallo!" into the map as a key-value-pair. 
  If force is true existing keys will be overridden.
  If relax is true the value may be empty an empty string.
  If encode is false, the string will not be coded (do not use!). 
*/
	public native boolean insertLine( String arg1, boolean force, boolean relax, boolean encode);
	public native boolean insertLine( String arg1);

/**  Get the value for the key as a long integer. 
  \a key is the key to search for, \value is a reference to the object
  the value for the key is assigned to. 
*/
	public native boolean get( String arg1, long arg2);

/**  Insert a long integer value for the given key. 
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
	public native boolean insert( String arg1, long arg2, boolean force);
	public native boolean insert( String arg1, long arg2);

/**  For insertion of UNICODE strings, a special method pair is created. The 
  data will be translated to utf8 and inserted in the map as a QCString. 
  This will probably be not fast, but this methods are not suited to save 
  large amounts of data. For saving anything else than UNICODE strings,
  no such conversion is needed.
  \a key is the key to search for, \value is a reference to the object
  the value for the key is assigned to. 
*/
//	public native boolean get( String arg1, String arg2);

/**  Insert a UNICODE string value for the given key. 
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
//	public native boolean insert( String arg1, String arg2, boolean force);
//	public native boolean insert( String arg1, String arg2);

/**  Get the value for the key as a double. 
  \a key is the key to search for, \value is a reference to the object
  the value for the key is assigned to. 
*/
	public native boolean get( String arg1, double arg2);

/**  Insert a double value for the given key. 
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
	public native boolean insert( String arg1, double arg2, boolean force);
	public native boolean insert( String arg1, double arg2);

/**  Get the value for the key as a boolean value. 
  \a key is the key to search for, \value is a reference to the object
  the value for the key is assigned to. 
*/
	public native boolean get( String arg1, boolean arg2);

/**  Insert a boolean value for the given key. 
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
	public native boolean insert( String arg1, boolean arg2, boolean force);
	public native boolean insert( String arg1, boolean arg2);

/**  Get the value for the key as a QStrList. 
  \a key is the key to search for, \value is a reference to the object
  the value for the key is assigned to. 
*/
	public native boolean get( String arg1, String[] arg2);

/**  Insert a QStrList for the given key. 
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
	public native boolean insert( String arg1, String[] arg2, boolean force);
	public native boolean insert( String arg1, String[] arg2);

/**  Get the value for the key as a StringList. Beware of the difference -
  a StringList is a list of String objects, while QStrList handles
  char like objects.
  \a key is the key to search for, \value is a reference to the object
  the value for the key is assigned to. 
*/
//	public native boolean get( String arg1, String[] arg2);

/**  Insert a StringList for the given key. 
  If force is true, an existing value for this key will be overridden.
  The method returns false if the key exists and \a force is false. 
*/
//	public native boolean insert( String arg1, String[] arg2, boolean force);
//	public native boolean insert( String arg1, String[] arg2);

/**  Get the value for the key as a QDate.
  The value will be parsed to a integer list that must be a \e valid
  date (see QDate documentation). \c false will be returned if the value
  is not valid or a null date. This situation might only happen in
  manually created files, since the insert-method for QDates rejects to
  insert inalid dates, it inserts null dates instead.

*/
	public native boolean insert( String arg1, Calendar arg2, boolean force);
	public native boolean insert( String arg1, Calendar arg2);

/**  Returns true if there are no keys declared in this map. 
*/
	public native boolean empty();

/**  Erases all key-value-pairs in the map. 
*/
	public native boolean erase( String key);

/**  Transform a complex string into a normal string object.
  The values are not stored  as they are, they are coded into 
  complex string where control and non-printable characters get a readable
  representation.
  When retrieving, this strings are translated back by this method.
  \a orig contains the string read from the file, \a index the position from 
  where to start the translation (need not be the beginning of the string), 
  \a result contains the transformed string, \a noOfChars the number of 
  characters used to parse the string. 
  Returns true if there where no errors while parsing.

*/
	protected native boolean insertRaw( String key, String value, boolean force);
	protected native boolean insertRaw( String key, String value);

/**  Retrieves the undecoded value (a complex string) of the given key. 
*/
	protected native boolean getRaw( String key, String value);
}
