/***************************************************************************
                            MainWindow.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A KPart-aware main window, whose user interface is described in XML.

 Inherit your main window from this class
 and don't forget to call {@link #setXMLFile} in the inherited constructor.

 It implements all internal interfaces in the case of a
 {@link KMainWindow} as host: the builder and servant interface (for menu
 merging).
 
 @short 
 A KPart-aware main window, whose user interface is described in XML.
*/
public class MainWindow extends KMainWindow implements  PartBaseInterface {
	protected MainWindow(Class dummy){super((Class) null);}


/** 
 Constructor, same signature as {@link KMainWindow}.
   
*/
	private native void newMainWindow( QWidget parent, String name, int f);
	public MainWindow( QWidget parent, String name, int f) {
		super((Class) null);
		newMainWindow( parent, name, f);
	}
	private native void newMainWindow( QWidget parent);
	public MainWindow( QWidget parent) {
		super((Class) null);
		newMainWindow( parent);
	}

/** 
 Compatibility Constructor, same signature as {@link KTMainWindow}.
   
*/
	private native void newMainWindow( String name, int f);
	public MainWindow( String name, int f) {
		super((Class) null);
		newMainWindow( name, f);
	}
	private native void newMainWindow();
	public MainWindow() {
		super((Class) null);
		newMainWindow();
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	protected native void createShellGUI( boolean create);
	protected native void createShellGUI();

/** 
 Create the GUI (by merging the host's and the active part's)

 For this you need to connect this slot to the
 {@link KPartManager#activePartChanged} signal

*/
	protected native void createGUI( Part part);

/** 
 Called when the active part wants to change the statusbar message
 Reimplement if your mainwindow has a complex statusbar
 (with several items)
   
*/
	protected native void slotSetStatusBarText( String arg1);

/**
  Internal method. Called by {@link KParts#Part} to specify the parent object for plugin objects.


*/
	public native void setPartObject( QObject object);
	public native QObject partObject();

/**
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor,
 because it loads the i18n catalogues.

*/
	public native void setInstance( KInstanceInterface instance);

/**
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor,
 because it loads the i18n catalogues.

*/
	public native void setInstance( KInstanceInterface instance, boolean loadPlugins);
}

/** Override these methods in subclasses of MainWindow to customise event handling behaviour */
interface MainWindowEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent e);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);

/** 
 Reimplemented to call the queryClose() and queryExit() handlers.

 We recommend that you reimplement the handlers rather than {@link #closeEvent}.
 If you do it anyway, ensure to call the base implementation to keep
 {@link #queryExit} running.
     
*/
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent e);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent e);
}

