/***************************************************************************
                          JavaSlot.h  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   Lost Highway Ltd reserves the right to issue additional license types *
 *   compatible with the Trolltech AS Qt commercial license.               *
 ***************************************************************************/

#ifndef _JAVASLOT_H_
#define _JAVASLOT_H_

#include <jni.h>
#include <qobject.h>

#include <qevent.h>
#include <qlistview.h>
#include <qiconview.h>
#include <qlistbox.h>
#include <qdatetime.h>
#include <qtoolbar.h>
#include <qaction.h>

class JavaSlotFactory;
class QMetaObject;

class JavaSlot: public QObject
{
    Q_OBJECT
public:
    JavaSlot(jobject receiver, jstring slot);
    ~JavaSlot();
	
	/** Set the JavaSlot factory to create any JavaSlot instances */
	static void setJavaSlotFactory(JavaSlotFactory * factory);

    /** Return a new JavaSlot instance via the JavaSlot factory */
	static JavaSlot * createJavaSlot(jobject receiver, jstring slot);

	/** Given a Java signal name, returns the corresponding C++ signal name.
		The QMetaObject is used to check whether the QObject instance described
		by 'smeta' implements the C++ signal. */
	const char * javaToQtSignalName(JNIEnv * env, jstring signalString, QMetaObject * smeta);
	
	/** Converts a Java type signature for a signal to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSignalType(const char * signalName, const char * javaTypeSignature, QMetaObject * smeta);

	/** Given a Java slot name, returns the corresponding C++ slot name */
	const char * javaToQtSlotName(JNIEnv * env, jstring slotString);

	/** Converts a Java type signature for a slot to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSlotType(const char * javaTypeSignature);

public slots:
    void invoke();
    void invoke(bool arg);
    void invoke(unsigned char arg);
    void invoke(char arg);
    void invoke(short arg);
    void invoke(int arg);
    void invoke(long arg);
    void invoke(float arg);
    void invoke(double arg);
    void invoke(jobjectArray args);
	void invoke(Orientation arg1);
	void invoke(QAction* arg1);
	void invoke(QDate arg1);
	void invoke(QDropEvent* arg1);
	void invoke(QDropEvent* arg1,QListViewItem*arg2);
	void invoke(QDropEvent*arg1,QListViewItem*arg2,QListViewItem*arg3);
	void invoke(QDropEvent* arg1,const QValueList<QIconDragItem> arg2);
	void invoke(QIconViewItem* arg1);
	void invoke(QIconViewItem* arg1,const QPoint& arg2);
	void invoke(QIconViewItem* arg1,const QString& arg2);
	void invoke(QList<QListViewItem> arg1,QList<QListViewItem> arg2,QList<QListViewItem> arg3);
	void invoke(QListBoxItem* arg1);
	void invoke(QListBoxItem* arg1,const QPoint& arg2);
	void invoke(QListViewItem*arg1);
	void invoke(QListViewItem* arg1,QListViewItem*arg2,QListViewItem*arg3);
	void invoke(QListViewItem* arg1,const QPoint& arg2,int arg3);
	void invoke(QListViewItem* arg1,const QString& arg2,int arg3);
	void invoke(QToolBar* arg1);
	void invoke(QObject* arg1);
	void invoke(QString arg1, QString arg2, unsigned arg3);
	void invoke(QString arg1, QStringList* arg2, unsigned arg3);
	void invoke(QStringList* arg1);
	void invoke(QWidget* arg1);
	void invoke(const QChar& arg1);
	void invoke(const QColor& arg1);
	void invoke(const QColor& arg1, const QString& arg2);
	void invoke(const QFont& arg1);
	void invoke(const QImage& arg1,int);
	void invoke(const QString& arg1);
	void invoke(const QString arg1);
	void invoke(const QString& arg1,const QString& arg2);
	void invoke(const QString& arg1,const QString& arg2,const QString& arg3);
	void invoke(const QString& arg1,const QPoint& arg2);
	void invoke(const QString arg1,const QString arg2);
	void invoke(int,QIconViewItem* arg1,const QPoint& arg2);
	void invoke(int,QListBoxItem* arg1,const QPoint& arg2);
	void invoke(int,QListViewItem* arg1,const QPoint& arg2,int arg3);
	void invoke(int arg1,QPoint arg2);
	void invoke(int arg1,const QString& arg2);
	void invoke(int arg1,bool arg2);
	void invoke(int arg1,int arg2);
	void invoke(int arg1,int arg2,int arg3);
	void invoke(int arg1,int arg2,int arg3,const QPoint& arg4);
protected:
    jobject invocation;
private:
    static JavaSlotFactory *	_factory;
};

class JavaSlotFactory {
public:
	JavaSlotFactory();
	~JavaSlotFactory() {};
	virtual JavaSlot *	createJavaSlot(jobject receiver, jstring slot);
};

class JavaSignal: public QObject
{
    Q_OBJECT
public:
    JavaSignal();
    ~JavaSignal();
    void emitArgs(jobjectArray args);
signals:
    void signalJava(jobjectArray);
};

#endif




