/***************************************************************************
                            KThemeBase.cpp -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

#define _BOOL_H_
#include <kthemebase.h>
#include <qstring.h>
#include <qcstring.h>

#include <qtjava/QtSupport.h>
#include <kdejava/KThemeBase.h>

class KThemeBaseJBridge : public KThemeBase
{
public:
	KThemeBaseJBridge(const QString& configFile) : KThemeBase(configFile) {}
	~KThemeBaseJBridge() {}
	QImage*  protected_image(WidgetType widget) {
		return (QImage* ) KThemeBase::image(widget);
	}
	QColor*  protected_gradientHigh(WidgetType widget) {
		return (QColor* ) KThemeBase::gradientHigh(widget);
	}
	QColor*  protected_gradientLow(WidgetType widget) {
		return (QColor* ) KThemeBase::gradientLow(widget);
	}
	void protected_readConfig(Qt::GUIStyle colorStyle) {
		KThemeBase::readConfig(colorStyle);
		return;
	}
//	void protected_readWidgetConfig(int i, KConfig* config, QString* pixnames, QString* brdnames, bool* loadArray) {
//		KThemeBase::readWidgetConfig(i, config, pixnames, brdnames, loadArray);
//		return;
//	}
	void protected_copyWidgetConfig(int sourceID, int destID, QString* pixnames, QString* brdnames) {
		KThemeBase::copyWidgetConfig(sourceID, destID, pixnames, brdnames);
		return;
	}
	QColorGroup*  protected_makeColorGroup(QColor& fg, QColor& bg, Qt::GUIStyle style) {
		return (QColorGroup* ) KThemeBase::makeColorGroup(fg, bg, style);
	}
	KThemePixmap*  protected_scale(int w, int h, WidgetType widget) {
		return (KThemePixmap* ) KThemeBase::scale(w, h, widget);
	}
	KThemePixmap*  protected_scaleBorder(int w, int h, WidgetType type) {
		return (KThemePixmap* ) KThemeBase::scaleBorder(w, h, type);
	}
	KThemePixmap*  protected_gradient(int w, int h, WidgetType widget) {
		return (KThemePixmap* ) KThemeBase::gradient(w, h, widget);
	}
	KThemePixmap*  protected_blend(WidgetType widget) {
		return (KThemePixmap* ) KThemeBase::blend(widget);
	}
	void protected_generateBorderPix(int i) {
		KThemeBase::generateBorderPix(i);
		return;
	}
	void protected_applyResourceGroup(KConfig* config, int i) {
		KThemeBase::applyResourceGroup(config, i);
		return;
	}
	void protected_applyMiscResourceGroup(KConfig* config) {
		KThemeBase::applyMiscResourceGroup(config);
		return;
	}
	void protected_readResourceGroup(int i, QString* pixnames, QString* brdnames, bool* loadArray) {
		KThemeBase::readResourceGroup(i, pixnames, brdnames, loadArray);
		return;
	}
	void protected_readMiscResourceGroup() {
		KThemeBase::readMiscResourceGroup();
		return;
	}
	KThemePixmap*  protected_loadPixmap(QString& name) {
		return (KThemePixmap* ) KThemeBase::loadPixmap(name);
	}
	QImage*  protected_loadImage(QString& name) {
		return (QImage* ) KThemeBase::loadImage(name);
	}
	void childEvent(QChildEvent* arg1) {
		if (! QtSupport::eventDelegate(this, "childEvent", arg1, "org.kde.qt.QChildEvent")) {
			QObject::childEvent(arg1);
		}
		return;
	}
	void timerEvent(QTimerEvent* arg1) {
		if (! QtSupport::eventDelegate(this, "timerEvent", arg1, "org.kde.qt.QTimerEvent")) {
			QObject::timerEvent(arg1);
		}
		return;
	}
};


JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_newKThemeBase(JNIEnv *env, jobject obj, jstring configFile)
{
static QString * _qstring_configFile = 0;
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KThemeBaseJBridge((QString&) * (QString *) QtSupport::toQString(env, configFile, &_qstring_configFile)));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_finalize(JNIEnv *env, jobject obj)
{
	if (QtSupport::allocatedInJavaWorld(env, obj)) {
		delete (KThemeBase*)QtSupport::getQt(env, obj);
		QtSupport::setQt(env, obj, 0);
	}
	return;
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_scaleHint(JNIEnv *env, jobject obj, jint widget)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->scaleHint((KThemeBase::WidgetType) widget);
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_gradientHint(JNIEnv *env, jobject obj, jint widget)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->gradientHint((KThemeBase::WidgetType) widget);
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_colorGroup(JNIEnv *env, jobject obj, jobject defaultGroup, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->colorGroup((QColorGroup&) *(QColorGroup *) QtSupport::getQt(env, defaultGroup), (KThemeBase::WidgetType) widget), "org.kde.qt.QColorGroup");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_pixmapBrush(JNIEnv *env, jobject obj, jobject group, jint role, jint w, jint h, jint widget)
{
	QBrush _b= ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->pixmapBrush((QColorGroup&) *(QColorGroup *) QtSupport::getQt(env, group), (QColorGroup::ColorRole) role, (int) w, (int) h, (KThemeBase::WidgetType) widget);
	return (jobject) QtSupport::objectForQtKey(env, (void *)new QBrush(_b.color(),_b.style()), "org.kde.qt.QBrush", TRUE);
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_isPixmap(JNIEnv *env, jobject obj, jint widget)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->isPixmap((KThemeBase::WidgetType) widget);
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_isColor(JNIEnv *env, jobject obj, jint widget)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->isColor((KThemeBase::WidgetType) widget);
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_is3DFocus(JNIEnv *env, jobject obj)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->is3DFocus();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_focusOffset(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->focusOffset();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_borderWidth(JNIEnv *env, jobject obj, jint widget)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->borderWidth((KThemeBase::WidgetType) widget);
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_pixBorderWidth(JNIEnv *env, jobject obj, jint widget)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->pixBorderWidth((KThemeBase::WidgetType) widget);
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_borderPixmap(JNIEnv *env, jobject obj, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->borderPixmap((KThemeBase::WidgetType) widget), "org.kde.koala.KThemePixmap");
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_highlightWidth(JNIEnv *env, jobject obj, jint widget)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->highlightWidth((KThemeBase::WidgetType) widget);
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_decoWidth(JNIEnv *env, jobject obj, jint widget)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->decoWidth((KThemeBase::WidgetType) widget);
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_getSBExtent(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->getSBExtent();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_scrollBarLayout(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->scrollBarLayout();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_arrowType(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->arrowType();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_shade(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->shade();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_frameWidth(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->frameWidth();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_splitWidth(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->splitWidth();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_bevelContrast(JNIEnv *env, jobject obj, jint widget)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->bevelContrast((KThemeBase::WidgetType) widget);
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_buttonXShift(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->buttonXShift();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_buttonYShift(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->buttonYShift();
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KThemeBase_sliderButtonLength(JNIEnv *env, jobject obj)
{
	return (jint) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->sliderButtonLength();
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_roundButton(JNIEnv *env, jobject obj)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->roundButton();
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_roundComboBox(JNIEnv *env, jobject obj)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->roundComboBox();
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_roundSlider(JNIEnv *env, jobject obj)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->roundSlider();
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_activeTabLine(JNIEnv *env, jobject obj)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->activeTabLine();
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KThemeBase_inactiveTabLine(JNIEnv *env, jobject obj)
{
	return (jboolean) ((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->inactiveTabLine();
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_uncached(JNIEnv *env, jobject obj, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->uncached((KThemeBase::WidgetType) widget), "org.kde.koala.KThemePixmap");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_scalePixmap(JNIEnv *env, jobject obj, jint w, jint h, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->scalePixmap((int) w, (int) h, (KThemeBase::WidgetType) widget), "org.kde.koala.KThemePixmap");
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_applyConfigFile(JNIEnv *env, jclass obj, jstring file)
{
static QString * _qstring_file = 0;
	KThemeBaseJBridge::applyConfigFile((QString&) * (QString *) QtSupport::toQString(env, file, &_qstring_file));
	return;
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_image(JNIEnv *env, jobject obj, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_image((KThemeBase::WidgetType) widget), "org.kde.qt.QImage");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_gradientHigh(JNIEnv *env, jobject obj, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_gradientHigh((KThemeBase::WidgetType) widget), "org.kde.qt.QColor");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_gradientLow(JNIEnv *env, jobject obj, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_gradientLow((KThemeBase::WidgetType) widget), "org.kde.qt.QColor");
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_readConfig__I(JNIEnv *env, jobject obj, jint colorStyle)
{
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_readConfig((Qt::GUIStyle) colorStyle);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_readConfig__(JNIEnv *env, jobject obj)
{
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_readConfig(Qt::WindowsStyle);
	return;
}

//JNIEXPORT void JNICALL
//Java_org_kde_koala_KThemeBase_readWidgetConfig(JNIEnv *env, jobject obj, jint i, jobject config, jstring pixnames, jstring brdnames, jintArray loadArray)
//{
//static QString * _qstring_brdnames = 0;
//static QString * _qstring_pixnames = 0;
//	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_readWidgetConfig((int) i, (KConfig*) QtSupport::getQt(env, config), (QString*) QtSupport::toQString(env, pixnames, &_qstring_pixnames), (QString*) QtSupport::toQString(env, brdnames, &_qstring_brdnames),  (bool*) QtSupport::toIntPtr(env, loadArray));
//	return;
//}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_copyWidgetConfig(JNIEnv *env, jobject obj, jint sourceID, jint destID, jstring pixnames, jstring brdnames)
{
static QString * _qstring_brdnames = 0;
static QString * _qstring_pixnames = 0;
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_copyWidgetConfig((int) sourceID, (int) destID, (QString*) QtSupport::toQString(env, pixnames, &_qstring_pixnames), (QString*) QtSupport::toQString(env, brdnames, &_qstring_brdnames));
	return;
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_makeColorGroup__Lorg_kde_qt_QColor_2Lorg_kde_qt_QColor_2I(JNIEnv *env, jobject obj, jobject fg, jobject bg, jint style)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_makeColorGroup((QColor&) *(QColor *) QtSupport::getQt(env, fg), (QColor&) *(QColor *) QtSupport::getQt(env, bg), (Qt::GUIStyle) style), "org.kde.qt.QColorGroup");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_makeColorGroup__Lorg_kde_qt_QColor_2Lorg_kde_qt_QColor_2(JNIEnv *env, jobject obj, jobject fg, jobject bg)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_makeColorGroup((QColor&) *(QColor *) QtSupport::getQt(env, fg), (QColor&) *(QColor *) QtSupport::getQt(env, bg), Qt::WindowsStyle), "org.kde.qt.QColorGroup");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_scale(JNIEnv *env, jobject obj, jint w, jint h, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_scale((int) w, (int) h, (KThemeBase::WidgetType) widget), "org.kde.koala.KThemePixmap");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_scaleBorder(JNIEnv *env, jobject obj, jint w, jint h, jint type)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_scaleBorder((int) w, (int) h, (KThemeBase::WidgetType) type), "org.kde.koala.KThemePixmap");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_gradient(JNIEnv *env, jobject obj, jint w, jint h, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_gradient((int) w, (int) h, (KThemeBase::WidgetType) widget), "org.kde.koala.KThemePixmap");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_blend(JNIEnv *env, jobject obj, jint widget)
{
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_blend((KThemeBase::WidgetType) widget), "org.kde.koala.KThemePixmap");
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_generateBorderPix(JNIEnv *env, jobject obj, jint i)
{
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_generateBorderPix((int) i);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_applyResourceGroup(JNIEnv *env, jobject obj, jobject config, jint i)
{
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_applyResourceGroup((KConfig*) QtSupport::getQt(env, config), (int) i);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_applyMiscResourceGroup(JNIEnv *env, jobject obj, jobject config)
{
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_applyMiscResourceGroup((KConfig*) QtSupport::getQt(env, config));
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_readResourceGroup(JNIEnv *env, jobject obj, jint i, jstring pixnames, jstring brdnames, jintArray loadArray)
{
static QString * _qstring_brdnames = 0;
static QString * _qstring_pixnames = 0;
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_readResourceGroup((int) i, (QString*) QtSupport::toQString(env, pixnames, &_qstring_pixnames), (QString*) QtSupport::toQString(env, brdnames, &_qstring_brdnames),  (bool*) QtSupport::toIntPtr(env, loadArray));
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KThemeBase_readMiscResourceGroup(JNIEnv *env, jobject obj)
{
	((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_readMiscResourceGroup();
	return;
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_loadPixmap(JNIEnv *env, jobject obj, jstring name)
{
static QString * _qstring_name = 0;
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_loadPixmap((QString&) * (QString *) QtSupport::toQString(env, name, &_qstring_name)), "org.kde.koala.KThemePixmap");
}

JNIEXPORT jobject JNICALL
Java_org_kde_koala_KThemeBase_loadImage(JNIEnv *env, jobject obj, jstring name)
{
static QString * _qstring_name = 0;
	return (jobject) QtSupport::objectForQtKey(env, (void *)((KThemeBaseJBridge*) QtSupport::getQt(env, obj))->protected_loadImage((QString&) * (QString *) QtSupport::toQString(env, name, &_qstring_name)), "org.kde.qt.QImage");
}

