/***************************************************************************
                            KAccel.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Handle keyboard accelerators.

 Allow an user to configure
 key bindings through application configuration files or through the
 {@link KKeyChooser} GUI.

 A {@link KAccel} contains a list of accelerator items. Each accelerator item
 consists of an action name and a keyboard code combined with modifiers
 (Shift, Ctrl and Alt.)

 For example, "Ctrl+P" could be a shortcut for printing a document. The key
 codes are listed in ckey.h. "Print" could be the action name for printing.
 The action name identifies the key binding in configuration files and the
 {@link KKeyChooser} GUI.

 When pressed, an accelerator key calls the slot to which it has been
 connected. Accelerator items can be connected so that a key will activate
 two different slots.

 A KAccel object handles key events sent to its parent widget and to all
 children of this parent widget.

 Key binding reconfiguration during run time can be prevented by specifying
 that an accelerator item is not configurable when it is inserted. A special
 group of non-configurable key bindings are known as the
 standard accelerators.

 The standard accelerators appear repeatedly in applications for
 standard document actions such as printing and saving. Convenience methods are
 available to insert and connect these accelerators which are configurable on
 a desktop-wide basis.

 It is possible for a user to choose to have no key associated with
 an action.

 The translated first argument for {@link #insertItem} is used only
 in the configuration dialog.
<pre>
 KAccel a = new KAccel( myWindow );
 // Insert an action "Scroll Up" which is associated with the "Up" key:
 a.insertItem( i18n("Scroll up"), "Scroll Up", "Up" );
 // Insert an action "Scroll Down" which is not associated with any key:
 a.insertItem( i18n("Scroll down"), "Scroll Down", 0);
 a.connectItem( "Scroll up", myWindow, SLOT(" scrollUp()") );
 // a.insertStdItem( KStdAccel.Print ); //not necessary, since it
	// is done automatially with the
	// connect below!
 a.connectItem(KStdAccel.Print, myWindow, SLOT(" printDoc()") );

 a.readSettings();
</pre>

 If a shortcut has a menu entry as well, you could insert them like
 this. The example is again the {@link KStdAccel#Print} from above.

 <pre>
 int id;
 id = popup.insertItem("&Print",this, SLOT("printDoc()"));
 a.changeMenuAccel(popup, id, KStdAccel.Print );
 </pre>

 If you want a somewhat "exotic" name for your standard print action, like
   id = popup.insertItem(i18n("Print &Document"),this, SLOT("printDoc()"));
 it might be a good idea to insert the standard action before as
          a.insertStdItem( KStdAccel.Print, i18n("Print Document") )
 as well, so that the user can easily find the corresponding function.

 This technique works for other actions as well.  Your "scroll up" function
 in a menu could be done with

 <pre>
    id = popup.insertItem(i18n"Scroll &up",this, SLOT("scrollUp()"));
    a.changeMenuAccel(popup, id, "Scroll Up" );
 </pre>

 Please keep the order right:  First insert all functions in the
 acceleratior, then call a . {@link #readSettings} and <em>then</em> build your
 menu structure.

 @version $Id: KAccel.java,v 1.3 2001/05/16 22:52:51 rdale Exp $
 
 @short Configurable key binding support.

*/
public class KAccel extends QAccel  {
	protected KAccel(Class dummy){super((Class) null);}


/** 
 Create a KAccel object with a parent widget and a name.
	 
*/
	private native void newKAccel( QWidget parent, String name);
	public KAccel( QWidget parent, String name) {
		super((Class) null);
		newKAccel( parent, name);
	}
	private native void newKAccel( QWidget parent);
	public KAccel( QWidget parent) {
		super((Class) null);
		newKAccel( parent);
	}

/** 
 Remove all accelerator items.
	 
*/
	public native void clear();

/** 
 Connect an accelerator item to a slot/signal in another object.

 Arguments:

*/
	public native void connectItem( String action, QObject receiver, String member, boolean activate);
	public native void connectItem( String action, QObject receiver, String member);

/** 
 Same as the preceding {@link #connectItem}, but used for standard
 accelerators.

 If the standard accelerator was not inserted so far, it
 will be inserted automatically.
	 
*/
	public native boolean connectItem( int accel, QObject receiver, String member, boolean activate);
	public native boolean connectItem( int accel, QObject receiver, String member);

/** 
 Retrieve the number of accelerator items.
	
*/
	public native int count();

/** 
 Retrieve the key code of the accelerator item with the action name
 <code>action</code>, or zero if either the action name cannot be
 found or the current key is set to no key.
	
*/
	public native int currentKey( String action);

/** 
 Retrieve the description  of the accelerator item with the
 action name <code>action</code>, or {@link String#null} if the action name cannot
 be found. Useful for menus.
	 
*/
	public native String description( String action);
	public native void setDescription( String action, String description);

/** 
 Retrieve the default key code of the accelerator item with
 the action name
 <code>action</code>, or zero if the action name cannot be found.
	
*/
	public native int defaultKey( String action);

/** 
 Disconnect an accelerator item from a function in another object.
	 
*/
	public native void disconnectItem( String action, QObject receiver, String member);

/** 
 Rerieve the identifier of the accelerator item with the keycode <code>key</code>,
 or {@link String#null} if the item cannot be found.
	 
*/
	public native int findKey( int key);

/** 
 Insert an accelerator item.

 If an action already exists the old association and connections
 will be removed.

*/
	public native boolean insertItem( String descr, String action, int defaultKeyCode, boolean configurable);
	public native boolean insertItem( String descr, String action, int defaultKeyCode);

/** 
 Insert an accelerator item.

 If an action already exists the old association and connections
 will be removed.

	 
*/
	public native boolean insertItem( String descr, String action, int defaultKeyCode, int identifier, QPopupMenu qmenu, boolean configurable);
	public native boolean insertItem( String descr, String action, int defaultKeyCode, int identifier, QPopupMenu qmenu);

/** 
 Insert an accelerator item.

 If an action already exists the old association and connections
 will be removed.

	 
*/
	public native boolean insertItem( String descr, String action, String defaultKeyCode, boolean configurable);
	public native boolean insertItem( String descr, String action, String defaultKeyCode);

/** 
 Insert an accelerator item.

 If an action already exists the old association and connections
 will be removed..

	 
*/
	public native boolean insertItem( String descr, String action, String defaultKeyCode, int identifier, QPopupMenu qmenu, boolean configurable);
	public native boolean insertItem( String descr, String action, String defaultKeyCode, int identifier, QPopupMenu qmenu);

/** 
 Insert a standard accelerator item.

 If an action already exists the old association and connections
 will be removed.
 param id One of the following: <code>Open</code>,
	<code>New</code>, <code>Close</code>, <code>Save</code>, <code>Print</code>, <code>Quit</code>, <code>Cut</code>, <code>Copy</code>, <code>Paste</code>, <code>Undo</code>, <code>Redo</code>,
	<code>Find</code>, <code>Replace</code>, <code>Insert</code>, <code>Home</code>, <code>End</code>, <code>Prior</code>, <code>Next</code>, or @pHelp.
 param descr You can optionally also assign a description to
 the standard item which may be used a in a popup menu.
	 
*/
	public native boolean insertStdItem( int identifier, String descr);
	public native boolean insertStdItem( int identifier);

/** 
 Convenience function form of {@link #insertItem}
 without the need to specify a localized
 function name for the user.

 This is useful if the accelerator
 is used internally only, without appearing in a menu or a
 keybinding editor.
	 
*/
	public native boolean insertItem( String action, int defaultKeyCode, boolean configurable);
	public native boolean insertItem( String action, int defaultKeyCode);

/** 
 Convenience function for of {@link #insertItem} without the need
 to specify a localized
 function name for the user.

 This is useful if the accelerator
 is only used internally, without appearing in a menu or a
 keybinding editor.
	 
*/
	public native boolean insertItem( String action, int defaultKeyCode, int identifier, QPopupMenu qmenu, boolean configurable);
	public native boolean insertItem( String action, int defaultKeyCode, int identifier, QPopupMenu qmenu);

/** 
 Remove the accelerator item with the action name action.
	 
*/
	public native void removeItem( String action);

/** 
 Shortcuts should be visible in the menu
 structure of an application.

 Use this function for that
 purpose.  Note that the action must have been inserted
 before!
	 
*/
	public native void changeMenuAccel( QPopupMenu menu, int identifier, String action);

/** 
 Same as {@link #changeMenuAccel} but for standard accelerators.
	 
*/
	public native void changeMenuAccel( QPopupMenu menu, int identifier, int accel);

/** 
 Set the dictionary of accelerator action names and {@link KKeyEntry}
 objects to <code>nKeyDict.</code>

 Note that only a shallow copy is made so
 that items will be lost when the {@link KKeyEntry} objects are deleted.
	 
*/
//	public native boolean setKeyDict( KKeyEntryMap nKeyDict);

/** 
 Retrieve the dictionary of accelerator action names and
 {@link KKeyEntry}
 objects. Note that only a shallow copy is returned so that
 items will be lost when the {@link KKeyEntry} objects are deleted.
	 
*/
//	public native KKeyEntryMap keyDict();

/** 
 Read all key associations from <code>config</code>, or (if <code>config</code>
 is zero) from the application's configuration file
 {@link KGlobal#config}.

 The group in which the configuration is stored can be
 set with {@link #setConfigGroup}.
	 
*/
	public native void readSettings( KConfig config);
	public native void readSettings();

/** 
 Write the current configurable associations to <code>config</code>,
 or (if <code>config</code> is zero) to the application's
 configuration file.
	 
*/
	public native void writeSettings( KConfig config);
	public native void writeSettings();

/** 
 Set the group in the configuration file in which the
 accelerator settings are stored.

 By default, this is "Keys".
	 
*/
	public native void setConfigGroup( String group);

/** 
 Retrieve the name of the group in which accelerator
 settings are stored.

*/
	public native String configGroup();

/** 
 If <code>global</code> is true, KAccel writes to the global
  configuration file, instead of the application configuration file.

*/
	public native void setConfigGlobal( boolean global);

/** 
 Will KAccel write to the global configuration file (instead of
  the application configuration file)?

*/
	public native boolean configGlobal();

/** 
 Enable all accelerators if activate is true, or disable it if
 activate is false.

 Individual keys can also be enabled or disabled.
	 
*/
	public native void setEnabled( boolean activate);

/** 
 Are accelerators enabled?

*/
	public native boolean isEnabled();

/** 
 Enable or disable an accelerator item.

*/
	public native void setItemEnabled( String action, boolean activate);

/** 
 Check whether a specific accelerator, <code>action</code>, is enabled.

*/
	public native boolean isItemEnabled( String action);

/** 
 Returns <code>true</code> if keyentry can be modified.
	 
*/
	public native boolean configurable( String action);

/** 
  Change the keycode for an accelerator.
	 
*/
	public native boolean updateItem( String action, int keyCode);

/** 
  Remove the keycode for an accelerator.

*/
	public native void clearItem( String action);

/** 
  Clear any pointers to a menu.

*/
	public native void removeDeletedMenu( QPopupMenu menu);
//	public static native void readKeyMap( KKeyEntryMap aKeyMap, String group, KConfigBase config);
//	public static native void readKeyMap( KKeyEntryMap aKeyMap, String group);

/** 
 More flexible version of @see writeSettings. You can specify your
 own key map. ( writeSettings calls this function internally )

*/
//	public static native void writeKeyMap( KKeyEntryMap aKeyMap, String group, KConfig config, boolean global);
//	public static native void writeKeyMap( KKeyEntryMap aKeyMap, String group);

/** 
 Retrieve the key code corresponding to the string <code>sKey</code> or
 zero if the string is not recognized.

 The string must be something like "Shift+A",
 "F1+Ctrl+Alt" or "Backspace" for example. That is, the string
 must consist of a key name plus a combination of
 the modifiers Shift, Ctrl and Alt.

 N.B.: <code>sKey</code> must <em>not</em> be {@link #i18n}'d!
	 
*/
	public static native int stringToKey( String sKey);

/** 
 Retrieve a string corresponding to the key code <code>keyCode</code>,
 which is empty if
 <code>keyCode</code> is not recognized or zero.
	 
*/
	public static native String keyToString( int keyCode, boolean i18_n);
}

/** Override these methods in subclasses of KAccel to customise event handling behaviour */
interface KAccelEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

