/***************************************************************************
                            KCharSelect.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A Widget which allows the user to select a character of a
 specified font in a table

 You can specify the font whoes characters should be displayed via
 {@link #setFont}. Using {@link #enableFontCombo} you can allow the
 user to choose the font from a combob-box. As only 256 characters
 are displayed at once in the table, using the spinbox on the top
 the user can choose starting from which chracater the table
 displayes them. This spinbox also can be enabled or disabled using
 {@link #enableTableSpinBox}.

 KCharSelect supports keyboard and mouse navigation. Click+Move
 selects always the character below the mouse cursor. Using the
 arrow keys the focus mark is moved around and with pressing RETURN
 or SPACE the cell which contains the focus mark gets selected.

 To get the current selected character, use the {@link #chr}
 method. You can set the character which should be displayed with
 {@link #setChar} and the table number which should be displayed with
 {@link #setTableNum}.

 @author Reginald Stadlbauer <reggie@kde.org>
 
 @version $Id: KCharSelect.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short Character-Selection Widget.
*/
public class KCharSelect extends QVBox  {
	protected KCharSelect(Class dummy){super((Class) null);}


/** 
 Constructor. <code>font</code> specifies which font should be displayed, <code>chr</code> which character should be selected and <code>tableNum</code> specifies
 the number of the table which should be displayed.
     
*/
	private native void newKCharSelect( QWidget parent, String name, String font, char arg1, int tableNum);
	public KCharSelect( QWidget parent, String name, String font, char arg1, int tableNum) {
		super((Class) null);
		newKCharSelect( parent, name, font, arg1, tableNum);
	}
	private native void newKCharSelect( QWidget parent, String name);
	public KCharSelect( QWidget parent, String name) {
		super((Class) null);
		newKCharSelect( parent, name);
	}

/** 
 Reimplemented.
     
*/
	public native QSize sizeHint();

/** 
 Sets the font which is displayed to <code>font</code>
     
*/
	public native void setFont( String font);

/** 
 Sets the currently selected character to <code>chr.</code>
     
*/
	public native void setChar( QChar chr);

/** 
 Sets the currently displayed table to <code>tableNum.</code>
     
*/
	public native void setTableNum( int tableNum);

/** 
 Returns the currently selected character.
     
*/
	public native QChar chr();

/** 
 Returns the currently displayed font.
     
*/
	public native QFont font();

/** 
 Returns the currently displayed table
     
*/
	public native int tableNum();

/** 
 If <code>e</code> is set to TRUE, the combobox which allows the user to
 select the font which should be displayed is enabled, else
 disabled.
     
*/
	public native void enableFontCombo( boolean e);

/** 

 If <code>e</code> is set to TRUE, the spinbox which allows the user to
 specify which characters of the font should be displayed, is
 enabled, else disabled.
     
*/
	public native void enableTableSpinBox( boolean e);

/** 
 Returns wether the font combobox on the top is enabled or
 disabled.

*/
	public native boolean isFontComboEnabled();

/** 
 Returns wether the table spinbox on the top is enabled or
 disabled.

*/
	public native boolean isTableSpinBoxEnabled();
	protected native void fillFontCombo();
	protected native void fontSelected( String _font);
	protected native void tableChanged( int _value);
	protected native void charHighlighted( QChar c);
	protected native void charHighlighted();
	protected native void charActivated( QChar c);
	protected native void charActivated();
	protected native void charFocusItemChanged();
	protected native void charFocusItemChanged( QChar c);
	protected native void charTableUp();
	protected native void charTableDown();
	protected static native void cleanupFontDatabase();
}

/** Override these methods in subclasses of KCharSelect to customise event handling behaviour */
interface KCharSelectEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

