/***************************************************************************
                            KDirOperator.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class KDirOperator extends QWidget  {
	protected KDirOperator(Class dummy){super((Class) null);}


/** 
 You need to call listDirectory() to actually load the directory,
 this constructor only initializes and doesn't start loading.
     
*/
	private native void newKDirOperator( KURL arg1, QWidget parent, String name);
	public KDirOperator( KURL arg1, QWidget parent, String name) {
		super((Class) null);
		newKDirOperator( arg1, parent, name);
	}
	private native void newKDirOperator();
	public KDirOperator() {
		super((Class) null);
		newKDirOperator();
	}
	protected native void finalize() throws InternalError;
	public native void setShowHiddenFiles( boolean s);
	public native boolean showHiddenFiles();
	public native boolean close();

/** 
 Set a filter like ".cpp .h .o". Call {@link #rereadDir} to apply it.
     
*/
	public native void setNameFilter( String filter);

/** 

*/
	public native String nameFilter();

/** 
 local URLs (i.e. directories) always have file: prepended.
     
*/
	public native KURL url();
	public native void setURL( KURL url, boolean clearforward);

/** 
 Clears the current selection and attempts to set <code>filename</code>
 the current file. filename is just the name, no path or url.
     
*/
	public native void setCurrentItem( String filename);
	public native void setView( KFileViewInterface view);
	public native KFileViewInterface view();

/** 
 Returns the widget of the current view. null if there is no view/widget.
     
*/
	public native QWidget viewWidget();
	public native void setView( int view);
	public native void setSorting( int arg1);
	public native int sorting();
	public native boolean isRoot();
//	public native KFileReader fileReader();

/** 

*/
	public native KProgress progressBar();

/** 
 Sets the listing/selection mode for the views, an OR'ed combination of

 You cannot mix File and Files of course.
     
*/
	public native void setMode( int m);
	public native int mode();
	public native void setPreviewWidget( QWidget w);

/** 

*/
	public native ArrayList selectedItems();
	public native boolean isSelected( KFileViewItem item);
	public native int numDirs();
	public native int numFiles();

/** 

*/
	public native KCompletion completionObject();

/** 

*/
	public native KCompletion dirCompletionObject();

/** 
 an accessor to a collection of all available Actions. The actions
 are static, they will be there all the time (no need to connect to
 the signals KActionCollection.inserted() or removed().

 There are the following actions:

 The short and detailed view are in an exclusive group. The sort-by
 actions are in an exclusive group as well.

 You can e.g. use
 <pre>actionCollection().action( "up" ).plug( someToolBar );</pre>
 to add a button into a toolbar, which makes the dirOperator change to
 its parent directory.

*/
	public native KActionCollection actionCollection();

/** 
 Reads the default settings for a view, i.e. the default KFile.FileView.
 Also reads the sorting and whether hidden files should be shown.
 Note: the default view will not be set - you have to call
 <pre>{@link #setView}</pre> to apply it.
     
*/
	public native void readConfig( KConfig arg1, String group);
	public native void readConfig( KConfig arg1);
	public native void saveConfig( KConfig arg1, String group);
	public native void saveConfig( KConfig arg1);

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 The default is false, set it to true if you don't want files selected
 with single click.
     
*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/** 

*/
	public native boolean onlyDoubleClickSelectsFiles();

/** 
 Creates the given directory/url. If it is a relative path,
 it will be completed with the current directory.
 If enterDirectory is true, the directory will be entered after a
 successful operation. If unsuccessful, a messagebox will be presented
 to the user.

*/
	public native boolean mkdir( String directory, boolean enterDirectory);
	public native boolean mkdir( String directory);

/** 
 Clears the forward and backward history.
     
*/
	public native void clearHistory();

/** 
 When going up in the directory hierarchy, KDirOperator can highlight
 the directory that was just left.

 I.e. when you go from /home/gis/src to /home/gis, the item "src" will
 be made the current item.

 Default is off.
     
*/
	public native void setEnableDirHighlighting( boolean enable);

/** 

 Default is false.
     
*/
	public native boolean dirHighlighting();
	public native void back();
	public native void forward();
	public native void home();
	public native void cdUp();
	public native void rereadDir();
	public native void mkdir();
	public native String makeCompletion( String arg1);
	public native String makeDirCompletion( String arg1);
//	protected native void setFileReader( KFileReader reader);
	protected native void setupActions();
	protected native void updateSortActions();
	protected native void updateViewActions();
	protected native void setupMenu();
	protected native void prepareCompletionObjects();
	protected native void resetCursor();
	protected native void readNextMimeType();
	protected native void pathChanged();
	protected native void filterChanged();
	protected native void insertNewFiles( ArrayList newone);
	protected native void itemDeleted( KFileItem arg1);
	protected native void selectDir( KFileViewItem arg1);
	protected native void selectFile( KFileViewItem arg1);
	protected native void highlightFile( KFileViewItem i);

/** 
 Called upon right-click to activate the popupmenu.
     
*/
	protected native void activatedMenu( KFileViewItem arg1);
	protected native void sortByName();
	protected native void sortBySize();
	protected native void sortByDate();
	protected native void sortReversed();
	protected native void toggleDirsFirst();
	protected native void toggleIgnoreCase();
	protected native void deleteOldView();
	protected native void slotCompletionMatch( String arg1);
}

/** Override these methods in subclasses of KDirOperator to customise event handling behaviour */
interface KDirOperatorEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

