/***************************************************************************
                            KDockWidget.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Floatable widget that can be dragged around with the mouse and
 encapsulate the actual widgets (and member of the dockwidget class
 set).

 You just grip the double-lined panel, tear it off its parent
 widget, drag it somewhere and let it loose. Depending on the
 position where you leave it, the dockwidget becomes a toplevel
 window on the desktop (floating mode) or docks to a new widget
 (dock mode).  + Note: A {@link KDockWidget} can only be docked to a
 {@link KDockWidget}.

 If you want to use this kind of widget, your main application
 window has to be a {@link KDockMainWindow}.  That is because it has
 got several additional dock management features, for instance a
 {@link KDockManager} that has an overview over all dockwidgets and and
 a dockmovemanager (internal class) that handles the dock process.

 Usually you create an {@link KDockWidget} that covers the actual widget in this way:
 <PRE>
 ...
 KDockMainWindow mainWidget;
 ...
 KDockWidget dock = null;
 dock = mainWidget.createDockWidget( "Any window caption", nicePixmap, null, i18n("window caption")); // null==no parent
 QWidget actualWidget( dock);
 dock.setWidget( actualWidget);
 ...
 </PRE>

 See {@link KDockMainWindow} how a dockwidget is docked in.

 @author Max Judin (documentation: Falk Brettschneider).

 @version $Id: KDockWidget.java,v 1.3 2001/05/16 22:52:51 rdale Exp $
 
 @short 
 Floatable widget that can be dragged around with the mouse and
 encapsulate the actual widgets (and member of the dockwidget class
 set).
*/
public class KDockWidget extends QWidget  {
	protected KDockWidget(Class dummy){super((Class) null);}


/** 
 Construct a dockwidget.

 Initially, docking to another and docking to this is allowed for
 every <code>DockPosition.</code>  It is supposed to be no (tab) group. It will
 taken under control of its dockmanager.

*/
	private native void newKDockWidget( KDockManager dockManager, String name, QPixmap pixmap, QWidget parent, String strCaption, String arg1, int f);
	public KDockWidget( KDockManager dockManager, String name, QPixmap pixmap, QWidget parent, String strCaption, String arg1, int f) {
		super((Class) null);
		newKDockWidget( dockManager, name, pixmap, parent, strCaption, arg1, f);
	}
	private native void newKDockWidget( KDockManager dockManager, String name, QPixmap pixmap);
	public KDockWidget( KDockManager dockManager, String name, QPixmap pixmap) {
		super((Class) null);
		newKDockWidget( dockManager, name, pixmap);
	}

/** 
 Destructs a dockwidget.
   
*/
	protected native void finalize() throws InternalError;

/** 
 This is a key method of this class! Use it to dock dockwidgets to
 another dockwidget at the right position within its 
 {@link KDockMainWindow} or a toplevel dockwidget.

 If the target is null, it will become a toplevel dockwidget at position pos;
 Note: Docking to another dockwidget means exactly:
 A new parent dockwidget will be created, that replaces the target dockwidget and contains another single helper widget (tab widget or panner)
 which contains both dockwidgets, this and the target dockwidget. So consider parent<.child relationships change completely during such actions.

*/
	public native KDockWidget manualDock( KDockWidget target, int dockPos, int spliPos, QPoint pos, boolean check, int tabIndex);
	public native KDockWidget manualDock( KDockWidget target, int dockPos);

/** 
 Specify where it is either possible or impossible for this to dock to another dockwidget.

*/
	public native void setEnableDocking( int pos);

/** 

*/
	public native int enableDocking();

/** 
 Specify where it is either possible or impossible for another dockwidget to dock to this.

*/
	public native void setDockSite( int pos);

/** 

*/
	public native int dockSite();

/** 
 Set the embedded widget.

 A QLayout takes care about proper resizing, automatically.

*/
	public native void setWidget( QWidget w);

/** 
 Get the embedded widget.

*/
	public native QWidget getWidget();

/** 
 Set the header of this dockwidget.

 A {@link QLayout} takes care about proper resizing, automatically.
 The header contains the drag panel, the close button and the stay button.

*/
	public native void setHeader( KDockWidgetAbstractHeader ah);

/** 
 Normally it simply shows the dockwidget. 

 But additionally, if it is docked to a tab widget (<code>DockCenter</code>), it is set as the active (visible) tab page.
   
*/
	public native void makeDockVisible();

/**  

 There are reasons that it's impossible:

*/
	public native boolean mayBeHide();

/**  

*/
	public native boolean mayBeShow();

/** 

*/
	public native KDockManager dockManager();

/** 
 Stores a string for a tooltip.

 That tooltip string has only a meaning when this dockwidget is shown as tab page.
 In this case the tooltip is shown when one holds the mouse cursor on the tab page header.
 Such tooltip will for instance be useful, if you use only icons there.
 Note: Setting an empty string switches the tooltip off.

*/
	public native void setToolTipString( String ttStr);

/** 

*/
	public native String toolTipString();

/**  

*/
	public native boolean isDockBackPossible();

/**  Set a string that is used for the label of the tab page when in tab page mode

*/
	public native void setTabPageLabel( String label);

/**  

*/
	public native String tabPageLabel();

/** 
 Catches and processes some {@link QWidget} events that are interesting for dockwidgets.
   
*/
	public native boolean event( QEvent arg1);

/** 
 Add dockwidget management actions to {@link QWidget#show}. 
   
*/
	public native void show();

/** 

*/
	public native KDockTabGroup parentDockTabGroup();

/**  Docks a dockwidget back to the dockwidget that was the neighbor widget before the current dock position. 
*/
	public native void dockBack();

/** 
 Toggles the visibility state of the dockwidget if it is able to be shown or to be hidden. 

   
*/
	public native void changeHideShowState();

/** 
 Undocks this. It means it becomes a toplevel widget framed by the system window manager.
 A small panel at the top of this undocked widget gives the possibility to drag it into
 another dockwidget by mouse (docking).
   
*/
	public native void undock();

/** 

*/
	protected native KDockTabGroup parentTabGroup();

/** 
 Check some conditions and show or hide the dockwidget header (drag panel).
 The header is hidden if:

*/
	protected native void updateHeader();

/**  Does several things here when it has noticed that the former brother widget (closest neighbor) gets lost.
 The former brother widget is needed for a possible dockback action, to speak with the Beatles:
 "To get back to where you once belonged" ;-)
   
*/
	protected native void loseFormerBrotherDockWidget();
	public static final int DockNone = 0;
	public static final int DockTop = 0x0001;
	public static final int DockLeft = 0x0002;
	public static final int DockRight = 0x0004;
	public static final int DockBottom = 0x0008;
	public static final int DockCenter = 0x0010;
	public static final int DockDesktop = 0x0020;
	public static final int DockCorner = DockTop|DockLeft|DockRight|DockBottom;
	public static final int DockFullSite = DockCorner|DockCenter;
	public static final int DockFullDocking = DockFullSite|DockDesktop;
}

/** Override these methods in subclasses of KDockWidget to customise event handling behaviour */
interface KDockWidgetEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

